/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.test;

import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.TokenRewriteStream;
import org.antlr.test.BaseTest;
import org.antlr.tool.Grammar;
import org.antlr.tool.Interpreter;

public class TestTokenRewriteStream
extends BaseTest {
    public void testInsertBeforeIndex0() throws Exception {
        Grammar grammar = new Grammar("lexer grammar t;\nA : 'a';\nB : 'b';\nC : 'c';\n");
        ANTLRStringStream aNTLRStringStream = new ANTLRStringStream("abc");
        Interpreter interpreter = new Interpreter(grammar, aNTLRStringStream);
        TokenRewriteStream tokenRewriteStream = new TokenRewriteStream(interpreter);
        tokenRewriteStream.LT(1);
        tokenRewriteStream.insertBefore(0, (Object)"0");
        String string = tokenRewriteStream.toString();
        String string2 = "0abc";
        TestTokenRewriteStream.assertEquals((String)string2, (String)string);
    }

    public void testInsertAfterLastIndex() throws Exception {
        Grammar grammar = new Grammar("lexer grammar t;\nA : 'a';\nB : 'b';\nC : 'c';\n");
        ANTLRStringStream aNTLRStringStream = new ANTLRStringStream("abc");
        Interpreter interpreter = new Interpreter(grammar, aNTLRStringStream);
        TokenRewriteStream tokenRewriteStream = new TokenRewriteStream(interpreter);
        tokenRewriteStream.LT(1);
        tokenRewriteStream.insertAfter(2, (Object)"x");
        String string = tokenRewriteStream.toString();
        String string2 = "abcx";
        TestTokenRewriteStream.assertEquals((String)string2, (String)string);
    }

    public void test2InsertBeforeAfterMiddleIndex() throws Exception {
        Grammar grammar = new Grammar("lexer grammar t;\nA : 'a';\nB : 'b';\nC : 'c';\n");
        ANTLRStringStream aNTLRStringStream = new ANTLRStringStream("abc");
        Interpreter interpreter = new Interpreter(grammar, aNTLRStringStream);
        TokenRewriteStream tokenRewriteStream = new TokenRewriteStream(interpreter);
        tokenRewriteStream.LT(1);
        tokenRewriteStream.insertBefore(1, (Object)"x");
        tokenRewriteStream.insertAfter(1, (Object)"x");
        String string = tokenRewriteStream.toString();
        String string2 = "axbxc";
        TestTokenRewriteStream.assertEquals((String)string2, (String)string);
    }

    public void testReplaceIndex0() throws Exception {
        Grammar grammar = new Grammar("lexer grammar t;\nA : 'a';\nB : 'b';\nC : 'c';\n");
        ANTLRStringStream aNTLRStringStream = new ANTLRStringStream("abc");
        Interpreter interpreter = new Interpreter(grammar, aNTLRStringStream);
        TokenRewriteStream tokenRewriteStream = new TokenRewriteStream(interpreter);
        tokenRewriteStream.LT(1);
        tokenRewriteStream.replace(0, (Object)"x");
        String string = tokenRewriteStream.toString();
        String string2 = "xbc";
        TestTokenRewriteStream.assertEquals((String)string2, (String)string);
    }

    public void testReplaceLastIndex() throws Exception {
        Grammar grammar = new Grammar("lexer grammar t;\nA : 'a';\nB : 'b';\nC : 'c';\n");
        ANTLRStringStream aNTLRStringStream = new ANTLRStringStream("abc");
        Interpreter interpreter = new Interpreter(grammar, aNTLRStringStream);
        TokenRewriteStream tokenRewriteStream = new TokenRewriteStream(interpreter);
        tokenRewriteStream.LT(1);
        tokenRewriteStream.replace(2, (Object)"x");
        String string = tokenRewriteStream.toString();
        String string2 = "abx";
        TestTokenRewriteStream.assertEquals((String)string2, (String)string);
    }

    public void testReplaceMiddleIndex() throws Exception {
        Grammar grammar = new Grammar("lexer grammar t;\nA : 'a';\nB : 'b';\nC : 'c';\n");
        ANTLRStringStream aNTLRStringStream = new ANTLRStringStream("abc");
        Interpreter interpreter = new Interpreter(grammar, aNTLRStringStream);
        TokenRewriteStream tokenRewriteStream = new TokenRewriteStream(interpreter);
        tokenRewriteStream.LT(1);
        tokenRewriteStream.replace(1, (Object)"x");
        String string = tokenRewriteStream.toString();
        String string2 = "axc";
        TestTokenRewriteStream.assertEquals((String)string2, (String)string);
    }

    public void testToStringStartStop() throws Exception {
        Grammar grammar = new Grammar("lexer grammar t;\nID : 'a'..'z'+;\nINT : '0'..'9'+;\nSEMI : ';';\nMUL : '*';\nASSIGN : '=';\nWS : ' '+;\n");
        ANTLRStringStream aNTLRStringStream = new ANTLRStringStream("x = 3 * 0;");
        Interpreter interpreter = new Interpreter(grammar, aNTLRStringStream);
        TokenRewriteStream tokenRewriteStream = new TokenRewriteStream(interpreter);
        tokenRewriteStream.LT(1);
        tokenRewriteStream.replace(4, 8, (Object)"0");
        String string = tokenRewriteStream.toOriginalString();
        String string2 = "x = 3 * 0;";
        TestTokenRewriteStream.assertEquals((String)string2, (String)string);
        string = tokenRewriteStream.toString();
        string2 = "x = 0;";
        TestTokenRewriteStream.assertEquals((String)string2, (String)string);
        string = tokenRewriteStream.toString(0, 9);
        string2 = "x = 0;";
        TestTokenRewriteStream.assertEquals((String)string2, (String)string);
        string = tokenRewriteStream.toString(4, 8);
        string2 = "0";
        TestTokenRewriteStream.assertEquals((String)string2, (String)string);
    }

    public void testToStringStartStop2() throws Exception {
        Grammar grammar = new Grammar("lexer grammar t;\nID : 'a'..'z'+;\nINT : '0'..'9'+;\nSEMI : ';';\nASSIGN : '=';\nPLUS : '+';\nMULT : '*';\nWS : ' '+;\n");
        ANTLRStringStream aNTLRStringStream = new ANTLRStringStream("x = 3 * 0 + 2 * 0;");
        Interpreter interpreter = new Interpreter(grammar, aNTLRStringStream);
        TokenRewriteStream tokenRewriteStream = new TokenRewriteStream(interpreter);
        tokenRewriteStream.LT(1);
        String string = tokenRewriteStream.toOriginalString();
        String string2 = "x = 3 * 0 + 2 * 0;";
        TestTokenRewriteStream.assertEquals((String)string2, (String)string);
        tokenRewriteStream.replace(4, 8, (Object)"0");
        string = tokenRewriteStream.toString();
        string2 = "x = 0 + 2 * 0;";
        TestTokenRewriteStream.assertEquals((String)string2, (String)string);
        string = tokenRewriteStream.toString(0, 17);
        string2 = "x = 0 + 2 * 0;";
        TestTokenRewriteStream.assertEquals((String)string2, (String)string);
        string = tokenRewriteStream.toString(4, 8);
        string2 = "0";
        TestTokenRewriteStream.assertEquals((String)string2, (String)string);
        string = tokenRewriteStream.toString(0, 8);
        string2 = "x = 0";
        TestTokenRewriteStream.assertEquals((String)string2, (String)string);
        string = tokenRewriteStream.toString(12, 16);
        string2 = "2 * 0";
        TestTokenRewriteStream.assertEquals((String)string2, (String)string);
        tokenRewriteStream.insertAfter(17, (Object)"// comment");
        string = tokenRewriteStream.toString(12, 17);
        string2 = "2 * 0;// comment";
        TestTokenRewriteStream.assertEquals((String)string2, (String)string);
        string = tokenRewriteStream.toString(0, 8);
        string2 = "x = 0";
        TestTokenRewriteStream.assertEquals((String)string2, (String)string);
    }

    public void test2ReplaceMiddleIndex() throws Exception {
        Grammar grammar = new Grammar("lexer grammar t;\nA : 'a';\nB : 'b';\nC : 'c';\n");
        ANTLRStringStream aNTLRStringStream = new ANTLRStringStream("abc");
        Interpreter interpreter = new Interpreter(grammar, aNTLRStringStream);
        TokenRewriteStream tokenRewriteStream = new TokenRewriteStream(interpreter);
        tokenRewriteStream.LT(1);
        tokenRewriteStream.replace(1, (Object)"x");
        tokenRewriteStream.replace(1, (Object)"y");
        String string = tokenRewriteStream.toString();
        String string2 = "ayc";
        TestTokenRewriteStream.assertEquals((String)string2, (String)string);
    }

    public void test2ReplaceMiddleIndex1InsertBefore() throws Exception {
        Grammar grammar = new Grammar("lexer grammar t;\nA : 'a';\nB : 'b';\nC : 'c';\n");
        ANTLRStringStream aNTLRStringStream = new ANTLRStringStream("abc");
        Interpreter interpreter = new Interpreter(grammar, aNTLRStringStream);
        TokenRewriteStream tokenRewriteStream = new TokenRewriteStream(interpreter);
        tokenRewriteStream.LT(1);
        tokenRewriteStream.insertBefore(0, (Object)"_");
        tokenRewriteStream.replace(1, (Object)"x");
        tokenRewriteStream.replace(1, (Object)"y");
        String string = tokenRewriteStream.toString();
        String string2 = "_ayc";
        TestTokenRewriteStream.assertEquals((String)string2, (String)string);
    }

    public void testReplaceThenDeleteMiddleIndex() throws Exception {
        Grammar grammar = new Grammar("lexer grammar t;\nA : 'a';\nB : 'b';\nC : 'c';\n");
        ANTLRStringStream aNTLRStringStream = new ANTLRStringStream("abc");
        Interpreter interpreter = new Interpreter(grammar, aNTLRStringStream);
        TokenRewriteStream tokenRewriteStream = new TokenRewriteStream(interpreter);
        tokenRewriteStream.LT(1);
        tokenRewriteStream.replace(1, (Object)"x");
        tokenRewriteStream.delete(1);
        String string = tokenRewriteStream.toString();
        String string2 = "ac";
        TestTokenRewriteStream.assertEquals((String)string2, (String)string);
    }

    public void testInsertInPriorReplace() throws Exception {
        Grammar grammar = new Grammar("lexer grammar t;\nA : 'a';\nB : 'b';\nC : 'c';\n");
        ANTLRStringStream aNTLRStringStream = new ANTLRStringStream("abc");
        Interpreter interpreter = new Interpreter(grammar, aNTLRStringStream);
        TokenRewriteStream tokenRewriteStream = new TokenRewriteStream(interpreter);
        tokenRewriteStream.LT(1);
        tokenRewriteStream.replace(0, 2, (Object)"x");
        tokenRewriteStream.insertBefore(1, (Object)"0");
        IllegalArgumentException illegalArgumentException = null;
        try {
            tokenRewriteStream.toString();
        }
        catch (IllegalArgumentException illegalArgumentException2) {
            illegalArgumentException = illegalArgumentException2;
        }
        String string = "insert op <InsertBeforeOp@1:\"0\"> within boundaries of previous <ReplaceOp@0..2:\"x\">";
        TestTokenRewriteStream.assertNotNull((Object)illegalArgumentException);
        TestTokenRewriteStream.assertEquals((String)string, (String)illegalArgumentException.getMessage());
    }

    public void testInsertThenReplaceSameIndex() throws Exception {
        Grammar grammar = new Grammar("lexer grammar t;\nA : 'a';\nB : 'b';\nC : 'c';\n");
        ANTLRStringStream aNTLRStringStream = new ANTLRStringStream("abc");
        Interpreter interpreter = new Interpreter(grammar, aNTLRStringStream);
        TokenRewriteStream tokenRewriteStream = new TokenRewriteStream(interpreter);
        tokenRewriteStream.LT(1);
        tokenRewriteStream.insertBefore(0, (Object)"0");
        tokenRewriteStream.replace(0, (Object)"x");
        String string = tokenRewriteStream.toString();
        String string2 = "xbc";
        TestTokenRewriteStream.assertEquals((String)string2, (String)string);
    }

    public void test2InsertMiddleIndex() throws Exception {
        Grammar grammar = new Grammar("lexer grammar t;\nA : 'a';\nB : 'b';\nC : 'c';\n");
        ANTLRStringStream aNTLRStringStream = new ANTLRStringStream("abc");
        Interpreter interpreter = new Interpreter(grammar, aNTLRStringStream);
        TokenRewriteStream tokenRewriteStream = new TokenRewriteStream(interpreter);
        tokenRewriteStream.LT(1);
        tokenRewriteStream.insertBefore(1, (Object)"x");
        tokenRewriteStream.insertBefore(1, (Object)"y");
        String string = tokenRewriteStream.toString();
        String string2 = "ayxbc";
        TestTokenRewriteStream.assertEquals((String)string2, (String)string);
    }

    public void test2InsertThenReplaceIndex0() throws Exception {
        Grammar grammar = new Grammar("lexer grammar t;\nA : 'a';\nB : 'b';\nC : 'c';\n");
        ANTLRStringStream aNTLRStringStream = new ANTLRStringStream("abc");
        Interpreter interpreter = new Interpreter(grammar, aNTLRStringStream);
        TokenRewriteStream tokenRewriteStream = new TokenRewriteStream(interpreter);
        tokenRewriteStream.LT(1);
        tokenRewriteStream.insertBefore(0, (Object)"x");
        tokenRewriteStream.insertBefore(0, (Object)"y");
        tokenRewriteStream.replace(0, (Object)"z");
        String string = tokenRewriteStream.toString();
        String string2 = "zbc";
        TestTokenRewriteStream.assertEquals((String)string2, (String)string);
    }

    public void testReplaceThenInsertBeforeLastIndex() throws Exception {
        Grammar grammar = new Grammar("lexer grammar t;\nA : 'a';\nB : 'b';\nC : 'c';\n");
        ANTLRStringStream aNTLRStringStream = new ANTLRStringStream("abc");
        Interpreter interpreter = new Interpreter(grammar, aNTLRStringStream);
        TokenRewriteStream tokenRewriteStream = new TokenRewriteStream(interpreter);
        tokenRewriteStream.LT(1);
        tokenRewriteStream.replace(2, (Object)"x");
        tokenRewriteStream.insertBefore(2, (Object)"y");
        String string = tokenRewriteStream.toString();
        String string2 = "abyx";
        TestTokenRewriteStream.assertEquals((String)string2, (String)string);
    }

    public void testInsertThenReplaceLastIndex() throws Exception {
        Grammar grammar = new Grammar("lexer grammar t;\nA : 'a';\nB : 'b';\nC : 'c';\n");
        ANTLRStringStream aNTLRStringStream = new ANTLRStringStream("abc");
        Interpreter interpreter = new Interpreter(grammar, aNTLRStringStream);
        TokenRewriteStream tokenRewriteStream = new TokenRewriteStream(interpreter);
        tokenRewriteStream.LT(1);
        tokenRewriteStream.insertBefore(2, (Object)"y");
        tokenRewriteStream.replace(2, (Object)"x");
        String string = tokenRewriteStream.toString();
        String string2 = "abx";
        TestTokenRewriteStream.assertEquals((String)string2, (String)string);
    }

    public void testReplaceThenInsertAfterLastIndex() throws Exception {
        Grammar grammar = new Grammar("lexer grammar t;\nA : 'a';\nB : 'b';\nC : 'c';\n");
        ANTLRStringStream aNTLRStringStream = new ANTLRStringStream("abc");
        Interpreter interpreter = new Interpreter(grammar, aNTLRStringStream);
        TokenRewriteStream tokenRewriteStream = new TokenRewriteStream(interpreter);
        tokenRewriteStream.LT(1);
        tokenRewriteStream.replace(2, (Object)"x");
        tokenRewriteStream.insertAfter(2, (Object)"y");
        String string = tokenRewriteStream.toString();
        String string2 = "abxy";
        TestTokenRewriteStream.assertEquals((String)string2, (String)string);
    }

    public void testReplaceRangeThenInsertAtLeftEdge() throws Exception {
        Grammar grammar = new Grammar("lexer grammar t;\nA : 'a';\nB : 'b';\nC : 'c';\n");
        ANTLRStringStream aNTLRStringStream = new ANTLRStringStream("abcccba");
        Interpreter interpreter = new Interpreter(grammar, aNTLRStringStream);
        TokenRewriteStream tokenRewriteStream = new TokenRewriteStream(interpreter);
        tokenRewriteStream.LT(1);
        tokenRewriteStream.replace(2, 4, (Object)"x");
        tokenRewriteStream.insertBefore(2, (Object)"y");
        String string = tokenRewriteStream.toString();
        String string2 = "abyxba";
        TestTokenRewriteStream.assertEquals((String)string2, (String)string);
    }

    public void testReplaceRangeThenInsertAtRightEdge() throws Exception {
        Grammar grammar = new Grammar("lexer grammar t;\nA : 'a';\nB : 'b';\nC : 'c';\n");
        ANTLRStringStream aNTLRStringStream = new ANTLRStringStream("abcccba");
        Interpreter interpreter = new Interpreter(grammar, aNTLRStringStream);
        TokenRewriteStream tokenRewriteStream = new TokenRewriteStream(interpreter);
        tokenRewriteStream.LT(1);
        tokenRewriteStream.replace(2, 4, (Object)"x");
        tokenRewriteStream.insertBefore(4, (Object)"y");
        IllegalArgumentException illegalArgumentException = null;
        try {
            tokenRewriteStream.toString();
        }
        catch (IllegalArgumentException illegalArgumentException2) {
            illegalArgumentException = illegalArgumentException2;
        }
        String string = "insert op <InsertBeforeOp@4:\"y\"> within boundaries of previous <ReplaceOp@2..4:\"x\">";
        TestTokenRewriteStream.assertNotNull((Object)illegalArgumentException);
        TestTokenRewriteStream.assertEquals((String)string, (String)illegalArgumentException.getMessage());
    }

    public void testReplaceRangeThenInsertAfterRightEdge() throws Exception {
        Grammar grammar = new Grammar("lexer grammar t;\nA : 'a';\nB : 'b';\nC : 'c';\n");
        ANTLRStringStream aNTLRStringStream = new ANTLRStringStream("abcccba");
        Interpreter interpreter = new Interpreter(grammar, aNTLRStringStream);
        TokenRewriteStream tokenRewriteStream = new TokenRewriteStream(interpreter);
        tokenRewriteStream.LT(1);
        tokenRewriteStream.replace(2, 4, (Object)"x");
        tokenRewriteStream.insertAfter(4, (Object)"y");
        String string = tokenRewriteStream.toString();
        String string2 = "abxyba";
        TestTokenRewriteStream.assertEquals((String)string2, (String)string);
    }

    public void testReplaceAll() throws Exception {
        Grammar grammar = new Grammar("lexer grammar t;\nA : 'a';\nB : 'b';\nC : 'c';\n");
        ANTLRStringStream aNTLRStringStream = new ANTLRStringStream("abcccba");
        Interpreter interpreter = new Interpreter(grammar, aNTLRStringStream);
        TokenRewriteStream tokenRewriteStream = new TokenRewriteStream(interpreter);
        tokenRewriteStream.LT(1);
        tokenRewriteStream.replace(0, 6, (Object)"x");
        String string = tokenRewriteStream.toString();
        String string2 = "x";
        TestTokenRewriteStream.assertEquals((String)string2, (String)string);
    }

    public void testReplaceSubsetThenFetch() throws Exception {
        Grammar grammar = new Grammar("lexer grammar t;\nA : 'a';\nB : 'b';\nC : 'c';\n");
        ANTLRStringStream aNTLRStringStream = new ANTLRStringStream("abcccba");
        Interpreter interpreter = new Interpreter(grammar, aNTLRStringStream);
        TokenRewriteStream tokenRewriteStream = new TokenRewriteStream(interpreter);
        tokenRewriteStream.LT(1);
        tokenRewriteStream.replace(2, 4, (Object)"xyz");
        String string = tokenRewriteStream.toString(0, 6);
        String string2 = "abxyzba";
        TestTokenRewriteStream.assertEquals((String)string2, (String)string);
    }

    public void testReplaceThenReplaceSuperset() throws Exception {
        Grammar grammar = new Grammar("lexer grammar t;\nA : 'a';\nB : 'b';\nC : 'c';\n");
        ANTLRStringStream aNTLRStringStream = new ANTLRStringStream("abcccba");
        Interpreter interpreter = new Interpreter(grammar, aNTLRStringStream);
        TokenRewriteStream tokenRewriteStream = new TokenRewriteStream(interpreter);
        tokenRewriteStream.LT(1);
        tokenRewriteStream.replace(2, 4, (Object)"xyz");
        tokenRewriteStream.replace(3, 5, (Object)"foo");
        IllegalArgumentException illegalArgumentException = null;
        try {
            tokenRewriteStream.toString();
        }
        catch (IllegalArgumentException illegalArgumentException2) {
            illegalArgumentException = illegalArgumentException2;
        }
        String string = "replace op boundaries of <ReplaceOp@3..5:\"foo\"> overlap with previous <ReplaceOp@2..4:\"xyz\">";
        TestTokenRewriteStream.assertNotNull((Object)illegalArgumentException);
        TestTokenRewriteStream.assertEquals((String)string, (String)illegalArgumentException.getMessage());
    }

    public void testReplaceThenReplaceLowerIndexedSuperset() throws Exception {
        Grammar grammar = new Grammar("lexer grammar t;\nA : 'a';\nB : 'b';\nC : 'c';\n");
        ANTLRStringStream aNTLRStringStream = new ANTLRStringStream("abcccba");
        Interpreter interpreter = new Interpreter(grammar, aNTLRStringStream);
        TokenRewriteStream tokenRewriteStream = new TokenRewriteStream(interpreter);
        tokenRewriteStream.LT(1);
        tokenRewriteStream.replace(2, 4, (Object)"xyz");
        tokenRewriteStream.replace(1, 3, (Object)"foo");
        IllegalArgumentException illegalArgumentException = null;
        try {
            tokenRewriteStream.toString();
        }
        catch (IllegalArgumentException illegalArgumentException2) {
            illegalArgumentException = illegalArgumentException2;
        }
        String string = "replace op boundaries of <ReplaceOp@1..3:\"foo\"> overlap with previous <ReplaceOp@2..4:\"xyz\">";
        TestTokenRewriteStream.assertNotNull((Object)illegalArgumentException);
        TestTokenRewriteStream.assertEquals((String)string, (String)illegalArgumentException.getMessage());
    }

    public void testReplaceSingleMiddleThenOverlappingSuperset() throws Exception {
        Grammar grammar = new Grammar("lexer grammar t;\nA : 'a';\nB : 'b';\nC : 'c';\n");
        ANTLRStringStream aNTLRStringStream = new ANTLRStringStream("abcba");
        Interpreter interpreter = new Interpreter(grammar, aNTLRStringStream);
        TokenRewriteStream tokenRewriteStream = new TokenRewriteStream(interpreter);
        tokenRewriteStream.LT(1);
        tokenRewriteStream.replace(2, 2, (Object)"xyz");
        tokenRewriteStream.replace(0, 3, (Object)"foo");
        String string = tokenRewriteStream.toString();
        String string2 = "fooa";
        TestTokenRewriteStream.assertEquals((String)string2, (String)string);
    }

    public void testCombineInserts() throws Exception {
        Grammar grammar = new Grammar("lexer grammar t;\nA : 'a';\nB : 'b';\nC : 'c';\n");
        ANTLRStringStream aNTLRStringStream = new ANTLRStringStream("abc");
        Interpreter interpreter = new Interpreter(grammar, aNTLRStringStream);
        TokenRewriteStream tokenRewriteStream = new TokenRewriteStream(interpreter);
        tokenRewriteStream.LT(1);
        tokenRewriteStream.insertBefore(0, (Object)"x");
        tokenRewriteStream.insertBefore(0, (Object)"y");
        String string = tokenRewriteStream.toString();
        String string2 = "yxabc";
        TestTokenRewriteStream.assertEquals((String)string2, (String)string);
    }

    public void testCombine3Inserts() throws Exception {
        Grammar grammar = new Grammar("lexer grammar t;\nA : 'a';\nB : 'b';\nC : 'c';\n");
        ANTLRStringStream aNTLRStringStream = new ANTLRStringStream("abc");
        Interpreter interpreter = new Interpreter(grammar, aNTLRStringStream);
        TokenRewriteStream tokenRewriteStream = new TokenRewriteStream(interpreter);
        tokenRewriteStream.LT(1);
        tokenRewriteStream.insertBefore(1, (Object)"x");
        tokenRewriteStream.insertBefore(0, (Object)"y");
        tokenRewriteStream.insertBefore(1, (Object)"z");
        String string = tokenRewriteStream.toString();
        String string2 = "yazxbc";
        TestTokenRewriteStream.assertEquals((String)string2, (String)string);
    }

    public void testCombineInsertOnLeftWithReplace() throws Exception {
        Grammar grammar = new Grammar("lexer grammar t;\nA : 'a';\nB : 'b';\nC : 'c';\n");
        ANTLRStringStream aNTLRStringStream = new ANTLRStringStream("abc");
        Interpreter interpreter = new Interpreter(grammar, aNTLRStringStream);
        TokenRewriteStream tokenRewriteStream = new TokenRewriteStream(interpreter);
        tokenRewriteStream.LT(1);
        tokenRewriteStream.replace(0, 2, (Object)"foo");
        tokenRewriteStream.insertBefore(0, (Object)"z");
        String string = tokenRewriteStream.toString();
        String string2 = "zfoo";
        TestTokenRewriteStream.assertEquals((String)string2, (String)string);
    }

    public void testCombineInsertOnLeftWithDelete() throws Exception {
        Grammar grammar = new Grammar("lexer grammar t;\nA : 'a';\nB : 'b';\nC : 'c';\n");
        ANTLRStringStream aNTLRStringStream = new ANTLRStringStream("abc");
        Interpreter interpreter = new Interpreter(grammar, aNTLRStringStream);
        TokenRewriteStream tokenRewriteStream = new TokenRewriteStream(interpreter);
        tokenRewriteStream.LT(1);
        tokenRewriteStream.delete(0, 2);
        tokenRewriteStream.insertBefore(0, (Object)"z");
        String string = tokenRewriteStream.toString();
        String string2 = "z";
        TestTokenRewriteStream.assertEquals((String)string2, (String)string);
    }

    public void testDisjointInserts() throws Exception {
        Grammar grammar = new Grammar("lexer grammar t;\nA : 'a';\nB : 'b';\nC : 'c';\n");
        ANTLRStringStream aNTLRStringStream = new ANTLRStringStream("abc");
        Interpreter interpreter = new Interpreter(grammar, aNTLRStringStream);
        TokenRewriteStream tokenRewriteStream = new TokenRewriteStream(interpreter);
        tokenRewriteStream.LT(1);
        tokenRewriteStream.insertBefore(1, (Object)"x");
        tokenRewriteStream.insertBefore(2, (Object)"y");
        tokenRewriteStream.insertBefore(0, (Object)"z");
        String string = tokenRewriteStream.toString();
        String string2 = "zaxbyc";
        TestTokenRewriteStream.assertEquals((String)string2, (String)string);
    }

    public void testOverlappingReplace() throws Exception {
        Grammar grammar = new Grammar("lexer grammar t;\nA : 'a';\nB : 'b';\nC : 'c';\n");
        ANTLRStringStream aNTLRStringStream = new ANTLRStringStream("abcc");
        Interpreter interpreter = new Interpreter(grammar, aNTLRStringStream);
        TokenRewriteStream tokenRewriteStream = new TokenRewriteStream(interpreter);
        tokenRewriteStream.LT(1);
        tokenRewriteStream.replace(1, 2, (Object)"foo");
        tokenRewriteStream.replace(0, 3, (Object)"bar");
        String string = tokenRewriteStream.toString();
        String string2 = "bar";
        TestTokenRewriteStream.assertEquals((String)string2, (String)string);
    }

    public void testOverlappingReplace2() throws Exception {
        Grammar grammar = new Grammar("lexer grammar t;\nA : 'a';\nB : 'b';\nC : 'c';\n");
        ANTLRStringStream aNTLRStringStream = new ANTLRStringStream("abcc");
        Interpreter interpreter = new Interpreter(grammar, aNTLRStringStream);
        TokenRewriteStream tokenRewriteStream = new TokenRewriteStream(interpreter);
        tokenRewriteStream.LT(1);
        tokenRewriteStream.replace(0, 3, (Object)"bar");
        tokenRewriteStream.replace(1, 2, (Object)"foo");
        IllegalArgumentException illegalArgumentException = null;
        try {
            tokenRewriteStream.toString();
        }
        catch (IllegalArgumentException illegalArgumentException2) {
            illegalArgumentException = illegalArgumentException2;
        }
        String string = "replace op boundaries of <ReplaceOp@1..2:\"foo\"> overlap with previous <ReplaceOp@0..3:\"bar\">";
        TestTokenRewriteStream.assertNotNull((Object)illegalArgumentException);
        TestTokenRewriteStream.assertEquals((String)string, (String)illegalArgumentException.getMessage());
    }

    public void testOverlappingReplace3() throws Exception {
        Grammar grammar = new Grammar("lexer grammar t;\nA : 'a';\nB : 'b';\nC : 'c';\n");
        ANTLRStringStream aNTLRStringStream = new ANTLRStringStream("abcc");
        Interpreter interpreter = new Interpreter(grammar, aNTLRStringStream);
        TokenRewriteStream tokenRewriteStream = new TokenRewriteStream(interpreter);
        tokenRewriteStream.LT(1);
        tokenRewriteStream.replace(1, 2, (Object)"foo");
        tokenRewriteStream.replace(0, 2, (Object)"bar");
        String string = tokenRewriteStream.toString();
        String string2 = "barc";
        TestTokenRewriteStream.assertEquals((String)string2, (String)string);
    }

    public void testOverlappingReplace4() throws Exception {
        Grammar grammar = new Grammar("lexer grammar t;\nA : 'a';\nB : 'b';\nC : 'c';\n");
        ANTLRStringStream aNTLRStringStream = new ANTLRStringStream("abcc");
        Interpreter interpreter = new Interpreter(grammar, aNTLRStringStream);
        TokenRewriteStream tokenRewriteStream = new TokenRewriteStream(interpreter);
        tokenRewriteStream.LT(1);
        tokenRewriteStream.replace(1, 2, (Object)"foo");
        tokenRewriteStream.replace(1, 3, (Object)"bar");
        String string = tokenRewriteStream.toString();
        String string2 = "abar";
        TestTokenRewriteStream.assertEquals((String)string2, (String)string);
    }

    public void testDropIdenticalReplace() throws Exception {
        Grammar grammar = new Grammar("lexer grammar t;\nA : 'a';\nB : 'b';\nC : 'c';\n");
        ANTLRStringStream aNTLRStringStream = new ANTLRStringStream("abcc");
        Interpreter interpreter = new Interpreter(grammar, aNTLRStringStream);
        TokenRewriteStream tokenRewriteStream = new TokenRewriteStream(interpreter);
        tokenRewriteStream.LT(1);
        tokenRewriteStream.replace(1, 2, (Object)"foo");
        tokenRewriteStream.replace(1, 2, (Object)"foo");
        String string = tokenRewriteStream.toString();
        String string2 = "afooc";
        TestTokenRewriteStream.assertEquals((String)string2, (String)string);
    }

    public void testDropPrevCoveredInsert() throws Exception {
        Grammar grammar = new Grammar("lexer grammar t;\nA : 'a';\nB : 'b';\nC : 'c';\n");
        ANTLRStringStream aNTLRStringStream = new ANTLRStringStream("abcc");
        Interpreter interpreter = new Interpreter(grammar, aNTLRStringStream);
        TokenRewriteStream tokenRewriteStream = new TokenRewriteStream(interpreter);
        tokenRewriteStream.LT(1);
        tokenRewriteStream.insertBefore(1, (Object)"foo");
        tokenRewriteStream.replace(1, 2, (Object)"foo");
        String string = tokenRewriteStream.toString();
        String string2 = "afooc";
        TestTokenRewriteStream.assertEquals((String)string2, (String)string);
    }

    public void testLeaveAloneDisjointInsert() throws Exception {
        Grammar grammar = new Grammar("lexer grammar t;\nA : 'a';\nB : 'b';\nC : 'c';\n");
        ANTLRStringStream aNTLRStringStream = new ANTLRStringStream("abcc");
        Interpreter interpreter = new Interpreter(grammar, aNTLRStringStream);
        TokenRewriteStream tokenRewriteStream = new TokenRewriteStream(interpreter);
        tokenRewriteStream.LT(1);
        tokenRewriteStream.insertBefore(1, (Object)"x");
        tokenRewriteStream.replace(2, 3, (Object)"foo");
        String string = tokenRewriteStream.toString();
        String string2 = "axbfoo";
        TestTokenRewriteStream.assertEquals((String)string2, (String)string);
    }

    public void testLeaveAloneDisjointInsert2() throws Exception {
        Grammar grammar = new Grammar("lexer grammar t;\nA : 'a';\nB : 'b';\nC : 'c';\n");
        ANTLRStringStream aNTLRStringStream = new ANTLRStringStream("abcc");
        Interpreter interpreter = new Interpreter(grammar, aNTLRStringStream);
        TokenRewriteStream tokenRewriteStream = new TokenRewriteStream(interpreter);
        tokenRewriteStream.LT(1);
        tokenRewriteStream.replace(2, 3, (Object)"foo");
        tokenRewriteStream.insertBefore(1, (Object)"x");
        String string = tokenRewriteStream.toString();
        String string2 = "axbfoo";
        TestTokenRewriteStream.assertEquals((String)string2, (String)string);
    }
}

