/*
 * Decompiled with CFR 0.152.
 */
package joana.sdg;

import java.util.Comparator;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import joana.sdg.SDG;
import joana.sdg.SDGEdge;
import joana.sdg.SDGNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SDGSerializer {
    private SDGSerializer() {
    }

    static Iterator<SDGNode> orderedNodes(SDG g2) {
        TreeSet<SDGNode> set = new TreeSet<SDGNode>(new Comparator<SDGNode>(){

            @Override
            public int compare(SDGNode o1, SDGNode o2) {
                return Integer.valueOf(o1.getId()).compareTo(o2.getId());
            }
        });
        Set vertexSet = g2.vertexSet();
        set.addAll(vertexSet);
        return set.iterator();
    }

    public static String toPDGFormat(SDG g2) {
        StringBuffer sb = new StringBuffer("SDG ");
        if (g2.getName() != null) {
            sb.append("\"").append(g2.getName()).append("\" ");
        }
        sb.append("{\n");
        Iterator<SDGNode> iter = SDGSerializer.orderedNodes(g2);
        while (iter.hasNext()) {
            SDGNode n2 = iter.next();
            sb.append(n2.getKind().toString()).append(" ");
            sb.append(n2.getId()).append(" {\n");
            sb.append("O ").append((Object)n2.getOperation()).append(";\n");
            if (n2.getLabel() != null) {
                sb.append("V \"").append(n2.getLabel()).append("\";\n");
            }
            if (n2.getType() != null) {
                sb.append("T \"").append(n2.getType()).append("\";\n");
            }
            sb.append("P ").append(n2.getProc()).append(";\n");
            if (n2.getSource() != null) {
                sb.append("S \"").append(n2.getSource()).append("\":");
                sb.append(n2.getSr()).append(',').append(n2.getSc()).append('-');
                sb.append(n2.getEr()).append(',').append(n2.getEc()).append(";\n");
            }
            if (n2.getThreadNumbers() != null) {
                sb.append("Z ");
                sb.append(n2.getThreadNumbers()[0]);
                for (int i2 = 1; i2 < n2.getThreadNumbers().length; ++i2) {
                    sb.append(", " + n2.getThreadNumbers()[i2]);
                }
                sb.append(";\n");
            }
            sb.append(SDGSerializer.getPDGDependencies(g2, n2));
            sb.append("}\n");
        }
        sb.append("}\n");
        return sb.toString();
    }

    private static String getPDGDependencies(SDG g2, SDGNode n2) {
        String dep = "";
        for (SDGEdge e2 : g2.outgoingEdgesOf(n2)) {
            SDGNode node = e2.getTarget();
            String kind = e2.getKind().toString();
            dep = dep + kind + " " + node.getId();
            if (e2.getLabel() != null) {
                dep = dep + ": \"" + e2.getLabel() + "\"";
            }
            dep = dep + ";\n";
        }
        return dep;
    }
}

