/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.ycomp.view;

import C.A.E;
import C.A.Y;
import C.I.A.A;
import C.I.A.P;
import C.I.A.V;
import C.I.I;
import C.I.o;
import de.unika.ipd.ycomp.attributes.AttributeManager;
import de.unika.ipd.ycomp.view.NoHierarchyException;
import de.unika.ipd.ycomp.view.YCompView;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.regex.PatternSyntaxException;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.border.EmptyBorder;
import javax.swing.tree.TreePath;

public class JSearchPane
extends JPanel {
    public JTree tree;
    public JTextField edit;
    private JComboBox searchTypeCB;
    public String medium;
    private int[] selectionRows;
    private TextGetter textGetter;
    private JLabel find;
    private JList list;
    private I graph;
    private YCompView ycompView;
    private JScrollPane treeScrollPane;
    private E globalNc;
    private AttributeManager am;

    public JSearchPane(YCompView ycompview, I graph, AttributeManager attrManager) throws NoHierarchyException {
        this.ycompView = ycompview;
        this.graph = graph;
        this.am = attrManager;
        this.globalNc = graph.\u00f0();
        this.setTextGetter(attrManager, "Label");
        this.setLayout(new BorderLayout());
        this.find = new JLabel("Find: ");
        this.edit = new JTextField();
        this.edit.addKeyListener(new FindInput());
        this.list = new JList();
        this.treeScrollPane = new JScrollPane(this.list);
        JPanel superpanel = new JPanel();
        superpanel.setLayout(new BorderLayout());
        JPanel jpanel = new JPanel();
        jpanel.setLayout(new BorderLayout());
        jpanel.add((Component)this.find, "West");
        jpanel.add(this.edit);
        superpanel.add((Component)jpanel, "North");
        jpanel = new JPanel();
        jpanel.setLayout(new BoxLayout(jpanel, 0));
        jpanel.setBorder(new EmptyBorder(2, 2, 2, 2));
        JButton nextButton = new JButton("Next");
        nextButton.setMargin(new Insets(0, 0, 0, 0));
        nextButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                JSearchPane.this.moveToNext();
            }
        });
        jpanel.add(nextButton);
        jpanel.add(Box.createHorizontalStrut(2));
        JButton prevButton = new JButton("Prev");
        prevButton.setMargin(new Insets(0, 0, 0, 0));
        prevButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                JSearchPane.this.moveToPrev();
            }
        });
        jpanel.add(prevButton);
        jpanel.add(Box.createHorizontalStrut(2));
        this.searchTypeCB = new JComboBox();
        this.searchTypeCB.setMinimumSize(new Dimension(80, 0));
        this.searchTypeCB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                JSearchPane.this.setTextGetter(JSearchPane.this.am, (String)JSearchPane.this.searchTypeCB.getSelectedItem());
            }
        });
        this.searchTypeCB.addKeyListener(new TypeInput());
        jpanel.add(this.searchTypeCB);
        superpanel.add(jpanel);
        this.add((Component)superpanel, "North");
        A hierarchy = A.E(graph);
        if (hierarchy == null) {
            throw new NoHierarchyException();
        }
        V htm = new V(hierarchy);
        htm.A(V.A(hierarchy));
        this.tree = new P(hierarchy, htm);
        this.treeScrollPane = new JScrollPane(this.tree);
        this.add(this.treeScrollPane);
        this.treeScrollPane.revalidate();
    }

    public void updateSearchTypes() {
        String selItem = (String)this.searchTypeCB.getSelectedItem();
        if (selItem == null) {
            selItem = "Label";
        }
        this.searchTypeCB.removeAllItems();
        this.searchTypeCB.addItem("Label");
        this.searchTypeCB.addItem("Title");
        for (String attrName : this.am.getAvailableNodeAttributeNames()) {
            this.searchTypeCB.addItem(attrName);
        }
        this.searchTypeCB.setSelectedItem(selItem);
    }

    public void setTextGetter(final AttributeManager am, final String medium) {
        if (medium == null) {
            return;
        }
        this.textGetter = medium.equals("Title") ? new TextGetter(){

            public String getText(Y n2) {
                return am.getTitle(n2);
            }
        } : (medium.equals("Label") ? new TextGetter(){

            public String getText(Y n2) {
                return JSearchPane.this.graph.e(n2);
            }
        } : new TextGetter(){

            public String getText(Y n2) {
                return am.getAttribute(n2, medium);
            }
        });
    }

    private void selectNode(String s2) {
        if (s2 == null || s2.equals("")) {
            return;
        }
        E nc = this.graph.k();
        Y last = null;
        nc.toLast();
        while (nc.ok()) {
            String realText = this.textGetter.getText(nc.B());
            if (realText != null) {
                if (this.stringMatch(realText, s2)) {
                    this.graph.A(nc.B(), true);
                    last = nc.B();
                } else {
                    this.graph.A(nc.B(), false);
                }
            }
            nc.prev();
        }
        this.globalNc = this.graph.\u00f0();
        o view = (o)this.graph.\u00da();
        if (view != null) {
            if (last != null) {
                this.ycompView.rememberPosition();
                view.E(this.graph.S(last), this.graph.O(last));
                this.ycompView.rememberPosition();
            }
            this.graph.\u00ef();
        }
        this.selectionRows = this.tree.getSelectionRows();
    }

    private boolean stringMatch(String realText, String s2) {
        try {
            return realText.toLowerCase().matches(s2.toLowerCase()) || realText.toLowerCase().contains(s2.toLowerCase());
        }
        catch (PatternSyntaxException e2) {
            return false;
        }
    }

    public void moveToNext() {
        if (this.globalNc.ok()) {
            try {
                o view;
                this.globalNc.next();
                if (!this.globalNc.ok()) {
                    this.globalNc.toFirst();
                }
                Y n2 = this.globalNc.B();
                if (this.selectionRows == null || this.selectionRows.length == 0) {
                    return;
                }
                for (int i2 = 0; i2 < this.selectionRows.length; ++i2) {
                    TreePath path = this.tree.getPathForRow(this.selectionRows[i2]);
                    Object last = path.getLastPathComponent();
                    if (!last.equals(n2)) continue;
                    this.tree.scrollRowToVisible(this.selectionRows[i2]);
                    break;
                }
                if ((view = (o)this.graph.\u00da()) != null) {
                    this.ycompView.rememberPosition();
                    view.E(this.graph.S(n2), this.graph.O(n2));
                    this.ycompView.rememberPosition();
                    this.graph.\u00ef();
                }
            }
            catch (NullPointerException e1) {
                System.err.println(e1.getMessage());
            }
        }
    }

    public void moveToPrev() {
        if (this.globalNc.ok()) {
            try {
                o view;
                this.globalNc.prev();
                if (!this.globalNc.ok()) {
                    this.globalNc.toLast();
                }
                Y n2 = this.globalNc.B();
                if (this.selectionRows == null || this.selectionRows.length == 0) {
                    return;
                }
                for (int i2 = 0; i2 < this.selectionRows.length; ++i2) {
                    TreePath path = this.tree.getPathForRow(this.selectionRows[i2]);
                    Object last = path.getLastPathComponent();
                    if (!last.equals(n2)) continue;
                    this.tree.scrollRowToVisible(this.selectionRows[i2]);
                    break;
                }
                if ((view = (o)this.graph.\u00da()) != null) {
                    this.ycompView.rememberPosition();
                    view.E(this.graph.S(n2), this.graph.O(n2));
                    this.ycompView.rememberPosition();
                    this.graph.\u00ef();
                }
            }
            catch (NullPointerException e1) {
                System.err.println(e1.getMessage());
            }
        }
    }

    public void focusSearchField() {
        this.edit.requestFocusInWindow();
        this.edit.selectAll();
    }

    public void focusTypeField() {
        this.searchTypeCB.requestFocusInWindow();
    }

    private class TypeInput
    implements KeyListener {
        private TypeInput() {
        }

        public void keyPressed(KeyEvent e2) {
            if (e2.getKeyChar() == '/') {
                JSearchPane.this.focusSearchField();
            }
        }

        public void keyTyped(KeyEvent e2) {
        }

        public void keyReleased(KeyEvent e2) {
            if (e2.getKeyCode() == 10) {
                JSearchPane.this.focusSearchField();
            } else if (e2.getKeyCode() == 27) {
                ((o)JSearchPane.this.graph.\u00da()).\u00ba().requestFocusInWindow();
            }
        }
    }

    private class FindInput
    implements KeyListener {
        private FindInput() {
        }

        public void keyPressed(KeyEvent e2) {
        }

        public void keyTyped(KeyEvent e2) {
        }

        public void keyReleased(KeyEvent e2) {
            if (e2.getKeyCode() == 10) {
                JSearchPane.this.selectNode(JSearchPane.this.edit.getText());
                ((o)JSearchPane.this.graph.\u00da()).\u00ba().requestFocusInWindow();
            } else if (e2.getKeyCode() == 27) {
                ((o)JSearchPane.this.graph.\u00da()).\u00ba().requestFocusInWindow();
            }
        }
    }

    private static interface TextGetter {
        public String getText(Y var1);
    }
}

