/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.ycomp.view;

import C.A.D;
import C.A.H;
import C.A.Y;
import C.I.A.Q;
import C.I.I;
import C.J.L;
import C.J.V;
import de.unika.ipd.ycomp.attributes.AttributeCarrier;
import de.unika.ipd.ycomp.attributes.AttributeManager;
import de.unika.ipd.ycomp.io.ServerPortHandler;
import de.unika.ipd.ycomp.reference.Couple;
import de.unika.ipd.ycomp.reference.ReferenceManager;
import de.unika.ipd.ycomp.reference.ReferenceNodeRealizer;
import de.unika.ipd.ycomp.tooltip.TooltipDrawable;
import de.unika.ipd.ycomp.view.HierarchyView;
import de.unika.ipd.ycomp.view.UndoManager;
import de.unika.ipd.ycomp.view.YCompView;
import java.awt.Cursor;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.lang.ref.WeakReference;
import java.util.Map;

public class AttributeTooltipMode
extends Q {
    private YCompView ycompView;
    private H virtualEdge;
    public boolean isVirtualEdgeMode = true;
    private WeakReference<Y> lastClickedNode;
    private WeakReference<H> lastClickedEdge;
    private TooltipDrawable pressedTooltip = null;
    private double pressedX = 0.0;
    private double pressedY = 0.0;
    AttributeManager am;
    ReferenceManager reference;
    int hf;
    int ff;
    double df;
    double cf;

    AttributeTooltipMode(AttributeManager am, ReferenceManager reference, YCompView ycompView) {
        this.showNodeTips(true);
        this.showEdgeTips(true);
        this.am = am;
        this.reference = reference;
        this.ycompView = ycompView;
        new HierarchyView(this.view, reference.hierarchy);
    }

    protected void nodeCreated(Y newNode) {
        super.nodeCreated(newNode);
        newNode.H().A((Object)newNode, new AttributeCarrier());
    }

    public void mousePressedLeft(double x, double y2) {
        TooltipDrawable hitTooltip = this.getTooltipFromPoint(x, y2);
        if (hitTooltip == null) {
            if (this.ycompView.selectedTooltip != null) {
                this.ycompView.selectedTooltip.setSelected(false);
                this.view.C(this.ycompView.selectedTooltip.getBounds());
                this.ycompView.selectedTooltip = null;
            }
            super.mousePressedLeft(x, y2);
            return;
        }
        if (this.ycompView.selectedTooltip != null && this.ycompView.selectedTooltip != hitTooltip) {
            this.ycompView.selectedTooltip.setSelected(false);
            this.view.C(this.ycompView.selectedTooltip.getBounds());
        }
        hitTooltip.setSelected(true);
        this.ycompView.selectedTooltip = this.pressedTooltip = hitTooltip;
        this.pressedX = x;
        this.pressedY = y2;
        this.view.A(Cursor.getPredefinedCursor(13));
        this.ycompView.fixedTooltips.remove(hitTooltip);
        this.ycompView.fixedTooltips.addFirst(hitTooltip);
        this.view.A().D(hitTooltip);
        this.view.A().C(hitTooltip);
        this.view.C(hitTooltip.getBounds());
    }

    public void mouseReleasedLeft(double x, double y2) {
        TooltipDrawable hitTooltip;
        if (this.pressedTooltip != null) {
            this.pressedTooltip = null;
            this.view.A(Cursor.getPredefinedCursor(0));
        }
        if ((hitTooltip = this.getTooltipFromPoint(x, y2)) != null) {
            return;
        }
        super.mouseReleasedLeft(x, y2);
    }

    public void mouseDraggedLeft(double x, double y2) {
        if (this.pressedTooltip != null) {
            Rectangle oldPos = this.pressedTooltip.getBounds();
            this.pressedTooltip.moveBy(x - this.pressedX, y2 - this.pressedY);
            this.view.C(oldPos);
            this.view.C(this.pressedTooltip.getBounds());
            this.pressedX = x;
            this.pressedY = y2;
            return;
        }
        this.allowEdgeCreation(this.lastDragEvent.isControlDown());
        super.mouseDraggedLeft(x, y2);
    }

    public void mousePressedRight(double x, double y2) {
        TooltipDrawable hitTooltip = this.getTooltipFromPoint(x, y2);
        if (hitTooltip == null) {
            if (this.ycompView.selectedTooltip != null) {
                this.ycompView.selectedTooltip.setSelected(false);
                this.view.C(this.ycompView.selectedTooltip.getBounds());
                this.ycompView.selectedTooltip = null;
            }
            super.mousePressedRight(x, y2);
        }
    }

    protected void paperClicked(I arg0, double arg1, double arg2, boolean arg3) {
        this.allowNodeCreation(this.lastReleaseEvent.isControlDown());
        super.paperClicked(arg0, arg1, arg2, arg3);
    }

    public void mouseMoved(MouseEvent e2) {
        super.mouseMoved(e2);
        if (this.reference.isReferenceNode(this.getHitInfo(e2).C())) {
            this.view.A(Cursor.getPredefinedCursor(12));
            if (this.isVirtualEdgeMode && this.virtualEdge == null) {
                this.drawReferenceEdge(this.getHitInfo(e2).C());
            }
        } else if (this.virtualEdge != null) {
            this.view.A(Cursor.getPredefinedCursor(0));
            if (this.isVirtualEdgeMode) {
                this.removeReferenceEdge();
            }
        }
    }

    public void drawReferenceEdge(Y node) {
        UndoManager um = UndoManager.getInstance(this.getGraph2D());
        um.setUndoEnabled(false);
        Couple couple = this.reference.getCouple(node);
        this.virtualEdge = this.reference.hierarchy.B(node, couple.getOther(node));
        this.view.A().A((Object)this.virtualEdge, new AttributeCarrier());
        this.view.A().X(this.virtualEdge).B(couple.isControlFlowCouple() ? ReferenceNodeRealizer.CONTROLFLOW_COLOR : ReferenceNodeRealizer.DARK_GREEN);
        this.view.B();
        um.setUndoEnabled(true);
    }

    public void removeReferenceEdge() {
        if (this.virtualEdge != null) {
            D g2 = this.virtualEdge.a();
            if (g2 != null) {
                UndoManager um = UndoManager.getInstance(this.getGraph2D());
                um.setUndoEnabled(false);
                g2.H(this.virtualEdge);
                this.view.B();
                um.setUndoEnabled(true);
            }
            this.virtualEdge = null;
        }
    }

    public void mouseClicked(MouseEvent ev) {
        if (ev.getClickCount() == 2) {
            ServerPortHandler server = this.ycompView.getServerPortHandler();
            if (server != null && server.isWaitingForElement()) {
                Y n2;
                Y y2 = n2 = this.lastClickedNode == null ? null : (Y)this.lastClickedNode.get();
                if (n2 != null) {
                    server.sendToClient(n2);
                } else {
                    H e2;
                    H h2 = e2 = this.lastClickedEdge == null ? null : (H)this.lastClickedEdge.get();
                    if (e2 != null) {
                        server.sendToClient(e2);
                    }
                }
            }
        } else {
            this.lastClickedNode = null;
            this.lastClickedEdge = null;
        }
        super.mouseClicked(ev);
    }

    protected void nodeClicked(Y n2) {
        if (this.reference.isReferenceNode(n2)) {
            Y realNode = this.reference.getRealNode(this.reference.getOther(n2));
            Y parent = this.reference.hierarchy.A(realNode);
            I g2 = parent != null && this.reference.hierarchy.C(parent) ? (I)this.reference.hierarchy.T(parent) : (I)this.reference.hierarchy.C();
            g2.\u00de();
            g2.A(realNode, true);
            this.ycompView.rememberPosition();
            this.view.A(g2);
            this.view.E(g2.S(realNode), g2.O(realNode));
            this.view.B();
            this.ycompView.rememberPosition();
            return;
        }
        this.lastClickedNode = new WeakReference<Y>(n2);
        this.lastClickedEdge = null;
    }

    protected void edgeClicked(I graph, H edge, boolean wasSelected, double x, double y2, boolean modifierSet) {
        if (!modifierSet) {
            this.lastClickedNode = null;
            this.lastClickedEdge = new WeakReference<H>(edge);
        }
        super.edgeClicked(graph, edge, wasSelected, x, y2, modifierSet);
    }

    public void mousePressedMiddle(double d2, double d1) {
        this.hf = this.originalX;
        this.ff = this.originalY;
        Point2D point2d = this.view.\u00ce();
        this.df = point2d.getX();
        this.cf = point2d.getY();
        this.view.A(Cursor.getPredefinedCursor(13));
    }

    public void mouseDraggedMiddle(double arg0, double arg1) {
        double d2 = this.originalX - this.hf;
        double d3 = this.originalY - this.ff;
        this.view.E(this.df - d2 / this.view.\u00cc(), this.cf - d3 / this.view.\u00cc());
        this.view.B();
    }

    public void mouseReleasedMiddle(double d2, double d1) {
        this.view.A(Cursor.getPredefinedCursor(0));
    }

    public static String htmlFormatter(String s2) {
        String ret = s2;
        ret = ret.replace("<", "&lt;");
        ret = ret.replace(">", "&gt;");
        ret = ret.replace("\\n", "<br>");
        ret = ret.replace("\n", "<br>");
        return ret;
    }

    protected String getEdgeTip(H e2) {
        String classname;
        AttributeCarrier ac;
        String text = "<html><table>";
        if (this.reference.isReferenceEdge(e2)) {
            e2 = this.reference.getCouple(e2).getOrigEdge();
        }
        if ((ac = this.am.getAttributeCarrier(e2)) == null) {
            return "No info available";
        }
        text = text + "<tr><em>" + AttributeTooltipMode.htmlFormatter(ac.getTitle()) + "</em></tr>";
        String label = ((I)this.am.getGraph()).Y(e2);
        if (label != null) {
            text = text + "<tr><td align=\"texttop\"><strong>label</strong></td>";
            text = text + "<td align=\"texttop\">" + AttributeTooltipMode.htmlFormatter(label) + "</td></tr>";
        }
        if ((classname = this.am.getClassNameOfEdge(e2)) != null) {
            text = text + "<tr><td align=\"texttop\"><strong>classname</strong></td>";
            text = text + "<td align=\"texttop\">" + AttributeTooltipMode.htmlFormatter(classname) + "</td></tr>";
        }
        for (Map.Entry<String, String> attrPair : this.am.getAttributes(e2)) {
            if (!this.am.isEdgeAttrVisible(attrPair.getKey())) continue;
            text = text + "<tr><td valign=\"top\"><strong>" + AttributeTooltipMode.htmlFormatter(attrPair.getKey()) + "</strong></td>" + "<td valign=\"top\">" + AttributeTooltipMode.htmlFormatter(attrPair.getValue()) + "</td></tr>";
        }
        text = text + "</table></html>";
        return text;
    }

    public String getNodeTip(Y node) {
        Y parent;
        String text = "<html><table>";
        if (this.reference.isReferenceNode(node) && (parent = this.reference.hierarchy.A(node = this.reference.getRealNode(this.reference.getOther(node)))) != null) {
            text = text + "<tr><td valign=\"top\"><strong>In group node</strong></td>";
            text = text + "<td valign=\"top\">" + this.getGraph2D().e(parent) + "</td></tr>";
        }
        text = text + "<tr><em>" + AttributeTooltipMode.htmlFormatter(this.am.getTitle(node)) + "</em></tr>";
        String label = ((I)this.am.getGraph()).e(node);
        if (label != null) {
            text = text + "<tr><td valign=\"top\"><strong>label</strong></td><td valign=\"top\">" + AttributeTooltipMode.htmlFormatter(label) + "</td></tr>";
        }
        for (Map.Entry<String, String> attrPair : this.am.getAttributes(node)) {
            if (!this.am.isNodeAttrVisible(attrPair.getKey())) continue;
            text = text + "<tr><td valign=\"top\"><strong>" + AttributeTooltipMode.htmlFormatter(attrPair.getKey()) + "</strong></td>" + "<td valign=\"top\">" + AttributeTooltipMode.htmlFormatter(attrPair.getValue()) + "</td></tr>";
        }
        text = text + "</table></html>";
        return text;
    }

    public void createFixedTooltip(Y node) {
        I graph = this.view.A();
        L point = graph.R(node);
        double x = point.B + graph.Q(node) - 10.0;
        double y2 = point.D + 10.0;
        String tipText = this.getNodeTip(node);
        TooltipDrawable tooltip = new TooltipDrawable(tipText, x, y2);
        graph.C(tooltip);
        if (this.ycompView != null) {
            this.ycompView.fixedTooltips.addFirst(tooltip);
        }
    }

    public void createFixedTooltip(H edge) {
        I graph = this.view.A();
        V path = graph.T(edge);
        L point = new L(0.0, 0.0);
        if (path.H() == 1) {
            point = path.J();
        } else if (path.H() > 1) {
            path.B().next();
            point = (L)path.B().current();
        }
        String tipText = this.getEdgeTip(edge);
        TooltipDrawable tooltip = new TooltipDrawable(tipText, point.B, point.D);
        graph.C(tooltip);
        if (this.ycompView != null) {
            this.ycompView.fixedTooltips.addFirst(tooltip);
            graph.\u00ef();
        }
    }

    public TooltipDrawable getTooltipFromPoint(double x, double y2) {
        for (TooltipDrawable tooltip : this.ycompView.fixedTooltips) {
            if (!tooltip.getBounds().contains(x, y2)) continue;
            return tooltip;
        }
        return null;
    }
}

