/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.ycomp.io;

import C.A.H;
import C.A.X;
import C.A.Y;
import C.A.Z;
import C.E.FA;
import C.E.JA;
import C.E._A;
import C.E.bA;
import C.E.lA;
import C.E.mA;
import C.E.p;
import C.I.$B;
import C.I.A.A;
import C.I.A.M;
import C.I.I;
import C.I.NB;
import C.I.PB;
import C.I.W;
import C.I.gA;
import C.I.s;
import de.unika.ipd.ycomp.VCG.VCGColor;
import de.unika.ipd.ycomp.attributes.AttributeCarrier;
import de.unika.ipd.ycomp.attributes.AttributeManager;
import de.unika.ipd.ycomp.module.Modules;
import de.unika.ipd.ycomp.reference.Couple;
import de.unika.ipd.ycomp.reference.ReferenceManager;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.SwingUtilities;

public class ServerPortHandler
extends Thread {
    private I graph2d;
    private Modules modules;
    private int portNumber;
    private PrintStream warnStream;
    private boolean waitForElement;
    private Y nodeToBeSent;
    private H edgeToBeSent;
    private A hierarchyManager;
    private ReferenceManager referenceManager;
    private HashMap<String, LabelNodeRealizer> nodeRealizers = new HashMap();
    private HashMap<String, LabelEdgeRealizer> edgeRealizers = new HashMap();
    private HashMap<String, Y> nodes = new HashMap();
    private HashMap<Y, String> nodeNames = new HashMap();
    private HashMap<String, H> edges = new HashMap();
    private HashMap<H, String> edgeNames = new HashMap();
    private HashMap<String, Y> subgraphNodes = new HashMap();
    private Pattern PAT_show = Pattern.compile("show");
    private Pattern PAT_sync = Pattern.compile("sync");
    private Pattern PAT_addNode = Pattern.compile("addNode \"(.*)\" \"(.*)\" \"(.*)\" \"(.*)\"");
    private Pattern PAT_addEdge = Pattern.compile("addEdge \"(.*)\" \"(.*)\" \"(.*)\" \"(.*)\" \"(.*)\"");
    private Pattern PAT_addSubgraphNode = Pattern.compile("addSubgraphNode \"(.*)\" \"(.*)\" \"(.*)\" \"(.*)\"");
    private Pattern PAT_moveNode = Pattern.compile("moveNode \"(.*)\" \"(.*)\"");
    private Pattern PAT_changeNode = Pattern.compile("changeNode \"(.*)\" \"(.*)\"");
    private Pattern PAT_changeEdge = Pattern.compile("changeEdge \"(.*)\" \"(.*)\"");
    private Pattern PAT_changeNodeAttr = Pattern.compile("changeNodeAttr \"(.*)\" \"(.*)\" \"(.*)\"");
    private Pattern PAT_changeEdgeAttr = Pattern.compile("changeEdgeAttr \"(.*)\" \"(.*)\" \"(.*)\"");
    private Pattern PAT_clearNodeAttr = Pattern.compile("clearNodeAttr \"(.*)\" \"(.*)\"");
    private Pattern PAT_clearEdgeAttr = Pattern.compile("clearEdgeAttr \"(.*)\" \"(.*)\"");
    private Pattern PAT_setNodeLabel = Pattern.compile("setNodeLabel \"(.*)\" \"(.*)\"");
    private Pattern PAT_setEdgeLabel = Pattern.compile("setEdgeLabel \"(.*)\" \"(.*)\"");
    private Pattern PAT_deleteNode = Pattern.compile("deleteNode \"(.*)\"");
    private Pattern PAT_deleteEdge = Pattern.compile("deleteEdge \"(.*)\"");
    private Pattern PAT_renameNode = Pattern.compile("renameNode \"(.*)\" \"(.*)\"");
    private Pattern PAT_renameEdge = Pattern.compile("renameEdge \"(.*)\" \"(.*)\"");
    private Pattern PAT_deleteGraph = Pattern.compile("deleteGraph");
    private Pattern PAT_addNodeRealizer = Pattern.compile("addNodeRealizer \"(.*)\" \"(.*)\" \"(.*)\" \"(.*)\" \"(.*)\"");
    private Pattern PAT_addEdgeRealizer = Pattern.compile("addEdgeRealizer \"(.*)\" \"(.*)\" \"(.*)\" \"(.*)\" \"(.*)\"");
    private Pattern PAT_setLayout = Pattern.compile("setLayout \"(.*)\"");
    private Pattern PAT_getLayoutOptions = Pattern.compile("getLayoutOptions");
    private Pattern PAT_setLayoutOption = Pattern.compile("setLayoutOption \"(.*)\" \"(.*)\"");
    private Pattern PAT_setOrientation = Pattern.compile("setOrientation \"(.*)\"");
    private Pattern PAT_layout = Pattern.compile("layout");
    private Pattern PAT_exit = Pattern.compile("exit");
    private Pattern PAT_setWarningOut = Pattern.compile("setWarningOut \"(.*)\"");
    private Pattern PAT_waitForElement = Pattern.compile("waitForElement (.*)");
    private gA[] continuous = new gA[]{gA.H, gA.G, gA.F, gA.E, gA.D};
    private gA[] dashed = new gA[]{gA.N, gA.M, gA.L, gA.K, gA.I};
    private gA[] dotted = new gA[]{gA.T, gA.S, gA.R, gA.Q, gA.O};

    public ServerPortHandler(I graph2d, Modules modules, int portNumber) {
        this.graph2d = graph2d;
        this.modules = modules;
        this.portNumber = portNumber;
        this.warnStream = System.out;
        this.hierarchyManager = A.E(graph2d);
        this.referenceManager = ReferenceManager.getInstance(graph2d);
    }

    public void run() {
        this.poll();
    }

    public void sendToClient(Y n) {
        this.nodeToBeSent = n;
    }

    public void sendToClient(H e2) {
        this.edgeToBeSent = e2;
    }

    public boolean isWaitingForElement() {
        return this.waitForElement;
    }

    private void warn(String msg) {
        if (this.warnStream != null) {
            this.warnStream.println("Warning: " + msg);
        }
    }

    private ServerSocket setupServerSocket() {
        ServerSocket ss;
        do {
            try {
                ss = new ServerSocket(this.portNumber);
            }
            catch (IOException e2) {
                e2.printStackTrace(System.err);
                ss = null;
            }
        } while (ss == null);
        return ss;
    }

    private void poll() {
        ServerSocket ss = this.setupServerSocket();
        Socket socket = null;
        BufferedReader in = null;
        OutputStreamWriter out = null;
        String line = null;
        while (true) {
            if (line != null) {
                try {
                    SwingUtilities.invokeAndWait(new ProcessRunnable(new StringBuffer(line), out));
                }
                catch (InterruptedException e2) {
                    e2.printStackTrace(System.err);
                }
                catch (InvocationTargetException e3) {
                    e3.printStackTrace(System.err);
                }
            } else {
                do {
                    try {
                        if (socket != null) {
                            socket.close();
                        }
                        socket = ss.accept();
                        in = new BufferedReader(new InputStreamReader(socket.getInputStream()));
                        out = new OutputStreamWriter(socket.getOutputStream());
                    }
                    catch (IOException e4) {
                        e4.printStackTrace(System.err);
                        in = null;
                        out = null;
                    }
                } while (in == null || out == null);
            }
            try {
                while (!in.ready()) {
                    if (this.nodeToBeSent != null) {
                        this.sendNodeToClientNow(out);
                        continue;
                    }
                    if (this.edgeToBeSent != null) {
                        this.sendEdgeToClientNow(out);
                        continue;
                    }
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e5) {}
                }
                line = in.readLine();
            }
            catch (IOException e6) {
                e6.printStackTrace(System.err);
                System.out.println("poll() : LOOP EXIT\n");
                assert (false) : "poll loop should never terminate!";
                return;
            }
        }
    }

    private void sendNodeToClientNow(OutputStreamWriter out) {
        String id = this.nodeNames.get(this.nodeToBeSent);
        this.nodeToBeSent = null;
        this.waitForElement = false;
        if (id == null) {
            this.warn("sendNodeToClient: Unknown node");
            return;
        }
        try {
            out.write("send " + id);
            out.flush();
        }
        catch (IOException e2) {
            e2.printStackTrace(System.err);
        }
    }

    private void sendEdgeToClientNow(OutputStreamWriter out) {
        String id = this.edgeNames.get(this.edgeToBeSent);
        this.edgeToBeSent = null;
        this.waitForElement = false;
        if (id == null) {
            this.warn("sendEdgeToClient: Unknown edge");
            return;
        }
        try {
            out.write("send " + id);
            out.flush();
        }
        catch (IOException e2) {
            e2.printStackTrace(System.err);
        }
    }

    private synchronized void processStatement(StringBuffer statement, OutputStreamWriter out) {
        assert (statement != null);
        Matcher m = this.PAT_show.matcher(statement);
        if (m.matches()) {
            this.show();
        } else {
            m = this.PAT_sync.matcher(statement);
            if (m.matches()) {
                this.sync(out);
            } else {
                m = this.PAT_addNode.matcher(statement);
                if (m.matches()) {
                    this.addNode(m.group(1), m.group(2), m.group(3), m.group(4));
                } else {
                    m = this.PAT_addEdge.matcher(statement);
                    if (m.matches()) {
                        this.addEdge(m.group(1), m.group(2), m.group(3), m.group(4), m.group(5));
                    } else {
                        m = this.PAT_addSubgraphNode.matcher(statement);
                        if (m.matches()) {
                            this.addSubgraphNode(m.group(1), m.group(2), m.group(3), m.group(4));
                        } else {
                            m = this.PAT_moveNode.matcher(statement);
                            if (m.matches()) {
                                this.moveNode(m.group(1), m.group(2));
                            } else {
                                m = this.PAT_changeNode.matcher(statement);
                                if (m.matches()) {
                                    this.changeNode(m.group(1), m.group(2));
                                } else {
                                    m = this.PAT_changeEdge.matcher(statement);
                                    if (m.matches()) {
                                        this.changeEdge(m.group(1), m.group(2));
                                    } else {
                                        m = this.PAT_changeNodeAttr.matcher(statement);
                                        if (m.matches()) {
                                            this.changeNodeAttr(m.group(1), m.group(2), m.group(3));
                                        } else {
                                            m = this.PAT_changeEdgeAttr.matcher(statement);
                                            if (m.matches()) {
                                                this.changeEdgeAttr(m.group(1), m.group(2), m.group(3));
                                            } else {
                                                m = this.PAT_clearNodeAttr.matcher(statement);
                                                if (m.matches()) {
                                                    this.clearNodeAttr(m.group(1), m.group(2));
                                                } else {
                                                    m = this.PAT_clearEdgeAttr.matcher(statement);
                                                    if (m.matches()) {
                                                        this.clearEdgeAttr(m.group(1), m.group(2));
                                                    } else {
                                                        m = this.PAT_setNodeLabel.matcher(statement);
                                                        if (m.matches()) {
                                                            this.setNodeLabel(m.group(1), m.group(2));
                                                        } else {
                                                            m = this.PAT_setEdgeLabel.matcher(statement);
                                                            if (m.matches()) {
                                                                this.setEdgeLabel(m.group(1), m.group(2));
                                                            } else {
                                                                m = this.PAT_deleteNode.matcher(statement);
                                                                if (m.matches()) {
                                                                    this.deleteNode(m.group(1));
                                                                } else {
                                                                    m = this.PAT_deleteEdge.matcher(statement);
                                                                    if (m.matches()) {
                                                                        this.deleteEdge(m.group(1));
                                                                    } else {
                                                                        m = this.PAT_renameNode.matcher(statement);
                                                                        if (m.matches()) {
                                                                            this.renameNode(m.group(1), m.group(2));
                                                                        } else {
                                                                            m = this.PAT_renameEdge.matcher(statement);
                                                                            if (m.matches()) {
                                                                                this.renameEdge(m.group(1), m.group(2));
                                                                            } else {
                                                                                m = this.PAT_deleteGraph.matcher(statement);
                                                                                if (m.matches()) {
                                                                                    this.deleteGraph();
                                                                                } else {
                                                                                    m = this.PAT_addNodeRealizer.matcher(statement);
                                                                                    if (m.matches()) {
                                                                                        this.addNodeRealizer(m.group(1), m.group(2), m.group(3), m.group(4), m.group(5));
                                                                                    } else {
                                                                                        m = this.PAT_addEdgeRealizer.matcher(statement);
                                                                                        if (m.matches()) {
                                                                                            this.addEdgeRealizer(m.group(1), m.group(2), m.group(3), m.group(4), m.group(5));
                                                                                        } else {
                                                                                            m = this.PAT_layout.matcher(statement);
                                                                                            if (m.matches()) {
                                                                                                this.layout();
                                                                                            } else {
                                                                                                m = this.PAT_setLayout.matcher(statement);
                                                                                                if (m.matches()) {
                                                                                                    this.setLayout(m.group(1));
                                                                                                } else {
                                                                                                    m = this.PAT_getLayoutOptions.matcher(statement);
                                                                                                    if (m.matches()) {
                                                                                                        this.getLayoutOptions(out);
                                                                                                    } else {
                                                                                                        m = this.PAT_setLayoutOption.matcher(statement);
                                                                                                        if (m.matches()) {
                                                                                                            this.setLayoutOption(m.group(1), m.group(2), out);
                                                                                                        } else {
                                                                                                            m = this.PAT_setOrientation.matcher(statement);
                                                                                                            if (m.matches()) {
                                                                                                                this.setOrientation(m.group(1));
                                                                                                            } else {
                                                                                                                m = this.PAT_exit.matcher(statement);
                                                                                                                if (m.matches()) {
                                                                                                                    this.exit();
                                                                                                                } else {
                                                                                                                    m = this.PAT_setWarningOut.matcher(statement);
                                                                                                                    if (m.matches()) {
                                                                                                                        this.setWarningOut(m.group(1));
                                                                                                                    } else {
                                                                                                                        m = this.PAT_waitForElement.matcher(statement);
                                                                                                                        if (m.matches()) {
                                                                                                                            this.waitForElement(m.group(1));
                                                                                                                        } else {
                                                                                                                            this.warn("Unknown Statement: " + statement);
                                                                                                                        }
                                                                                                                    }
                                                                                                                }
                                                                                                            }
                                                                                                        }
                                                                                                    }
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    private void exit() {
        System.exit(0);
    }

    private void waitForElement(String val) {
        if (val.equals("true")) {
            this.waitForElement = true;
        } else if (val.equals("false")) {
            this.waitForElement = false;
        } else {
            this.warn("Unknown boolean value: \"" + val + "\"");
        }
    }

    private void setLayout(String name) {
        JRadioButtonMenuItem menuItem = this.modules.getModuleMenuItemByName(name);
        if (menuItem == null) {
            this.warn("Unknown layout module: " + name);
            return;
        }
        menuItem.doClick();
    }

    private void getLayoutOptions(OutputStreamWriter out) {
        try {
            C.B.H module = this.modules.getCurrentLayoutModule();
            lA optHandler = module.getOptionHandler();
            for (int i2 = 0; i2 < optHandler.\u00f1(); ++i2) {
                JA optSec = optHandler.G(i2);
                for (int j = 0; j < optSec.size(); ++j) {
                    FA item = optSec.E(j);
                    if (item instanceof _A) {
                        _A enumItem = (_A)item;
                        String possVals = null;
                        for (Object enumVal : enumItem.\u00a5()) {
                            possVals = (possVals == null ? "" : possVals + ", ") + enumVal.toString();
                        }
                        out.write(item.j() + " = " + item.d() + " (possible: " + possVals + ")\n");
                        continue;
                    }
                    out.write(item.j() + " = " + item.d() + "\n");
                }
            }
            out.write("endoptions\n");
            out.flush();
        }
        catch (IOException e2) {
            e2.printStackTrace(System.err);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void setLayoutOption(String optionName, String optionValue, OutputStreamWriter out) {
        try {
            String errorMsg = "Option \"" + optionName + "\" does not exist!\n";
            C.B.H module = this.modules.getCurrentLayoutModule();
            lA optHandler = module.getOptionHandler();
            block6: for (int i2 = 0; i2 < optHandler.\u00f1(); ++i2) {
                block17: {
                    int len$;
                    Object[] arr$;
                    boolean found;
                    FA item;
                    block18: {
                        JA optSec = optHandler.G(i2);
                        for (int j = 0; j < optSec.size(); ++j) {
                            item = optSec.E(j);
                            if (!item.j().equals(optionName)) continue;
                            if (item instanceof bA) {
                                try {
                                    int val = Integer.parseInt(optionValue);
                                    item.C(val);
                                    break block17;
                                }
                                catch (NumberFormatException ex) {
                                    errorMsg = "\"" + optionValue + "\" is not an integer!";
                                    break block6;
                                }
                            }
                            if (item instanceof p) {
                                try {
                                    double val = Double.parseDouble(optionValue);
                                    item.C(val);
                                    break block17;
                                }
                                catch (NumberFormatException ex) {
                                    errorMsg = "\"" + optionValue + "\" is not a double!";
                                    break block6;
                                }
                            }
                            if (item instanceof _A) {
                                _A enumItem = (_A)item;
                                found = false;
                                arr$ = enumItem.\u00a5();
                                len$ = arr$.length;
                                break block18;
                            }
                            if (item instanceof mA) {
                                if (optionValue.equalsIgnoreCase("true")) {
                                    item.C(Boolean.TRUE);
                                    break block17;
                                }
                                if (optionValue.equalsIgnoreCase("false")) {
                                    item.C(Boolean.FALSE);
                                    break block17;
                                } else {
                                    errorMsg = "\"" + optionValue + "\" is not a boolean!";
                                    break block6;
                                }
                            }
                            item.C(optionValue);
                            break block17;
                        }
                        continue;
                    }
                    for (int i$ = 0; i$ < len$; ++i$) {
                        Object enumVal = arr$[i$];
                        if (!enumVal.toString().equals(optionValue)) continue;
                        found = true;
                        break;
                    }
                    if (!found) {
                        errorMsg = "\"" + optionValue + "\" is not a valid value for this enum!";
                        break;
                    }
                    item.C(optionValue);
                }
                errorMsg = "optionset\n";
                break;
            }
            out.write(errorMsg);
            out.flush();
            return;
        }
        catch (IOException e2) {
            e2.printStackTrace(System.err);
        }
    }

    private void setOrientation(String orientation) {
        C.B.H module = this.modules.getCurrentLayoutModule();
        lA optHandler = module.getOptionHandler();
        for (int i2 = 0; i2 < optHandler.\u00f1(); ++i2) {
            JA optSec = optHandler.G(i2);
            for (int j = 0; j < optSec.size(); ++j) {
                if (!optSec.E(j).j().equals("ORIENTATION")) continue;
                optSec.E(j).C(orientation);
                return;
            }
        }
        this.warn("setOrientation not supported by current layout module!");
    }

    private void show() {
        this.graph2d.\u00ef();
    }

    private void layout() {
        this.modules.getCurrentLayoutModule().start(this.graph2d);
    }

    private void sync(OutputStreamWriter out) {
        try {
            out.write("sync\n");
            out.flush();
        }
        catch (IOException e2) {
            e2.printStackTrace(System.err);
        }
    }

    private void addNodeRealizer(String id, String linecolor, String fillcolor, String textcolor, String shapeName) {
        C.I.mA nr = this.graph2d.\u00e4();
        NB snr = new NB(nr);
        this.nodeRealizers.put(id, new LabelNodeRealizer(snr, VCGColor.getColorIgnoreCase(textcolor)));
        snr.setLineColor(VCGColor.getColorIgnoreCase(linecolor));
        snr.setFillColor(VCGColor.getColorIgnoreCase(fillcolor));
        if (!shapeName.equals("box")) {
            int shapeVal;
            if (shapeName.equals("triangle")) {
                shapeVal = 5;
            } else if (shapeName.equals("circle")) {
                shapeVal = 2;
            } else if (shapeName.equals("ellipse")) {
                shapeVal = 2;
            } else if (shapeName.equals("rhomb")) {
                shapeVal = 8;
            } else if (shapeName.equals("hexagon")) {
                shapeVal = 4;
            } else if (shapeName.equals("trapeze")) {
                shapeVal = 9;
            } else if (shapeName.equals("uptrapeze")) {
                shapeVal = 10;
            } else if (shapeName.equals("lparallelogram")) {
                shapeVal = 3;
            } else if (shapeName.equals("rparallelogram")) {
                shapeVal = 3;
            } else {
                this.warn("Unknown shape: " + shapeName);
                return;
            }
            snr.setShapeType((byte)shapeVal);
        }
    }

    private void addEdgeRealizer(String id, String linecolor, String textcolor, String thickness, String linestyle) {
        gA[] lt;
        int thick;
        $B er = this.graph2d.\u00ea().y();
        this.edgeRealizers.put(id, new LabelEdgeRealizer(er, VCGColor.getColorIgnoreCase(textcolor)));
        er.B(VCGColor.getColorIgnoreCase(linecolor));
        try {
            thick = Integer.parseInt(thickness);
        }
        catch (NumberFormatException e2) {
            thick = -1;
        }
        if (thick < 1 || thick > 5) {
            this.warn("Illegal thickness (must be an integer between 1 and 5): " + thickness);
            return;
        }
        if (linestyle.equals("dashed")) {
            lt = this.dashed;
        } else if (linestyle.equals("dotted")) {
            lt = this.dotted;
        } else if (linestyle.equals("continuous")) {
            lt = this.continuous;
        } else {
            this.warn("Illegal linestyle (must be either dashed, dotted or continuous): " + linestyle);
            return;
        }
        er.B(lt[thick - 1]);
    }

    private String unescape(String label) {
        return label.replace("\\\\", "\\").replace("\\n", "\n");
    }

    private void addNode(String parentId, String id, String realizerId, String label) {
        LabelNodeRealizer lnr;
        Y parentNode;
        if (this.nodes.containsKey(id)) {
            this.warn("addNode: Node already exists: " + id);
            return;
        }
        if (!parentId.equals("-1")) {
            parentNode = this.subgraphNodes.get(parentId);
            if (parentNode == null) {
                this.warn("addNode: Unknown parent graph: " + parentId);
                return;
            }
        } else {
            parentNode = null;
        }
        if ((lnr = this.nodeRealizers.get(realizerId)) == null) {
            this.warn("addNode: Unknown NodeRealizer: " + realizerId);
            return;
        }
        C.I.mA nr = lnr.nodeRealizer.createCopy();
        Y n = this.graph2d.B(nr);
        this.graph2d.A((Object)n, new AttributeCarrier());
        this.nodes.put(id, n);
        this.nodeNames.put(n, id);
        if (parentNode != null) {
            this.hierarchyManager.F(new X(n), parentNode);
        }
        AttributeManager am = AttributeManager.getInstance(this.graph2d);
        am.setTitle(n, id);
        this.graph2d.A(n, this.unescape(label));
        nr.getLabel().setTextColor(lnr.textColor);
        this.adjustNodeSize2Label(n);
    }

    private void addEdge(String id, String src, String tgt, String realizerId, String label) {
        if (this.edges.containsKey(id)) {
            this.warn("addEdge: Edge already exists: " + id);
            return;
        }
        Y nsrc = this.nodes.get(src);
        Y ntgt = this.nodes.get(tgt);
        LabelEdgeRealizer ler = this.edgeRealizers.get(realizerId);
        if (nsrc == null) {
            this.warn("addEdge: Unknown source Node: " + src);
            return;
        }
        if (ntgt == null) {
            this.warn("addEdge: Unknown target Node: " + tgt);
            return;
        }
        if (ler == null) {
            this.warn("addEdge: Unknown EdgeRealizer: " + realizerId);
            return;
        }
        $B er = ler.edgeRealizer.y();
        H e2 = this.graph2d.A(nsrc, ntgt, er);
        this.graph2d.A((Object)e2, new AttributeCarrier());
        this.edges.put(id, e2);
        this.edgeNames.put(e2, id);
        AttributeManager am = AttributeManager.getInstance(this.graph2d);
        am.setTitle(e2, id);
        this.graph2d.A(e2, this.unescape(label));
        er.L().setTextColor(ler.textColor);
    }

    private void addSubgraphNode(String parentId, String id, String realizerId, String label) {
        LabelNodeRealizer lnr;
        Y parentNode;
        if (this.nodes.containsKey(id)) {
            this.warn("addSubgraphNode: Node already exists: " + id);
            return;
        }
        if (!parentId.equals("-1")) {
            parentNode = this.subgraphNodes.get(parentId);
            if (parentNode == null) {
                this.warn("addSubgraphNode: Unknown subgraph node: " + parentId);
                return;
            }
        } else {
            parentNode = null;
        }
        if ((lnr = this.nodeRealizers.get(realizerId)) == null) {
            this.warn("addSubgraphNode: Unknown NodeRealizer: " + realizerId);
            return;
        }
        Y subGraphNode = this.hierarchyManager.L(this.graph2d);
        this.graph2d.A((Object)subGraphNode, new AttributeCarrier());
        if (parentNode != null) {
            this.hierarchyManager.F(new X(subGraphNode), parentNode);
        }
        this.subgraphNodes.put(id, subGraphNode);
        this.nodes.put(id, subGraphNode);
        this.nodeNames.put(subGraphNode, id);
        AttributeManager am = AttributeManager.getInstance(this.graph2d);
        am.setTitle(subGraphNode, id);
        M gnr = (M)this.graph2d.f(subGraphNode).createCopy();
        gnr.N(false);
        gnr.setFillColor(lnr.nodeRealizer.getFillColor());
        gnr.setLineColor(lnr.nodeRealizer.getLineColor());
        this.graph2d.A(subGraphNode, gnr);
        this.graph2d.A(subGraphNode, this.unescape(label));
        gnr.getLabel().setTextColor(lnr.textColor);
    }

    private void moveNode(String id, String destSubgraphNodeId) {
        Y node = this.nodes.get(id);
        if (node == null) {
            this.warn("moveNode: Unknown Node: " + id);
            return;
        }
        if (destSubgraphNodeId.equals("-1")) {
            this.hierarchyManager.D(new X(node));
        } else {
            Y subgraphNode = this.subgraphNodes.get(destSubgraphNodeId);
            if (subgraphNode == null) {
                this.warn("moveNode: Unknown subgraph node: " + destSubgraphNodeId);
                return;
            }
            Y curNode = subgraphNode;
            while ((curNode = this.hierarchyManager.A(curNode)) != null) {
                if (curNode != node) continue;
                this.warn("moveNode: Ignoring move leading to cycle in group hierarchy: " + id + " -> " + destSubgraphNodeId);
                return;
            }
            LinkedList<Couple> coupleList = this.referenceManager.getCouplesForNode(node);
            if (coupleList != null) {
                LinkedList copiedList = (LinkedList)coupleList.clone();
                for (Couple couple : copiedList) {
                    this.referenceManager.deleteCoupleNoFold(couple, true, null);
                }
            }
            this.hierarchyManager.F(new X(node), subgraphNode);
        }
    }

    private void changeNode(String id, String newRealizerId) {
        Y node = this.nodes.get(id);
        if (node == null) {
            this.warn("changeNode: Unknown Node: " + id);
            return;
        }
        C.I.mA oldRealizer = this.graph2d.f(node);
        String title = oldRealizer.getLabelText();
        LabelNodeRealizer newLRealizer = this.nodeRealizers.get(newRealizerId);
        if (newLRealizer == null) {
            this.warn("changeNode: Unknown NodeRealizer: " + newRealizerId);
            return;
        }
        if (this.hierarchyManager.V(node)) {
            M gnr = (M)this.graph2d.f(node).createCopy();
            gnr.N(false);
            gnr.setFillColor(newLRealizer.nodeRealizer.getFillColor());
            gnr.setLineColor(newLRealizer.nodeRealizer.getLineColor());
            this.graph2d.A(node, gnr);
            gnr.getLabel().setTextColor(newLRealizer.textColor);
            this.adjustNodeSize2Label(node);
            gnr.setX(oldRealizer.getX());
            gnr.setY(oldRealizer.getY());
        } else {
            C.I.mA newRealizer = newLRealizer.nodeRealizer.createCopy();
            newRealizer.setLabelText(title);
            newRealizer.getLabel().setTextColor(newLRealizer.textColor);
            this.graph2d.A(node, newRealizer);
            this.adjustNodeSize2Label(node);
            newRealizer.setX(oldRealizer.getX());
            newRealizer.setY(oldRealizer.getY());
        }
    }

    private void applyEdgeRealizer(H edge, LabelEdgeRealizer realizer) {
        $B oldRealizer = this.graph2d.X(edge);
        String title = oldRealizer.p();
        $B newRealizer = realizer.edgeRealizer.y();
        newRealizer.A(title);
        newRealizer.L().setTextColor(realizer.textColor);
        PB bendcursor = oldRealizer.Y();
        while (bendcursor.ok()) {
            W bend = bendcursor.E();
            newRealizer.D(bend.A(), bend.D());
            bendcursor.next();
        }
        this.graph2d.A(edge, newRealizer);
    }

    private void changeEdge(String id, String newRealizerId) {
        H edge = this.edges.get(id);
        if (edge == null) {
            this.warn("changeEdge: Unknown Edge: " + id);
            return;
        }
        LabelEdgeRealizer newLRealizer = this.edgeRealizers.get(newRealizerId);
        if (newLRealizer == null) {
            this.warn("changeEdge: Unknown EdgeRealizer: " + newRealizerId);
            return;
        }
        Couple couple = this.referenceManager.getCouple(edge);
        if (couple != null) {
            this.applyEdgeRealizer(couple.getSrcRefEdge(), newLRealizer);
            this.applyEdgeRealizer(couple.getTgtRefEdge(), newLRealizer);
        }
        this.applyEdgeRealizer(edge, newLRealizer);
    }

    private void changeNodeAttr(String id, String attrName, String attrValue) {
        Y node = this.nodes.get(id);
        if (node == null) {
            this.warn("changeNodeAttr: Unknown Node: " + id);
            return;
        }
        AttributeManager am = AttributeManager.getInstance(this.graph2d);
        am.setAttribute(node, attrName, attrValue);
    }

    private void changeEdgeAttr(String id, String attrName, String attrValue) {
        H edge = this.edges.get(id);
        if (edge == null) {
            this.warn("changeEdgeAttr: Unknown Edge: " + id);
            return;
        }
        AttributeManager am = AttributeManager.getInstance(this.graph2d);
        am.setAttribute(edge, attrName, attrValue);
    }

    private void clearNodeAttr(String id, String attrName) {
        Y node = this.nodes.get(id);
        if (node == null) {
            this.warn("clearNodeAttr: Unknown Node: " + id);
            return;
        }
        AttributeManager am = AttributeManager.getInstance(this.graph2d);
        am.setAttribute(node, attrName, null);
    }

    private void clearEdgeAttr(String id, String attrName) {
        H edge = this.edges.get(id);
        if (edge == null) {
            this.warn("clearEdgeAttr: Unknown Edge: " + id);
            return;
        }
        AttributeManager am = AttributeManager.getInstance(this.graph2d);
        am.setAttribute(edge, attrName, null);
    }

    private void setNodeLabel(String id, String newLabel) {
        Y node = this.nodes.get(id);
        if (node == null) {
            this.warn("setNodeLabel: Unknown Node: " + id);
            return;
        }
        this.graph2d.A(node, this.unescape(newLabel));
        this.adjustNodeSize2Label(node);
    }

    private void setEdgeLabel(String id, String newLabel) {
        H edge = this.edges.get(id);
        if (edge == null) {
            this.warn("setEdgeLabel: Unknown Edge: " + id);
            return;
        }
        newLabel = this.unescape(newLabel);
        Couple couple = this.referenceManager.getCouple(edge);
        if (couple != null) {
            this.graph2d.A(couple.getSrcRefEdge(), newLabel);
            this.graph2d.A(couple.getTgtRefEdge(), newLabel);
        }
        this.graph2d.A(edge, newLabel);
    }

    private void deleteGraph() {
        this.nodes.clear();
        this.nodeNames.clear();
        this.edges.clear();
        this.edgeNames.clear();
        this.subgraphNodes.clear();
        AttributeManager.getInstance(this.graph2d).clear();
        this.graph2d._();
        this.graph2d.\u00ef();
    }

    private void deleteNode(String id) {
        Y node = this.nodes.get(id);
        if (node == null) {
            this.warn("deleteNode: Unknown Node: " + id);
            return;
        }
        Z edgecursor = node.I();
        while (edgecursor.ok()) {
            H edge = edgecursor.D();
            String edgeid = this.edgeNames.get(edge);
            this.edgeNames.remove(edge);
            this.edges.remove(edgeid);
            edgecursor.next();
        }
        this.nodes.remove(id);
        this.nodeNames.remove(node);
        this.graph2d.B(node);
    }

    private void deleteEdge(String id) {
        H edge = this.edges.get(id);
        if (edge == null) {
            this.warn("deleteEdge: Unknown Edge: " + id);
            return;
        }
        this.edges.remove(id);
        this.edgeNames.remove(edge);
        Couple couple = this.referenceManager.getCouple(edge);
        if (couple != null) {
            this.referenceManager.deleteCoupleNoFold(couple, false, null);
        } else {
            this.graph2d.H(edge);
        }
    }

    private void renameNode(String oldId, String newId) {
        Y node = this.nodes.get(oldId);
        if (node == null) {
            this.warn("renameNode: Unknown Node: " + oldId);
            return;
        }
        this.nodes.remove(oldId);
        this.nodes.put(newId, node);
        this.nodeNames.put(node, newId);
    }

    private void renameEdge(String oldId, String newId) {
        H edge = this.edges.get(oldId);
        if (edge == null) {
            this.warn("renameEdge: Unknown Edge: " + oldId);
            return;
        }
        this.edges.remove(oldId);
        this.edges.put(newId, edge);
        this.edgeNames.put(edge, newId);
    }

    private void setWarningOut(String dest) {
        if (dest.equals("stderr")) {
            this.warnStream = System.err;
        } else if (dest.equals("stdout")) {
            this.warnStream = System.out;
        } else if (dest.equals("none")) {
            this.warnStream = null;
        } else {
            this.warn("Unknown warning out: " + dest);
        }
    }

    private void adjustNodeSize2Label(Y n) {
        C.I.mA nr = this.graph2d.f(n);
        s lr = nr.getLabel();
        if (lr.getWidth() + 10.0 > nr.getWidth()) {
            nr.setWidth(lr.getWidth() + 10.0);
        }
        if (lr.getHeight() + 10.0 > nr.getHeight()) {
            nr.setHeight(lr.getHeight() + 10.0);
        }
    }

    private class ProcessRunnable
    implements Runnable {
        StringBuffer stringbuffer;
        OutputStreamWriter out;

        public ProcessRunnable(StringBuffer stringbuffer, OutputStreamWriter out) {
            this.stringbuffer = stringbuffer;
            this.out = out;
        }

        public void run() {
            ServerPortHandler.this.processStatement(this.stringbuffer, this.out);
        }
    }

    private class LabelEdgeRealizer {
        public $B edgeRealizer;
        public Color textColor;

        public LabelEdgeRealizer($B edgeRealizer, Color textColor) {
            this.edgeRealizer = edgeRealizer;
            this.textColor = textColor;
        }
    }

    private class LabelNodeRealizer {
        public C.I.mA nodeRealizer;
        public Color textColor;

        public LabelNodeRealizer(C.I.mA nodeRealizer, Color textColor) {
            this.nodeRealizer = nodeRealizer;
            this.textColor = textColor;
        }
    }
}

