/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.ycomp.io;

import C.A.H;
import C.A.Y;
import C.H.F;
import C.I.$B;
import C.I.I;
import C.I.mA;
import C.I.s;
import de.unika.ipd.ycomp.attributes.AttributeCarrier;
import de.unika.ipd.ycomp.attributes.AttributeManager;
import java.awt.Color;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import joana.sdg.SDG;
import joana.sdg.SDGEdge;
import joana.sdg.SDGNode;

public class SDGIOHandler
extends F {
    private AttributeManager attributeManager;
    private HashMap<SDGNode.Kind, Color> nodeColors = new HashMap();
    private HashMap<SDGEdge.Kind, Color> edgeColors = new HashMap();
    private HashMap<SDGEdge.Kind, Integer> edgeClasses = new HashMap();

    public SDGIOHandler() {
        this.initColors();
    }

    public String getFileFormatString() {
        return "SDG Files";
    }

    public String getFileNameExtension() {
        return "pdg";
    }

    private static void adjustLabelSize(I graph, Y n) {
        mA nr = graph.f(n);
        s lr = nr.getLabel();
        if (lr.getWidth() + 10.0 > nr.getWidth()) {
            nr.setWidth(lr.getWidth() + 10.0);
        }
        if (lr.getHeight() + 10.0 > nr.getHeight()) {
            nr.setHeight(lr.getHeight() + 10.0);
        }
    }

    private void initColors() {
        Color color;
        String colorString;
        Properties colorproperties = new Properties();
        try {
            InputStream inStream = ClassLoader.getSystemResourceAsStream("de/unika/ipd/ycomp/SDG/sdgcolors.properties");
            colorproperties.load(inStream);
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        for (SDGNode.Kind kind : SDGNode.Kind.values()) {
            colorString = colorproperties.getProperty(kind.toString());
            if (colorString == null) continue;
            try {
                color = Color.decode(colorString);
                this.nodeColors.put(kind, color);
            }
            catch (Exception e3) {
                e3.printStackTrace();
            }
        }
        for (Enum enum_ : SDGEdge.Kind.values()) {
            colorString = colorproperties.getProperty(((SDGEdge.Kind)enum_).toString() + "_COL");
            if (colorString == null) continue;
            try {
                color = Color.decode(colorString);
                this.edgeColors.put((SDGEdge.Kind)enum_, color);
            }
            catch (Exception e4) {
                e4.printStackTrace();
            }
        }
    }

    public void read(I graph, InputStream in) throws IOException {
        this.attributeManager = AttributeManager.getInstance(graph);
        try {
            SDG sdg = SDG.readFrom(in);
            int id = 0;
            for (SDGEdge.Kind kind : SDGEdge.Kind.values()) {
                this.edgeClasses.put(kind, id);
                this.attributeManager.setEdgeClassName(id, kind.name());
                ++id;
            }
            Iterator i2 = sdg.vertexSet().iterator();
            HashMap<SDGNode, Y> nodemap = new HashMap<SDGNode, Y>();
            while (i2.hasNext()) {
                SDGNode sdgnode = (SDGNode)i2.next();
                String label = "" + sdgnode.getId();
                if (sdgnode.getLabel() != null) {
                    label = label + " " + sdgnode.getLabel();
                }
                Y n = graph.A(0.0, 0.0, label);
                nodemap.put(sdgnode, n);
                SDGIOHandler.adjustLabelSize(graph, n);
                mA realizer = graph.f(n);
                realizer.setFillColor(this.nodeColors.get((Object)sdgnode.getKind()));
                graph.A((Object)n, new AttributeCarrier());
                this.attributeManager.setTitle(n, label);
                this.attributeManager.setAttribute(n, "Value", sdgnode.getLabel());
                this.attributeManager.setAttribute(n, "Operation", sdgnode.getOperation().toString());
                this.attributeManager.setAttribute(n, "Kind", sdgnode.getKind().toString());
                this.attributeManager.setAttribute(n, "Id", Integer.toString(sdgnode.getId()));
                if (sdgnode.getThreadNumbers() != null) {
                    StringBuilder builder = new StringBuilder();
                    boolean first = true;
                    for (int tn : sdgnode.getThreadNumbers()) {
                        builder.append(tn);
                        if (first) {
                            first = false;
                            continue;
                        }
                        builder.append(", ");
                    }
                    this.attributeManager.setAttribute(n, "ThreadNumbers", builder.toString());
                }
                if (sdgnode.getType() == null) continue;
                this.attributeManager.setAttribute(n, "Type", sdgnode.getType());
            }
            for (SDGEdge sdgedge : sdg.edgeSet()) {
                Y from = (Y)nodemap.get(sdgedge.getSource());
                Y to = (Y)nodemap.get(sdgedge.getTarget());
                H edge = graph.A(from, to);
                $B realizer = graph.X(edge);
                realizer.B(this.edgeColors.get((Object)sdgedge.getKind()));
                if (sdgedge.getLabel() != null) {
                    realizer.A(sdgedge.getLabel());
                }
                graph.A((Object)edge, new AttributeCarrier());
                this.attributeManager.setClassOfEdge(edge, this.edgeClasses.get((Object)sdgedge.getKind()));
            }
        }
        catch (Exception e2) {
            System.out.println("Parse Error: " + e2.getMessage());
            throw new IOException(e2.getMessage());
        }
    }

    public boolean canWrite() {
        return false;
    }

    public boolean canWriteSubset() {
        return false;
    }

    public void write(I arg0, OutputStream arg1) throws IOException {
        throw new IOException("cannot write");
    }
}

