/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.ycomp.attributes;

import C.A.D;
import C.A.G;
import C.A.H;
import C.A.Y;
import C.A.a;
import de.unika.ipd.ycomp.attributes.AttributeCarrier;
import de.unika.ipd.ycomp.util.Iterabler;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeManager {
    private D graph;
    private HashMap<Integer, String> nodeClassIDToClassnameMap;
    private HashMap<Integer, String> edgeClassIDToClassnameMap;
    private HashMap<String, Integer> nodeClassnameToClassIDMap;
    private HashMap<String, Integer> edgeClassnameToClassIDMap;
    private HashMap<String, Boolean> nodeAttrNameToVisibleMap;
    private HashMap<String, Boolean> edgeAttrNameToVisibleMap;
    private static a managerList = new a();
    private static AttributeCarrier nullCarrier = new AttributeCarrier();

    public AttributeManager(D graph) {
        this.setGraph(graph);
        managerList.add(this);
        this.nodeClassIDToClassnameMap = new HashMap();
        this.edgeClassIDToClassnameMap = new HashMap();
        this.nodeClassnameToClassIDMap = new HashMap();
        this.edgeClassnameToClassIDMap = new HashMap();
        this.nodeAttrNameToVisibleMap = new HashMap();
        this.edgeAttrNameToVisibleMap = new HashMap();
    }

    public D getGraph() {
        return this.graph;
    }

    public void setGraph(D graph) {
        this.graph = graph;
    }

    protected void finalize() {
        managerList.remove(this);
    }

    public static AttributeManager getInstance(D g2) {
        G amlc = managerList.cursor();
        while (amlc.ok()) {
            AttributeManager am = (AttributeManager)amlc.current();
            if (am.getGraph() == g2) {
                return am;
            }
            amlc.next();
        }
        return null;
    }

    public AttributeCarrier getAttributeCarrier(Y n) {
        AttributeCarrier carrier = (AttributeCarrier)this.graph.C((Object)n);
        if (carrier == null) {
            return nullCarrier;
        }
        return carrier;
    }

    public AttributeCarrier getAttributeCarrier(H e2) {
        return (AttributeCarrier)this.graph.C((Object)e2);
    }

    public void setAttributeCarrier(H e2, AttributeCarrier carrier) {
        this.graph.A(e2, carrier);
    }

    public void setAttributeCarrier(Y n, AttributeCarrier carrier) {
        this.graph.A((Object)n, carrier);
    }

    public String getTitle(Y n) {
        return this.getAttributeCarrier(n).getTitle();
    }

    public String getTitle(H e2) {
        return this.getAttributeCarrier(e2).getTitle();
    }

    public void setTitle(Y n, String title) {
        this.getAttributeCarrier(n).setTitle(title);
    }

    public void setTitle(H e2, String title) {
        this.getAttributeCarrier(e2).setTitle(title);
    }

    public int getClassOfNode(Y n) {
        return this.getAttributeCarrier(n).getClassID();
    }

    public void setClassOfNode(Y n, int classID) {
        this.getAttributeCarrier(n).setClassID(classID);
    }

    public String getClassNameOfNode(Y n) {
        return this.getNodeClassName(this.getClassOfNode(n));
    }

    public void setNodeClassName(int classID, String classname) {
        this.nodeClassIDToClassnameMap.put(classID, classname);
        this.nodeClassnameToClassIDMap.put(classname, classID);
    }

    public String getNodeClassName(int classID) {
        return this.nodeClassIDToClassnameMap.get(classID);
    }

    public int getNodeClassID(String classname) {
        return this.nodeClassnameToClassIDMap.get(classname);
    }

    public Iterable<Map.Entry<Integer, String>> getNodeClassIterator() {
        return new Iterabler<Map.Entry<Integer, String>>(this.nodeClassIDToClassnameMap.entrySet().iterator());
    }

    public int getClassOfEdge(H e2) {
        return this.getAttributeCarrier(e2).getClassID();
    }

    public void setClassOfEdge(H e2, int classID) {
        this.getAttributeCarrier(e2).setClassID(classID);
    }

    public String getClassNameOfEdge(H e2) {
        return this.getEdgeClassName(this.getClassOfEdge(e2));
    }

    public void setEdgeClassName(int classID, String classname) {
        this.edgeClassIDToClassnameMap.put(classID, classname);
        this.edgeClassnameToClassIDMap.put(classname, classID);
    }

    public String getEdgeClassName(int classID) {
        return this.edgeClassIDToClassnameMap.get(classID);
    }

    public int getEdgeClassID(String classname) {
        return this.edgeClassnameToClassIDMap.get(classname);
    }

    public Iterable<Map.Entry<Integer, String>> getEdgeClassIterator() {
        return new Iterabler<Map.Entry<Integer, String>>(this.edgeClassIDToClassnameMap.entrySet().iterator());
    }

    public String getAttribute(Y n, String attrName) {
        return this.getAttributeCarrier(n).getAttribute(attrName);
    }

    public String getAttribute(H e2, String attrName) {
        return this.getAttributeCarrier(e2).getAttribute(attrName);
    }

    public Iterable<Map.Entry<String, String>> getAttributes(Y n) {
        return new Iterabler<Map.Entry<String, String>>(this.getAttributeCarrier(n).getAttributes());
    }

    public Iterable<Map.Entry<String, String>> getAttributes(H e2) {
        return new Iterabler<Map.Entry<String, String>>(this.getAttributeCarrier(e2).getAttributes());
    }

    public void setAttribute(Y n, String attrName, String attrValue) {
        if (!this.nodeAttrNameToVisibleMap.containsKey(attrName = attrName.intern())) {
            this.nodeAttrNameToVisibleMap.put(attrName, Boolean.TRUE);
        }
        this.getAttributeCarrier(n).setAttribute(attrName, attrValue);
    }

    public void setAttribute(H e2, String attrName, String attrValue) {
        if (!this.edgeAttrNameToVisibleMap.containsKey(attrName = attrName.intern())) {
            this.edgeAttrNameToVisibleMap.put(attrName, Boolean.TRUE);
        }
        this.getAttributeCarrier(e2).setAttribute(attrName, attrValue);
    }

    public Iterabler<String> getAvailableNodeAttributeNames() {
        return new Iterabler<String>(this.nodeAttrNameToVisibleMap.keySet().iterator());
    }

    public Iterabler<String> getAvailableEdgeAttributeNames() {
        return new Iterabler<String>(this.edgeAttrNameToVisibleMap.keySet().iterator());
    }

    public void clear() {
        this.nodeClassIDToClassnameMap.clear();
        this.nodeClassnameToClassIDMap.clear();
        this.edgeClassIDToClassnameMap.clear();
        this.edgeClassnameToClassIDMap.clear();
        this.nodeAttrNameToVisibleMap.clear();
        this.edgeAttrNameToVisibleMap.clear();
    }

    public boolean isNodeAttrVisible(String attrName) {
        return this.nodeAttrNameToVisibleMap.get(attrName);
    }

    public void setNodeAttrVisible(String attrName, boolean v) {
        this.nodeAttrNameToVisibleMap.put(attrName, v);
    }

    public boolean isEdgeAttrVisible(String attrName) {
        return this.edgeAttrNameToVisibleMap.get(attrName);
    }

    public void setEdgeAttrVisible(String attrName, boolean v) {
        this.edgeAttrNameToVisibleMap.put(attrName, v);
    }
}

