/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.ycomp.algo;

import C.A.H;
import C.A.X;
import C.A.Y;
import C.A.Z;
import C.I.A.A;
import C.I.A.M;
import C.I.I;
import de.unika.ipd.ycomp.attributes.AttributeCarrier;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.ListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoopAnalysis {
    private A hierarchyManager;
    private I graph2d;
    private Loop rootLoop;
    private Loop currentLoop;
    private int loopNodeCount = 0;
    private int maxLoopDepth = 0;
    private int currentDfn = 1;
    private LinkedList<Y> stack = new LinkedList();
    private HashSet<Y> stackHashSet = new HashSet();
    private HashSet<H> backedges = new HashSet();
    private HashSet<H> realBackedges = null;
    private HashMap<Y, NodeInfo> nodeInfos = new HashMap();
    private LinkedList<Y> loopGroupNodes = new LinkedList();

    public LoopAnalysis(A hierarchyManager, I graph2d) {
        this.hierarchyManager = hierarchyManager;
        this.graph2d = graph2d;
        this.rootLoop = this.currentLoop = new Loop(null);
    }

    private boolean isBackedge(H edge) {
        return this.backedges.contains(edge);
    }

    private void push(Y node) {
        this.stack.addFirst(node);
        this.stackHashSet.add(node);
    }

    private void popAndUnmarkUntil(Y lastNode) {
        Y curNode;
        do {
            curNode = this.stack.removeFirst();
            this.stackHashSet.remove(curNode);
            NodeInfo nodeInfo = this.nodeInfos.get(curNode);
            nodeInfo.visited = false;
        } while (curNode != lastNode);
    }

    private void popToLoopUntil(Y lastNode) {
        Y curNode;
        do {
            curNode = this.stack.removeFirst();
            this.stackHashSet.remove(curNode);
            NodeInfo nodeInfo = this.nodeInfos.get(curNode);
            ++this.loopNodeCount;
            nodeInfo.dfn = nodeInfo.dfn;
            this.currentLoop.addChildNode(curNode);
        } while (curNode != lastNode);
    }

    private boolean isInStack(Y node) {
        return this.stackHashSet.contains(node);
    }

    private boolean isStartBlock(Y node) {
        return node.O() != 0 && (node.C() == 0 || node.C() == 1 && node.K().V() == node);
    }

    private boolean isEndBlock(Y node) {
        return node.O() == 0 && node.C() != 0;
    }

    private boolean isHead(Y node) {
        boolean foundOutside = false;
        boolean foundInside = false;
        NodeInfo nodeInfo = this.nodeInfos.get(node);
        if (this.isEndBlock(node)) {
            return false;
        }
        Z ec = node.G();
        while (ec.ok()) {
            Y pred;
            H predEdge = ec.D();
            if (!this.isBackedge(predEdge) && this.isInStack(pred = predEdge.V())) {
                NodeInfo predInfo = this.nodeInfos.get(pred);
                if (predInfo.dfn < nodeInfo.uplink) {
                    foundOutside = true;
                } else {
                    foundInside = true;
                }
            }
            ec.next();
        }
        return foundOutside && foundInside;
    }

    private boolean isEndlessHead(Y node) {
        boolean foundOutside = false;
        boolean foundInside = false;
        if (this.isEndBlock(node)) {
            return false;
        }
        Z ec = node.G();
        while (ec.ok()) {
            H predEdge = ec.D();
            if (!this.isBackedge(predEdge)) {
                Y pred = predEdge.V();
                if (!this.isInStack(pred)) {
                    foundOutside = true;
                } else {
                    foundInside = true;
                }
            }
            ec.next();
        }
        return !foundOutside && foundInside;
    }

    private H smallestDfnPred(Y node, int limit) {
        H minEdge = null;
        int minDfn = Integer.MAX_VALUE;
        if (this.isEndBlock(node)) {
            return null;
        }
        Z ec = node.G();
        while (ec.ok()) {
            Y pred;
            H predEdge = ec.D();
            if (!this.isBackedge(predEdge) && this.isInStack(pred = predEdge.V())) {
                NodeInfo nodeInfo = this.nodeInfos.get(pred);
                if (nodeInfo.dfn >= limit && nodeInfo.dfn < minDfn) {
                    minDfn = nodeInfo.dfn;
                    minEdge = predEdge;
                }
            }
            ec.next();
        }
        return minEdge;
    }

    private H largestDfnPred(Y node) {
        H maxEdge = null;
        int maxDfn = Integer.MIN_VALUE;
        if (this.isEndBlock(node)) {
            return null;
        }
        Z ec = node.G();
        while (ec.ok()) {
            Y pred;
            H predEdge = ec.D();
            if (!this.isBackedge(predEdge) && this.isInStack(pred = predEdge.V())) {
                NodeInfo nodeInfo = this.nodeInfos.get(pred);
                if (nodeInfo.dfn > maxDfn) {
                    maxDfn = nodeInfo.dfn;
                    maxEdge = predEdge;
                }
            }
            ec.next();
        }
        return maxEdge;
    }

    private Y findTail(Y node) {
        Y curNode = this.stack.getFirst();
        H backedge = null;
        if (this.isHead(curNode)) {
            NodeInfo nodeInfo = this.nodeInfos.get(curNode);
            backedge = this.smallestDfnPred(curNode, nodeInfo.dfn);
            if (backedge == null) {
                backedge = this.smallestDfnPred(curNode, 0);
            }
            if (backedge == null && curNode == node) {
                return null;
            }
        } else {
            NodeInfo nodeInfo;
            if (curNode == node) {
                return null;
            }
            boolean isDeadLoop = false;
            ListIterator<Y> ni = this.stack.listIterator(1);
            while (ni.hasNext()) {
                curNode = (Y)ni.next();
                if (this.isHead(curNode)) {
                    nodeInfo = this.nodeInfos.get(curNode);
                    backedge = this.smallestDfnPred(curNode, nodeInfo.dfn + 1);
                    if (backedge == null) {
                        backedge = this.largestDfnPred(curNode);
                    }
                    if (curNode != node || backedge != null) break;
                    isDeadLoop = true;
                    break;
                }
                if (curNode != node) continue;
                isDeadLoop = true;
                break;
            }
            if (isDeadLoop) {
                ni = this.stack.listIterator(1);
                while (ni.hasNext()) {
                    curNode = (Y)ni.next();
                    if (this.isEndlessHead(curNode)) {
                        nodeInfo = this.nodeInfos.get(curNode);
                        backedge = this.smallestDfnPred(curNode, nodeInfo.dfn + 1);
                        if (backedge == null) {
                            backedge = this.largestDfnPred(curNode);
                        }
                        if (node == curNode && backedge == null) {
                            isDeadLoop = true;
                            break;
                        }
                    }
                    if (curNode != node) continue;
                }
            }
        }
        if (backedge == null) {
            return null;
        }
        this.backedges.add(backedge);
        return this.isEndBlock(node) ? null : backedge.X();
    }

    private void closeLoop(Loop loop) {
        ListIterator<Loop> cli = loop.getChildLoops();
        while (cli.hasNext()) {
            Loop childLoop = cli.next();
            if (childLoop.getNumChildNodes() != 0 || childLoop.getNumChildLoops() != 1) continue;
            cli.remove();
            Loop childChildLoop = childLoop.getChildLoops().next();
            cli.add(childChildLoop);
        }
        this.currentLoop = loop;
    }

    private void calcLoops(Y node) {
        NodeInfo nodeInfo = this.nodeInfos.get(node);
        if (nodeInfo != null && nodeInfo.visited) {
            return;
        }
        if (nodeInfo == null) {
            nodeInfo = new NodeInfo(this.currentDfn);
            this.nodeInfos.put(node, nodeInfo);
        } else {
            nodeInfo.dfn = this.currentDfn;
            nodeInfo.uplink = this.currentDfn;
        }
        nodeInfo.visited = true;
        ++this.currentDfn;
        this.push(node);
        if (!this.isEndBlock(node)) {
            Z ec = node.M();
            while (ec.ok()) {
                Y inNode;
                H inEdge = ec.D();
                if (!this.isBackedge(inEdge) && !this.isStartBlock(inNode = inEdge.X())) {
                    this.calcLoops(inNode);
                    if (this.isInStack(inNode)) {
                        NodeInfo inNodeInfo = this.nodeInfos.get(inNode);
                        if (inNodeInfo.uplink < nodeInfo.uplink) {
                            nodeInfo.uplink = inNodeInfo.uplink;
                        }
                    }
                }
                ec.next();
            }
        }
        if (nodeInfo.dfn == nodeInfo.uplink) {
            Y tail = this.findTail(node);
            if (tail != null) {
                Loop oldloop = this.currentLoop;
                this.currentLoop = new Loop(this.currentLoop);
                this.popAndUnmarkUntil(node);
                this.calcLoops(tail);
                this.closeLoop(oldloop);
            } else {
                this.popToLoopUntil(node);
            }
        }
    }

    public void doLoopAnalysis() {
        Y startNode = new StartNodeFinder().findStartNode(this.hierarchyManager);
        if (startNode == null) {
            return;
        }
        this.calcLoops(startNode);
    }

    private Y createLoopGroups(Y parent, Loop loop, boolean createGroupNode) {
        Y groupNode;
        if (createGroupNode) {
            groupNode = parent == null ? this.hierarchyManager.L(this.hierarchyManager.C()) : this.hierarchyManager.N(parent);
            this.graph2d.A((Object)groupNode, new AttributeCarrier());
            M nr = (M)this.graph2d.f(groupNode);
            nr.setLabelText("#LOOP-" + groupNode.R());
            int level = (this.hierarchyManager.F(groupNode) - 1) % 4;
            int colval = 192 * (5 - level) / 5;
            nr.setFillColor(new Color(colval, colval, colval));
            nr.N(false);
            this.loopGroupNodes.add(groupNode);
        } else {
            groupNode = parent;
        }
        X children = new X();
        ListIterator<Loop> cli = loop.getChildLoops();
        while (cli.hasNext()) {
            Loop childLoop = (Loop)cli.next();
            children.add(this.createLoopGroups(groupNode, childLoop, true));
        }
        ListIterator<Y> cni = loop.getChildNodes();
        while (cni.hasNext()) {
            Y childNode = (Y)cni.next();
            children.add(childNode);
        }
        if (groupNode != parent) {
            this.hierarchyManager.F(children, groupNode);
        }
        return groupNode;
    }

    public LinkedList<Y> createLoopGroups(Y parent) {
        this.createLoopGroups(parent, this.rootLoop, false);
        return this.loopGroupNodes;
    }

    public HashSet<H> getBackedges() {
        if (this.realBackedges == null) {
            this.realBackedges = new HashSet();
            block0: for (H backedge : this.backedges) {
                if (this.hierarchyManager.F(backedge)) {
                    Y realSource = this.hierarchyManager.B(backedge);
                    Y realTarget = this.hierarchyManager.A(backedge);
                    Z ec = realSource.G();
                    while (ec.ok()) {
                        H edge = ec.D();
                        if (edge.V() == realTarget) {
                            this.realBackedges.add(edge);
                            continue block0;
                        }
                        ec.next();
                    }
                    continue;
                }
                this.realBackedges.add(backedge);
            }
        }
        return this.realBackedges;
    }

    private class NodeInfo {
        public boolean visited;
        public int dfn;
        public int uplink;

        public NodeInfo(int dfn) {
            this.dfn = dfn;
            this.uplink = dfn;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Loop {
        private int depth;
        private ArrayList<Loop> childLoops = new ArrayList();
        private ArrayList<Y> childNodes = new ArrayList();

        public Loop(Loop parent) {
            if (parent == null) {
                this.depth = 0;
            } else {
                parent.addChildLoop(this);
                this.depth = parent.depth + 1;
                if (this.depth > LoopAnalysis.this.maxLoopDepth) {
                    LoopAnalysis.this.maxLoopDepth = this.depth;
                }
            }
        }

        public int getNumChildLoops() {
            return this.childLoops.size();
        }

        public ListIterator<Loop> getChildLoops() {
            return this.childLoops.listIterator();
        }

        public int getNumChildNodes() {
            return this.childNodes.size();
        }

        public ListIterator<Y> getChildNodes() {
            return this.childNodes.listIterator();
        }

        public void addChildLoop(Loop child) {
            this.childLoops.add(child);
        }

        public void addChildNode(Y node) {
            this.childNodes.add(node);
        }
    }

    private class StartNodeFinder
    implements A._F {
        private Y startNode = null;

        private StartNodeFinder() {
        }

        public Y findStartNode(A hm) {
            hm.A(this);
            return this.startNode;
        }

        public void visitNode(Y node) {
            if (node.O() != 0 && (node.C() == 0 || node.C() == 1 && node.K().V() == node)) {
                this.startNode = node;
            }
        }
    }
}

