/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.ycomp.VCG;

import C.A.E;
import C.A.H;
import C.A.X;
import C.A.Y;
import C.I.$B;
import C.I.A.A;
import C.I.I;
import C.I.VA;
import C.I.gA;
import C.I.mA;
import C.I.s;
import de.unika.ipd.ycomp.VCG.NullEdge;
import de.unika.ipd.ycomp.VCG.VCGColor;
import de.unika.ipd.ycomp.attributes.AttributeCarrier;
import de.unika.ipd.ycomp.attributes.AttributeManager;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import org.antlr.runtime.Parser;
import org.antlr.runtime.RecognizerSharedState;
import org.antlr.runtime.Token;
import org.antlr.runtime.TokenStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class VCGParserBase
extends Parser {
    public static final String[] tokenNames = new String[]{"<invalid>", "<EOR>", "<DOWN>", "<UP>", "IDENTIFIER", "INTEGER", "META_COMMENT", "FLOAT", "STRING", "IDCHAR", "DIGIT", "ESC", "SL_COMMENT", "ML_COMMENT", "WS", "'graph'", "':'", "'{'", "'}'", "'title'", "'label'", "'info1'", "'info2'", "'info3'", "'color'", "'textcolor'", "'bordercolor'", "'width'", "'height'", "'borderwidth'", "'x'", "'y'", "'classname'", "'infoname'", "'colorentry'", "'layoutalgorithm'", "'display_edge_labels'", "'manhattan_edges'", "'port_sharing'", "'orientation'", "'status'", "'loc'", "'create_loop_tree'", "'create_reference_nodes'", "'layout_against_orientation'", "'foldnode.'", "'foldedge.'", "'node.'", "'edge.'", "'node'", "'edge'", "'nearedge'", "'leftnearedge'", "'rightnearedge'", "'bentnearedge'", "'leftbentnearedge'", "'rightbentnearedge'", "'backedge'", "'shape'", "'sourcename'", "'targetname'", "'linestyle'", "'class'", "'arrowcolor'", "'backarrowcolor'", "'thickness'", "'priority'", "'yes'", "'no'"};
    protected I graph;
    protected Y node;
    protected Y defaultNode;
    protected Y deleteNode;
    protected Y topNode;
    protected NullEdge defaultEdge;
    protected A hierarchy;
    protected AttributeManager attribute;
    protected ArrayList<NullEdge> edges = new ArrayList();
    protected HashMap<String, Y> nodes = new HashMap();
    protected HashMap<Integer, String> infonames;
    protected HashMap<String, Object> settings = new HashMap();

    public VCGParserBase(TokenStream arg0, RecognizerSharedState arg1) {
        super(arg0, arg1);
    }

    public void init(I graph) {
        this.graph = graph;
        this.hierarchy = A.E(graph);
        this.attribute = AttributeManager.getInstance(graph);
        this.infonames = new HashMap();
        mA n = graph.\u00e4();
        n.setFillColor(VCGColor.getColorByName("WHITE"));
        n.setLineType(gA.H);
        graph.A(n);
    }

    protected int getInteger(Token t) {
        String s2 = t.getText();
        return Integer.parseInt(s2);
    }

    protected float getFloat(Token t) {
        String s2 = t.getText();
        return Float.parseFloat(s2);
    }

    protected double getDouble(Token t) {
        String s2 = t.getText();
        return Double.parseDouble(s2);
    }

    protected String getInfoName(int id) {
        String name = this.infonames.get(id);
        if (name == null) {
            return "info" + id;
        }
        return name;
    }

    private void adjustLabelSize(Y n) {
        mA nr = this.graph.f(n);
        s lr = nr.getLabel();
        if (lr.getWidth() + 10.0 > nr.getWidth()) {
            nr.setWidth(lr.getWidth() + 10.0);
        }
        if (lr.getHeight() + 10.0 > nr.getHeight()) {
            nr.setHeight(lr.getHeight() + 10.0);
        }
    }

    private Y createMissingNode(String title) {
        Y node = this.graph.c();
        this.graph.A((Object)node, new AttributeCarrier());
        if (this.topNode != null) {
            this.hierarchy.F(new X(node), this.topNode);
        }
        this.nodes.put(title, node);
        this.attribute.setTitle(node, title);
        this.graph.A(node, "Missing " + title);
        mA nr = this.graph.f(node);
        this.associateColors("RED", new NodeFillColorSetter(nr));
        this.adjustLabelSize(node);
        return node;
    }

    protected void createEdgesAndLabels() {
        E nc = this.graph.k();
        boolean missing = false;
        nc.toFirst();
        while (nc.ok()) {
            String label;
            Y n = (Y)nc.current();
            String title = this.attribute.getTitle(n);
            if (title == null) {
                title = "unnamed";
                this.attribute.setTitle(n, title);
            }
            this.graph.A(n, (label = this.graph.e(n)) == null ? title : label);
            this.adjustLabelSize(n);
            nc.next();
        }
        for (NullEdge e2 : this.edges) {
            Y src = this.nodes.get(e2.sourceName);
            Y tgt = this.nodes.get(e2.targetName);
            if (src == null) {
                missing = true;
                src = this.createMissingNode(e2.sourceName);
            }
            if (tgt == null) {
                missing = true;
                tgt = this.createMissingNode(e2.targetName);
            }
            e2.source = src;
            e2.target = tgt;
            H edge = this.hierarchy.B(e2.source, e2.target);
            $B er = this.graph.X(edge);
            this.attribute.setAttributeCarrier(edge, e2.eac);
            if (e2.getLabel() != null) {
                String[] splitLabel = e2.getLabel().split("Attributes:");
                if (splitLabel.length > 1) {
                    String[] attrNameValue = splitLabel[1].split("=|\n");
                    int i2 = 0;
                    while (i2 + 1 < attrNameValue.length) {
                        this.attribute.setAttribute(edge, attrNameValue[i2], attrNameValue[i2 + 1]);
                        i2 += 2;
                    }
                }
                VA label = er.L();
                label.setText(splitLabel[0]);
                label.B((byte)33);
                label.setPosition((byte)15);
            }
            er.B(e2.getLineStyle());
            if (e2.color != null) {
                this.associateColors(e2.color, new EdgeColorSetter(er));
            }
            if (e2.textColor != null) {
                this.associateColors(e2.textColor, new EdgeLabelTextColorSetter(er));
            }
            if (e2.arrowColor != null) {
                this.associateColors(e2.arrowColor, new EdgeArrowColorSetter(er));
            }
            if (e2.backArrowColor == null) continue;
            this.associateColors(e2.backArrowColor, new EdgeBackArrowColorSetter(er));
        }
        if (missing) {
            System.out.println("Warning: missing nodes were added!");
        }
    }

    protected void associateColors(String colorString, ColorSetter colorSetter) {
        Color c2 = VCGColor.getColorIgnoreCase(colorString);
        if (c2 != null) {
            colorSetter.setColor(c2);
        }
    }

    @Override
    public String[] getTokenNames() {
        return tokenNames;
    }

    @Override
    public String getGrammarFileName() {
        return "/afs/info.uni-karlsruhe.de/user/matze/develop/ycomp/src/de/unika/ipd/ycomp/VCG/VCG.g";
    }

    public HashMap<String, Object> getSettings() {
        return this.settings;
    }

    protected class NodeLabelTextColorSetter
    implements ColorSetter {
        mA nr;

        public NodeLabelTextColorSetter(mA nr) {
            this.nr = nr;
        }

        public void setColor(Color color) {
            this.nr.getLabel().setTextColor(color);
        }
    }

    class NodeFillColorSetter
    implements ColorSetter {
        mA nr;

        public NodeFillColorSetter(mA nr) {
            this.nr = nr;
        }

        public void setColor(Color color) {
            this.nr.setFillColor(color);
        }
    }

    protected class NodeBorderColorSetter
    implements ColorSetter {
        mA nr;

        public NodeBorderColorSetter(mA nr) {
            this.nr = nr;
        }

        public void setColor(Color color) {
            this.nr.setLineColor(color);
        }
    }

    class EdgeLabelTextColorSetter
    implements ColorSetter {
        $B er;

        public EdgeLabelTextColorSetter($B er) {
            this.er = er;
        }

        public void setColor(Color color) {
            this.er.L().setTextColor(color);
        }
    }

    class EdgeColorSetter
    implements ColorSetter {
        $B er;

        public EdgeColorSetter($B er) {
            this.er = er;
        }

        public void setColor(Color color) {
            this.er.B(color);
        }
    }

    class EdgeBackArrowColorSetter
    implements ColorSetter {
        public EdgeBackArrowColorSetter($B er) {
        }

        public void setColor(Color color) {
        }
    }

    class EdgeArrowColorSetter
    implements ColorSetter {
        public EdgeArrowColorSetter($B er) {
        }

        public void setColor(Color color) {
        }
    }

    static interface ColorSetter {
        public void setColor(Color var1);
    }
}

