/*
 * Decompiled with CFR 0.152.
 */
package yext.graphml.processor;

import java.awt.Color;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import y.module.YModule;
import y.option.OptionHandler;
import y.option.OptionItem;
import y.view.DefaultBackgroundRenderer;
import y.view.Graph2DView;

public class BackgroundConfigurator
extends YModule {
    private static final String L = "BACKGROUND_CONFIGURATOR";
    private static final String J = "DYNAMIC";
    private static final String F = "PLAIN";
    private static final String I = "CENTERED";
    private static final String D = "BRICKED";
    private static final String B = "TILED";
    private static final String K = "FULLSCREEN";
    private static final String C = "MODE";
    private static final String E = "IMAGE_URL";
    private static final String A = "COLOR";
    private static final String H = "ORIGIN_X";
    private static final String G = "ORIGIN_Y";

    public BackgroundConfigurator() {
        super(L, "yFiles Team", "Configures the background of the Graph2DView associated with the input graph");
    }

    protected OptionHandler createOptionHandler() {
        OptionHandler optionHandler = new OptionHandler(this.getModuleName());
        optionHandler.addColor(A, OptionItem.UNDEFINED, false, true, true, true);
        optionHandler.addFile(E, "");
        Object[] objectArray = new String[]{F, I, B, D, J, K};
        optionHandler.addEnum(C, objectArray, 0);
        optionHandler.addDouble(H, 0.0);
        optionHandler.addDouble(G, 0.0);
        return optionHandler;
    }

    protected void mainrun() {
        OptionHandler optionHandler = this.getOptionHandler();
        Graph2DView graph2DView = this.getGraph2DView();
        if (graph2DView == null) {
            return;
        }
        if (!(graph2DView.getBackgroundRenderer() instanceof DefaultBackgroundRenderer)) {
            return;
        }
        DefaultBackgroundRenderer defaultBackgroundRenderer = (DefaultBackgroundRenderer)graph2DView.getBackgroundRenderer();
        Object object = optionHandler.get(A);
        if (object instanceof Color) {
            defaultBackgroundRenderer.setColor((Color)object);
        }
        object = optionHandler.get(E);
        String string = (String)object;
        URL uRL = null;
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            File file = new File(string);
            try {
                if (file.canRead()) {
                    uRL = file.toURL();
                }
            }
            catch (MalformedURLException malformedURLException2) {
                // empty catch block
            }
        }
        if (uRL != null) {
            defaultBackgroundRenderer.setImageResource(uRL);
        }
        if ((object = optionHandler.get(C)).equals(F)) {
            defaultBackgroundRenderer.setMode((byte)4);
        } else if (object.equals(B)) {
            defaultBackgroundRenderer.setMode((byte)1);
        } else if (object.equals(D)) {
            defaultBackgroundRenderer.setMode((byte)2);
        } else if (object.equals(K)) {
            defaultBackgroundRenderer.setMode((byte)0);
        } else if (object.equals(I)) {
            defaultBackgroundRenderer.setMode((byte)3);
        } else if (object.equals(J)) {
            defaultBackgroundRenderer.setMode((byte)5);
        }
        defaultBackgroundRenderer.setImageOrigin(optionHandler.getDouble(H), optionHandler.getDouble(G));
        graph2DView.updateView();
    }
}

