/*
 * Decompiled with CFR 0.152.
 */
package yext.graphml.graph2D;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import org.graphdrawing.graphml.reader.dom.DOMGraphMLParser;
import org.graphdrawing.graphml.writer.DirectGraphMLWriter;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import y.base.Graph;
import y.io.IOHandler;
import y.view.Graph2D;
import yext.graphml.graph2D.YReadEdgeHandler;
import yext.graphml.graph2D.YReadNodeHandler;
import yext.graphml.graph2D.YWriteEdgeHandler;
import yext.graphml.graph2D.YWriteNodeHandler;
import yext.graphml.reader.YGraphElementFactory;
import yext.graphml.writer.YGraphElementProvider;

public class YGraphMLIOHandler
extends IOHandler {
    private DOMGraphMLParser B = new DOMGraphMLParser();
    private DirectGraphMLWriter A = new DirectGraphMLWriter();
    public static final String OLD_GRAPHML_DTD_URI = "http://www.graphdrawing.org/dtds/graphml.dtd";
    public static final String GRAPHML_DTD_URI = "http://graphml.graphdrawing.org/dtds/graphml.dtd";
    public static final String GRAPHML_DTD = "<!ELEMENT graphml  ((desc)?,(key)*,((data)|(graph))*)><!ELEMENT locator EMPTY><!ATTLIST locator    xmlns:xlink   CDATA    #FIXED    \"http://www.w3.org/TR/2000/PR-xlink-20001220/\"    xlink:href    CDATA    #REQUIRED    xlink:type    (simple) #FIXED    \"simple\"><!ELEMENT desc (#PCDATA)><!ELEMENT graph    ((desc)?,((((data)|(node)|(edge)|(hyperedge))*)|(locator)))><!ATTLIST graph    id          ID                    #IMPLIED    edgedefault (directed|undirected) #REQUIRED><!ELEMENT node   (desc?,(((data|port)*,graph?)|locator))><!ATTLIST node    id        ID      #REQUIRED><!ELEMENT port ((desc)?,((data)|(port))*)><!ATTLIST port    name    NMTOKEN  #REQUIRED><!ELEMENT edge ((desc)?,(data)*,(graph)?)><!ATTLIST edge    id         ID           #IMPLIED    source     IDREF        #REQUIRED    sourceport NMTOKEN      #IMPLIED    target     IDREF        #REQUIRED    targetport NMTOKEN      #IMPLIED    directed   (true|false) #IMPLIED><!ELEMENT hyperedge  ((desc)?,((data)|(endpoint))*,(graph)?)><!ATTLIST hyperedge    id     ID      #IMPLIED><!ELEMENT endpoint ((desc)?)><!ATTLIST endpoint          id    ID             #IMPLIED    node  IDREF          #REQUIRED    port  NMTOKEN        #IMPLIED     type  (in|out|undir) \"undir\"><!ELEMENT key (#PCDATA)><!ATTLIST key    id  ID                                            #REQUIRED    for (graph|node|edge|hyperedge|port|endpoint|all) \"all\"><!ELEMENT data  (#PCDATA)><!ATTLIST data    key      IDREF        #REQUIRED    id       ID           #IMPLIED>";

    public YGraphMLIOHandler() {
        this.getGraphMLWriter().addNodeOutputHandler(new YWriteNodeHandler());
        this.getGraphMLWriter().addEdgeOutputHandler(new YWriteEdgeHandler());
        this.getGraphMLParser().addDOMInputHandler(new YReadNodeHandler());
        this.getGraphMLParser().addDOMInputHandler(new YReadEdgeHandler());
    }

    public boolean canRead() {
        return true;
    }

    public boolean canWrite() {
        return true;
    }

    public String getFileFormatString() {
        return "Y-GraphML file";
    }

    public String getFileNameExtension() {
        return "ygraphml";
    }

    public void setGraphMLWriter(DirectGraphMLWriter directGraphMLWriter) {
        this.A = directGraphMLWriter;
    }

    public DirectGraphMLWriter getGraphMLWriter() {
        return this.A;
    }

    public void setGraphMLParser(DOMGraphMLParser dOMGraphMLParser) {
        this.B = dOMGraphMLParser;
    }

    public DOMGraphMLParser getGraphMLParser() {
        return this.B;
    }

    public void read(Graph2D graph2D, InputStream inputStream) throws IOException {
        YGraphElementFactory yGraphElementFactory = new YGraphElementFactory((Graph)graph2D);
        this.B.setGraphElementFactory(yGraphElementFactory);
        this.B.getDocumentBuilderFactory().setNamespaceAware(true);
        this.B.parse(inputStream, new _A());
    }

    public void write(Graph2D graph2D, OutputStream outputStream) throws IOException {
        if (graph2D == null || outputStream == null) {
            return;
        }
        this.A.setGraphElementProvider(new YGraphElementProvider((Graph)graph2D));
        this.A.write(outputStream);
    }

    static class _A
    implements EntityResolver {
        _A() {
        }

        public InputSource resolveEntity(String string, String string2) throws SAXException {
            if (string2.equals(YGraphMLIOHandler.GRAPHML_DTD_URI) || string2.equals(YGraphMLIOHandler.OLD_GRAPHML_DTD_URI)) {
                InputSource inputSource = new InputSource(new StringReader(YGraphMLIOHandler.GRAPHML_DTD));
                inputSource.setSystemId(YGraphMLIOHandler.GRAPHML_DTD_URI);
                return inputSource;
            }
            throw new SAXException("Unknown System Identifier: " + string2);
        }
    }
}

