/*
 * Decompiled with CFR 0.152.
 */
package yext.graphml.graph2D;

import java.util.HashMap;
import java.util.Map;
import org.graphdrawing.graphml.reader.GraphMLParseContext;
import org.graphdrawing.graphml.reader.dom.DOMGraphMLParseContext;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import y.base.Edge;
import y.base.Graph;
import y.view.EdgeRealizer;
import y.view.Graph2D;
import yext.graphml.graph2D.EdgeRealizerSerializer;
import yext.graphml.reader.AbstractDOMInputHandler;

public class ReadEdgeRealizerHandler
extends AbstractDOMInputHandler {
    protected static Map edgeRealizerSerializers = new HashMap();

    public static void addEdgeRealizerSerializer(EdgeRealizerSerializer edgeRealizerSerializer) {
        edgeRealizerSerializers.put(edgeRealizerSerializer.getName(), edgeRealizerSerializer);
    }

    public boolean acceptKey(NamedNodeMap namedNodeMap, int n) {
        String string = null;
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Node node = namedNodeMap.item(i);
            if (!node.getNodeName().toLowerCase().equals("yfiles.type")) continue;
            string = node.getNodeValue();
        }
        return string != null && string.equals("edgegraphics");
    }

    protected void parseData(DOMGraphMLParseContext dOMGraphMLParseContext, Graph graph, Object object, boolean bl, Node node) {
        if (bl) {
            return;
        }
        NodeList nodeList = node.getChildNodes();
        Edge edge = (Edge)object;
        Graph2D graph2D = (Graph2D)graph;
        if (nodeList != null) {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node2 = nodeList.item(i);
                if (node2.getNodeType() != 1) continue;
                ReadEdgeRealizerHandler.parseRealizer(graph2D, edge, node2, dOMGraphMLParseContext);
            }
        }
    }

    public static EdgeRealizer parseRealizer(Graph2D graph2D, Edge edge, Node node, GraphMLParseContext graphMLParseContext) {
        String string = node.getNodeName();
        EdgeRealizerSerializer edgeRealizerSerializer = (EdgeRealizerSerializer)edgeRealizerSerializers.get(string);
        if (edgeRealizerSerializer == null) {
            string = node.getLocalName();
            edgeRealizerSerializer = (EdgeRealizerSerializer)edgeRealizerSerializers.get(string);
        }
        if (edgeRealizerSerializer == null) {
            System.err.println("Cannot recognize edge type: " + string);
            return null;
        }
        try {
            EdgeRealizer edgeRealizer = (EdgeRealizer)edgeRealizerSerializer.getRealizerClass().newInstance();
            graph2D.setRealizer(edge, edgeRealizer);
            edgeRealizerSerializer.parse(edgeRealizer, node, graphMLParseContext);
            return edgeRealizer;
        }
        catch (InstantiationException instantiationException) {
            instantiationException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        return null;
    }

    protected void applyDefault(DOMGraphMLParseContext dOMGraphMLParseContext, Graph graph, Object object) {
    }
}

