/*
 * Decompiled with CFR 0.152.
 */
package yext.graphml.graph2D;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.graphdrawing.graphml.reader.GraphElementFactory;
import org.graphdrawing.graphml.reader.dom.DOMGraphMLParser;
import org.graphdrawing.graphml.reader.dom.DOMInputHandler;
import org.graphdrawing.graphml.writer.DirectGraphMLWriter;
import org.graphdrawing.graphml.writer.GraphElementProvider;
import org.graphdrawing.graphml.writer.GraphMLWriteContext;
import org.graphdrawing.graphml.writer.OutputHandler;
import org.graphdrawing.graphml.writer.XMLAttributesProviderAdapter;
import y.base.DataAcceptor;
import y.base.DataProvider;
import y.base.EdgeMap;
import y.base.Graph;
import y.base.NodeMap;
import y.io.IOHandler;
import y.util.D;
import y.view.Graph2D;
import y.view.hierarchy.HierarchyManager;
import yext.graphml.graph2D.ArcEdgeRealizerSerializer;
import yext.graphml.graph2D.BezierEdgeRealizerSerializer;
import yext.graphml.graph2D.EdgeRealizerSerializer;
import yext.graphml.graph2D.FolderTypeXMLAttributesParser;
import yext.graphml.graph2D.FolderTypeXMLAttributesProvider;
import yext.graphml.graph2D.GenericNodeRealizerSerializer;
import yext.graphml.graph2D.GroupNodeRealizerSerializer;
import yext.graphml.graph2D.ImageNodeRealizerSerializer;
import yext.graphml.graph2D.NodeRealizerSerializer;
import yext.graphml.graph2D.PolyLineEdgeRealizerSerializer;
import yext.graphml.graph2D.ProxyAutoBoundsNodeRealizerSerializer;
import yext.graphml.graph2D.ProxyShapeNodeRealizerSerializer;
import yext.graphml.graph2D.QuadCurveEdgeRealizerSerializer;
import yext.graphml.graph2D.ReadEdgeRealizerHandler;
import yext.graphml.graph2D.ReadNodeRealizerHandler;
import yext.graphml.graph2D.ShapeNodeRealizerSerializer;
import yext.graphml.graph2D.SplineEdgeRealizerSerializer;
import yext.graphml.graph2D.WriteEdgeRealizerHandler;
import yext.graphml.graph2D.WriteNodeRealizerHandler;
import yext.graphml.graph2D.YHierarchyGraphElementFactory;
import yext.graphml.graph2D.YHierarchyGraphElementProvider;
import yext.graphml.processor.PostprocessorInputHandler;
import yext.graphml.reader.AttrDataAcceptorInputHandler;
import yext.graphml.reader.GraphMLEntityResolver;
import yext.graphml.reader.YGraphElementFactory;
import yext.graphml.writer.AttrDataProviderOutputHandler;
import yext.graphml.writer.YGraphElementProvider;

public class GraphMLIOHandler
extends IOHandler {
    protected boolean writeDTDEnabled = false;
    protected boolean writeXMLSchemaEnabled = true;
    protected boolean validationEnabled = false;
    protected boolean ignoreGraphicsEnabled = false;
    protected ArrayList graphInputHandlers = new ArrayList();
    protected ArrayList nodeInputHandlers = new ArrayList();
    protected ArrayList edgeInputHandlers = new ArrayList();
    protected ArrayList graphOutputHandlers = new ArrayList();
    protected ArrayList nodeOutputHandlers = new ArrayList();
    protected ArrayList edgeOutputHandlers = new ArrayList();
    PostprocessorInputHandler B = new PostprocessorInputHandler();
    private Map A;
    private Map C;

    public GraphMLIOHandler() {
        this.graphInputHandlers.add(this.B);
        this.A = new HashMap();
        this.C = new HashMap();
    }

    public String getFileFormatString() {
        return "GraphML file";
    }

    public String getFileNameExtension() {
        return "graphml";
    }

    public boolean canRead() {
        return true;
    }

    public boolean canWrite() {
        return true;
    }

    public Collection getInputHandlers(int n) {
        switch (n) {
            case 3: {
                return this.graphInputHandlers;
            }
            case 1: {
                return this.nodeInputHandlers;
            }
            case 2: {
                return this.edgeInputHandlers;
            }
        }
        throw new IllegalArgumentException("unknown scope " + n);
    }

    public Collection getOutputHandlers(int n) {
        switch (n) {
            case 3: {
                return this.graphOutputHandlers;
            }
            case 1: {
                return this.nodeOutputHandlers;
            }
            case 2: {
                return this.edgeOutputHandlers;
            }
        }
        throw new IllegalArgumentException("unknown scope " + n);
    }

    protected DirectGraphMLWriter createDirectGraphMLWriter() {
        DirectGraphMLWriter directGraphMLWriter = new DirectGraphMLWriter();
        return directGraphMLWriter;
    }

    public static void addNodeRealizerSerializer(NodeRealizerSerializer nodeRealizerSerializer) {
        ReadNodeRealizerHandler.addNodeRealizerSerializer(nodeRealizerSerializer);
        WriteNodeRealizerHandler.addNodeRealizerSerializer(nodeRealizerSerializer);
    }

    public static void addEdgeRealizerSerializer(EdgeRealizerSerializer edgeRealizerSerializer) {
        ReadEdgeRealizerHandler.addEdgeRealizerSerializer(edgeRealizerSerializer);
        WriteEdgeRealizerHandler.addEdgeRealizerSerializer(edgeRealizerSerializer);
    }

    public void addAttribute(NodeMap nodeMap, String string, int n) {
        this.nodeInputHandlers.add(new AttrDataAcceptorInputHandler(string, (DataAcceptor)nodeMap, 1, n));
        this.nodeOutputHandlers.add(new AttrDataProviderOutputHandler(string, (DataProvider)nodeMap, 1, n));
    }

    public void addAttribute(EdgeMap edgeMap, String string, int n) {
        this.edgeInputHandlers.add(new AttrDataAcceptorInputHandler(string, (DataAcceptor)edgeMap, 2, n));
        this.edgeOutputHandlers.add(new AttrDataProviderOutputHandler(string, (DataProvider)edgeMap, 2, n));
    }

    public void addGraphAttribute(DataProvider dataProvider, DataAcceptor dataAcceptor, String string, int n) {
        if (dataAcceptor != null) {
            this.graphInputHandlers.add(new AttrDataAcceptorInputHandler(string, dataAcceptor, 3, n));
        }
        if (dataProvider != null) {
            this.graphOutputHandlers.add(new AttrDataProviderOutputHandler(string, dataProvider, 3, n));
        }
    }

    public void addNodeAttribute(DataProvider dataProvider, DataAcceptor dataAcceptor, String string, int n) {
        if (dataAcceptor != null) {
            this.nodeInputHandlers.add(new AttrDataAcceptorInputHandler(string, dataAcceptor, 1, n));
        }
        if (dataProvider != null) {
            this.nodeOutputHandlers.add(new AttrDataProviderOutputHandler(string, dataProvider, 1, n));
        }
    }

    public void addEdgeAttribute(DataProvider dataProvider, DataAcceptor dataAcceptor, String string, int n) {
        if (dataAcceptor != null) {
            this.edgeInputHandlers.add(new AttrDataAcceptorInputHandler(string, dataAcceptor, 2, n));
        }
        if (dataProvider != null) {
            this.edgeOutputHandlers.add(new AttrDataProviderOutputHandler(string, dataProvider, 2, n));
        }
    }

    public boolean isIgnoreGraphicsEnabled() {
        return this.ignoreGraphicsEnabled;
    }

    public boolean isValidationEnabled() {
        return this.validationEnabled;
    }

    public boolean isWriteDTDEnabled() {
        return this.writeDTDEnabled;
    }

    public boolean isWriteXMLSchemaEnabled() {
        return this.writeXMLSchemaEnabled;
    }

    public void setIgnoreGraphicsEnabled(boolean bl) {
        this.ignoreGraphicsEnabled = bl;
    }

    public void setValidationEnabled(boolean bl) {
        this.validationEnabled = bl;
    }

    public void setWriteDTDEnabled(boolean bl) {
        this.writeDTDEnabled = bl;
    }

    public void setWriteXMLSchemaEnabled(boolean bl) {
        this.writeXMLSchemaEnabled = bl;
    }

    public void addNamespace(String string, String string2) {
        this.A.put(string, string2);
    }

    public void addSchemaLocation(String string, String string2) {
        this.C.put(string, string2);
    }

    public void write(Graph2D graph2D, OutputStream outputStream) throws IOException {
        int n;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        if (graph2D == null || outputStream == null) {
            return;
        }
        DirectGraphMLWriter directGraphMLWriter = this.createDirectGraphMLWriter();
        directGraphMLWriter.setWriteDTDEnabled(this.writeDTDEnabled);
        directGraphMLWriter.setWriteXMLSchemaEnabled(this.writeXMLSchemaEnabled);
        HierarchyManager hierarchyManager = HierarchyManager.getInstance((Graph)graph2D);
        if (!this.ignoreGraphicsEnabled) {
            if (!this.A.containsKey("http://yworks.com/xml/graphml")) {
                this.A.put("http://yworks.com/xml/graphml", "y");
            }
            if (!this.C.containsKey("http://graphml.graphdrawing.org/xmlns/graphml")) {
                this.C.put("http://graphml.graphdrawing.org/xmlns/graphml", "http://www.yworks.com/xml/schema/graphml/1.0/ygraphml.xsd");
            }
            object4 = new WriteNodeRealizerHandler();
            directGraphMLWriter.addNodeOutputHandler((OutputHandler)object4);
            object3 = new WriteEdgeRealizerHandler();
            directGraphMLWriter.addEdgeOutputHandler((OutputHandler)object3);
            if (hierarchyManager != null) {
                directGraphMLWriter.addXMLAttributeProvider(new FolderTypeXMLAttributesProvider(hierarchyManager));
            }
        } else if (!this.C.containsKey("http://graphml.graphdrawing.org/xmlns/graphml")) {
            this.C.put("http://graphml.graphdrawing.org/xmlns/graphml", "http://www.yworks.com/xml/schema/graphml/1.0/graphml-attributes.xsd");
        }
        object4 = "";
        object3 = this.C.keySet().iterator();
        while (object3.hasNext()) {
            object2 = object3.next().toString();
            object4 = (String)object4 + (String)object2 + " " + this.C.get(object2);
            if (!object3.hasNext()) continue;
            object4 = (String)object4 + " ";
        }
        directGraphMLWriter.setSchema((String)object4);
        object3 = "";
        object2 = this.A.keySet().iterator();
        while (object2.hasNext()) {
            object = object2.next().toString();
            String string = (String)this.A.get(object);
            object3 = string == null || string.equals("") ? (String)object3 + "xmlns=\"" + (String)object + "\"" : (String)object3 + "xmlns:" + string + "=\"" + (String)object + "\"";
            if (!object2.hasNext()) continue;
            object3 = (String)object3 + " ";
        }
        object2 = object3;
        directGraphMLWriter.addXMLAttributeProvider(new XMLAttributesProviderAdapter((String)object2){
            private final /* synthetic */ String val$finalNameSpaceString;
            {
                this.val$finalNameSpaceString = string;
            }

            public String getGraphMLAttributes(GraphMLWriteContext graphMLWriteContext) {
                return this.val$finalNameSpaceString;
            }
        });
        object = HierarchyManager.getInstance((Graph)graph2D) != null ? new YHierarchyGraphElementProvider((Graph)graph2D) : new YGraphElementProvider((Graph)graph2D);
        directGraphMLWriter.setGraphElementProvider((GraphElementProvider)object);
        for (n = 0; n < this.graphOutputHandlers.size(); ++n) {
            directGraphMLWriter.addGraphOutputHandler((OutputHandler)this.graphOutputHandlers.get(n));
        }
        for (n = 0; n < this.nodeOutputHandlers.size(); ++n) {
            directGraphMLWriter.addNodeOutputHandler((OutputHandler)this.nodeOutputHandlers.get(n));
        }
        for (n = 0; n < this.edgeOutputHandlers.size(); ++n) {
            directGraphMLWriter.addEdgeOutputHandler((OutputHandler)this.edgeOutputHandlers.get(n));
        }
        directGraphMLWriter.write(outputStream);
    }

    public void read(Graph2D graph2D, InputStream inputStream) throws IOException {
        int n;
        Object object;
        DOMGraphMLParser dOMGraphMLParser = new DOMGraphMLParser();
        if (!this.ignoreGraphicsEnabled) {
            object = new ReadNodeRealizerHandler();
            ReadEdgeRealizerHandler readEdgeRealizerHandler = new ReadEdgeRealizerHandler();
            dOMGraphMLParser.addDOMInputHandler((DOMInputHandler)object);
            dOMGraphMLParser.addDOMInputHandler(readEdgeRealizerHandler);
            HierarchyManager hierarchyManager = HierarchyManager.getInstance((Graph)graph2D);
            if (hierarchyManager != null) {
                dOMGraphMLParser.addXMLAttributeParser(new FolderTypeXMLAttributesParser(hierarchyManager));
            }
        }
        object = HierarchyManager.getInstance((Graph)graph2D) != null ? new YHierarchyGraphElementFactory((Graph)graph2D) : new YGraphElementFactory((Graph)graph2D);
        dOMGraphMLParser.setGraphElementFactory((GraphElementFactory)object);
        for (n = 0; n < this.graphInputHandlers.size(); ++n) {
            dOMGraphMLParser.addDOMInputHandler((DOMInputHandler)this.graphInputHandlers.get(n));
        }
        for (n = 0; n < this.nodeInputHandlers.size(); ++n) {
            dOMGraphMLParser.addDOMInputHandler((DOMInputHandler)this.nodeInputHandlers.get(n));
        }
        for (n = 0; n < this.edgeInputHandlers.size(); ++n) {
            dOMGraphMLParser.addDOMInputHandler((DOMInputHandler)this.edgeInputHandlers.get(n));
        }
        dOMGraphMLParser.getDocumentBuilderFactory().setValidating(this.validationEnabled);
        dOMGraphMLParser.getDocumentBuilderFactory().setNamespaceAware(true);
        dOMGraphMLParser.parse(inputStream, new GraphMLEntityResolver());
    }

    static {
        GraphMLIOHandler.addNodeRealizerSerializer(new ShapeNodeRealizerSerializer());
        GraphMLIOHandler.addNodeRealizerSerializer(new ImageNodeRealizerSerializer());
        GraphMLIOHandler.addNodeRealizerSerializer(new ProxyAutoBoundsNodeRealizerSerializer());
        GraphMLIOHandler.addNodeRealizerSerializer(new ProxyShapeNodeRealizerSerializer());
        GraphMLIOHandler.addNodeRealizerSerializer(new GroupNodeRealizerSerializer());
        try {
            GraphMLIOHandler.addNodeRealizerSerializer(new GenericNodeRealizerSerializer());
        }
        catch (Error error) {
            D.bug((Object)error);
        }
        GraphMLIOHandler.addEdgeRealizerSerializer(new ArcEdgeRealizerSerializer());
        GraphMLIOHandler.addEdgeRealizerSerializer(new PolyLineEdgeRealizerSerializer());
        GraphMLIOHandler.addEdgeRealizerSerializer(new BezierEdgeRealizerSerializer());
        GraphMLIOHandler.addEdgeRealizerSerializer(new SplineEdgeRealizerSerializer());
        try {
            GraphMLIOHandler.addEdgeRealizerSerializer(new QuadCurveEdgeRealizerSerializer());
        }
        catch (Error error) {
            D.bug((Object)error);
        }
    }
}

