/*
 * Decompiled with CFR 0.152.
 */
package yext.graphml.graph2D;

import org.graphdrawing.graphml.reader.GraphMLParseContext;
import org.graphdrawing.graphml.writer.GraphMLWriteContext;
import org.graphdrawing.graphml.writer.IndentPrintWriter;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import y.layout.NodeLayout;
import y.view.NodeLabel;
import y.view.NodeRealizer;
import yext.graphml.graph2D.GraphicsSerializationToolkit;
import yext.graphml.graph2D.NodeRealizerSerializer;
import yext.graphml.graph2D.XMLTools;

public abstract class AbstractNodeRealizerSerializer
implements NodeRealizerSerializer {
    static boolean A = false;

    public static void setWriteSelectionStateEnabled(boolean bl) {
        A = bl;
    }

    public static boolean isWriteSelectionStateEnabled(boolean bl) {
        return A;
    }

    public void parse(NodeRealizer nodeRealizer, Node node, GraphMLParseContext graphMLParseContext) {
        NodeList nodeList;
        if ("true".equals(XMLTools.getAttr(node, "selected"))) {
            nodeRealizer.setSelected(true);
        }
        if ((nodeList = node.getChildNodes()) != null) {
            int n = 0;
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node2;
                Object object;
                Node node3 = nodeList.item(i);
                if (node3.getNodeType() != 1) continue;
                String string = node3.getLocalName();
                if (string.equals("Geometry")) {
                    GraphicsSerializationToolkit.parseNodeLayout(node3, (NodeLayout)nodeRealizer);
                }
                if (string.equals("NodeLabel")) {
                    while (nodeRealizer.labelCount() <= n) {
                        object = nodeRealizer.createNodeLabel();
                        nodeRealizer.addLabel((NodeLabel)object);
                    }
                    GraphicsSerializationToolkit.A(node3, nodeRealizer.getLabel(n++), graphMLParseContext);
                }
                if (string.equals("Fill")) {
                    object = node3.getAttributes();
                    node2 = object.getNamedItem("hasColor");
                    if (node2 == null || !"false".equalsIgnoreCase(node2.getNodeValue())) {
                        node2 = object.getNamedItem("color");
                        if (node2 != null) {
                            nodeRealizer.setFillColor(GraphicsSerializationToolkit.parseColor(node2.getNodeValue()));
                        }
                    } else {
                        nodeRealizer.setFillColor(null);
                    }
                    if ((node2 = object.getNamedItem("color2")) != null) {
                        nodeRealizer.setFillColor2(GraphicsSerializationToolkit.parseColor(node2.getNodeValue()));
                    }
                    if ((node2 = object.getNamedItem("transparent")) != null) {
                        nodeRealizer.setTransparent("true".equalsIgnoreCase(node2.getNodeValue()));
                    }
                }
                if (!string.equals("BorderStyle")) continue;
                nodeRealizer.setLineType(GraphicsSerializationToolkit.parseLineType(node3));
                object = node3.getAttributes();
                node2 = object.getNamedItem("hasColor");
                if (node2 == null || !"false".equalsIgnoreCase(node2.getNodeValue())) {
                    node2 = object.getNamedItem("color");
                    if (node2 == null) continue;
                    nodeRealizer.setLineColor(GraphicsSerializationToolkit.parseColor(node2.getNodeValue()));
                    continue;
                }
                nodeRealizer.setLineColor(null);
            }
        }
    }

    public void writeAttributes(NodeRealizer nodeRealizer, IndentPrintWriter indentPrintWriter, GraphMLWriteContext graphMLWriteContext) {
        if (A) {
            indentPrintWriter.print("selected=\"" + nodeRealizer.isSelected() + "\"");
        }
    }

    public void write(NodeRealizer nodeRealizer, IndentPrintWriter indentPrintWriter, GraphMLWriteContext graphMLWriteContext) {
        GraphicsSerializationToolkit.writeNodeLayout(indentPrintWriter, (NodeLayout)nodeRealizer);
        this.writeFill(indentPrintWriter, nodeRealizer);
        GraphicsSerializationToolkit.writeStyle(indentPrintWriter, "BorderStyle", nodeRealizer.getLineType(), nodeRealizer.getLineColor());
        for (int i = 0; i < nodeRealizer.labelCount(); ++i) {
            GraphicsSerializationToolkit.writeNodeLabel(indentPrintWriter, nodeRealizer.getLabel(i));
        }
    }

    protected void writeFill(IndentPrintWriter indentPrintWriter, NodeRealizer nodeRealizer) {
        indentPrintWriter.print("<y:Fill ");
        if (nodeRealizer.getFillColor() == null) {
            indentPrintWriter.print("hasColor=\"false\" ");
        } else {
            GraphicsSerializationToolkit.writeColor(indentPrintWriter, "color", nodeRealizer.getFillColor());
        }
        if (nodeRealizer.getFillColor2() != null) {
            GraphicsSerializationToolkit.writeColor(indentPrintWriter, "color2", nodeRealizer.getFillColor2());
        }
        indentPrintWriter.println(" transparent=\"" + nodeRealizer.isTransparent() + "\"/>");
    }
}

