/*
 * Decompiled with CFR 0.152.
 */
package yext.graphml.graph2D;

import org.graphdrawing.graphml.reader.GraphMLParseContext;
import org.graphdrawing.graphml.writer.GraphMLWriteContext;
import org.graphdrawing.graphml.writer.IndentPrintWriter;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import y.layout.EdgeLayout;
import y.view.EdgeLabel;
import y.view.EdgeRealizer;
import yext.graphml.graph2D.EdgeRealizerSerializer;
import yext.graphml.graph2D.GraphicsSerializationToolkit;
import yext.graphml.graph2D.XMLTools;

public abstract class AbstractEdgeRealizerSerializer
implements EdgeRealizerSerializer {
    static boolean A = false;

    public static void setWriteSelectionStateEnabled(boolean bl) {
        A = bl;
    }

    public static boolean isWriteSelectionStateEnabled(boolean bl) {
        return A;
    }

    public void parse(EdgeRealizer edgeRealizer, Node node, GraphMLParseContext graphMLParseContext) {
        NodeList nodeList;
        if ("true".equals(XMLTools.getAttr(node, "selected"))) {
            edgeRealizer.setSelected(true);
        }
        if ((nodeList = node.getChildNodes()) != null) {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Object object;
                Node node2 = nodeList.item(i);
                if (node2.getNodeType() != 1) continue;
                String string = node2.getLocalName();
                if (string.equals("Path")) {
                    GraphicsSerializationToolkit.parsePath(node2, (EdgeLayout)edgeRealizer);
                }
                if (string.equals("EdgeLabel")) {
                    object = edgeRealizer.createEdgeLabel();
                    edgeRealizer.addLabel((EdgeLabel)object);
                    GraphicsSerializationToolkit.A(node2, (EdgeLabel)object, graphMLParseContext);
                }
                if (string.equals("LineStyle")) {
                    edgeRealizer.setLineType(GraphicsSerializationToolkit.parseLineType(node2));
                    object = node2.getAttributes();
                    Node node3 = object.getNamedItem("hasColor");
                    if (node3 == null || !"false".equalsIgnoreCase(node3.getNodeValue())) {
                        node3 = object.getNamedItem("color");
                        if (node3 != null) {
                            edgeRealizer.setLineColor(GraphicsSerializationToolkit.parseColor(node3.getNodeValue()));
                        }
                    } else {
                        edgeRealizer.setLineColor(GraphicsSerializationToolkit.parseColor(node3.getNodeValue()));
                    }
                }
                if (!string.equals("Arrows")) continue;
                edgeRealizer.setSourceArrow(GraphicsSerializationToolkit.parseArrow(node2, "source"));
                edgeRealizer.setTargetArrow(GraphicsSerializationToolkit.parseArrow(node2, "target"));
            }
        }
    }

    public void writeAttributes(EdgeRealizer edgeRealizer, IndentPrintWriter indentPrintWriter, GraphMLWriteContext graphMLWriteContext) {
        if (A) {
            indentPrintWriter.print("selected=\"" + edgeRealizer.isSelected() + "\"");
        }
    }

    public void write(EdgeRealizer edgeRealizer, IndentPrintWriter indentPrintWriter, GraphMLWriteContext graphMLWriteContext) {
        GraphicsSerializationToolkit.writePath(indentPrintWriter, (EdgeLayout)edgeRealizer);
        GraphicsSerializationToolkit.writeStyle(indentPrintWriter, "LineStyle", edgeRealizer.getLineType(), edgeRealizer.getLineColor());
        GraphicsSerializationToolkit.writeArrows(indentPrintWriter, "Arrows", edgeRealizer.getSourceArrow(), edgeRealizer.getTargetArrow());
        for (int i = 0; i < edgeRealizer.labelCount(); ++i) {
            GraphicsSerializationToolkit.writeEdgeLabel(indentPrintWriter, edgeRealizer.getLabel(i));
        }
    }
}

