/*
 * Decompiled with CFR 0.152.
 */
package yext.graphml.geom;

import java.util.StringTokenizer;
import org.graphdrawing.graphml.reader.dom.DOMGraphMLParser;
import org.graphdrawing.graphml.writer.DirectGraphMLWriter;
import y.base.DataAcceptor;
import y.base.DataProvider;
import y.base.Edge;
import y.base.Node;
import y.geom.YPoint;
import y.geom.YPointCursor;
import y.geom.YPointPath;
import y.layout.EdgeLayout;
import y.layout.LayoutGraph;
import y.util.DataAcceptorAdapter;
import y.util.DataProviderAdapter;
import yext.graphml.graph2D.GraphMLIOHandler;
import yext.graphml.reader.AttrDataAcceptorInputHandler;
import yext.graphml.writer.AttrDataProviderOutputHandler;

public class GeomGraphMLIOHandler
extends GraphMLIOHandler {
    protected boolean includeLayout = false;

    protected static void addNOH(DirectGraphMLWriter directGraphMLWriter, String string, int n, DataProvider dataProvider) {
        directGraphMLWriter.addNodeOutputHandler(new AttrDataProviderOutputHandler(string, dataProvider, 1, n));
    }

    protected static void addEOH(DirectGraphMLWriter directGraphMLWriter, String string, int n, DataProvider dataProvider) {
        directGraphMLWriter.addEdgeOutputHandler(new AttrDataProviderOutputHandler(string, dataProvider, 2, n));
    }

    public static void addGeomOutputHandlers(DirectGraphMLWriter directGraphMLWriter) {
        GeomGraphMLIOHandler.addNOH(directGraphMLWriter, "x", 4, (DataProvider)new NodeXDataProvider());
        GeomGraphMLIOHandler.addNOH(directGraphMLWriter, "y", 4, (DataProvider)new NodeYDataProvider());
        GeomGraphMLIOHandler.addNOH(directGraphMLWriter, "width", 4, (DataProvider)new NodeWidthDataProvider());
        GeomGraphMLIOHandler.addNOH(directGraphMLWriter, "height", 4, (DataProvider)new NodeHeightDataProvider());
        GeomGraphMLIOHandler.addEOH(directGraphMLWriter, "sourcePortX", 4, (DataProvider)new EdgeSourcePortXDataProvider());
        GeomGraphMLIOHandler.addEOH(directGraphMLWriter, "sourcePortY", 4, (DataProvider)new EdgeSourcePortYDataProvider());
        GeomGraphMLIOHandler.addEOH(directGraphMLWriter, "targetPortX", 4, (DataProvider)new EdgeTargetPortXDataProvider());
        GeomGraphMLIOHandler.addEOH(directGraphMLWriter, "targetPortY", 4, (DataProvider)new EdgeTargetPortYDataProvider());
        GeomGraphMLIOHandler.addEOH(directGraphMLWriter, "bendsX", 5, (DataProvider)new EdgeBendsXDataProvider());
        GeomGraphMLIOHandler.addEOH(directGraphMLWriter, "bendsY", 5, (DataProvider)new EdgeBendsYDataProvider());
    }

    public static void addGeomInputHandlers(DOMGraphMLParser dOMGraphMLParser) {
        dOMGraphMLParser.addDOMInputHandler(new AttrDataAcceptorInputHandler("x", (DataAcceptor)new NodeXDataAcceptor(), 1, 4));
        dOMGraphMLParser.addDOMInputHandler(new AttrDataAcceptorInputHandler("y", (DataAcceptor)new NodeYDataAcceptor(), 1, 4));
        dOMGraphMLParser.addDOMInputHandler(new AttrDataAcceptorInputHandler("width", (DataAcceptor)new NodeWidthDataAcceptor(), 1, 4));
        dOMGraphMLParser.addDOMInputHandler(new AttrDataAcceptorInputHandler("height", (DataAcceptor)new NodeHeightDataAcceptor(), 1, 4));
        dOMGraphMLParser.addDOMInputHandler(new AttrDataAcceptorInputHandler("sourcePortX", (DataAcceptor)new EdgeSourcePortXDataAcceptor(), 2, 4));
        dOMGraphMLParser.addDOMInputHandler(new AttrDataAcceptorInputHandler("sourcePortY", (DataAcceptor)new EdgeSourcePortYDataAcceptor(), 2, 4));
        dOMGraphMLParser.addDOMInputHandler(new AttrDataAcceptorInputHandler("targetPortX", (DataAcceptor)new EdgeTargetPortXDataAcceptor(), 2, 4));
        dOMGraphMLParser.addDOMInputHandler(new AttrDataAcceptorInputHandler("targetPortY", (DataAcceptor)new EdgeTargetPortYDataAcceptor(), 2, 4));
        dOMGraphMLParser.addDOMInputHandler(new AttrDataAcceptorInputHandler("bendsX", (DataAcceptor)new EdgeBendsXDataAcceptor(), 2, 5));
        dOMGraphMLParser.addDOMInputHandler(new AttrDataAcceptorInputHandler("bendsY", (DataAcceptor)new EdgeBendsYDataAcceptor(), 2, 5));
    }

    public void init() {
    }

    public String getFileFormatString() {
        return "GraphML file";
    }

    public String getFileNameExtension() {
        return "graphml";
    }

    public static GeomGraphMLIOHandler newInstance() {
        return new GeomGraphMLIOHandler();
    }

    public boolean isIncludeLayout() {
        return this.includeLayout;
    }

    public void setIncludeLayout(boolean bl) {
        this.includeLayout = bl;
    }

    public static class EdgeBendsYDataAcceptor
    extends StringEdgeDataAcceptorAdapter {
        public void set(Edge edge, LayoutGraph layoutGraph, String string) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
            int n = 0;
            EdgeLayout edgeLayout = layoutGraph.getEdgeLayout((Object)edge);
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                double d = Double.parseDouble(string2);
                if (n < edgeLayout.pointCount()) {
                    YPoint yPoint = edgeLayout.getPoint(n);
                    edgeLayout.setPoint(n, yPoint.getX(), d);
                } else {
                    edgeLayout.addPoint(0.0, d);
                }
                ++n;
            }
        }
    }

    public static class EdgeBendsXDataAcceptor
    extends StringEdgeDataAcceptorAdapter {
        public void set(Edge edge, LayoutGraph layoutGraph, String string) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
            int n = 0;
            EdgeLayout edgeLayout = layoutGraph.getEdgeLayout((Object)edge);
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                double d = Double.parseDouble(string2);
                if (n < edgeLayout.pointCount()) {
                    YPoint yPoint = edgeLayout.getPoint(n);
                    edgeLayout.setPoint(n, d, yPoint.getY());
                } else {
                    edgeLayout.addPoint(d, 0.0);
                }
                ++n;
            }
        }
    }

    public static class EdgeTargetPortYDataAcceptor
    extends EdgeDataAcceptorAdapter {
        public void setDouble(Edge edge, LayoutGraph layoutGraph, double d) {
            layoutGraph.setTargetPointRel(edge, new YPoint(layoutGraph.getTargetPointRel(edge).getX(), d));
        }
    }

    public static class EdgeTargetPortXDataAcceptor
    extends EdgeDataAcceptorAdapter {
        public void setDouble(Edge edge, LayoutGraph layoutGraph, double d) {
            layoutGraph.setTargetPointRel(edge, new YPoint(d, layoutGraph.getTargetPointRel(edge).getY()));
        }
    }

    public static class EdgeSourcePortYDataAcceptor
    extends EdgeDataAcceptorAdapter {
        public void setDouble(Edge edge, LayoutGraph layoutGraph, double d) {
            layoutGraph.setSourcePointRel(edge, new YPoint(layoutGraph.getSourcePointRel(edge).getX(), d));
        }
    }

    public static class EdgeSourcePortXDataAcceptor
    extends EdgeDataAcceptorAdapter {
        public void setDouble(Edge edge, LayoutGraph layoutGraph, double d) {
            layoutGraph.setSourcePointRel(edge, new YPoint(d, layoutGraph.getSourcePointRel(edge).getY()));
        }
    }

    public static class NodeHeightDataAcceptor
    extends NodeDataAcceptorAdapter {
        public void setDouble(Node node, LayoutGraph layoutGraph, double d) {
            YPoint yPoint = layoutGraph.getLocation(node);
            layoutGraph.setSize(node, layoutGraph.getWidth(node), d);
            layoutGraph.setLocation(node, yPoint);
        }
    }

    public static class NodeWidthDataAcceptor
    extends NodeDataAcceptorAdapter {
        public void setDouble(Node node, LayoutGraph layoutGraph, double d) {
            YPoint yPoint = layoutGraph.getLocation(node);
            layoutGraph.setSize(node, d, layoutGraph.getHeight(node));
            layoutGraph.setLocation(node, yPoint);
        }
    }

    public static class NodeYDataAcceptor
    extends NodeDataAcceptorAdapter {
        public void setDouble(Node node, LayoutGraph layoutGraph, double d) {
            layoutGraph.setLocation(node, layoutGraph.getX(node), d);
        }
    }

    public static class NodeXDataAcceptor
    extends NodeDataAcceptorAdapter {
        public void setDouble(Node node, LayoutGraph layoutGraph, double d) {
            layoutGraph.setLocation(node, d, layoutGraph.getY(node));
        }
    }

    public static abstract class StringEdgeDataAcceptorAdapter
    extends DataAcceptorAdapter {
        public void set(Object object, Object object2) {
            Edge edge = (Edge)object;
            LayoutGraph layoutGraph = (LayoutGraph)edge.getGraph();
            this.set(edge, layoutGraph, object2.toString());
        }

        public abstract void set(Edge var1, LayoutGraph var2, String var3);
    }

    public static abstract class EdgeDataAcceptorAdapter
    extends DataAcceptorAdapter {
        public void setDouble(Object object, double d) {
            Edge edge = (Edge)object;
            LayoutGraph layoutGraph = (LayoutGraph)edge.getGraph();
            this.setDouble(edge, layoutGraph, d);
        }

        public abstract void setDouble(Edge var1, LayoutGraph var2, double var3);
    }

    public static abstract class NodeDataAcceptorAdapter
    extends DataAcceptorAdapter {
        public void setDouble(Object object, double d) {
            Node node = (Node)object;
            LayoutGraph layoutGraph = (LayoutGraph)node.getGraph();
            this.setDouble(node, layoutGraph, d);
        }

        public abstract void setDouble(Node var1, LayoutGraph var2, double var3);
    }

    public static class EdgeBendsYDataProvider
    extends EdgeDataProviderAdapter {
        public Object get(Edge edge, LayoutGraph layoutGraph) {
            StringBuffer stringBuffer = new StringBuffer();
            YPointPath yPointPath = layoutGraph.getPoints(edge);
            if (yPointPath.length() == 0) {
                return "";
            }
            YPointCursor yPointCursor = yPointPath.points();
            YPoint yPoint = yPointCursor.point();
            stringBuffer.append(yPoint.getY());
            yPointCursor.next();
            while (yPointCursor.ok()) {
                stringBuffer.append(" " + yPointCursor.point().getY());
                yPointCursor.next();
            }
            return stringBuffer.toString();
        }
    }

    public static class EdgeBendsXDataProvider
    extends EdgeDataProviderAdapter {
        public Object get(Edge edge, LayoutGraph layoutGraph) {
            StringBuffer stringBuffer = new StringBuffer();
            YPointPath yPointPath = layoutGraph.getPoints(edge);
            if (yPointPath.length() == 0) {
                return "";
            }
            YPointCursor yPointCursor = yPointPath.points();
            YPoint yPoint = yPointCursor.point();
            stringBuffer.append(yPoint.getX());
            yPointCursor.next();
            while (yPointCursor.ok()) {
                stringBuffer.append(" " + yPointCursor.point().getX());
                yPointCursor.next();
            }
            return stringBuffer.toString();
        }
    }

    public static class EdgeTargetPortYDataProvider
    extends EdgeDataProviderAdapter {
        public Object get(Edge edge, LayoutGraph layoutGraph) {
            return new Double(layoutGraph.getTargetPointRel(edge).getY());
        }
    }

    public static class EdgeTargetPortXDataProvider
    extends EdgeDataProviderAdapter {
        public Object get(Edge edge, LayoutGraph layoutGraph) {
            return new Double(layoutGraph.getTargetPointRel(edge).getX());
        }
    }

    public static class EdgeSourcePortYDataProvider
    extends EdgeDataProviderAdapter {
        public Object get(Edge edge, LayoutGraph layoutGraph) {
            return new Double(layoutGraph.getSourcePointRel(edge).getY());
        }
    }

    public static class EdgeSourcePortXDataProvider
    extends EdgeDataProviderAdapter {
        public Object get(Edge edge, LayoutGraph layoutGraph) {
            return new Double(layoutGraph.getSourcePointRel(edge).getX());
        }
    }

    public static class NodeHeightDataProvider
    extends NodeDataProviderAdapter {
        public Object get(Node node, LayoutGraph layoutGraph) {
            return new Double(layoutGraph.getHeight(node));
        }
    }

    public static class NodeWidthDataProvider
    extends NodeDataProviderAdapter {
        public Object get(Node node, LayoutGraph layoutGraph) {
            return new Double(layoutGraph.getWidth(node));
        }
    }

    public static class NodeYDataProvider
    extends NodeDataProviderAdapter {
        public Object get(Node node, LayoutGraph layoutGraph) {
            return new Double(layoutGraph.getY(node));
        }
    }

    public static class NodeXDataProvider
    extends NodeDataProviderAdapter {
        public Object get(Node node, LayoutGraph layoutGraph) {
            return new Double(layoutGraph.getX(node));
        }
    }

    public static abstract class EdgeDataProviderAdapter
    extends DataProviderAdapter {
        public Object get(Object object) {
            Edge edge = (Edge)object;
            LayoutGraph layoutGraph = (LayoutGraph)edge.getGraph();
            return this.get(edge, layoutGraph);
        }

        public abstract Object get(Edge var1, LayoutGraph var2);
    }

    public static abstract class NodeDataProviderAdapter
    extends DataProviderAdapter {
        public Object get(Object object) {
            Node node = (Node)object;
            LayoutGraph layoutGraph = (LayoutGraph)node.getGraph();
            return this.get(node, layoutGraph);
        }

        public abstract Object get(Node var1, LayoutGraph var2);
    }
}

