/*
 * Decompiled with CFR 0.152.
 */
package org.graphdrawing.graphml.writer;

import java.io.PrintWriter;
import java.io.Writer;

public class IndentPrintWriter
extends PrintWriter {
    protected int currentIdentation = 0;
    protected String indentString = "";
    protected boolean newLine = true;
    protected int defaultIndent = 2;
    protected boolean xmlConversion = false;

    public IndentPrintWriter(Writer writer) {
        super(writer);
    }

    public IndentPrintWriter(Writer writer, boolean bl) {
        super(writer, bl);
    }

    public boolean isXmlConversionActive() {
        return this.xmlConversion;
    }

    public void setXmlConversionActive(boolean bl) {
        this.xmlConversion = bl;
    }

    public void increaseIndent() {
        this.increaseIndent(this.defaultIndent);
    }

    public void decreaseIndent() {
        this.decreaseIndent(this.defaultIndent);
    }

    public void increaseIndent(int n) {
        this.currentIdentation += n;
        this.updateIndentation();
    }

    public void decreaseIndent(int n) {
        this.currentIdentation -= n;
        this.updateIndentation();
    }

    protected void updateIndentation() {
        char[] cArray = new char[this.currentIdentation];
        for (int i = 0; i < this.currentIdentation; ++i) {
            cArray[i] = 32;
        }
        this.indentString = new String(cArray);
    }

    public void print(String string) {
        if (this.newLine) {
            super.print(this.indentString);
        }
        super.print(this.xmlConversion ? IndentPrintWriter.convert(string) : string);
        this.newLine = false;
    }

    public void println(String string) {
        super.println(string);
        this.newLine = true;
    }

    public void println() {
        super.println();
        this.newLine = true;
    }

    public static String convert(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        block9: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '&': {
                    stringBuffer.append("&amp;");
                    continue block9;
                }
                case '\"': {
                    stringBuffer.append("&quot;");
                    continue block9;
                }
                case '\'': {
                    stringBuffer.append("&apos;");
                    continue block9;
                }
                case '<': {
                    stringBuffer.append("&lt;");
                    continue block9;
                }
                case '>': {
                    stringBuffer.append("&gt;");
                    continue block9;
                }
                case '\r': {
                    if (i >= n - 1 || string.charAt(i + 1) != '\n') continue block9;
                    stringBuffer.append("&#xA;");
                    ++i;
                    continue block9;
                }
                case '\n': {
                    stringBuffer.append("&#xA;");
                    continue block9;
                }
                default: {
                    if (c < '\u0080') {
                        stringBuffer.append(c);
                        continue block9;
                    }
                    stringBuffer.append("&#x" + Integer.toHexString(c) + ";");
                }
            }
        }
        return stringBuffer.toString();
    }
}

