/*
 * Decompiled with CFR 0.152.
 */
package org.graphdrawing.graphml.writer;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import org.graphdrawing.graphml.writer.GraphElementProvider;
import org.graphdrawing.graphml.writer.GraphMLWriteContext;
import org.graphdrawing.graphml.writer.IndentPrintWriter;
import org.graphdrawing.graphml.writer.OutputHandler;
import org.graphdrawing.graphml.writer.XMLAttributesProvider;
import y.base.YCursor;
import y.base.YList;
import y.util.YVersion;

public class DirectGraphMLWriter {
    protected boolean writeDTDEnabled = false;
    protected boolean writeXMLSchemaEnabled = true;
    protected String dtd = "http://graphml.graphdrawing.org/dtds/graphml.dtd";
    protected String schema = "http://graphml.graphdrawing.org/xmlns/graphml http://www.yworks.com/xml/schema/graphml/1.0/graphml-attributes.xsd";
    protected boolean writeXMLPI = true;
    protected String defaultNamespace = "http://graphml.graphdrawing.org/xmlns/graphml";
    protected String shortNamespace = null;
    protected String longNamespace = null;
    protected String prefix = "";
    protected String encoding = "UTF-8";
    protected Map ids;
    protected int INDENT = 2;
    private YList E = new YList();
    private ArrayList C = new ArrayList();
    private Vector G = new Vector();
    private Vector A = new Vector();
    private Vector B = new Vector();
    private Vector[] D = new Vector[7];
    private Vector F = new Vector();
    protected GraphMLWriteContext graphMLWriteContext;
    protected Map nodeIds;

    public DirectGraphMLWriter() {
        for (int i = 0; i < 7; ++i) {
            this.D[i] = new Vector();
        }
    }

    public boolean isWriteDTDEnabled() {
        return this.writeDTDEnabled;
    }

    public boolean isWriteXMLSchemaEnabled() {
        return this.writeXMLSchemaEnabled;
    }

    public void setWriteDTDEnabled(boolean bl) {
        this.writeDTDEnabled = bl;
    }

    public void setWriteXMLSchemaEnabled(boolean bl) {
        this.writeXMLSchemaEnabled = bl;
    }

    public boolean isWriteXMLPI() {
        return this.writeXMLPI;
    }

    public void setWriteXMLPI(boolean bl) {
        this.writeXMLPI = bl;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String string) {
        this.encoding = string;
    }

    public void setNamespace(String string, String string2) {
        this.shortNamespace = string;
        this.longNamespace = string2;
        this.prefix = this.shortNamespace != null ? this.shortNamespace + ":" : "";
    }

    public void setDefaultNamespace(String string) {
        this.defaultNamespace = string;
    }

    public void setSchema(String string) {
        this.schema = string;
    }

    public void setDTD(String string) {
        this.dtd = string;
    }

    public void setGraphElementProvider(GraphElementProvider graphElementProvider) {
        this.clearGraphElementProviders();
        this.E.add((Object)graphElementProvider);
    }

    public void clearGraphElementProviders() {
        this.E.clear();
    }

    public void addGraphElementProvider(GraphElementProvider graphElementProvider) {
        this.E.add((Object)graphElementProvider);
    }

    public void addNodeOutputHandler(OutputHandler outputHandler) {
        this.addOutputHandler(outputHandler, 1);
    }

    public void addEdgeOutputHandler(OutputHandler outputHandler) {
        this.addOutputHandler(outputHandler, 2);
    }

    public void addGraphOutputHandler(OutputHandler outputHandler) {
        this.addOutputHandler(outputHandler, 3);
    }

    public void addOutputHandler(OutputHandler outputHandler, int n) {
        if (n == 2 || n == 0) {
            this.G.add(outputHandler);
        }
        if (n == 1 || n == 0) {
            this.C.add(outputHandler);
        }
        if (n == 3 || n == 0) {
            this.A.add(outputHandler);
        }
        if (n == 4 || n == 0) {
            this.B.add(outputHandler);
        }
        this.D[n].add(outputHandler);
    }

    public void addXMLAttributeProvider(XMLAttributesProvider xMLAttributesProvider) {
        this.F.add(xMLAttributesProvider);
    }

    public void write(OutputStream outputStream) throws IOException {
        if (outputStream == null) {
            return;
        }
        try {
            IndentPrintWriter indentPrintWriter = new IndentPrintWriter(new OutputStreamWriter(outputStream, this.encoding));
            this.writeData(indentPrintWriter);
            indentPrintWriter.flush();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IOException("Encoding not supported : " + this.encoding);
        }
    }

    protected void writeData(IndentPrintWriter indentPrintWriter) {
        this.writeXMLHeader(indentPrintWriter);
        this.writeRootElement(indentPrintWriter);
    }

    protected void writeXMLHeader(IndentPrintWriter indentPrintWriter) {
        if (this.writeXMLPI) {
            indentPrintWriter.println("<?xml version=\"1.0\" encoding=\"" + this.encoding + "\"?>\n" + "<!-- Created by yFiles " + YVersion.currentVersionString() + " -->");
        }
        if (this.writeDTDEnabled && this.dtd != null) {
            indentPrintWriter.println("<!DOCTYPE graphml SYSTEM \"" + this.dtd + "\">");
        }
    }

    protected void writeRootElement(IndentPrintWriter indentPrintWriter) {
        String string;
        String string2;
        this.nodeIds = new HashMap();
        this.graphMLWriteContext = this.createGraphMLWriteContext();
        String string3 = "";
        Object object = this.F.iterator();
        while (object.hasNext()) {
            string2 = ((XMLAttributesProvider)object.next()).getGraphMLAttributes(this.graphMLWriteContext);
            if (string2.length() <= 0) continue;
            string3 = string3 + string2;
            if (!object.hasNext()) continue;
            string3 = string3 + " ";
        }
        object = "";
        if (this.writeXMLSchemaEnabled) {
            object = "xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"" + this.schema + "\"";
        }
        string2 = "";
        if (this.defaultNamespace != null) {
            string2 = "xmlns=\"" + this.defaultNamespace + "\"";
        }
        if (this.shortNamespace == null) {
            indentPrintWriter.print("<graphml " + string2);
        } else {
            indentPrintWriter.print("<" + this.shortNamespace + ":graphml xmlns:" + this.shortNamespace + "=\"" + this.longNamespace + "\"");
        }
        if (string3.length() > 0) {
            indentPrintWriter.print(" " + string3);
        }
        if (((String)object).length() > 0) {
            indentPrintWriter.print(" " + (String)object);
        }
        if ((string = this.getGraphMLAtts()).length() > 0) {
            indentPrintWriter.print(" " + string);
        }
        indentPrintWriter.println(">");
        this.writeKeyDefinitions(indentPrintWriter);
        YCursor yCursor = this.E.cursor();
        while (yCursor.ok()) {
            this.writeGraphElement((GraphElementProvider)yCursor.current(), indentPrintWriter, "G", true);
            yCursor.next();
        }
        indentPrintWriter.println("</" + this.prefix + "graphml>");
        this.nodeIds = null;
    }

    protected void writeKeyDefinitions(IndentPrintWriter indentPrintWriter) {
        int n = 0;
        this.ids = new HashMap();
        for (int i = 0; i < 7; ++i) {
            for (int j = 0; j < this.D[i].size(); ++j) {
                OutputHandler outputHandler = (OutputHandler)this.D[i].elementAt(j);
                this.ids.put(outputHandler, "d" + n);
                ++n;
                this.A(outputHandler, indentPrintWriter, i);
            }
        }
    }

    private void A(OutputHandler outputHandler, IndentPrintWriter indentPrintWriter, int n) {
        String string = this.ids.get(outputHandler).toString();
        String string2 = outputHandler.getKeyAttributes(this.graphMLWriteContext);
        String string3 = null;
        switch (n) {
            case 0: {
                string3 = "for=\"all\"";
                break;
            }
            case 3: {
                string3 = "for=\"graph\"";
                break;
            }
            case 1: {
                string3 = "for=\"node\"";
                break;
            }
            case 2: {
                string3 = "for=\"edge\"";
                break;
            }
            case 4: {
                string3 = "for=\"hyperedge\"";
                break;
            }
            case 5: {
                string3 = "for=\"endpoint\"";
                break;
            }
            case 6: {
                string3 = "for=\"port\"";
                break;
            }
            default: {
                throw new RuntimeException("Undefined scope: " + n);
            }
        }
        string2 = "id=\"" + string + "\" " + string3 + " " + string2;
        this.writeSingle("key", string2, indentPrintWriter);
    }

    private void A(OutputHandler outputHandler, IndentPrintWriter indentPrintWriter) {
        String string = this.ids.get(outputHandler).toString();
        String string2 = outputHandler.getDataAttributes(this.graphMLWriteContext);
        string2 = "key=\"" + string + "\" " + string2;
        this.writeStarting("data", string2, indentPrintWriter);
        outputHandler.printDataOutput(this.graphMLWriteContext, indentPrintWriter);
        this.writeEnding("data", indentPrintWriter);
    }

    protected void writeGraphElement(GraphElementProvider graphElementProvider, IndentPrintWriter indentPrintWriter, String string, boolean bl) {
        int n;
        Object object;
        int n2;
        indentPrintWriter.increaseIndent(this.INDENT);
        this.graphMLWriteContext.pushGraphMLElement(graphElementProvider.getGraphObject());
        String string2 = graphElementProvider.isDefaultDirected() ? "directed" : "undirected";
        String string3 = "";
        for (n2 = 0; n2 < this.F.size(); ++n2) {
            object = ((XMLAttributesProvider)this.F.get(n2)).getGraphAttributes(this.graphMLWriteContext);
            if (((String)object).length() <= 0) continue;
            string3 = string3 + " " + (String)object;
        }
        indentPrintWriter.println("<" + this.prefix + "graph id=\"" + string + "\" edgedefault=\"" + string2 + "\"" + string3 + ">");
        for (n2 = 0; n2 < this.A.size(); ++n2) {
            object = (OutputHandler)this.A.elementAt(n2);
            this.A((OutputHandler)object, indentPrintWriter);
        }
        String string4 = bl ? "" : string + ":";
        for (n = 0; n < graphElementProvider.getNodeCount(); ++n) {
            this.writeNode(graphElementProvider, n, string4, indentPrintWriter);
        }
        for (n = 0; n < graphElementProvider.getEdgeCount(); ++n) {
            this.writeEdge(graphElementProvider, n, string4, indentPrintWriter);
        }
        for (n = 0; n < graphElementProvider.getHyperEdgeCount(); ++n) {
            this.writeHyperEdge(graphElementProvider, n, string4, indentPrintWriter);
        }
        indentPrintWriter.println("</" + this.prefix + "graph>");
        indentPrintWriter.decreaseIndent(this.INDENT);
        this.graphMLWriteContext.popGraphMLElement();
    }

    protected void writeEdge(GraphElementProvider graphElementProvider, int n, String string, IndentPrintWriter indentPrintWriter) {
        Object object;
        int n2;
        Object object2 = graphElementProvider.getEdgeObject(n);
        Object object3 = graphElementProvider.getSourceNode(object2);
        Object object4 = graphElementProvider.getTargetNode(object2);
        String string2 = this.nodeIds.get(object3).toString();
        String string3 = this.nodeIds.get(object4).toString();
        String string4 = string + "e" + String.valueOf(n);
        String string5 = "id=\"" + string4 + "\" " + "source" + "=\"" + string2 + "\" " + "target" + "=\"" + string3 + "\"";
        if (graphElementProvider.isDefaultDirected() != graphElementProvider.isDirected(object2)) {
            string5 = string5 + " directed=\"" + graphElementProvider.isDirected(object2) + "\"";
        }
        this.graphMLWriteContext.pushGraphMLElement(object2);
        for (n2 = 0; n2 < this.F.size(); ++n2) {
            object = ((XMLAttributesProvider)this.F.get(n2)).getEdgeAttributes(this.graphMLWriteContext);
            if (((String)object).length() <= 0) continue;
            string5 = string5 + " " + (String)object;
        }
        if (this.G.size() > 0) {
            this.writeStarting("edge", string5, indentPrintWriter);
            indentPrintWriter.println();
            for (n2 = 0; n2 < this.G.size(); ++n2) {
                object = (OutputHandler)this.G.elementAt(n2);
                this.A((OutputHandler)object, indentPrintWriter);
            }
            this.writeEnding("edge", indentPrintWriter);
        } else {
            this.writeSingle("edge", string5, indentPrintWriter);
        }
        this.graphMLWriteContext.popGraphMLElement();
    }

    protected void writeNode(GraphElementProvider graphElementProvider, int n, String string, IndentPrintWriter indentPrintWriter) {
        Object object = graphElementProvider.getNodeObject(n);
        String string2 = string + "n" + String.valueOf(n);
        this.nodeIds.put(object, string2);
        String string3 = "id=\"" + string2 + "\"";
        this.graphMLWriteContext.pushGraphMLElement(object);
        for (int i = 0; i < this.F.size(); ++i) {
            String string4 = ((XMLAttributesProvider)this.F.get(i)).getNodeAttributes(this.graphMLWriteContext);
            if (string4.length() <= 0) continue;
            string3 = string3 + " " + string4;
        }
        GraphElementProvider graphElementProvider2 = graphElementProvider.getNodeSubgraph(object);
        if (this.C.size() > 0 || graphElementProvider2 != null) {
            this.writeStarting("node", string3, indentPrintWriter);
            indentPrintWriter.println();
            for (int i = 0; i < this.C.size(); ++i) {
                OutputHandler outputHandler = (OutputHandler)this.C.get(i);
                this.A(outputHandler, indentPrintWriter);
            }
            if (graphElementProvider2 != null) {
                this.writeGraphElement(graphElementProvider2, indentPrintWriter, string2 + ":", false);
            }
            this.writeEnding("node", indentPrintWriter);
        } else {
            this.writeSingle("node", string3, indentPrintWriter);
        }
        this.graphMLWriteContext.popGraphMLElement();
    }

    protected void writeHyperEdge(GraphElementProvider graphElementProvider, int n, String string, IndentPrintWriter indentPrintWriter) {
        Object object;
        int n2;
        Object object2 = graphElementProvider.getHyperEdgeObject(n);
        String string2 = string + "he" + String.valueOf(n);
        String string3 = "id=\"" + string2 + "\" ";
        this.graphMLWriteContext.pushGraphMLElement(object2);
        for (n2 = 0; n2 < this.F.size(); ++n2) {
            object = ((XMLAttributesProvider)this.F.get(n2)).getHyperEdgeAttributes(this.graphMLWriteContext);
            if (((String)object).length() <= 0) continue;
            string3 = string3 + " " + (String)object;
        }
        this.writeStarting("hyperedge", string3, indentPrintWriter);
        indentPrintWriter.println();
        for (n2 = 0; n2 < graphElementProvider.getEndPointCount(object2); ++n2) {
            object = graphElementProvider.getEndPoint(object2, n2);
            String string4 = this.nodeIds.get(object).toString();
            String string5 = "node=\"" + string4 + "\"";
            this.writeSingle("endpoint", string5, indentPrintWriter);
        }
        for (n2 = 0; n2 < this.B.size(); ++n2) {
            object = (OutputHandler)this.B.elementAt(n2);
            this.A((OutputHandler)object, indentPrintWriter);
        }
        this.writeEnding("hyperedge", indentPrintWriter);
        this.graphMLWriteContext.popGraphMLElement();
    }

    protected void writeStarting(String string, String string2, IndentPrintWriter indentPrintWriter) {
        indentPrintWriter.increaseIndent(this.INDENT);
        if (string2.length() > 0) {
            indentPrintWriter.print("<" + this.prefix + string + " " + string2 + ">");
        } else {
            indentPrintWriter.print("<" + this.prefix + string + ">");
        }
    }

    protected void writeEnding(String string, IndentPrintWriter indentPrintWriter) {
        indentPrintWriter.println("</" + this.prefix + string + ">");
        indentPrintWriter.decreaseIndent(this.INDENT);
    }

    protected void writeSingle(String string, String string2, IndentPrintWriter indentPrintWriter) {
        indentPrintWriter.increaseIndent(this.INDENT);
        indentPrintWriter.println("<" + this.prefix + string + " " + string2 + "/>");
        indentPrintWriter.decreaseIndent(this.INDENT);
    }

    protected String getGraphMLAtts() {
        return "";
    }

    protected GraphMLWriteContext createGraphMLWriteContext() {
        return new GraphMLWriteContext();
    }
}

