/*
 * Decompiled with CFR 0.152.
 */
package org.graphdrawing.graphml.reader.dom;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Stack;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.graphdrawing.graphml.reader.GraphElementFactory;
import org.graphdrawing.graphml.reader.GraphMLParseException;
import org.graphdrawing.graphml.reader.dom.DOMGraphMLParseContext;
import org.graphdrawing.graphml.reader.dom.DOMInputHandler;
import org.graphdrawing.graphml.reader.dom.Precedence;
import org.graphdrawing.graphml.reader.dom.XMLAttributesParser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.SAXException;

public class DOMGraphMLParser {
    private GraphElementFactory C;
    protected boolean validationEnabled = false;
    private DOMGraphMLParseContext A;
    private Stack D = new Stack();
    private HashMap E = new HashMap();
    private HashMap H = new HashMap();
    private List G = new ArrayList();
    private List F = new ArrayList();
    private ArrayList[] I = new ArrayList[7];
    private DocumentBuilderFactory B = DocumentBuilderFactory.newInstance();

    public DocumentBuilderFactory getDocumentBuilderFactory() {
        return this.B;
    }

    public void setGraphElementFactory(GraphElementFactory graphElementFactory) {
        this.C = graphElementFactory;
    }

    public void addDOMInputHandler(DOMInputHandler dOMInputHandler) {
        this.G.add(dOMInputHandler);
    }

    public void removeDOMInputHandler(DOMInputHandler dOMInputHandler) {
        this.G.remove(dOMInputHandler);
    }

    public void addXMLAttributeParser(XMLAttributesParser xMLAttributesParser) {
        this.F.add(xMLAttributesParser);
    }

    public void removeXMLAttributeParser(XMLAttributesParser xMLAttributesParser) {
        this.F.remove(xMLAttributesParser);
    }

    public Object parse(InputStream inputStream) throws GraphMLParseException {
        return this.parse(inputStream, null);
    }

    public Object parse(InputStream inputStream, EntityResolver entityResolver) throws GraphMLParseException {
        if (this.C == null) {
            throw new GraphMLParseException("No Graph Element Factory configured !");
        }
        try {
            this.B.setNamespaceAware(true);
            this.B.setValidating(this.validationEnabled);
            DocumentBuilder documentBuilder = this.B.newDocumentBuilder();
            documentBuilder.setEntityResolver(entityResolver);
            Document document = documentBuilder.parse(inputStream);
            return this.parseDocument(document);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new GraphMLParseException("Cannot instantiate parser !");
        }
        catch (FactoryConfigurationError factoryConfigurationError) {
            throw new GraphMLParseException("Factory misconfigured !");
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace(System.err);
            throw new GraphMLParseException("SAX error : " + sAXException.toString());
        }
        catch (IOException iOException) {
            iOException.printStackTrace(System.err);
            throw new GraphMLParseException("Error reading from inputstream !");
        }
    }

    public Object parseDocument(Document document) throws GraphMLParseException {
        Element element = document.getDocumentElement();
        if (element.getLocalName().toLowerCase().equals("graphml")) {
            return this.parseGraphMLNode(element);
        }
        return null;
    }

    public Object parseGraphMLNode(Node node) throws GraphMLParseException {
        this.D.clear();
        this.H.clear();
        this.E.clear();
        for (int i = 0; i < this.I.length; ++i) {
            this.I[i] = new ArrayList();
        }
        this.A = new DOMGraphMLParseContext();
        this.A.setAttributes(node.getAttributes());
        Object object = this.C.createGraphML(this.A);
        if (object != null) {
            this.A.pushGraphMLElement(object);
        }
        for (int i = 0; i < this.F.size(); ++i) {
            XMLAttributesParser xMLAttributesParser = (XMLAttributesParser)this.F.get(i);
            xMLAttributesParser.parseGraphMLAttributes(this.A);
        }
        NodeList nodeList = node.getChildNodes();
        if (nodeList != null) {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node2 = nodeList.item(i);
                if (node2.getNodeType() != 1) continue;
                String string = node2.getLocalName().toLowerCase();
                if (string.equals("key")) {
                    this.parseKeyNode(node2);
                }
                if (!string.equals("graph")) continue;
                this.parseGraphNode(node2);
            }
        }
        this.D.clear();
        this.H.clear();
        this.E.clear();
        return object;
    }

    protected void parseGraphNode(Node node) throws GraphMLParseException {
        Serializable serializable;
        Object object;
        Object object2;
        Object object3;
        NamedNodeMap namedNodeMap = node.getAttributes();
        String string = null;
        int n = -1;
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Node node2 = namedNodeMap.item(i);
            if (node2.getNodeName().toLowerCase().equals("id")) {
                string = node2.getNodeValue();
            }
            if (!node2.getNodeName().toLowerCase().equals("edgedefault")) continue;
            object3 = node2.getNodeValue();
            if (((String)object3).equals("directed")) {
                n = 0;
            }
            if (!((String)object3).equals("undirected")) continue;
            n = 1;
        }
        if (n == -1) {
            throw new GraphMLParseException("Edgedefault not defined in graph !");
        }
        this.D.push(new Boolean(n == 0));
        this.A.setAttributes(namedNodeMap);
        Object object4 = this.C.createGraph(this.A, string, n);
        this.A.pushGraphMLElement(object4);
        for (int i = 0; i < this.F.size(); ++i) {
            object3 = (XMLAttributesParser)this.F.get(i);
            object3.parseGraphAttributes(this.A);
        }
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(this.I[3]);
        arrayList.addAll(this.I[0]);
        object3 = new Integer(0);
        HashMap hashMap = new HashMap();
        Object object5 = arrayList.iterator();
        while (object5.hasNext()) {
            object2 = object5.next();
            object = new Integer(this.A(object2));
            serializable = (ArrayList<Object>)hashMap.get(object);
            if (serializable == null) {
                serializable = new ArrayList<Object>();
                hashMap.put(object, serializable);
            }
            serializable.add(object2);
        }
        object5 = new Comparator(){

            public int compare(Object object, Object object2) {
                return (Integer)object - (Integer)object2;
            }
        };
        if (!hashMap.containsKey(object3)) {
            hashMap.put(object3, new ArrayList());
        }
        object2 = new ArrayList(hashMap.keySet());
        Collections.sort(object2, object5);
        object = ((ArrayList)object2).iterator();
        while (object.hasNext()) {
            int n2;
            serializable = (Integer)object.next();
            arrayList = (ArrayList)hashMap.get(serializable);
            NodeList nodeList = node.getChildNodes();
            if (nodeList != null) {
                for (n2 = 0; n2 < nodeList.getLength(); ++n2) {
                    Node node3 = nodeList.item(n2);
                    if (node3.getNodeType() != 1) continue;
                    String string2 = node3.getLocalName().toLowerCase();
                    if (string2.equals("data")) {
                        this.parseDataNode(node3, arrayList);
                    }
                    if (!((Integer)serializable).equals(object3)) continue;
                    if (string2.equals("node")) {
                        this.parseNodeNode(node3);
                    }
                    if (string2.equals("edge")) {
                        this.parseEdgeNode(node3);
                    }
                    if (!string2.equals("hyperedge")) continue;
                    this.parseHyperEdgeNode(node3);
                }
            }
            for (n2 = 0; n2 < arrayList.size(); ++n2) {
                ((DOMInputHandler)arrayList.get(n2)).applyDefault(this.A);
            }
        }
        this.A.popGraphMLElement();
        this.D.pop();
    }

    private int A(Object object) {
        return object instanceof Precedence ? ((Precedence)object).getPrecedence() : 0;
    }

    protected void parseNodeNode(Node node) throws GraphMLParseException {
        int n;
        Object object;
        NamedNodeMap namedNodeMap = node.getAttributes();
        String string = null;
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Node node2 = namedNodeMap.item(i);
            if (!node2.getNodeName().toLowerCase().equals("id")) continue;
            string = node2.getNodeValue();
        }
        if (string == null) {
            throw new GraphMLParseException("Node id not defined !");
        }
        Object object2 = this.E.get(string);
        if (object2 == null) {
            this.A.setAttributes(namedNodeMap);
            object2 = this.C.createNode(this.A, string);
            this.E.put(string, object2);
        }
        this.A.pushGraphMLElement(object2);
        for (int i = 0; i < this.F.size(); ++i) {
            object = (XMLAttributesParser)this.F.get(i);
            object.parseNodeAttributes(this.A);
        }
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(this.I[1]);
        arrayList.addAll(this.I[0]);
        object = node.getChildNodes();
        if (object != null) {
            for (n = 0; n < object.getLength(); ++n) {
                Node node3 = object.item(n);
                if (node3.getNodeType() != 1) continue;
                String string2 = node3.getLocalName().toLowerCase();
                if (string2.equals("graph")) {
                    this.parseGraphNode(node3);
                }
                if (!string2.equals("data")) continue;
                this.parseDataNode(node3, arrayList);
            }
        }
        for (n = 0; n < arrayList.size(); ++n) {
            ((DOMInputHandler)arrayList.get(n)).applyDefault(this.A);
        }
        this.A.popGraphMLElement();
    }

    protected void parseEdgeNode(Node node) throws GraphMLParseException {
        int n;
        Object object;
        Object object2;
        NamedNodeMap namedNodeMap = node.getAttributes();
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        boolean bl = (Boolean)this.D.peek();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            object2 = namedNodeMap.item(i);
            if (object2.getNodeName().toLowerCase().equals("id")) {
                string = object2.getNodeValue();
            }
            if (object2.getNodeName().toLowerCase().equals("source")) {
                string2 = object2.getNodeValue();
            }
            if (object2.getNodeName().toLowerCase().equals("sourceport")) {
                string4 = object2.getNodeValue();
            }
            if (object2.getNodeName().toLowerCase().equals("target")) {
                string3 = object2.getNodeValue();
            }
            if (object2.getNodeName().toLowerCase().equals("targetport")) {
                string5 = object2.getNodeValue();
            }
            if (!object2.getNodeName().toLowerCase().equals("directed")) continue;
            bl = Boolean.valueOf(object2.getNodeValue());
        }
        if (string2 == null) {
            throw new GraphMLParseException("Source id not defined in edge !");
        }
        if (string3 == null) {
            throw new GraphMLParseException("Target id not defined in edge !");
        }
        Object object3 = this.E.get(string2);
        object2 = this.E.get(string3);
        if (object3 == null) {
            this.A.setAttributes(null);
            object3 = this.C.createNode(this.A, string2);
            this.E.put(string2, object3);
        }
        if (object2 == null) {
            this.A.setAttributes(null);
            object2 = this.C.createNode(this.A, string3);
            this.E.put(string3, object2);
        }
        this.A.setAttributes(namedNodeMap);
        Object object4 = this.C.createEdge(this.A, string, object3, object2, null, null, bl);
        this.A.pushGraphMLElement(object4);
        for (int i = 0; i < this.F.size(); ++i) {
            object = (XMLAttributesParser)this.F.get(i);
            object.parseEdgeAttributes(this.A);
        }
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(this.I[2]);
        arrayList.addAll(this.I[0]);
        object = node.getChildNodes();
        if (object != null) {
            for (n = 0; n < object.getLength(); ++n) {
                String string6;
                Node node2 = object.item(n);
                if (node2.getNodeType() != 1 || !(string6 = node2.getLocalName().toLowerCase()).equals("data")) continue;
                this.parseDataNode(node2, arrayList);
            }
        }
        for (n = 0; n < arrayList.size(); ++n) {
            ((DOMInputHandler)arrayList.get(n)).applyDefault(this.A);
        }
        this.A.popGraphMLElement();
    }

    protected void parseHyperEdgeNode(Node node) throws GraphMLParseException {
        int n;
        Object object;
        NamedNodeMap namedNodeMap = node.getAttributes();
        String string = null;
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Node node2 = namedNodeMap.item(i);
            if (!node2.getNodeName().toLowerCase().equals("id")) continue;
            string = node2.getNodeValue();
        }
        this.A.setAttributes(namedNodeMap);
        Object object2 = this.C.createHyperEdge(this.A, string);
        this.A.pushGraphMLElement(object2);
        for (int i = 0; i < this.F.size(); ++i) {
            object = (XMLAttributesParser)this.F.get(i);
            object.parseHyperEdgeAttributes(this.A);
        }
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(this.I[4]);
        arrayList.addAll(this.I[0]);
        object = node.getChildNodes();
        if (object != null) {
            for (n = 0; n < object.getLength(); ++n) {
                Node node3 = object.item(n);
                if (node3.getNodeType() != 1) continue;
                String string2 = node3.getLocalName().toLowerCase();
                if (string2.equals("data")) {
                    this.parseDataNode(node3, arrayList);
                }
                if (!string2.equals("endpoint")) continue;
                this.parseEndPointNode(node3);
            }
        }
        for (n = 0; n < arrayList.size(); ++n) {
            ((DOMInputHandler)arrayList.get(n)).applyDefault(this.A);
        }
        this.A.popGraphMLElement();
    }

    protected void parseEndPointNode(Node node) throws GraphMLParseException {
        int n;
        Object object;
        NamedNodeMap namedNodeMap = node.getAttributes();
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Node node2 = namedNodeMap.item(i);
            if (node2.getNodeName().toLowerCase().equals("id")) {
                string = node2.getNodeValue();
            }
            if (node2.getNodeName().toLowerCase().equals("port")) {
                string3 = node2.getNodeValue();
            }
            if (node2.getNodeName().toLowerCase().equals("type")) {
                string4 = node2.getNodeValue();
            }
            if (!node2.getNodeName().toLowerCase().equals("node")) continue;
            string2 = node2.getNodeValue();
        }
        if (string2 == null) {
            throw new GraphMLParseException("Endpoint node not defined !");
        }
        Object object2 = this.E.get(string2);
        if (object2 == null) {
            this.A.setAttributes(null);
            object2 = this.C.createNode(this.A, string2);
            this.E.put(string2, object2);
        }
        int n2 = 0;
        if (string4 == null) {
            n2 = 0;
        } else if (string4.equals("undir")) {
            n2 = 0;
        } else if (string4.equals("in")) {
            n2 = 1;
        } else if (string4.equals("out")) {
            n2 = 2;
        } else {
            throw new GraphMLParseException("Unknown endpoint type : " + string4);
        }
        this.A.setAttributes(namedNodeMap);
        Object object3 = this.C.createEndPoint(this.A, string, object2, null, n2);
        this.A.pushGraphMLElement(object3);
        for (int i = 0; i < this.F.size(); ++i) {
            object = (XMLAttributesParser)this.F.get(i);
            object.parseEndPointNodeAttributes(this.A);
        }
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(this.I[5]);
        arrayList.addAll(this.I[0]);
        object = node.getChildNodes();
        if (object != null) {
            for (n = 0; n < object.getLength(); ++n) {
                String string5;
                Node node3 = object.item(n);
                if (node3.getNodeType() != 1 || !(string5 = node3.getLocalName().toLowerCase()).equals("data")) continue;
                this.parseDataNode(node3, arrayList);
            }
        }
        for (n = 0; n < arrayList.size(); ++n) {
            ((DOMInputHandler)arrayList.get(n)).applyDefault(this.A);
        }
        this.A.popGraphMLElement();
    }

    public void parseKeyNode(Node node) throws GraphMLParseException {
        Object object;
        int n;
        NamedNodeMap namedNodeMap = node.getAttributes();
        String string = null;
        String string2 = null;
        int n2 = 0;
        for (n = 0; n < namedNodeMap.getLength(); ++n) {
            object = namedNodeMap.item(n);
            if (object.getNodeName().toLowerCase().equals("id")) {
                string = object.getNodeValue();
            }
            if (!object.getNodeName().toLowerCase().equals("for")) continue;
            string2 = object.getNodeValue();
        }
        if (string == null) {
            throw new GraphMLParseException("Id not defined in key !");
        }
        if (string2 != null) {
            if (string2.equals("all")) {
                n2 = 0;
            }
            if (string2.equals("node")) {
                n2 = 1;
            }
            if (string2.equals("edge")) {
                n2 = 2;
            }
            if (string2.equals("graph")) {
                n2 = 3;
            }
            if (string2.equals("hyperedge")) {
                n2 = 4;
            }
            if (string2.equals("endpoint")) {
                n2 = 5;
            }
            if (string2.equals("port")) {
                n2 = 6;
            }
        }
        this.A.setAttributes(namedNodeMap);
        for (n = 0; n < this.G.size(); ++n) {
            object = (DOMInputHandler)this.G.get(n);
            if (!object.acceptKey(namedNodeMap, n2)) continue;
            this.I[n2].add(object);
            ArrayList<HandlerDefinition> arrayList = (ArrayList<HandlerDefinition>)this.H.get(string);
            if (arrayList == null) {
                arrayList = new ArrayList<HandlerDefinition>(5);
                this.H.put(string, arrayList);
            }
            arrayList.add(new HandlerDefinition((DOMInputHandler)object, n2));
            object.parseData(this.A, true, node);
        }
    }

    protected void parseDataNode(Node node, List list) throws GraphMLParseException {
        NamedNodeMap namedNodeMap = node.getAttributes();
        String string = null;
        String string2 = null;
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Node node2 = namedNodeMap.item(i);
            if (node2.getNodeName().toLowerCase().equals("id")) {
                string = node2.getNodeValue();
            }
            if (!node2.getNodeName().toLowerCase().equals("key")) continue;
            string2 = node2.getNodeValue();
        }
        if (string2 == null) {
            throw new GraphMLParseException("Key not defined in data tag !");
        }
        this.A.setAttributes(namedNodeMap);
        List list2 = (List)this.H.get(string2);
        if (list2 == null) {
            return;
        }
        for (int i = 0; i < list2.size(); ++i) {
            HandlerDefinition handlerDefinition = (HandlerDefinition)list2.get(i);
            DOMInputHandler dOMInputHandler = handlerDefinition.getHandler();
            if (dOMInputHandler == null || !list.contains(dOMInputHandler)) {
                return;
            }
            list.remove(dOMInputHandler);
            dOMInputHandler.parseData(this.A, false, node);
        }
    }

    protected static class HandlerDefinition {
        private DOMInputHandler B;
        private int A;

        public HandlerDefinition(DOMInputHandler dOMInputHandler, int n) {
            this.B = dOMInputHandler;
            this.A = n;
        }

        public DOMInputHandler getHandler() {
            return this.B;
        }

        public int getScope() {
            return this.A;
        }
    }
}

