/*
 * Decompiled with CFR 0.152.
 */
package org.graphdrawing.graphml.attr;

import org.graphdrawing.graphml.attr.AttributeFactory;
import org.graphdrawing.graphml.reader.dom.DOMGraphMLParseContext;
import org.graphdrawing.graphml.reader.dom.DOMInputHandler;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AttributeInputHandler
implements DOMInputHandler {
    protected AttributeFactory attributeFactory = null;
    protected String name;
    protected String defaultValue;

    public AttributeInputHandler(String string, AttributeFactory attributeFactory) {
        this.name = string;
        this.attributeFactory = attributeFactory;
    }

    public void setAttributeFactory(AttributeFactory attributeFactory) {
        this.attributeFactory = attributeFactory;
    }

    public boolean acceptKey(NamedNodeMap namedNodeMap, int n) {
        Node node = namedNodeMap.getNamedItem("attr.name");
        Node node2 = namedNodeMap.getNamedItem("attr.type");
        if (node == null || node2 == null) {
            return false;
        }
        String string = node.getNodeValue();
        if (!string.equals(this.name)) {
            return false;
        }
        String string2 = node2.getNodeValue();
        int n2 = -1;
        if (string2.equals("double")) {
            n2 = 4;
        } else if (string2.equals("int")) {
            n2 = 1;
        } else if (string2.equals("long")) {
            n2 = 2;
        } else if (string2.equals("float")) {
            n2 = 3;
        } else if (string2.equals("string")) {
            n2 = 5;
        } else if (string2.equals("boolean")) {
            n2 = 6;
        }
        if (n2 == -1) {
            throw new RuntimeException("Type: " + string2 + " is not supported !");
        }
        this.attributeFactory.defineAttribute(this.name, n2, n);
        return true;
    }

    public void parseData(DOMGraphMLParseContext dOMGraphMLParseContext, boolean bl, Node node) {
        if (bl) {
            NodeList nodeList = node.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node2 = nodeList.item(i);
                if (node2.getNodeType() != 1 || !node2.getLocalName().equals("default")) continue;
                this.defaultValue = node2.getFirstChild().getNodeValue();
            }
        } else {
            if (node.getFirstChild() == null) {
                return;
            }
            String string = node.getFirstChild().getNodeValue();
            if (this.attributeFactory != null) {
                this.attributeFactory.createAttribute(dOMGraphMLParseContext, this.name, string);
            }
        }
    }

    public void applyDefault(DOMGraphMLParseContext dOMGraphMLParseContext) {
        this.attributeFactory.createAttribute(dOMGraphMLParseContext, this.name, this.defaultValue);
    }
}

