/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.util.report;

import de.unika.ipd.grgen.util.report.Handler;
import de.unika.ipd.grgen.util.report.Location;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public class TableHandler
implements TableModel,
Handler {
    private static final String[] msgNames = new String[]{"error", "warning", "note", "debug", "note"};
    private static final int COL_DEGREE = 0;
    private static final int COL_MSG = 1;
    private static final String[] columnNames = new String[]{"degree", "message"};
    private List<TableModelListener> listeners = new LinkedList<TableModelListener>();
    private Vector<Message> messages = new Vector();

    @Override
    public void addTableModelListener(TableModelListener tableModelListener) {
        this.listeners.add(tableModelListener);
    }

    @Override
    public void removeTableModelListener(TableModelListener tableModelListener) {
        this.listeners.remove(tableModelListener);
    }

    public Class<String> getColumnClass(int n) {
        return String.class;
    }

    @Override
    public int getColumnCount() {
        return columnNames.length;
    }

    @Override
    public String getColumnName(int n) {
        return columnNames[n];
    }

    @Override
    public int getRowCount() {
        return this.messages.size();
    }

    @Override
    public Object getValueAt(int n, int n2) {
        Message message = this.messages.get(n);
        String string = "";
        switch (n2) {
            case 0: {
                string = msgNames[message.degree];
                break;
            }
            case 1: {
                string = message.msg;
            }
        }
        return string;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
    }

    public void entering(String string) {
    }

    public void leaving() {
    }

    @Override
    public void report(int n, Location location, String string) {
        this.messages.add(new Message(n, string));
    }

    private static class Message {
        byte degree;
        String msg;

        public Message(int n, String string) {
            this.degree = (byte)n;
            this.msg = string;
            if (n < 0 || n > 4) {
                throw new IllegalArgumentException("degree is out of range!");
            }
        }
    }
}

