/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.util.report;

import de.unika.ipd.grgen.util.report.Handler;
import de.unika.ipd.grgen.util.report.Location;
import java.io.PrintStream;

public class StreamHandler
implements Handler {
    private PrintStream stream;
    private int indent;

    public StreamHandler(PrintStream printStream) {
        this.stream = printStream;
        this.indent = 0;
    }

    private void doIndent() {
        for (int i = 0; i < this.indent; ++i) {
            this.stream.print("  ");
        }
    }

    @Override
    public void report(int n, Location location, String string) {
        this.doIndent();
        this.stream.print("GrGen: [");
        if (n == 1) {
            this.stream.print("ERROR ");
        } else if (n == 2) {
            this.stream.print("WARNING ");
        } else if (n == 4) {
            this.stream.print("NOTE ");
        }
        this.stream.println((location.hasLocation() ? "at " + location.getLocation() + "] " : "at ?] ") + string);
    }

    public void entering(String string) {
        this.doIndent();
        this.stream.println(string + " {");
        ++this.indent;
    }

    public void leaving() {
        this.indent = this.indent > 0 ? this.indent - 1 : 0;
        this.doIndent();
        this.stream.println("}");
    }
}

