/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.util.report;

import de.unika.ipd.grgen.util.report.Location;
import de.unika.ipd.grgen.util.report.Reporter;

public class ErrorReporter
extends Reporter {
    public static final int ERROR = 1;
    public static final int WARNING = 2;
    public static final int NOTE = 4;
    protected static int errCount = 0;
    protected static int warnCount = 0;

    public ErrorReporter() {
        this.setMask(7);
    }

    public void error(Location location, String string) {
        if (string.equals("mismatched input '$' expecting RPAREN")) {
            this.report(1, location, string + " -- forgot \"@\"?");
        } else {
            this.report(1, location, string);
        }
        ++errCount;
    }

    public void error(String string) {
        this.report(1, string);
        ++errCount;
    }

    public void warning(Location location, String string) {
        this.report(2, location, string);
        ++warnCount;
    }

    public void warning(String string) {
        this.report(2, string);
        ++warnCount;
    }

    public void note(Location location, String string) {
        this.report(4, location, string);
    }

    public void note(String string) {
        this.report(4, string);
    }

    public static int getErrorCount() {
        return errCount;
    }

    public static int getWarnCount() {
        return warnCount;
    }
}

