/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.util;

import de.unika.ipd.grgen.util.XMLDumpable;
import java.io.PrintStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;

public class XMLDumper {
    private final PrintStream ps;
    private int indent = 0;
    private final String indentString;
    private final Collection<XMLDumpable> visited = new HashSet<XMLDumpable>();

    public XMLDumper(PrintStream printStream) {
        this(printStream, "  ");
    }

    public XMLDumper(PrintStream printStream, String string) {
        this.ps = printStream;
        this.indentString = string;
    }

    public void dump(XMLDumpable xMLDumpable) {
        Object object;
        if (this.visited.contains(xMLDumpable)) {
            this.dumpRef(xMLDumpable);
            return;
        }
        this.visited.add(xMLDumpable);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        xMLDumpable.addFields(hashMap);
        String string = xMLDumpable.getTagName();
        this.indent();
        this.ps.print('<');
        this.ps.print(string);
        this.ps.print(" id=\"");
        this.ps.print(xMLDumpable.getXMLId());
        this.ps.print('\"');
        Iterator iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            object = hashMap.get(k);
            if (object instanceof Iterator) continue;
            this.ps.print(' ');
            this.ps.print(k);
            this.ps.print("=\"");
            this.ps.print(object);
            this.ps.print('\"');
            iterator.remove();
        }
        if (!hashMap.isEmpty()) {
            this.ps.println('>');
            ++this.indent;
            for (Object k : hashMap.keySet()) {
                object = (Iterator)hashMap.get(k);
                String string2 = k.toString();
                if (!object.hasNext()) continue;
                this.indent();
                this.ps.print('<');
                this.ps.print(string2);
                this.ps.println('>');
                ++this.indent;
                while (object.hasNext()) {
                    Object e = object.next();
                    assert (e instanceof XMLDumpable);
                    this.dump((XMLDumpable)e);
                }
                --this.indent;
                this.indent();
                this.ps.print("</");
                this.ps.print(string2);
                this.ps.println('>');
            }
            --this.indent;
            this.indent();
            this.ps.print("</");
            this.ps.print(string);
            this.ps.println('>');
        } else {
            this.ps.println("/>");
        }
    }

    private void dumpRef(XMLDumpable xMLDumpable) {
        this.indent();
        this.ps.print('<');
        this.ps.print(xMLDumpable.getRefTagName());
        this.ps.print(" id=\"");
        this.ps.print(xMLDumpable.getXMLId());
        this.ps.println("\"/>");
    }

    private void indent() {
        for (int i = 0; i < this.indent; ++i) {
            this.ps.print(this.indentString);
        }
    }
}

