/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.util;

import de.unika.ipd.grgen.util.GraphDumpable;
import de.unika.ipd.grgen.util.GraphDumper;
import java.awt.Color;
import java.io.PrintStream;
import java.util.HashMap;

public class VCGDumper
implements GraphDumper {
    private PrintStream ps;
    private int currSetColor;
    private static String prefix = "n";
    private static HashMap<Color, String> colorMap = new HashMap();
    private static HashMap<Integer, String> shapeMap = new HashMap();
    private static HashMap<Integer, String> lineStyleMap = new HashMap();

    private static String escapeString(String string) {
        return string.replaceAll("\"", "\\\\\"");
    }

    public VCGDumper(PrintStream printStream) {
        this.ps = printStream;
        this.currSetColor = 32;
    }

    @Override
    public void begin() {
        this.ps.println("graph:{\nlate_edge_labels:yes\ndisplay_edge_labels:yes\nmanhattan_edges:yes\nport_sharing:no\n");
    }

    @Override
    public void finish() {
        this.ps.println("}");
        this.ps.flush();
        this.ps.close();
    }

    private String getColor(Color color) {
        String string;
        if (colorMap.containsKey(color)) {
            string = colorMap.get(color);
        } else if (this.currSetColor < 256) {
            int n = this.currSetColor++;
            string = String.valueOf(n);
            colorMap.put(color, string);
            this.ps.println("colorentry " + n + ": " + color.getRed() + " " + color.getGreen() + " " + color.getBlue());
        } else {
            string = "white";
        }
        return string;
    }

    private static String getPrefix() {
        return prefix;
    }

    private String getNodeAttributes(GraphDumpable graphDumpable) {
        String string = this.getColor(graphDumpable.getNodeColor());
        Integer n = new Integer(graphDumpable.getNodeShape());
        String string2 = graphDumpable.getNodeInfo();
        if (string2 != null) {
            string2 = VCGDumper.escapeString(string2);
        }
        String string3 = VCGDumper.escapeString(graphDumpable.getNodeLabel());
        String string4 = "title:\"" + VCGDumper.getPrefix() + graphDumpable.getNodeId() + "\" label:\"" + string3 + "\"";
        if (string2 != null) {
            string4 = string4 + " info1:\"" + string2 + "\"";
        }
        string4 = string4 + " color:" + string;
        if (shapeMap.containsKey(n)) {
            string4 = string4 + " shape:" + shapeMap.get(n);
        }
        return string4;
    }

    @Override
    public void node(GraphDumpable graphDumpable) {
        this.ps.println("node:{" + this.getNodeAttributes(graphDumpable) + "}");
    }

    @Override
    public void edge(GraphDumpable graphDumpable, GraphDumpable graphDumpable2, String string, int n, Color color) {
        if (graphDumpable != null && graphDumpable2 != null) {
            String string2 = this.getColor(color);
            String string3 = "edge:{sourcename:\"" + VCGDumper.getPrefix() + graphDumpable.getNodeId() + "\" targetname:\"" + VCGDumper.getPrefix() + graphDumpable2.getNodeId() + "\"";
            if (string != null) {
                string3 = string3 + " label:\"" + VCGDumper.escapeString(string) + "\"";
            }
            string3 = string3 + " color:" + string2;
            if (n != -1) {
                string3 = string3 + " linestyle:" + lineStyleMap.get(new Integer(n));
            }
            string3 = string3 + "}";
            this.ps.println(string3);
        }
    }

    @Override
    public void edge(GraphDumpable graphDumpable, GraphDumpable graphDumpable2, String string, int n) {
        this.edge(graphDumpable, graphDumpable2, string, n, Color.BLACK);
    }

    @Override
    public void edge(GraphDumpable graphDumpable, GraphDumpable graphDumpable2, String string) {
        this.edge(graphDumpable, graphDumpable2, string, -1, Color.BLACK);
    }

    @Override
    public void edge(GraphDumpable graphDumpable, GraphDumpable graphDumpable2) {
        this.edge(graphDumpable, graphDumpable2, null, -1, Color.BLACK);
    }

    @Override
    public void beginSubgraph(GraphDumpable graphDumpable) {
        this.ps.println("graph:{" + this.getNodeAttributes(graphDumpable) + " status:clustered");
    }

    @Override
    public void beginSubgraph(String string) {
        this.ps.print("graph:{title:\"");
        this.ps.print(string);
        this.ps.println('\"');
        this.ps.print("  label:\"");
        this.ps.print(string);
        this.ps.println('\"');
        this.ps.println("  status:clustered");
    }

    @Override
    public void endSubgraph() {
        this.ps.println("}\n");
    }

    static {
        colorMap.put(Color.BLACK, "black");
        colorMap.put(Color.BLUE, "lightblue");
        colorMap.put(Color.CYAN, "cyan");
        colorMap.put(Color.GRAY, "lightgrey");
        colorMap.put(Color.DARK_GRAY, "darkgrey");
        colorMap.put(Color.MAGENTA, "magenta");
        colorMap.put(Color.ORANGE, "orange");
        colorMap.put(Color.GREEN, "green");
        colorMap.put(Color.RED, "red");
        colorMap.put(Color.PINK, "pink");
        colorMap.put(Color.YELLOW, "yellow");
        colorMap.put(Color.WHITE, "white");
        shapeMap.put(new Integer(0), "box");
        shapeMap.put(new Integer(1), "rhomb");
        shapeMap.put(new Integer(2), "ellipse");
        shapeMap.put(new Integer(3), "triangle");
        lineStyleMap.put(new Integer(0), "continuous");
        lineStyleMap.put(new Integer(1), "dashed");
        lineStyleMap.put(new Integer(2), "dotted");
    }
}

