/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.util;

import java.io.IOException;
import java.io.OutputStream;

public class MultiplexOutputStream
extends OutputStream {
    private final OutputStream[] mux = new OutputStream[32];
    private int fill = 0;

    public void addStream(OutputStream outputStream) {
        if (this.fill == this.mux.length - 1) {
            OutputStream[] outputStreamArray = new OutputStream[2 * this.fill];
            System.arraycopy(this.mux, 0, outputStreamArray, 0, this.mux.length);
        }
        this.mux[this.fill++] = outputStream;
    }

    @Override
    public void write(int n) throws IOException {
        for (int i = 0; i < this.fill; ++i) {
            this.mux[i].write(n);
        }
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        for (int i = 0; i < this.fill; ++i) {
            this.mux[i].write(byArray, n, n2);
        }
    }

    @Override
    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    @Override
    public void flush() throws IOException {
        for (int i = 0; i < this.fill; ++i) {
            this.mux[i].flush();
        }
    }

    @Override
    public void close() throws IOException {
        for (int i = 0; i < this.fill; ++i) {
            this.mux[i].close();
        }
    }
}

