/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.parser;

import de.unika.ipd.grgen.util.report.Location;

public class Coords
implements Location {
    protected static final Coords INVALID = new Coords();
    protected static final Coords BUILTIN = new Coords(0, 0, "<builtin>");
    protected int line;
    protected int column;
    protected String filename;

    public static final Coords getInvalid() {
        return INVALID;
    }

    public static final Coords getBuiltin() {
        return BUILTIN;
    }

    public Coords() {
        this(-1, -1, null);
    }

    public Coords(int n, int n2, String string) {
        this.line = n;
        this.column = n2;
        this.filename = string;
    }

    public Coords(int n, int n2) {
        this(n, n2, null);
    }

    private boolean valid() {
        return this.line != -1 && this.column != -1;
    }

    public String toString() {
        if (this.valid()) {
            return this.filename + ":" + this.line + "," + this.column;
        }
        return "nowhere";
    }

    public final String getAtCoords() {
        return " [at " + this.toString() + "]";
    }

    public final String getDeclarationCoords(boolean bl) {
        if (!this.hasLocation()) {
            return "";
        }
        if (this == Coords.getBuiltin()) {
            return "";
        }
        return " [declared " + (bl ? "implicitly " : "") + "at " + this.toString() + "]";
    }

    @Override
    public String getLocation() {
        return this.toString();
    }

    @Override
    public boolean hasLocation() {
        return this.valid();
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof Coords) {
            Coords coords = (Coords)object;
            bl = this.line == coords.line && this.column == coords.column && (this.filename == null && coords.filename == null || this.filename != null && this.filename.equals(coords.filename));
        }
        return bl;
    }

    public int hashCode() {
        return ((this.filename != null ? this.filename.hashCode() : 13) * 31 + this.line) * 31 + this.column;
    }

    public int getLine() {
        return this.line;
    }

    public int getColumn() {
        return this.column;
    }

    public String getFileName() {
        return this.filename;
    }

    public boolean comesBefore(Coords coords) {
        if (!this.valid()) {
            return false;
        }
        if (!coords.valid()) {
            return false;
        }
        if (this.getLine() < coords.getLine()) {
            return true;
        }
        return this.getLine() == coords.getLine() && this.getColumn() < coords.getColumn();
    }
}

