/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ir.type;

import de.unika.ipd.grgen.ir.Ident;
import de.unika.ipd.grgen.ir.Identifiable;
import de.unika.ipd.grgen.ir.model.type.InheritanceType;
import de.unika.ipd.grgen.ir.type.container.ArrayType;
import java.util.Comparator;

public abstract class Type
extends Identifiable {
    private static final Comparator<Type> COMPARATOR = new Comparator<Type>(){

        @Override
        public int compare(Type type, Type type2) {
            if (type.isEqual(type2)) {
                return 0;
            }
            if (type instanceof InheritanceType && type2 instanceof InheritanceType) {
                int n;
                int n2 = ((InheritanceType)type).getMaxDist();
                if (n2 < (n = ((InheritanceType)type2).getMaxDist())) {
                    return -1;
                }
                if (n2 > n) {
                    return 1;
                }
            }
            return type.getIdent().compareTo(type2.getIdent());
        }
    };

    public Type(String string, Ident ident) {
        super(string, ident);
    }

    public boolean isEqual(Type type) {
        return type == this;
    }

    protected boolean castableTo(Type type) {
        return false;
    }

    public final boolean isCastableTo(Type type) {
        return this.isEqual(type) || this.castableTo(type);
    }

    public boolean isVoid() {
        return false;
    }

    public TypeClass classify() {
        return TypeClass.IS_UNKNOWN;
    }

    static final Comparator<Type> getComparator() {
        return COMPARATOR;
    }

    @Override
    public int compareTo(Identifiable identifiable) {
        if (identifiable instanceof Type) {
            return COMPARATOR.compare(this, (Type)identifiable);
        }
        assert (false);
        return super.compareTo(identifiable);
    }

    public boolean isOrderableType() {
        if (this.classify() == TypeClass.IS_BYTE) {
            return true;
        }
        if (this.classify() == TypeClass.IS_SHORT) {
            return true;
        }
        if (this.classify() == TypeClass.IS_INTEGER) {
            return true;
        }
        if (this.classify() == TypeClass.IS_LONG) {
            return true;
        }
        if (this.classify() == TypeClass.IS_FLOAT) {
            return true;
        }
        if (this.classify() == TypeClass.IS_DOUBLE) {
            return true;
        }
        if (this.classify() == TypeClass.IS_STRING) {
            return true;
        }
        return this.classify() == TypeClass.IS_BOOLEAN;
    }

    public boolean isFilterableType() {
        if (this.isOrderableType()) {
            return true;
        }
        if (this.classify() == TypeClass.IS_NODE) {
            return true;
        }
        if (this.classify() == TypeClass.IS_EDGE) {
            return true;
        }
        return this.classify() == TypeClass.IS_INTERNAL_CLASS_OBJECT;
    }

    public boolean isArrayOfMatchType() {
        if (this.classify() != TypeClass.IS_ARRAY) {
            return false;
        }
        return ((ArrayType)this).valueType.classify() == TypeClass.IS_MATCH;
    }

    public boolean isArrayOfMatchClassType() {
        if (this.classify() != TypeClass.IS_ARRAY) {
            return false;
        }
        return ((ArrayType)this).valueType.classify() == TypeClass.IS_DEFINED_MATCH;
    }

    public void addToDigest(StringBuffer stringBuffer) {
    }

    public static enum TypeClass {
        IS_UNKNOWN,
        IS_BYTE,
        IS_SHORT,
        IS_INTEGER,
        IS_LONG,
        IS_FLOAT,
        IS_DOUBLE,
        IS_BOOLEAN,
        IS_STRING,
        IS_TYPE,
        IS_OBJECT,
        IS_SET,
        IS_MAP,
        IS_ARRAY,
        IS_DEQUE,
        IS_UNTYPED_EXEC_VAR_TYPE,
        IS_EXTERNAL_CLASS_OBJECT,
        IS_GRAPH,
        IS_MATCH,
        IS_DEFINED_MATCH,
        IS_NODE,
        IS_EDGE,
        IS_INTERNAL_CLASS_OBJECT,
        IS_INTERNAL_TRANSIENT_CLASS_OBJECT;

    }
}

