/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ir.stmt.graph;

import de.unika.ipd.grgen.ir.NeededEntities;
import de.unika.ipd.grgen.ir.pattern.IndexAccessOrdering;
import de.unika.ipd.grgen.ir.pattern.Variable;
import de.unika.ipd.grgen.ir.stmt.EvalStatement;
import java.util.Collection;
import java.util.LinkedList;

public class ForIndexAccessOrdering
extends EvalStatement {
    private Variable iterationVar;
    private IndexAccessOrdering iao;
    private Collection<EvalStatement> statements = new LinkedList<EvalStatement>();

    public ForIndexAccessOrdering(Variable variable, IndexAccessOrdering indexAccessOrdering) {
        super("for index access ordering");
        this.iterationVar = variable;
        this.iao = indexAccessOrdering;
    }

    public void addLoopedStatement(EvalStatement evalStatement) {
        this.statements.add(evalStatement);
    }

    public Variable getIterationVar() {
        return this.iterationVar;
    }

    public IndexAccessOrdering getIndexAccessOrdering() {
        return this.iao;
    }

    public Collection<EvalStatement> getLoopedStatements() {
        return this.statements;
    }

    @Override
    public void collectNeededEntities(NeededEntities neededEntities) {
        this.iao.collectNeededEntities(neededEntities);
        for (EvalStatement evalStatement : this.statements) {
            evalStatement.collectNeededEntities(neededEntities);
        }
        if (neededEntities.variables != null) {
            neededEntities.variables.remove(this.iterationVar);
        }
    }
}

