/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ir.stmt.graph;

import de.unika.ipd.grgen.ir.NeededEntities;
import de.unika.ipd.grgen.ir.pattern.IndexAccessEquality;
import de.unika.ipd.grgen.ir.pattern.Variable;
import de.unika.ipd.grgen.ir.stmt.EvalStatement;
import java.util.Collection;
import java.util.LinkedList;

public class ForIndexAccessEquality
extends EvalStatement {
    private Variable iterationVar;
    private IndexAccessEquality iae;
    private Collection<EvalStatement> statements = new LinkedList<EvalStatement>();

    public ForIndexAccessEquality(Variable variable, IndexAccessEquality indexAccessEquality) {
        super("for index access equality");
        this.iterationVar = variable;
        this.iae = indexAccessEquality;
    }

    public void addLoopedStatement(EvalStatement evalStatement) {
        this.statements.add(evalStatement);
    }

    public Variable getIterationVar() {
        return this.iterationVar;
    }

    public IndexAccessEquality getIndexAcccessEquality() {
        return this.iae;
    }

    public Collection<EvalStatement> getLoopedStatements() {
        return this.statements;
    }

    @Override
    public void collectNeededEntities(NeededEntities neededEntities) {
        this.iae.collectNeededEntities(neededEntities);
        for (EvalStatement evalStatement : this.statements) {
            evalStatement.collectNeededEntities(neededEntities);
        }
        if (neededEntities.variables != null) {
            neededEntities.variables.remove(this.iterationVar);
        }
    }
}

