/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ir.stmt;

import de.unika.ipd.grgen.ir.NeededEntities;
import de.unika.ipd.grgen.ir.expr.Expression;
import de.unika.ipd.grgen.ir.stmt.BlockNestingStatement;
import de.unika.ipd.grgen.ir.stmt.EvalStatement;
import java.util.Collection;
import java.util.LinkedList;

public class ConditionStatement
extends BlockNestingStatement {
    private Expression conditionExpr;
    private Collection<EvalStatement> falseCaseStatements = null;

    public ConditionStatement(Expression expression) {
        super("condition statement");
        this.conditionExpr = expression;
    }

    public void addFalseCaseStatement(EvalStatement evalStatement) {
        if (this.falseCaseStatements == null) {
            this.falseCaseStatements = new LinkedList<EvalStatement>();
        }
        this.falseCaseStatements.add(evalStatement);
    }

    public Expression getConditionExpr() {
        return this.conditionExpr;
    }

    public Collection<EvalStatement> getFalseCaseStatements() {
        return this.falseCaseStatements;
    }

    @Override
    public void collectNeededEntities(NeededEntities neededEntities) {
        this.conditionExpr.collectNeededEntities(neededEntities);
        for (EvalStatement evalStatement : this.statements) {
            evalStatement.collectNeededEntities(neededEntities);
        }
        if (this.falseCaseStatements != null) {
            for (EvalStatement evalStatement : this.falseCaseStatements) {
                evalStatement.collectNeededEntities(neededEntities);
            }
        }
    }
}

