/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ir.stmt;

import de.unika.ipd.grgen.ir.Entity;
import de.unika.ipd.grgen.ir.NeededEntities;
import de.unika.ipd.grgen.ir.expr.Expression;
import de.unika.ipd.grgen.ir.expr.Qualification;
import de.unika.ipd.grgen.ir.pattern.GraphEntity;
import de.unika.ipd.grgen.ir.pattern.Variable;
import de.unika.ipd.grgen.ir.stmt.EvalStatement;
import java.util.HashSet;

public class CompoundAssignment
extends EvalStatement {
    private Qualification target;
    private CompoundAssignmentType operation;
    private Expression expr;

    public CompoundAssignment(Qualification qualification, CompoundAssignmentType compoundAssignmentType, Expression expression) {
        super("compound assignment");
        this.target = qualification;
        this.operation = compoundAssignmentType;
        this.expr = expression;
    }

    public Qualification getTarget() {
        return this.target;
    }

    public Expression getExpression() {
        return this.expr;
    }

    public CompoundAssignmentType getOperation() {
        return this.operation;
    }

    @Override
    public String toString() {
        String string = this.getTarget().toString();
        string = this.operation == CompoundAssignmentType.UNION ? string + " |= " : (this.operation == CompoundAssignmentType.INTERSECTION ? string + " &= " : (this.operation == CompoundAssignmentType.WITHOUT ? string + " \\= " : (this.operation == CompoundAssignmentType.CONCATENATE ? string + " += " : string + " = ")));
        string = string + this.getExpression().toString();
        return string;
    }

    @Override
    public void collectNeededEntities(NeededEntities neededEntities) {
        Entity entity = this.target.getOwner();
        if (!CompoundAssignment.isGlobalVariable(entity)) {
            neededEntities.add((GraphEntity)entity);
        }
        HashSet<Variable> hashSet = neededEntities.variables;
        neededEntities.variables = null;
        this.target.collectNeededEntities(neededEntities);
        neededEntities.variables = hashSet;
        this.getExpression().collectNeededEntities(neededEntities);
    }

    public static enum CompoundAssignmentType {
        NONE,
        UNION,
        INTERSECTION,
        WITHOUT,
        CONCATENATE,
        ASSIGN;

    }
}

