/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ir.pattern;

import de.unika.ipd.grgen.ir.Entity;
import de.unika.ipd.grgen.ir.IR;
import de.unika.ipd.grgen.ir.pattern.Edge;
import de.unika.ipd.grgen.ir.pattern.Node;
import de.unika.ipd.grgen.ir.pattern.PatternGraphLhs;
import de.unika.ipd.grgen.ir.pattern.RetypedEdge;
import de.unika.ipd.grgen.ir.pattern.RetypedNode;
import de.unika.ipd.grgen.ir.pattern.SubpatternUsage;
import de.unika.ipd.grgen.ir.pattern.Variable;
import de.unika.ipd.grgen.util.GraphDumpable;
import de.unika.ipd.grgen.util.GraphDumpableProxy;
import de.unika.ipd.grgen.util.Walkable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

public abstract class PatternGraphBase
extends IR {
    protected final Map<Node, GraphNode> nodes;
    protected final Map<Edge, GraphEdge> edges;
    protected final Set<Variable> vars = new LinkedHashSet<Variable>();
    protected final Set<SubpatternUsage> subpatternUsages;
    protected final HashSet<Node> homToAllNodes = new HashSet();
    protected final HashSet<Edge> homToAllEdges = new HashSet();
    PatternGraphLhs directlyNestingLHSGraph;
    private String nameOfGraph;

    public PatternGraphBase(String string) {
        super("graph");
        this.nameOfGraph = string;
        this.nodes = new LinkedHashMap<Node, GraphNode>();
        this.edges = new LinkedHashMap<Edge, GraphEdge>();
        this.subpatternUsages = new LinkedHashSet<SubpatternUsage>();
    }

    protected PatternGraphBase(String string, Map<Node, GraphNode> map, Map<Edge, GraphEdge> map2, Set<SubpatternUsage> set) {
        super("graph");
        this.nameOfGraph = string;
        this.nodes = map;
        this.edges = map2;
        this.subpatternUsages = set;
    }

    public void setDirectlyNestingLHSGraph(PatternGraphLhs patternGraphLhs) {
        this.directlyNestingLHSGraph = patternGraphLhs;
    }

    public String getNameOfGraph() {
        return this.nameOfGraph;
    }

    public void setNameSuffix(String string) {
        this.setName("graph " + string);
    }

    private GraphNode getOrSetNode(Node node) {
        GraphNode graphNode;
        if (node == null) {
            return null;
        }
        if (node.isRetyped() && node.isRHSEntity()) {
            RetypedNode retypedNode = (RetypedNode)node;
            node = retypedNode.getOldNode();
            node.setRetypedNode(retypedNode, this);
            retypedNode.directlyNestingLHSGraph = this.directlyNestingLHSGraph;
        }
        if (!this.nodes.containsKey(node)) {
            graphNode = new GraphNode(node);
            this.nodes.put(node, graphNode);
        } else {
            graphNode = this.nodes.get(node);
        }
        return graphNode;
    }

    private GraphNode checkNode(Node node) {
        assert (this.nodes.containsKey(node)) : "Node must be in graph: " + node;
        return this.nodes.get(node);
    }

    public boolean hasNode(Node node) {
        return this.nodes.containsKey(node);
    }

    public Collection<Node> getNodes() {
        return Collections.unmodifiableCollection(this.nodes.keySet());
    }

    public Collection<Node> putNodes(Collection<Node> collection) {
        collection.addAll(this.nodes.keySet());
        return collection;
    }

    public void addSingleNode(Node node) {
        this.getOrSetNode(node);
    }

    public boolean isSingle(Node node) {
        GraphNode graphNode = this.checkNode(node);
        return graphNode.incoming.isEmpty() && graphNode.outgoing.isEmpty();
    }

    public void addNodeIfNotYetContained(Node node) {
        if (this.hasNode(node)) {
            return;
        }
        this.addSingleNode(node);
        this.addHomToAll(node);
    }

    public void addHomToAll(Node node) {
        this.homToAllNodes.add(node);
    }

    public GraphDumpable getLocalDumpable(Node node) {
        if (node == null) {
            return null;
        }
        return this.checkNode(node);
    }

    public int getInDegree(Node node) {
        GraphNode graphNode = this.checkNode(node);
        return graphNode.incoming.size();
    }

    public int getOutDegree(Node node) {
        GraphNode graphNode = this.checkNode(node);
        return graphNode.outgoing.size();
    }

    public Collection<Edge> getIncoming(Node node, Collection<Edge> collection) {
        GraphNode graphNode = this.checkNode(node);
        for (GraphEdge graphEdge : graphNode.incoming) {
            collection.add(graphEdge.edge);
        }
        return collection;
    }

    public Collection<? extends Edge> getIncoming(Node node) {
        return Collections.unmodifiableCollection(this.getIncoming(node, new LinkedList<Edge>()));
    }

    public Collection<Edge> getOutgoing(Node node, Collection<Edge> collection) {
        GraphNode graphNode = this.checkNode(node);
        for (GraphEdge graphEdge : graphNode.outgoing) {
            collection.add(graphEdge.edge);
        }
        return collection;
    }

    public Collection<Edge> getOutgoing(Node node) {
        return Collections.unmodifiableCollection(this.getOutgoing(node, new LinkedList<Edge>()));
    }

    public void addConnection(Node node, Edge edge, Node node2, boolean bl, boolean bl2, boolean bl3) {
        GraphNode graphNode = this.getOrSetNode(node);
        GraphNode graphNode2 = this.getOrSetNode(node2);
        edge.fixedDirection = bl;
        GraphEdge graphEdge = this.getOrSetEdge(edge);
        if (!bl2 && graphNode != null) {
            graphNode.outgoing.add(graphEdge);
        }
        if (!bl3 && graphNode2 != null) {
            graphNode2.incoming.add(graphEdge);
        }
        if (bl2) {
            edge.setRedirectedSource(node, this);
        } else {
            graphEdge.source = graphNode;
        }
        if (bl3) {
            edge.setRedirectedTarget(node2, this);
        } else {
            graphEdge.target = graphNode2;
        }
    }

    private GraphEdge getOrSetEdge(Edge edge) {
        GraphEdge graphEdge;
        if (edge.isRetyped() && edge.isRHSEntity()) {
            RetypedEdge retypedEdge = (RetypedEdge)edge;
            edge = retypedEdge.getOldEdge();
            edge.setRetypedEdge(retypedEdge, this);
            retypedEdge.directlyNestingLHSGraph = this.directlyNestingLHSGraph;
        }
        if (!this.edges.containsKey(edge)) {
            graphEdge = new GraphEdge(edge);
            this.edges.put(edge, graphEdge);
        } else {
            graphEdge = this.edges.get(edge);
        }
        return graphEdge;
    }

    private GraphEdge checkEdge(Edge edge) {
        assert (this.edges.containsKey(edge)) : "Edge must be in graph: " + edge;
        return this.edges.get(edge);
    }

    public boolean hasEdge(Edge edge) {
        return this.edges.containsKey(edge);
    }

    public Collection<Edge> getEdges() {
        return Collections.unmodifiableCollection(this.edges.keySet());
    }

    public Collection<Edge> putEdges(Collection<Edge> collection) {
        collection.addAll(this.edges.keySet());
        return collection;
    }

    public void addSingleEdge(Edge edge) {
        this.getOrSetEdge(edge);
    }

    public void addEdgeIfNotYetContained(Edge edge) {
        if (this.hasEdge(edge)) {
            return;
        }
        this.addSingleEdge(edge);
        this.addHomToAll(edge);
    }

    public void addHomToAll(Edge edge) {
        this.homToAllEdges.add(edge);
    }

    public GraphDumpable getLocalDumpable(Edge edge) {
        return this.checkEdge(edge);
    }

    public Node getSource(Edge edge) {
        GraphEdge graphEdge = this.checkEdge(edge);
        return graphEdge.source != null ? graphEdge.source.node : null;
    }

    public Node getTarget(Edge edge) {
        GraphEdge graphEdge = this.checkEdge(edge);
        return graphEdge.target != null ? graphEdge.target.node : null;
    }

    public void addVariable(Variable variable) {
        this.vars.add(variable);
    }

    public Collection<Variable> getVars() {
        return Collections.unmodifiableCollection(this.vars);
    }

    public boolean hasVar(Variable variable) {
        return this.vars.contains(variable);
    }

    public boolean hasSubpatternUsage(SubpatternUsage subpatternUsage) {
        return this.subpatternUsages.contains(subpatternUsage);
    }

    public Collection<SubpatternUsage> getSubpatternUsages() {
        return Collections.unmodifiableCollection(this.subpatternUsages);
    }

    public void addSubpatternUsage(SubpatternUsage subpatternUsage) {
        this.subpatternUsages.add(subpatternUsage);
    }

    public Entity tryGetMember(String string) {
        for (Node entity : this.nodes.keySet()) {
            if (!entity.getIdent().toString().equals(string)) continue;
            return entity;
        }
        for (Edge edge : this.edges.keySet()) {
            if (!edge.getIdent().toString().equals(string)) continue;
            return edge;
        }
        for (Variable variable : this.vars) {
            if (!variable.getIdent().toString().equals(string)) continue;
            return variable;
        }
        return null;
    }

    protected class GraphNode
    extends Node {
        private final Set<GraphEdge> outgoing;
        private final Set<GraphEdge> incoming;
        private final Node node;
        private final String nodeId;

        private GraphNode(Node node) {
            super(node.getIdent(), node.getNodeType(), node.directlyNestingLHSGraph, node.isMaybeDeleted(), node.isMaybeRetyped(), node.isDefToBeYieldedTo(), node.context);
            this.incoming = new LinkedHashSet<GraphEdge>();
            this.outgoing = new LinkedHashSet<GraphEdge>();
            this.node = node;
            this.nodeId = "g" + PatternGraphBase.super.getId() + "_" + super.getNodeId();
        }

        @Override
        public String getNodeId() {
            return this.nodeId;
        }

        @Override
        public String getNodeInfo() {
            return this.node.getNodeInfo();
        }
    }

    protected class GraphEdge
    extends Edge {
        private GraphNode source;
        private GraphNode target;
        private Edge edge;
        private final String nodeId;

        private GraphEdge(Edge edge) {
            super(edge.getIdent(), edge.getEdgeType(), edge.directlyNestingLHSGraph, edge.isMaybeDeleted(), edge.isMaybeRetyped(), edge.isDefToBeYieldedTo(), edge.context);
            this.edge = edge;
            this.nodeId = "g" + PatternGraphBase.super.getId() + "_" + super.getNodeId();
            this.fixedDirection = edge.fixedDirection;
        }

        @Override
        public String getNodeId() {
            return this.nodeId;
        }

        @Override
        public int getNodeShape() {
            return 2;
        }

        @Override
        public String getNodeInfo() {
            return this.edge.getNodeInfo();
        }
    }

    protected abstract class GraphObject
    extends GraphDumpableProxy
    implements Walkable {
        public GraphObject(GraphDumpable graphDumpable) {
            super(graphDumpable);
        }
    }
}

