/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ir.pattern;

import de.unika.ipd.grgen.ast.decl.pattern.ConstraintDeclNode;
import de.unika.ipd.grgen.ir.Entity;
import de.unika.ipd.grgen.ir.Ident;
import de.unika.ipd.grgen.ir.expr.Expression;
import de.unika.ipd.grgen.ir.model.type.InheritanceType;
import de.unika.ipd.grgen.ir.pattern.IndexAccess;
import de.unika.ipd.grgen.ir.pattern.IndexAccessOrdering;
import de.unika.ipd.grgen.ir.pattern.NameLookup;
import de.unika.ipd.grgen.ir.pattern.NameOrAttributeInitialization;
import de.unika.ipd.grgen.ir.pattern.PatternGraphBase;
import de.unika.ipd.grgen.ir.pattern.StorageAccess;
import de.unika.ipd.grgen.ir.pattern.StorageAccessIndex;
import de.unika.ipd.grgen.ir.pattern.UniqueLookup;
import de.unika.ipd.grgen.ir.type.TypeExpr;
import de.unika.ipd.grgen.util.Annotations;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

public abstract class GraphEntity
extends Entity {
    protected final InheritanceType type;
    protected final Annotations annotations;
    protected HashMap<PatternGraphBase, GraphEntity> retyped = null;
    protected GraphEntity typeof = null;
    protected ConstraintDeclNode.CopyKind copyKind = ConstraintDeclNode.CopyKind.None;
    protected InheritanceType parameterInterfaceType = null;
    public StorageAccess storageAccess = null;
    public StorageAccessIndex storageAccessIndex = null;
    public IndexAccess indexAccess = null;
    public Vector<IndexAccessOrdering> multipleIndexAccesses = new Vector();
    public NameLookup nameMapAccess = null;
    public UniqueLookup uniqueIndexAccess = null;
    protected Collection<? extends InheritanceType> constraints = Collections.emptySet();
    private boolean maybeDeleted;
    private boolean maybeRetyped;
    public Expression initialization;
    public Vector<NameOrAttributeInitialization> nameOrAttributeInitialization = new Vector();
    protected int dependencyLevel = 0;

    protected GraphEntity(String string, Ident ident, InheritanceType inheritanceType, Annotations annotations, boolean bl, boolean bl2, boolean bl3, int n) {
        super(string, ident, inheritanceType, false, bl3, n);
        this.setChildrenNames(childrenNames);
        this.type = inheritanceType;
        this.annotations = annotations;
        this.maybeDeleted = bl;
        this.maybeRetyped = bl2;
        this.context = n;
    }

    public InheritanceType getInheritanceType() {
        return this.type;
    }

    public void setTypeofCopy(GraphEntity graphEntity, ConstraintDeclNode.CopyKind copyKind) {
        this.typeof = graphEntity;
        this.copyKind = copyKind;
    }

    public void setConstraints(TypeExpr typeExpr) {
        this.constraints = typeExpr.evaluate();
    }

    @Override
    public Annotations getAnnotations() {
        return this.annotations;
    }

    public boolean isMaybeDeleted() {
        return this.maybeDeleted;
    }

    public boolean isMaybeRetyped() {
        return this.maybeRetyped;
    }

    @Override
    public void addFields(Map<String, Object> map) {
        super.addFields(map);
        map.put("valid_types", this.constraints.iterator());
        map.put("retyped", Collections.singleton(this.retyped));
        map.put("typeof", Collections.singleton(this.typeof));
    }

    @Override
    public boolean isRetyped() {
        return false;
    }

    public boolean changesType(PatternGraphBase patternGraphBase) {
        if (patternGraphBase == null) {
            return this.retyped != null;
        }
        return this.getRetypedEntity(patternGraphBase) != null;
    }

    public void setRetypedEntity(GraphEntity graphEntity, PatternGraphBase patternGraphBase) {
        if (this.retyped == null) {
            this.retyped = new HashMap();
        }
        this.retyped.put(patternGraphBase, graphEntity);
    }

    public GraphEntity getRetypedEntity(PatternGraphBase patternGraphBase) {
        if (this.retyped == null) {
            return null;
        }
        return this.retyped.get(patternGraphBase);
    }

    public GraphEntity getTypeof() {
        return this.typeof;
    }

    public ConstraintDeclNode.CopyKind getCopy() {
        return this.copyKind;
    }

    public boolean inheritsType() {
        return this.typeof != null;
    }

    public void setParameterInterfaceType(InheritanceType inheritanceType) {
        this.parameterInterfaceType = inheritanceType;
    }

    public InheritanceType getParameterInterfaceType() {
        return this.parameterInterfaceType;
    }

    public void setStorage(StorageAccess storageAccess) {
        this.storageAccess = storageAccess;
    }

    public void setStorageIndex(StorageAccessIndex storageAccessIndex) {
        this.storageAccessIndex = storageAccessIndex;
    }

    public void setIndex(IndexAccess indexAccess) {
        this.indexAccess = indexAccess;
    }

    public void addIndex(IndexAccessOrdering indexAccessOrdering) {
        this.multipleIndexAccesses.add(indexAccessOrdering);
    }

    public void setNameMapAccess(NameLookup nameLookup) {
        this.nameMapAccess = nameLookup;
    }

    public void setUniqueIndexAccess(UniqueLookup uniqueLookup) {
        this.uniqueIndexAccess = uniqueLookup;
    }

    public void setInitialization(Expression expression) {
        this.initialization = expression;
    }

    public void addNameOrAttributeInitialization(NameOrAttributeInitialization nameOrAttributeInitialization) {
        this.nameOrAttributeInitialization.add(nameOrAttributeInitialization);
    }

    public boolean hasNameInitialization() {
        for (NameOrAttributeInitialization nameOrAttributeInitialization : this.nameOrAttributeInitialization) {
            if (nameOrAttributeInitialization.attribute != null) continue;
            return true;
        }
        return false;
    }

    public NameOrAttributeInitialization getNameInitialization() {
        for (NameOrAttributeInitialization nameOrAttributeInitialization : this.nameOrAttributeInitialization) {
            if (nameOrAttributeInitialization.attribute != null) continue;
            return nameOrAttributeInitialization;
        }
        return null;
    }

    public boolean hasAttributeInitialization() {
        for (NameOrAttributeInitialization nameOrAttributeInitialization : this.nameOrAttributeInitialization) {
            if (nameOrAttributeInitialization.attribute == null) continue;
            return true;
        }
        return false;
    }

    public void incrementDependencyLevel() {
        ++this.dependencyLevel;
    }

    public int getDependencyLevel() {
        return this.dependencyLevel;
    }

    public final Collection<InheritanceType> getConstraints() {
        return Collections.unmodifiableCollection(this.constraints);
    }

    @Override
    public String getNodeInfo() {
        return super.getNodeInfo() + "\nconstraints: " + this.getConstraints();
    }
}

