/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ir.model.type;

import de.unika.ipd.grgen.ir.Constructor;
import de.unika.ipd.grgen.ir.Entity;
import de.unika.ipd.grgen.ir.Ident;
import de.unika.ipd.grgen.ir.executable.FunctionMethod;
import de.unika.ipd.grgen.ir.executable.ProcedureMethod;
import de.unika.ipd.grgen.ir.expr.array.ArrayInit;
import de.unika.ipd.grgen.ir.expr.deque.DequeInit;
import de.unika.ipd.grgen.ir.expr.map.MapInit;
import de.unika.ipd.grgen.ir.expr.set.SetInit;
import de.unika.ipd.grgen.ir.model.MemberInit;
import de.unika.ipd.grgen.ir.type.CompoundType;
import de.unika.ipd.grgen.ir.type.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class InheritanceType
extends CompoundType {
    public static final int ABSTRACT = 1;
    public static final int CONST = 2;
    private static int nextTypeID = 0;
    private static ArrayList<InheritanceType> typesByID = new ArrayList();
    private int typeID;
    private int inheritanceTypeID;
    private int maxDist = -1;
    private final Set<InheritanceType> directSuperTypes = new LinkedHashSet<InheritanceType>();
    private final Set<InheritanceType> directSubTypes = new LinkedHashSet<InheritanceType>();
    private Set<InheritanceType> allSuperTypes = null;
    private Set<InheritanceType> allSubTypes = null;
    private List<Constructor> constructors = new LinkedList<Constructor>();
    private List<MemberInit> memberInitializers = new LinkedList<MemberInit>();
    private List<MapInit> mapInitializers = new LinkedList<MapInit>();
    private List<SetInit> setInitializers = new LinkedList<SetInit>();
    private List<ArrayInit> arrayInitializers = new LinkedList<ArrayInit>();
    private List<DequeInit> dequeInitializers = new LinkedList<DequeInit>();
    private Map<String, Entity> allMembers = null;
    private Map<String, FunctionMethod> allFunctionMethods = null;
    private Map<String, ProcedureMethod> allProcedureMethods = null;
    private Map<Entity, Entity> overridingMembers = null;
    private final int modifiers;
    private String externalName = null;

    protected InheritanceType(String string, Ident ident, int n, String string2) {
        super(string, ident);
        this.modifiers = n;
        this.externalName = string2;
        this.typeID = nextTypeID++;
        typesByID.add(this);
    }

    public int getTypeID() {
        return this.typeID;
    }

    public static InheritanceType getByTypeID(int n) {
        return typesByID.get(n);
    }

    public int getInheritanceTypeID() {
        return this.inheritanceTypeID;
    }

    public void setInheritanceTypeID(int n) {
        this.inheritanceTypeID = n;
    }

    public boolean isRoot() {
        return this.directSuperTypes.isEmpty();
    }

    public void addDirectSuperType(InheritanceType inheritanceType) {
        assert (this.allSubTypes == null && this.allSuperTypes == null) : "wrong order of calls";
        if (this.allSubTypes != null || this.allSuperTypes != null) {
            error.error(inheritanceType.getIdent().getCoords(), "A container in a type is not allowed to reference a subtype.");
        }
        this.directSuperTypes.add(inheritanceType);
        inheritanceType.directSubTypes.add(this);
    }

    public Set<InheritanceType> getDirectSuperTypes() {
        return Collections.unmodifiableSet(this.directSuperTypes);
    }

    public Set<InheritanceType> getAllSuperTypes() {
        if (this.allSuperTypes == null) {
            this.allSuperTypes = new LinkedHashSet<InheritanceType>();
            for (InheritanceType inheritanceType : this.directSuperTypes) {
                this.allSuperTypes.addAll(inheritanceType.getAllSuperTypes());
                this.allSuperTypes.add(inheritanceType);
            }
        }
        return Collections.unmodifiableSet(this.allSuperTypes);
    }

    public Set<InheritanceType> getAllSubTypes() {
        if (this.allSubTypes == null) {
            this.allSubTypes = new LinkedHashSet<InheritanceType>();
            this.allSubTypes.add(this);
            for (InheritanceType inheritanceType : this.directSubTypes) {
                this.allSubTypes.addAll(inheritanceType.getAllSubTypes());
                this.allSubTypes.add(inheritanceType);
            }
        }
        return Collections.unmodifiableSet(this.allSubTypes);
    }

    public Set<InheritanceType> getDirectSubTypes() {
        return Collections.unmodifiableSet(this.directSubTypes);
    }

    private void addMembers(InheritanceType inheritanceType) {
        for (Entity entity : inheritanceType.getMembers()) {
            String string = entity.getIdent().toString();
            Entity entity2 = this.allMembers.get(string);
            if (entity2 != null) {
                if (entity2.getType().isVoid()) {
                    this.overridingMembers.put(entity, entity2);
                } else {
                    Type type = entity.getOwner();
                    Type type2 = entity2.getOwner();
                    String string2 = type2.getIdent().getCoords().getDeclarationCoords(false);
                    error.error(entity.getIdent().getCoords(), "The " + entity + " of " + type + " is already defined. It is also declared in " + type2 + string2 + ".");
                }
            }
            this.allMembers.put(string, entity);
        }
    }

    private void addFunctionMethods(InheritanceType inheritanceType) {
        for (FunctionMethod functionMethod : inheritanceType.getFunctionMethods()) {
            String string = functionMethod.getIdent().toString();
            this.allFunctionMethods.put(string, functionMethod);
        }
    }

    private void addProcedureMethods(InheritanceType inheritanceType) {
        for (ProcedureMethod procedureMethod : inheritanceType.getProcedureMethods()) {
            String string = procedureMethod.getIdent().toString();
            this.allProcedureMethods.put(string, procedureMethod);
        }
    }

    public Collection<Entity> getAllMembers() {
        if (this.allMembers == null) {
            this.allMembers = new LinkedHashMap<String, Entity>();
            this.overridingMembers = new LinkedHashMap<Entity, Entity>();
            for (InheritanceType inheritanceType : this.getAllSuperTypes()) {
                this.addMembers(inheritanceType);
            }
            this.addMembers(this);
        }
        return this.allMembers.values();
    }

    public Collection<FunctionMethod> getAllFunctionMethods() {
        if (this.allFunctionMethods == null) {
            this.allFunctionMethods = new LinkedHashMap<String, FunctionMethod>();
            for (InheritanceType inheritanceType : this.getAllSuperTypes()) {
                this.addFunctionMethods(inheritanceType);
            }
            this.addFunctionMethods(this);
        }
        return this.allFunctionMethods.values();
    }

    public Map<String, FunctionMethod> getAllFunctionMethodsByName() {
        if (this.allFunctionMethods == null) {
            this.getAllFunctionMethods();
        }
        return this.allFunctionMethods;
    }

    public Collection<ProcedureMethod> getAllProcedureMethods() {
        if (this.allProcedureMethods == null) {
            this.allProcedureMethods = new LinkedHashMap<String, ProcedureMethod>();
            for (InheritanceType inheritanceType : this.getAllSuperTypes()) {
                this.addProcedureMethods(inheritanceType);
            }
            this.addProcedureMethods(this);
        }
        return this.allProcedureMethods.values();
    }

    public Map<String, ProcedureMethod> getAllProcedureMethodsByName() {
        if (this.allProcedureMethods == null) {
            this.getAllProcedureMethods();
        }
        return this.allProcedureMethods;
    }

    public boolean superTypeDefinesFunctionMethod(FunctionMethod functionMethod) {
        for (InheritanceType inheritanceType : this.getAllSuperTypes()) {
            if (!inheritanceType.getAllFunctionMethodsByName().containsKey(functionMethod.getIdent().toString())) continue;
            return true;
        }
        return false;
    }

    public boolean superTypeDefinesProcedureMethod(ProcedureMethod procedureMethod) {
        for (InheritanceType inheritanceType : this.getAllSuperTypes()) {
            if (!inheritanceType.getAllProcedureMethodsByName().containsKey(procedureMethod.getIdent().toString())) continue;
            return true;
        }
        return false;
    }

    public Entity getOverriddenMember(Entity entity) {
        return this.overridingMembers.get(entity);
    }

    public void addConstructor(Constructor constructor) {
        this.constructors.add(constructor);
    }

    public Collection<Constructor> getConstructor() {
        return this.constructors;
    }

    public void addMemberInit(MemberInit memberInit) {
        this.memberInitializers.add(memberInit);
    }

    public Collection<MemberInit> getMemberInits() {
        return this.memberInitializers;
    }

    public void addMapInit(MapInit mapInit) {
        this.mapInitializers.add(mapInit);
    }

    public Collection<MapInit> getMapInits() {
        return this.mapInitializers;
    }

    public void addSetInit(SetInit setInit) {
        this.setInitializers.add(setInit);
    }

    public Collection<SetInit> getSetInits() {
        return this.setInitializers;
    }

    public void addArrayInit(ArrayInit arrayInit) {
        this.arrayInitializers.add(arrayInit);
    }

    public Collection<ArrayInit> getArrayInits() {
        return this.arrayInitializers;
    }

    public void addDequeInit(DequeInit dequeInit) {
        this.dequeInitializers.add(dequeInit);
    }

    public Collection<DequeInit> getDequeInits() {
        return this.dequeInitializers;
    }

    public boolean isDirectSubTypeOf(InheritanceType inheritanceType) {
        return this.directSuperTypes.contains(inheritanceType);
    }

    public boolean isDirectSuperTypeOf(InheritanceType inheritanceType) {
        return inheritanceType.isDirectSubTypeOf(this);
    }

    @Override
    protected boolean castableTo(Type type) {
        if (!(type instanceof InheritanceType)) {
            return false;
        }
        InheritanceType inheritanceType = (InheritanceType)type;
        if (this.isDirectSubTypeOf(inheritanceType)) {
            return true;
        }
        for (InheritanceType inheritanceType2 : this.getDirectSuperTypes()) {
            if (!inheritanceType2.castableTo(inheritanceType)) continue;
            return true;
        }
        return false;
    }

    public final int getMaxDist() {
        if (this.maxDist == -1) {
            this.maxDist = 0;
            for (InheritanceType inheritanceType : this.directSuperTypes) {
                int n = inheritanceType.getMaxDist() + 1;
                this.maxDist = n > this.maxDist ? n : this.maxDist;
            }
        }
        return this.maxDist;
    }

    public final String getExternalName() {
        return this.externalName;
    }

    public final boolean isAbstract() {
        return (this.modifiers & 1) != 0;
    }

    public final boolean isConst() {
        return (this.modifiers & 2) != 0;
    }

    @Override
    public void addFields(Map<String, Object> map) {
        super.addFields(map);
        map.put("inherits", this.directSuperTypes.iterator());
        map.put("const", this.isConst());
        map.put("abstract ", this.isAbstract());
    }
}

