/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ir.model.type;

import de.unika.ipd.grgen.ir.Ident;
import de.unika.ipd.grgen.ir.executable.ExternalFunctionMethod;
import de.unika.ipd.grgen.ir.executable.ExternalProcedureMethod;
import de.unika.ipd.grgen.ir.model.type.InheritanceType;
import de.unika.ipd.grgen.ir.type.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class ExternalObjectType
extends InheritanceType {
    private List<ExternalFunctionMethod> externalFunctionMethods = new LinkedList<ExternalFunctionMethod>();
    private List<ExternalProcedureMethod> externalProcedureMethods = new LinkedList<ExternalProcedureMethod>();
    private Map<String, ExternalFunctionMethod> allExternalFunctionMethods = null;
    private Map<String, ExternalProcedureMethod> allExternalProcedureMethods = null;

    public ExternalObjectType(Ident ident) {
        super("external object type", ident, 0, null);
    }

    public Collection<ExternalFunctionMethod> getExternalFunctionMethods() {
        return Collections.unmodifiableCollection(this.externalFunctionMethods);
    }

    public void addExternalFunctionMethod(ExternalFunctionMethod externalFunctionMethod) {
        this.externalFunctionMethods.add(externalFunctionMethod);
        externalFunctionMethod.setOwner(this);
    }

    public void addExternalProcedureMethod(ExternalProcedureMethod externalProcedureMethod) {
        this.externalProcedureMethods.add(externalProcedureMethod);
        externalProcedureMethod.setOwner(this);
    }

    public Collection<ExternalProcedureMethod> getExternalProcedureMethods() {
        return Collections.unmodifiableCollection(this.externalProcedureMethods);
    }

    private void addExternalFunctionMethods(ExternalObjectType externalObjectType) {
        for (ExternalFunctionMethod externalFunctionMethod : externalObjectType.getExternalFunctionMethods()) {
            String string = externalFunctionMethod.getIdent().toString();
            this.allExternalFunctionMethods.put(string, externalFunctionMethod);
        }
    }

    private void addExternalProcedureMethods(ExternalObjectType externalObjectType) {
        for (ExternalProcedureMethod externalProcedureMethod : externalObjectType.getExternalProcedureMethods()) {
            String string = externalProcedureMethod.getIdent().toString();
            this.allExternalProcedureMethods.put(string, externalProcedureMethod);
        }
    }

    public Collection<ExternalFunctionMethod> getAllExternalFunctionMethods() {
        if (this.allExternalFunctionMethods == null) {
            this.allExternalFunctionMethods = new LinkedHashMap<String, ExternalFunctionMethod>();
            for (InheritanceType inheritanceType : this.getAllSuperTypes()) {
                this.addExternalFunctionMethods((ExternalObjectType)inheritanceType);
            }
            this.addExternalFunctionMethods(this);
        }
        return this.allExternalFunctionMethods.values();
    }

    public Collection<ExternalProcedureMethod> getAllExternalProcedureMethods() {
        if (this.allExternalProcedureMethods == null) {
            this.allExternalProcedureMethods = new LinkedHashMap<String, ExternalProcedureMethod>();
            for (InheritanceType inheritanceType : this.getAllSuperTypes()) {
                this.addExternalProcedureMethods((ExternalObjectType)inheritanceType);
            }
            this.addExternalProcedureMethods(this);
        }
        return this.allExternalProcedureMethods.values();
    }

    @Override
    public Type.TypeClass classify() {
        return Type.TypeClass.IS_EXTERNAL_CLASS_OBJECT;
    }
}

