/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ir.model.type;

import de.unika.ipd.grgen.ir.ContainedInPackage;
import de.unika.ipd.grgen.ir.Ident;
import de.unika.ipd.grgen.ir.Identifiable;
import de.unika.ipd.grgen.ir.model.EnumItem;
import de.unika.ipd.grgen.ir.type.Type;
import de.unika.ipd.grgen.ir.type.basic.PrimitiveType;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class EnumType
extends PrimitiveType
implements ContainedInPackage {
    private String packageContainedIn;
    private final List<EnumItem> items = new LinkedList<EnumItem>();

    public EnumType(Ident ident) {
        super("enum type", ident);
    }

    public void addItem(EnumItem enumItem) {
        this.items.add(enumItem);
    }

    public List<EnumItem> getItems() {
        return Collections.unmodifiableList(this.items);
    }

    @Override
    public Type.TypeClass classify() {
        return Type.TypeClass.IS_INTEGER;
    }

    @Override
    public String getPackageContainedIn() {
        return this.packageContainedIn;
    }

    public void setPackageContainedIn(String string) {
        this.packageContainedIn = string;
    }

    @Override
    protected void canonicalizeLocal() {
        Collections.sort(this.items, Identifiable.COMPARATOR);
    }

    @Override
    public void addToDigest(StringBuffer stringBuffer) {
        stringBuffer.append(this);
        stringBuffer.append('[');
        int n = 0;
        for (EnumItem enumItem : this.items) {
            if (n > 0) {
                stringBuffer.append(',');
            }
            stringBuffer.append(enumItem);
            ++n;
        }
        stringBuffer.append(']');
    }
}

