/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ir.model.type;

import de.unika.ipd.grgen.ir.ContainedInPackage;
import de.unika.ipd.grgen.ir.Ident;
import de.unika.ipd.grgen.ir.model.ConnAssert;
import de.unika.ipd.grgen.ir.model.type.InheritanceType;
import de.unika.ipd.grgen.ir.type.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class EdgeType
extends InheritanceType
implements ContainedInPackage {
    private String packageContainedIn;
    private final List<ConnAssert> connectionAsserts = new LinkedList<ConnAssert>();
    protected Directedness directedness;

    public EdgeType(Ident ident, int n, String string) {
        super("edge type", ident, n, string);
    }

    public Directedness getDirectedness() {
        return this.directedness;
    }

    public void setDirectedness(Directedness directedness) {
        this.directedness = directedness;
    }

    public void canonicalizeConnectionAsserts() {
        Collections.sort(this.connectionAsserts, new Comparator<ConnAssert>(){

            @Override
            public int compare(ConnAssert connAssert, ConnAssert connAssert2) {
                return connAssert.compareTo(connAssert2);
            }
        });
    }

    public void addConnAssert(ConnAssert connAssert) {
        this.connectionAsserts.add(connAssert);
    }

    public Collection<ConnAssert> getConnAsserts() {
        return Collections.unmodifiableCollection(this.connectionAsserts);
    }

    @Override
    public void addFields(Map<String, Object> map) {
        super.addFields(map);
        map.put("conn_asserts", this.connectionAsserts.iterator());
    }

    @Override
    public void addToDigest(StringBuffer stringBuffer) {
        super.addToDigest(stringBuffer);
        stringBuffer.append('[');
        int n = 0;
        for (ConnAssert connAssert : this.connectionAsserts) {
            if (n > 0) {
                stringBuffer.append(',');
            }
            stringBuffer.append(connAssert.toString());
            ++n;
        }
        stringBuffer.append(']');
    }

    @Override
    public Type.TypeClass classify() {
        return Type.TypeClass.IS_EDGE;
    }

    @Override
    public String getPackageContainedIn() {
        return this.packageContainedIn;
    }

    public void setPackageContainedIn(String string) {
        this.packageContainedIn = string;
    }

    public static enum Directedness {
        Arbitrary,
        Directed,
        Undirected;

    }
}

