/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ir.expr.set;

import de.unika.ipd.grgen.ir.Entity;
import de.unika.ipd.grgen.ir.NeededEntities;
import de.unika.ipd.grgen.ir.expr.Expression;
import de.unika.ipd.grgen.ir.type.container.SetType;
import java.util.Collection;

public class SetInit
extends Expression {
    private Collection<Expression> setItems;
    private Entity member;
    private SetType setType;
    private boolean isConst;

    public SetInit(Collection<Expression> collection, Entity entity, SetType setType, boolean bl) {
        super("set init", entity != null ? entity.getType() : setType);
        this.setItems = collection;
        this.member = entity;
        this.setType = setType;
        this.isConst = bl;
    }

    @Override
    public void collectNeededEntities(NeededEntities neededEntities) {
        neededEntities.add(this);
        for (Expression expression : this.setItems) {
            expression.collectNeededEntities(neededEntities);
        }
    }

    public Collection<Expression> getSetItems() {
        return this.setItems;
    }

    public void setMember(Entity entity) {
        assert (this.member == null && entity != null);
        this.member = entity;
    }

    public Entity getMember() {
        return this.member;
    }

    public SetType getSetType() {
        return this.setType;
    }

    public void forceNotConstant() {
        this.isConst = false;
    }

    public boolean isConstant() {
        return this.isConst;
    }

    public String getAnonymousSetName() {
        return "anonymous_set_" + this.getId();
    }
}

