/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ir.expr.map;

import de.unika.ipd.grgen.ir.Entity;
import de.unika.ipd.grgen.ir.NeededEntities;
import de.unika.ipd.grgen.ir.expr.Expression;
import de.unika.ipd.grgen.ir.expr.ExpressionPair;
import de.unika.ipd.grgen.ir.type.container.MapType;
import java.util.Collection;

public class MapInit
extends Expression {
    private Collection<ExpressionPair> mapItems;
    private Entity member;
    private MapType mapType;
    private boolean isConst;

    public MapInit(Collection<ExpressionPair> collection, Entity entity, MapType mapType, boolean bl) {
        super("map init", entity != null ? entity.getType() : mapType);
        this.mapItems = collection;
        this.member = entity;
        this.mapType = mapType;
        this.isConst = bl;
    }

    @Override
    public void collectNeededEntities(NeededEntities neededEntities) {
        neededEntities.add(this);
        for (ExpressionPair expressionPair : this.mapItems) {
            expressionPair.collectNeededEntities(neededEntities);
        }
    }

    public Collection<ExpressionPair> getMapItems() {
        return this.mapItems;
    }

    public void setMember(Entity entity) {
        assert (this.member == null && entity != null);
        this.member = entity;
    }

    public Entity getMember() {
        return this.member;
    }

    public MapType getMapType() {
        return this.mapType;
    }

    public void forceNotConstant() {
        this.isConst = false;
    }

    public boolean isConstant() {
        return this.isConst;
    }

    public String getAnonymousMapName() {
        return "anonymous_map_" + this.getId();
    }
}

