/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ir.expr;

import de.unika.ipd.grgen.ir.Entity;
import de.unika.ipd.grgen.ir.NeededEntities;
import de.unika.ipd.grgen.ir.expr.Expression;
import de.unika.ipd.grgen.ir.pattern.GraphEntity;
import de.unika.ipd.grgen.ir.pattern.Variable;
import de.unika.ipd.grgen.ir.type.DefinedMatchType;
import de.unika.ipd.grgen.ir.type.MatchType;

public class Qualification
extends Expression {
    private final Entity owner;
    private final Expression ownerExpr;
    private final Entity member;

    public Qualification(Entity entity, Entity entity2) {
        super("qual", entity2.getType());
        this.owner = entity;
        this.ownerExpr = null;
        this.member = entity2;
    }

    public Qualification(Expression expression, Entity entity) {
        super("qual", entity.getType());
        this.owner = null;
        this.ownerExpr = expression;
        this.member = entity;
    }

    public Entity getOwner() {
        return this.owner;
    }

    public Expression getOwnerExpr() {
        return this.ownerExpr;
    }

    public Entity getMember() {
        return this.member;
    }

    @Override
    public String getNodeLabel() {
        return "<" + this.owner + ">.<" + this.member + ">";
    }

    @Override
    public void collectNeededEntities(NeededEntities neededEntities) {
        if (this.owner != null) {
            if (!(Qualification.isGlobalVariable(this.owner) || this.owner.getType() instanceof MatchType || this.owner.getType() instanceof DefinedMatchType)) {
                if (this.owner instanceof GraphEntity) {
                    neededEntities.addAttr((GraphEntity)this.owner, this.member);
                } else {
                    neededEntities.add((Variable)this.owner);
                }
            }
        } else {
            this.ownerExpr.collectNeededEntities(neededEntities);
        }
    }
}

