/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ir;

import de.unika.ipd.grgen.ir.IR;
import de.unika.ipd.grgen.parser.Coords;
import de.unika.ipd.grgen.parser.Scope;
import de.unika.ipd.grgen.parser.Symbol;
import de.unika.ipd.grgen.parser.SymbolTable;
import de.unika.ipd.grgen.util.Annotated;
import de.unika.ipd.grgen.util.Annotations;
import de.unika.ipd.grgen.util.EmptyAnnotations;
import java.util.HashMap;

public class Ident
extends IR
implements Comparable<Ident>,
Annotated {
    private static HashMap<String, Ident> identifiers = new HashMap();
    private final String text;
    private final SymbolTable symTab;
    private final Scope scope;
    private final Coords def;
    private final Annotations annots;
    private final int precomputedHashCode;

    private Ident(String string, SymbolTable symbolTable, Scope scope, Coords coords, Annotations annotations) {
        super("ident");
        this.text = string;
        this.scope = scope;
        this.symTab = symbolTable;
        this.def = coords;
        this.annots = annotations;
        this.precomputedHashCode = (symbolTable.getName() + ":" + string).hashCode();
    }

    private Ident(String string, Coords coords, Annotations annotations) {
        this(string, SymbolTable.getInvalid(), Scope.getInvalid(), coords, annotations);
    }

    public Ident(String string, Coords coords) {
        this(string, coords, EmptyAnnotations.get());
    }

    @Override
    public String toString() {
        return this.text;
    }

    public Coords getCoords() {
        return this.def;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof Ident) {
            Ident ident = (Ident)object;
            bl = this.text.equals(ident.text) && this.scope.equals(ident.scope);
        }
        return bl;
    }

    public static Ident get(String string, Symbol.Definition definition, Annotations annotations) {
        Ident ident;
        Coords coords = definition.getCoords();
        String string2 = string + "#" + coords.toString();
        if (identifiers.containsKey(string2)) {
            ident = identifiers.get(string2);
        } else {
            ident = new Ident(string, definition.getSymbol().getSymbolTable(), definition.getScope(), coords, annotations);
            identifiers.put(string2, ident);
        }
        return ident;
    }

    @Override
    public String getNodeInfo() {
        return super.getNodeInfo() + "\nCoords: " + this.def + "\nScope: " + this.scope.getPath();
    }

    @Override
    public String getNodeLabel() {
        return this.getName() + " " + this.text;
    }

    @Override
    public int compareTo(Ident ident) {
        return this.toString().compareTo(ident.toString());
    }

    public int hashCode() {
        return this.precomputedHashCode;
    }

    public Scope getScope() {
        return this.scope;
    }

    public SymbolTable getSymbolTable() {
        return this.symTab;
    }

    @Override
    public Annotations getAnnotations() {
        return this.annots;
    }
}

