/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.be.Csharp;

import de.unika.ipd.grgen.be.Csharp.CSharpBase;
import de.unika.ipd.grgen.ir.Entity;
import de.unika.ipd.grgen.ir.expr.Qualification;
import de.unika.ipd.grgen.ir.model.AttributeIndex;
import de.unika.ipd.grgen.ir.model.IncidenceCountIndex;
import de.unika.ipd.grgen.ir.model.Index;
import de.unika.ipd.grgen.ir.model.Model;
import de.unika.ipd.grgen.ir.model.type.NodeType;
import de.unika.ipd.grgen.ir.type.basic.BooleanType;
import de.unika.ipd.grgen.ir.type.basic.StringType;
import de.unika.ipd.grgen.util.Direction;
import de.unika.ipd.grgen.util.SourceBuilder;

public class ModelIndexGen
extends CSharpBase {
    private Model model;
    private SourceBuilder sb = null;

    public ModelIndexGen(Model model, SourceBuilder sourceBuilder, String string, String string2, String string3, String string4) {
        super(string, string2, string3, string4);
        this.model = model;
        this.sb = sourceBuilder;
    }

    void genIndexTypes() {
        for (Index index : this.model.getIndices()) {
            this.genIndexType(index);
        }
    }

    void genIndexType(Index index) {
        String string;
        String string2 = index.getIdent().toString();
        String string3 = index instanceof AttributeIndex ? this.formatAttributeType(((AttributeIndex)index).entity) : "int";
        String string4 = string = index instanceof AttributeIndex ? this.formatElementInterfaceRef(((AttributeIndex)index).type) : this.formatElementInterfaceRef(((IncidenceCountIndex)index).getStartNodeType());
        if (index instanceof AttributeIndex) {
            this.sb.appendFront("interface Index" + string2 + " : GRGEN_LIBGR.IAttributeIndex\n");
        } else if (index instanceof IncidenceCountIndex) {
            this.sb.appendFront("interface Index" + string2 + " : GRGEN_LIBGR.IIncidenceCountIndex\n");
        }
        this.sb.appendFront("{\n");
        this.sb.indent();
        this.sb.appendFront("IEnumerable<" + string + "> Lookup(" + string3 + " fromto);\n");
        this.sb.appendFront("IEnumerable<" + string + "> LookupAscending();\n");
        this.sb.appendFront("IEnumerable<" + string + "> LookupAscendingFromInclusive(" + string3 + " from);\n");
        this.sb.appendFront("IEnumerable<" + string + "> LookupAscendingFromExclusive(" + string3 + " from);\n");
        this.sb.appendFront("IEnumerable<" + string + "> LookupAscendingToInclusive(" + string3 + " to);\n");
        this.sb.appendFront("IEnumerable<" + string + "> LookupAscendingToExclusive(" + string3 + " to);\n");
        this.sb.appendFront("IEnumerable<" + string + "> LookupAscendingFromInclusiveToInclusive(" + string3 + " from, " + string3 + " to);\n");
        this.sb.appendFront("IEnumerable<" + string + "> LookupAscendingFromInclusiveToExclusive(" + string3 + " from, " + string3 + " to);\n");
        this.sb.appendFront("IEnumerable<" + string + "> LookupAscendingFromExclusiveToInclusive(" + string3 + " from, " + string3 + " to);\n");
        this.sb.appendFront("IEnumerable<" + string + "> LookupAscendingFromExclusiveToExclusive(" + string3 + " from, " + string3 + " to);\n");
        this.sb.appendFront("IEnumerable<" + string + "> LookupDescending();\n");
        this.sb.appendFront("IEnumerable<" + string + "> LookupDescendingFromInclusive(" + string3 + " from);\n");
        this.sb.appendFront("IEnumerable<" + string + "> LookupDescendingFromExclusive(" + string3 + " from);\n");
        this.sb.appendFront("IEnumerable<" + string + "> LookupDescendingToInclusive(" + string3 + " to);\n");
        this.sb.appendFront("IEnumerable<" + string + "> LookupDescendingToExclusive(" + string3 + " to);\n");
        this.sb.appendFront("IEnumerable<" + string + "> LookupDescendingFromInclusiveToInclusive(" + string3 + " from, " + string3 + " to);\n");
        this.sb.appendFront("IEnumerable<" + string + "> LookupDescendingFromInclusiveToExclusive(" + string3 + " from, " + string3 + " to);\n");
        this.sb.appendFront("IEnumerable<" + string + "> LookupDescendingFromExclusiveToInclusive(" + string3 + " from, " + string3 + " to);\n");
        this.sb.appendFront("IEnumerable<" + string + "> LookupDescendingFromExclusiveToExclusive(" + string3 + " from, " + string3 + " to);\n");
        if (index instanceof IncidenceCountIndex) {
            this.sb.appendFront("int GetIncidenceCount(" + string + " element);\n");
        }
        this.sb.unindent();
        this.sb.appendFront("}\n");
        this.sb.append("\n");
    }

    void genIndexImplementations() {
        int n = 0;
        for (Index index : this.model.getIndices()) {
            if (index instanceof AttributeIndex) {
                this.genIndexImplementation((AttributeIndex)index, n);
            } else {
                this.genIndexImplementation((IncidenceCountIndex)index, n);
            }
            ++n;
        }
    }

    void genIndexImplementation(AttributeIndex attributeIndex, int n) {
        String string = attributeIndex.getIdent().toString();
        String string2 = this.formatElementInterfaceRef(attributeIndex.type);
        String string3 = this.model.getIdent().toString() + "GraphModel";
        this.sb.appendFront("public class Index" + string + "Impl : Index" + string + "\n");
        this.sb.appendFront("{\n");
        this.sb.indent();
        this.sb.appendFront("public GRGEN_LIBGR.IndexDescription Description { get { return " + string3 + ".GetIndexDescription(" + n + "); } }\n");
        this.sb.append("\n");
        this.sb.appendFront("public int Size { get { return count; } }\n");
        this.sb.append("\n");
        this.sb.appendFront("protected class TreeNode\n");
        this.sb.appendFront("{\n");
        this.sb.indent();
        this.sb.appendFront("// search tree structure\n");
        this.sb.appendFront("public TreeNode left;\n");
        this.sb.appendFront("public TreeNode right;\n");
        this.sb.appendFront("public int level;\n");
        this.sb.append("\n");
        this.sb.appendFront("// user data\n");
        this.sb.appendFront("public " + string2 + " value;\n");
        this.sb.append("\n");
        this.sb.appendFront("// for the bottom node, operating as sentinel\n");
        this.sb.appendFront("public TreeNode()\n");
        this.sb.appendFront("{\n");
        this.sb.indent();
        this.sb.appendFront("left = this;\n");
        this.sb.appendFront("right = this;\n");
        this.sb.appendFront("level = 0;\n");
        this.sb.unindent();
        this.sb.appendFront("}\n");
        this.sb.append("\n");
        this.sb.appendFront("// for regular nodes (that are born as leaf nodes)\n");
        this.sb.appendFront("public TreeNode(" + string2 + " value, TreeNode bottom)\n");
        this.sb.appendFront("{\n");
        this.sb.indent();
        this.sb.appendFront("left = bottom;\n");
        this.sb.appendFront("right = bottom;\n");
        this.sb.appendFront("level = 1;\n");
        this.sb.append("\n");
        this.sb.appendFront("this.value = value;\n");
        this.sb.unindent();
        this.sb.appendFront("}\n");
        this.sb.append("\n");
        this.sb.appendFront("// for copy constructing from other index\n");
        this.sb.appendFront("public TreeNode(TreeNode left, TreeNode right, int level, " + string2 + " value)\n");
        this.sb.appendFront("{\n");
        this.sb.indent();
        this.sb.appendFront("this.left = left;\n");
        this.sb.appendFront("this.right = right;\n");
        this.sb.appendFront("this.level = level;\n");
        this.sb.append("\n");
        this.sb.appendFront("this.value = value;\n");
        this.sb.unindent();
        this.sb.appendFront("}\n");
        this.sb.unindent();
        this.sb.appendFront("}\n");
        this.sb.append("\n");
        this.sb.appendFront("protected TreeNode root;\n");
        this.sb.appendFront("protected TreeNode bottom;\n");
        this.sb.appendFront("protected TreeNode deleted;\n");
        this.sb.appendFront("protected TreeNode last;\n");
        this.sb.appendFront("protected int count;\n");
        this.sb.appendFront("protected int version;\n");
        this.sb.append("\n");
        this.genEqualElementEntry(attributeIndex);
        this.genEqualEntry(attributeIndex);
        this.genAscendingElementEntry(attributeIndex, false, true, false, true);
        this.genAscendingEntry(attributeIndex, false, true, false, true);
        this.genAscendingElementEntry(attributeIndex, true, true, false, true);
        this.genAscendingEntry(attributeIndex, true, true, false, true);
        this.genAscendingElementEntry(attributeIndex, true, false, false, true);
        this.genAscendingEntry(attributeIndex, true, false, false, true);
        this.genAscendingElementEntry(attributeIndex, false, true, true, true);
        this.genAscendingEntry(attributeIndex, false, true, true, true);
        this.genAscendingElementEntry(attributeIndex, false, true, true, false);
        this.genAscendingEntry(attributeIndex, false, true, true, false);
        this.genAscendingElementEntry(attributeIndex, true, true, true, true);
        this.genAscendingEntry(attributeIndex, true, true, true, true);
        this.genAscendingElementEntry(attributeIndex, true, true, true, false);
        this.genAscendingEntry(attributeIndex, true, true, true, false);
        this.genAscendingElementEntry(attributeIndex, true, false, true, true);
        this.genAscendingEntry(attributeIndex, true, false, true, true);
        this.genAscendingElementEntry(attributeIndex, true, false, true, false);
        this.genAscendingEntry(attributeIndex, true, false, true, false);
        this.genDescendingElementEntry(attributeIndex, false, true, false, true);
        this.genDescendingEntry(attributeIndex, false, true, false, true);
        this.genDescendingElementEntry(attributeIndex, true, true, false, true);
        this.genDescendingEntry(attributeIndex, true, true, false, true);
        this.genDescendingElementEntry(attributeIndex, true, false, false, true);
        this.genDescendingEntry(attributeIndex, true, false, false, true);
        this.genDescendingElementEntry(attributeIndex, false, true, true, true);
        this.genDescendingEntry(attributeIndex, false, true, true, true);
        this.genDescendingElementEntry(attributeIndex, false, true, true, false);
        this.genDescendingEntry(attributeIndex, false, true, true, false);
        this.genDescendingElementEntry(attributeIndex, true, true, true, true);
        this.genDescendingEntry(attributeIndex, true, true, true, true);
        this.genDescendingElementEntry(attributeIndex, true, true, true, false);
        this.genDescendingEntry(attributeIndex, true, true, true, false);
        this.genDescendingElementEntry(attributeIndex, true, false, true, true);
        this.genDescendingEntry(attributeIndex, true, false, true, true);
        this.genDescendingElementEntry(attributeIndex, true, false, true, false);
        this.genDescendingEntry(attributeIndex, true, false, true, false);
        this.genEqual(attributeIndex);
        this.genAscending(attributeIndex, false, true, false, true);
        this.genAscending(attributeIndex, true, true, false, true);
        this.genAscending(attributeIndex, true, false, false, true);
        this.genAscending(attributeIndex, false, true, true, true);
        this.genAscending(attributeIndex, false, true, true, false);
        this.genAscending(attributeIndex, true, true, true, true);
        this.genAscending(attributeIndex, true, true, true, false);
        this.genAscending(attributeIndex, true, false, true, true);
        this.genAscending(attributeIndex, true, false, true, false);
        this.genDescending(attributeIndex, false, true, false, true);
        this.genDescending(attributeIndex, true, true, false, true);
        this.genDescending(attributeIndex, true, false, false, true);
        this.genDescending(attributeIndex, false, true, true, true);
        this.genDescending(attributeIndex, false, true, true, false);
        this.genDescending(attributeIndex, true, true, true, true);
        this.genDescending(attributeIndex, true, true, true, false);
        this.genDescending(attributeIndex, true, false, true, true);
        this.genDescending(attributeIndex, true, false, true, false);
        this.sb.appendFront("public Index" + string + "Impl(GRGEN_LGSP.LGSPGraph graph)\n");
        this.sb.appendFront("{\n");
        this.sb.indent();
        this.sb.appendFront("this.graph = graph;\n");
        this.sb.append("\n");
        this.sb.appendFront("// initialize AA tree used to implement the index\n");
        this.sb.appendFront("bottom = new TreeNode();\n");
        this.sb.appendFront("root = bottom;\n");
        this.sb.appendFront("deleted = bottom;\n");
        this.sb.appendFront("count = 0;\n");
        this.sb.appendFront("version = 0;\n");
        this.sb.append("\n");
        this.sb.appendFront("graph.OnClearingGraph += ClearingGraph;\n");
        if (attributeIndex.type instanceof NodeType) {
            this.sb.appendFront("graph.OnNodeAdded += Added;\n");
            this.sb.appendFront("graph.OnRemovingNode += Removing;\n");
            this.sb.appendFront("graph.OnChangingNodeAttribute += ChangingAttribute;\n");
            this.sb.appendFront("graph.OnRetypingNode += Retyping;\n");
        } else {
            this.sb.appendFront("graph.OnEdgeAdded += Added;\n");
            this.sb.appendFront("graph.OnRemovingEdge += Removing;\n");
            this.sb.appendFront("graph.OnChangingEdgeAttribute += ChangingAttribute;\n");
            this.sb.appendFront("graph.OnRetypingEdge += Retyping;\n");
        }
        this.sb.unindent();
        this.sb.appendFront("}\n");
        this.sb.append("\n");
        this.sb.appendFront("public void FillAsClone(Index" + string + "Impl that, IDictionary<GRGEN_LIBGR.IGraphElement, GRGEN_LIBGR.IGraphElement> oldToNewMap)\n");
        this.sb.appendFront("{\n");
        this.sb.indent();
        this.sb.appendFront("root = FillAsClone(that.root, that.bottom, oldToNewMap);\n");
        this.sb.appendFront("count = that.count;\n");
        this.sb.unindent();
        this.sb.appendFront("}\n");
        this.sb.append("\n");
        this.sb.appendFront("protected TreeNode FillAsClone(TreeNode that, TreeNode otherBottom, IDictionary<GRGEN_LIBGR.IGraphElement, GRGEN_LIBGR.IGraphElement> oldToNewMap)\n");
        this.sb.appendFront("{\n");
        this.sb.indent();
        this.sb.appendFront("if(that == otherBottom)\n");
        this.sb.appendFrontIndented("return bottom;\n");
        this.sb.appendFront("else\n");
        this.sb.indent();
        this.sb.appendFront("return new TreeNode(\n");
        this.sb.indent();
        this.sb.appendFront("FillAsClone(that.left, otherBottom, oldToNewMap),\n");
        this.sb.appendFront("FillAsClone(that.right, otherBottom, oldToNewMap),\n");
        this.sb.appendFront("that.level,\n");
        this.sb.appendFront("(" + string2 + ")oldToNewMap[that.value]\n");
        this.sb.unindent();
        this.sb.appendFront(");\n");
        this.sb.unindent();
        this.sb.unindent();
        this.sb.appendFront("}\n");
        this.sb.append("\n");
        this.genIndexMaintainingEventHandlers(attributeIndex);
        this.genIndexAATreeBalancingInsertionDeletion(attributeIndex);
        this.sb.appendFront("private GRGEN_LGSP.LGSPGraph graph;\n");
        this.sb.unindent();
        this.sb.appendFront("}\n");
        this.sb.append("\n");
    }

    void genEqualElementEntry(Index index) {
        String string = index instanceof AttributeIndex ? this.formatAttributeType(((AttributeIndex)index).entity) : "int";
        this.sb.appendFront("public IEnumerable<GRGEN_LIBGR.IGraphElement> LookupElements(object fromto)\n");
        this.sb.appendFront("{\n");
        this.sb.indent();
        this.sb.appendFront("int versionAtIterationBegin = version;\n");
        this.sb.appendFront("foreach(GRGEN_LIBGR.IGraphElement value in Lookup(root, (" + string + ")fromto))\n");
        this.sb.appendFront("{\n");
        this.sb.indent();
        this.sb.appendFront("yield return value;\n");
        this.sb.appendFront("if(version != versionAtIterationBegin)\n");
        this.sb.appendFrontIndented("throw new InvalidOperationException(\"Index changed during enumeration\");\n");
        this.sb.unindent();
        this.sb.appendFront("}\n");
        this.sb.unindent();
        this.sb.appendFront("}\n");
        this.sb.append("\n");
    }

    void genEqualEntry(Index index) {
        String string = index instanceof AttributeIndex ? this.formatAttributeType(((AttributeIndex)index).entity) : "int";
        String string2 = index instanceof AttributeIndex ? this.formatElementInterfaceRef(((AttributeIndex)index).type) : this.formatElementInterfaceRef(((IncidenceCountIndex)index).getStartNodeType());
        this.sb.appendFront("public IEnumerable<" + string2 + "> Lookup(" + string + " fromto)\n");
        this.sb.appendFront("{\n");
        this.sb.indent();
        this.sb.appendFront("int versionAtIterationBegin = version;\n");
        this.sb.appendFront("foreach(" + string2 + " value in Lookup(root, fromto))\n");
        this.sb.appendFront("{\n");
        this.sb.indent();
        this.sb.appendFront("yield return value;\n");
        this.sb.appendFront("if(version != versionAtIterationBegin)\n");
        this.sb.appendFrontIndented("throw new InvalidOperationException(\"Index changed during enumeration\");\n");
        this.sb.unindent();
        this.sb.appendFront("}\n");
        this.sb.unindent();
        this.sb.appendFront("}\n");
        this.sb.append("\n");
    }

    void genEqual(AttributeIndex attributeIndex) {
        String string = this.formatAttributeType(attributeIndex.entity);
        String string2 = attributeIndex.entity.getIdent().toString();
        String string3 = this.formatElementInterfaceRef(attributeIndex.type);
        this.sb.appendFront("private IEnumerable<" + string3 + "> Lookup(TreeNode current, " + string + " fromto)\n");
        this.sb.appendFront("{\n");
        this.sb.indent();
        this.sb.appendFront("if(current == bottom)\n");
        this.sb.appendFrontIndented("yield break;\n");
        this.sb.append("\n");
        this.sb.appendFront("int versionAtIterationBegin = version;\n");
        this.sb.append("\n");
        this.sb.appendFront("// don't go left if the value is already lower than fromto\n");
        if (attributeIndex.entity.getType() instanceof BooleanType) {
            this.sb.appendFront("if(current.value." + string2 + ".CompareTo(fromto)>=0)\n");
        } else if (attributeIndex.entity.getType() instanceof StringType) {
            this.sb.appendFront("if(String.Compare(current.value." + string2 + ", fromto, StringComparison.InvariantCulture)>=0)\n");
        } else {
            this.sb.appendFront("if(current.value." + string2 + " >= fromto)\n");
        }
        this.sb.appendFront("{\n");
        this.sb.indent();
        this.sb.appendFront("foreach(" + string3 + " value in Lookup(current.left, fromto))\n");
        this.sb.appendFront("{\n");
        this.sb.indent();
        this.sb.appendFront("yield return value;\n");
        this.sb.appendFront("if(version != versionAtIterationBegin)\n");
        this.sb.appendFrontIndented("throw new InvalidOperationException(\"Index changed during enumeration\");\n");
        this.sb.unindent();
        this.sb.appendFront("}\n");
        this.sb.unindent();
        this.sb.appendFront("}\n");
        this.sb.append("\n");
        this.sb.appendFront("// (only) yield a value that is equal to fromto\n");
        this.sb.appendFront("if(current.value." + string2 + " == fromto)\n");
        this.sb.appendFront("{\n");
        this.sb.indent();
        this.sb.appendFront("// the value is within range.\n");
        this.sb.appendFront("yield return current.value;\n");
        this.sb.appendFront("if(version != versionAtIterationBegin)\n");
        this.sb.appendFrontIndented("throw new InvalidOperationException(\"Index changed during enumeration\");\n");
        this.sb.unindent();
        this.sb.appendFront("}\n");
        this.sb.append("\n");
        this.sb.appendFront("// don't go right if the value is already higher than fromto\n");
        if (attributeIndex.entity.getType() instanceof BooleanType) {
            this.sb.appendFront("if(current.value." + string2 + ".CompareTo(fromto)<=0)\n");
        } else if (attributeIndex.entity.getType() instanceof StringType) {
            this.sb.appendFront("if(String.Compare(current.value." + string2 + ", fromto, StringComparison.InvariantCulture)<=0)\n");
        } else {
            this.sb.appendFront("if(current.value." + string2 + " <= fromto)\n");
        }
        this.sb.appendFront("{\n");
        this.sb.indent();
        this.sb.appendFront("foreach(" + string3 + " value in Lookup(current.right, fromto))\n");
        this.sb.appendFront("{\n");
        this.sb.indent();
        this.sb.appendFront("yield return value;\n");
        this.sb.appendFront("if(version != versionAtIterationBegin)\n");
        this.sb.appendFrontIndented("throw new InvalidOperationException(\"Index changed during enumeration\");\n");
        this.sb.unindent();
        this.sb.appendFront("}\n");
        this.sb.unindent();
        this.sb.appendFront("}\n");
        this.sb.unindent();
        this.sb.appendFront("}\n");
        this.sb.append("\n");
    }

    void genAscendingElementEntry(Index index, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        String string = index instanceof AttributeIndex ? this.formatAttributeType(((AttributeIndex)index).entity) : "int";
        String string2 = "Ascending";
        if (bl) {
            string2 = string2 + "From";
            string2 = bl2 ? string2 + "Inclusive" : string2 + "Exclusive";
        }
        if (bl3) {
            string2 = string2 + "To";
            string2 = bl4 ? string2 + "Inclusive" : string2 + "Exclusive";
        }
        this.sb.appendFront("public IEnumerable<GRGEN_LIBGR.IGraphElement> LookupElements" + string2 + "(");
        if (bl) {
            this.sb.append("object from");
        }
        if (bl && bl3) {
            this.sb.append(", ");
        }
        if (bl3) {
            this.sb.append("object to");
        }
        this.sb.append(")\n");
        this.sb.appendFront("{\n");
        this.sb.indent();
        this.sb.appendFront("int versionAtIterationBegin = version;\n");
        this.sb.appendFront("foreach(GRGEN_LIBGR.IGraphElement value in Lookup" + string2 + "(root");
        if (bl) {
            this.sb.append(", (" + string + ")from");
        }
        if (bl3) {
            this.sb.append(", (" + string + ")to");
        }
        this.sb.append("))\n");
        this.sb.appendFront("{\n");
        this.sb.indent();
        this.sb.appendFront("yield return value;\n");
        this.sb.appendFront("if(version != versionAtIterationBegin)\n");
        this.sb.appendFrontIndented("throw new InvalidOperationException(\"Index changed during enumeration\");\n");
        this.sb.unindent();
        this.sb.appendFront("}\n");
        this.sb.unindent();
        this.sb.appendFront("}\n");
        this.sb.append("\n");
    }

    void genAscendingEntry(Index index, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        String string = index instanceof AttributeIndex ? this.formatAttributeType(((AttributeIndex)index).entity) : "int";
        String string2 = index instanceof AttributeIndex ? this.formatElementInterfaceRef(((AttributeIndex)index).type) : this.formatElementInterfaceRef(((IncidenceCountIndex)index).getStartNodeType());
        String string3 = "Ascending";
        if (bl) {
            string3 = string3 + "From";
            string3 = bl2 ? string3 + "Inclusive" : string3 + "Exclusive";
        }
        if (bl3) {
            string3 = string3 + "To";
            string3 = bl4 ? string3 + "Inclusive" : string3 + "Exclusive";
        }
        this.sb.appendFront("public IEnumerable<" + string2 + "> Lookup" + string3 + "(");
        if (bl) {
            this.sb.append(string + " from");
        }
        if (bl && bl3) {
            this.sb.append(", ");
        }
        if (bl3) {
            this.sb.append(string + " to");
        }
        this.sb.append(")\n");
        this.sb.appendFront("{\n");
        this.sb.indent();
        this.sb.appendFront("int versionAtIterationBegin = version;\n");
        this.sb.appendFront("foreach(" + string2 + " value in Lookup" + string3 + "(root");
        if (bl) {
            this.sb.append(", from");
        }
        if (bl3) {
            this.sb.append(", to");
        }
        this.sb.append("))\n");
        this.sb.appendFront("{\n");
        this.sb.indent();
        this.sb.appendFront("yield return value;\n");
        this.sb.appendFront("if(version != versionAtIterationBegin)\n");
        this.sb.appendFrontIndented("throw new InvalidOperationException(\"Index changed during enumeration\");\n");
        this.sb.unindent();
        this.sb.appendFront("}\n");
        this.sb.unindent();
        this.sb.appendFront("}\n");
        this.sb.append("\n");
    }

    void genAscending(AttributeIndex attributeIndex, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        String string = this.formatAttributeType(attributeIndex.entity);
        String string2 = attributeIndex.entity.getIdent().toString();
        String string3 = this.formatElementInterfaceRef(attributeIndex.type);
        String string4 = "Ascending";
        if (bl) {
            string4 = string4 + "From";
            string4 = bl2 ? string4 + "Inclusive" : string4 + "Exclusive";
        }
        if (bl3) {
            string4 = string4 + "To";
            string4 = bl4 ? string4 + "Inclusive" : string4 + "Exclusive";
        }
        this.sb.appendFront("private IEnumerable<" + string3 + "> Lookup" + string4 + "(TreeNode current");
        if (bl) {
            this.sb.append(", " + string + " from");
        }
        if (bl3) {
            this.sb.append(", " + string + " to");
        }
        this.sb.append(")\n");
        this.sb.appendFront("{\n");
        this.sb.indent();
        this.sb.appendFront("if(current == bottom)\n");
        this.sb.appendFrontIndented("yield break;\n");
        this.sb.append("\n");
        this.sb.appendFront("int versionAtIterationBegin = version;\n");
        this.sb.append("\n");
        if (bl) {
            this.sb.appendFront("// don't go left if the value is already lower than from\n");
            if (attributeIndex.entity.getType() instanceof BooleanType) {
                this.sb.appendFront("if(current.value." + string2 + ".CompareTo(from)" + (bl2 ? " >= " : " > ") + "0)\n");
            } else if (attributeIndex.entity.getType() instanceof StringType) {
                this.sb.appendFront("if(String.Compare(current.value." + string2 + ", from, StringComparison.InvariantCulture)" + (bl2 ? " >= " : " > ") + "0)\n");
            } else {
                this.sb.appendFront("if(current.value." + string2 + (bl2 ? " >= " : " > ") + "from)\n");
            }
        }
        this.sb.appendFront("{\n");
        this.sb.indent();
        this.sb.appendFront("foreach(" + string3 + " value in Lookup" + string4 + "(current.left");
        if (bl) {
            this.sb.append(", from");
        }
        if (bl3) {
            this.sb.append(", to");
        }
        this.sb.append("))\n");
        this.sb.appendFront("{\n");
        this.sb.indent();
        this.sb.appendFront("yield return value;\n");
        this.sb.appendFront("if(version != versionAtIterationBegin)\n");
        this.sb.appendFrontIndented("throw new InvalidOperationException(\"Index changed during enumeration\");\n");
        this.sb.unindent();
        this.sb.appendFront("}\n");
        this.sb.unindent();
        this.sb.appendFront("}\n");
        this.sb.append("\n");
        if (bl || bl3) {
            this.sb.appendFront("// (only) yield a value that is within bounds\n");
            this.sb.appendFront("if(");
            if (bl) {
                if (attributeIndex.entity.getType() instanceof BooleanType) {
                    this.sb.append("current.value." + string2 + ".CompareTo(from)" + (bl2 ? " >= " : " > ") + "0");
                } else if (attributeIndex.entity.getType() instanceof StringType) {
                    this.sb.append("String.Compare(current.value." + string2 + ", from, StringComparison.InvariantCulture)" + (bl2 ? " >= " : " > ") + "0");
                } else {
                    this.sb.append("current.value." + string2 + (bl2 ? " >= " : " > ") + "from");
                }
            }
            if (bl && bl3) {
                this.sb.append(" && ");
            }
            if (bl3) {
                if (attributeIndex.entity.getType() instanceof BooleanType) {
                    this.sb.append("current.value." + string2 + ".CompareTo(to)" + (bl4 ? " <= " : " < ") + "0");
                } else if (attributeIndex.entity.getType() instanceof StringType) {
                    this.sb.append("String.Compare(current.value." + string2 + ", to, StringComparison.InvariantCulture)" + (bl4 ? " <= " : " < ") + "0");
                } else {
                    this.sb.append("current.value." + string2 + (bl4 ? " <= " : " < ") + "to");
                }
            }
            this.sb.append(")\n");
        }
        this.sb.appendFront("{\n");
        this.sb.indent();
        this.sb.appendFront("// the value is within range.\n");
        this.sb.appendFront("yield return current.value;\n");
        this.sb.appendFront("if(version != versionAtIterationBegin)\n");
        this.sb.appendFrontIndented("throw new InvalidOperationException(\"Index changed during enumeration\");\n");
        this.sb.unindent();
        this.sb.appendFront("}\n");
        this.sb.append("\n");
        if (bl3) {
            this.sb.appendFront("// don't go right if the value is already higher than to\n");
            if (attributeIndex.entity.getType() instanceof BooleanType) {
                this.sb.appendFront("if(current.value." + string2 + ".CompareTo(to)" + (bl4 ? " <= " : " < ") + "0)\n");
            } else if (attributeIndex.entity.getType() instanceof StringType) {
                this.sb.appendFront("if(String.Compare(current.value." + string2 + ", to, StringComparison.InvariantCulture)" + (bl4 ? " <= " : " < ") + "0)\n");
            } else {
                this.sb.appendFront("if(current.value." + string2 + (bl4 ? " <= " : " < ") + "to)\n");
            }
        }
        this.sb.appendFront("{\n");
        this.sb.indent();
        this.sb.appendFront("foreach(" + string3 + " value in Lookup" + string4 + "(current.right");
        if (bl) {
            this.sb.append(", from");
        }
        if (bl3) {
            this.sb.append(", to");
        }
        this.sb.append("))\n");
        this.sb.appendFront("{\n");
        this.sb.indent();
        this.sb.appendFront("yield return value;\n");
        this.sb.appendFront("if(version != versionAtIterationBegin)\n");
        this.sb.appendFrontIndented("throw new InvalidOperationException(\"Index changed during enumeration\");\n");
        this.sb.unindent();
        this.sb.appendFront("}\n");
        this.sb.unindent();
        this.sb.appendFront("}\n");
        this.sb.unindent();
        this.sb.appendFront("}\n");
        this.sb.append("\n");
    }

    void genDescendingElementEntry(Index index, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        String string = index instanceof AttributeIndex ? this.formatAttributeType(((AttributeIndex)index).entity) : "int";
        String string2 = "Descending";
        if (bl) {
            string2 = string2 + "From";
            string2 = bl2 ? string2 + "Inclusive" : string2 + "Exclusive";
        }
        if (bl3) {
            string2 = string2 + "To";
            string2 = bl4 ? string2 + "Inclusive" : string2 + "Exclusive";
        }
        this.sb.appendFront("public IEnumerable<GRGEN_LIBGR.IGraphElement> LookupElements" + string2 + "(");
        if (bl) {
            this.sb.append("object from");
        }
        if (bl && bl3) {
            this.sb.append(", ");
        }
        if (bl3) {
            this.sb.append("object to");
        }
        this.sb.append(")\n");
        this.sb.appendFront("{\n");
        this.sb.indent();
        this.sb.appendFront("int versionAtIterationBegin = version;\n");
        this.sb.appendFront("foreach(GRGEN_LIBGR.IGraphElement value in Lookup" + string2 + "(root");
        if (bl) {
            this.sb.append(", (" + string + ")from");
        }
        if (bl3) {
            this.sb.append(", (" + string + ")to");
        }
        this.sb.append("))\n");
        this.sb.appendFront("{\n");
        this.sb.indent();
        this.sb.appendFront("yield return value;\n");
        this.sb.appendFront("if(version != versionAtIterationBegin)\n");
        this.sb.appendFrontIndented("throw new InvalidOperationException(\"Index changed during enumeration\");\n");
        this.sb.unindent();
        this.sb.appendFront("}\n");
        this.sb.unindent();
        this.sb.appendFront("}\n");
        this.sb.append("\n");
    }

    void genDescendingEntry(Index index, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        String string = index instanceof AttributeIndex ? this.formatAttributeType(((AttributeIndex)index).entity) : "int";
        String string2 = index instanceof AttributeIndex ? this.formatElementInterfaceRef(((AttributeIndex)index).type) : this.formatElementInterfaceRef(((IncidenceCountIndex)index).getStartNodeType());
        String string3 = "Descending";
        if (bl) {
            string3 = string3 + "From";
            string3 = bl2 ? string3 + "Inclusive" : string3 + "Exclusive";
        }
        if (bl3) {
            string3 = string3 + "To";
            string3 = bl4 ? string3 + "Inclusive" : string3 + "Exclusive";
        }
        this.sb.appendFront("public IEnumerable<" + string2 + "> Lookup" + string3 + "(");
        if (bl) {
            this.sb.append(string + " from");
        }
        if (bl && bl3) {
            this.sb.append(", ");
        }
        if (bl3) {
            this.sb.append(string + " to");
        }
        this.sb.append(")\n");
        this.sb.appendFront("{\n");
        this.sb.indent();
        this.sb.appendFront("int versionAtIterationBegin = version;\n");
        this.sb.appendFront("foreach(" + string2 + " value in Lookup" + string3 + "(root");
        if (bl) {
            this.sb.append(", from");
        }
        if (bl3) {
            this.sb.append(", to");
        }
        this.sb.append("))\n");
        this.sb.appendFront("{\n");
        this.sb.indent();
        this.sb.appendFront("yield return value;\n");
        this.sb.appendFront("if(version != versionAtIterationBegin)\n");
        this.sb.appendFrontIndented("throw new InvalidOperationException(\"Index changed during enumeration\");\n");
        this.sb.unindent();
        this.sb.appendFront("}\n");
        this.sb.unindent();
        this.sb.appendFront("}\n");
        this.sb.append("\n");
    }

    void genDescending(AttributeIndex attributeIndex, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        String string = this.formatAttributeType(attributeIndex.entity);
        String string2 = attributeIndex.entity.getIdent().toString();
        String string3 = this.formatElementInterfaceRef(attributeIndex.type);
        String string4 = "Descending";
        if (bl) {
            string4 = string4 + "From";
            string4 = bl2 ? string4 + "Inclusive" : string4 + "Exclusive";
        }
        if (bl3) {
            string4 = string4 + "To";
            string4 = bl4 ? string4 + "Inclusive" : string4 + "Exclusive";
        }
        this.sb.appendFront("private IEnumerable<" + string3 + "> Lookup" + string4 + "(TreeNode current");
        if (bl) {
            this.sb.append(", " + string + " from");
        }
        if (bl3) {
            this.sb.append(", " + string + " to");
        }
        this.sb.append(")\n");
        this.sb.appendFront("{\n");
        this.sb.indent();
        this.sb.appendFront("if(current == bottom)\n");
        this.sb.appendFrontIndented("yield break;\n");
        this.sb.append("\n");
        this.sb.appendFront("int versionAtIterationBegin = version;\n");
        this.sb.append("\n");
        if (bl) {
            this.sb.appendFront("// don't go left if the value is already lower than from\n");
            if (attributeIndex.entity.getType() instanceof BooleanType) {
                this.sb.appendFront("if(current.value." + string2 + ".CompareTo(from)" + (bl2 ? " <= " : " < ") + "0)\n");
            } else if (attributeIndex.entity.getType() instanceof StringType) {
                this.sb.appendFront("if(String.Compare(current.value." + string2 + ", from, StringComparison.InvariantCulture)" + (bl2 ? " <= " : " < ") + "0)\n");
            } else {
                this.sb.appendFront("if(current.value." + string2 + (bl2 ? " <= " : " < ") + "from)\n");
            }
        }
        this.sb.appendFront("{\n");
        this.sb.indent();
        this.sb.appendFront("foreach(" + string3 + " value in Lookup" + string4 + "(current.right");
        if (bl) {
            this.sb.append(", from");
        }
        if (bl3) {
            this.sb.append(", to");
        }
        this.sb.append("))\n");
        this.sb.appendFront("{\n");
        this.sb.indent();
        this.sb.appendFront("yield return value;\n");
        this.sb.appendFront("if(version != versionAtIterationBegin)\n");
        this.sb.appendFrontIndented("throw new InvalidOperationException(\"Index changed during enumeration\");\n");
        this.sb.unindent();
        this.sb.appendFront("}\n");
        this.sb.unindent();
        this.sb.appendFront("}\n");
        this.sb.append("\n");
        if (bl || bl3) {
            this.sb.appendFront("// (only) yield a value that is within bounds\n");
            this.sb.appendFront("if(");
            if (bl) {
                if (attributeIndex.entity.getType() instanceof BooleanType) {
                    this.sb.append("current.value." + string2 + ".CompareTo(from)" + (bl2 ? " <= " : " < ") + "0");
                } else if (attributeIndex.entity.getType() instanceof StringType) {
                    this.sb.append("String.Compare(current.value." + string2 + ", from, StringComparison.InvariantCulture)" + (bl2 ? " <= " : " < ") + "0");
                } else {
                    this.sb.append("current.value." + string2 + (bl2 ? " <= " : " < ") + "from");
                }
            }
            if (bl && bl3) {
                this.sb.append(" && ");
            }
            if (bl3) {
                if (attributeIndex.entity.getType() instanceof BooleanType) {
                    this.sb.append("current.value." + string2 + ".CompareTo(to)" + (bl4 ? " >= " : " > ") + "0");
                } else if (attributeIndex.entity.getType() instanceof StringType) {
                    this.sb.append("String.Compare(current.value." + string2 + ", to, StringComparison.InvariantCulture)" + (bl4 ? " >= " : " > ") + "0");
                } else {
                    this.sb.append("current.value." + string2 + (bl4 ? " >= " : " > ") + "to");
                }
            }
            this.sb.append(")\n");
        }
        this.sb.appendFront("{\n");
        this.sb.indent();
        this.sb.appendFront("// the value is within range.\n");
        this.sb.appendFront("yield return current.value;\n");
        this.sb.appendFront("if(version != versionAtIterationBegin)\n");
        this.sb.appendFrontIndented("throw new InvalidOperationException(\"Index changed during enumeration\");\n");
        this.sb.unindent();
        this.sb.appendFront("}\n");
        this.sb.append("\n");
        if (bl3) {
            this.sb.appendFront("// don't go right if the value is already higher than to\n");
            if (attributeIndex.entity.getType() instanceof BooleanType) {
                this.sb.appendFront("if(current.value." + string2 + ".CompareTo(to)" + (bl4 ? " >= " : " > ") + "0)\n");
            } else if (attributeIndex.entity.getType() instanceof StringType) {
                this.sb.appendFront("if(String.Compare(current.value." + string2 + ", to, StringComparison.InvariantCulture)" + (bl4 ? " >= " : " > ") + "0)\n");
            } else {
                this.sb.appendFront("if(current.value." + string2 + (bl4 ? " >= " : " > ") + "to)\n");
            }
        }
        this.sb.appendFront("{\n");
        this.sb.indent();
        this.sb.appendFront("foreach(" + string3 + " value in Lookup" + string4 + "(current.left");
        if (bl) {
            this.sb.append(", from");
        }
        if (bl3) {
            this.sb.append(", to");
        }
        this.sb.append("))\n");
        this.sb.appendFront("{\n");
        this.sb.indent();
        this.sb.appendFront("yield return value;\n");
        this.sb.appendFront("if(version != versionAtIterationBegin)\n");
        this.sb.appendFrontIndented("throw new InvalidOperationException(\"Index changed during enumeration\");\n");
        this.sb.unindent();
        this.sb.appendFront("}\n");
        this.sb.unindent();
        this.sb.appendFront("}\n");
        this.sb.unindent();
        this.sb.appendFront("}\n");
        this.sb.append("\n");
    }

    void genIndexMaintainingEventHandlers(AttributeIndex attributeIndex) {
        String string = this.formatAttributeType(attributeIndex.entity);
        String string2 = attributeIndex.entity.getIdent().toString();
        String string3 = this.formatElementInterfaceRef(attributeIndex.type);
        this.sb.appendFront("void ClearingGraph(GRGEN_LIBGR.IGraph graph)\n");
        this.sb.appendFront("{\n");
        this.sb.indent();
        this.sb.appendFront("// ReInitialize AA tree to clear the index\n");
        this.sb.appendFront("bottom = new TreeNode();\n");
        this.sb.appendFront("root = bottom;\n");
        this.sb.appendFront("deleted = bottom;\n");
        this.sb.appendFront("last = null;\n");
        this.sb.appendFront("count = 0;\n");
        this.sb.appendFront("version = 0;\n");
        this.sb.unindent();
        this.sb.appendFront("}\n\n");
        this.sb.appendFront("void Added(GRGEN_LIBGR.IGraphElement elem)\n");
        this.sb.appendFront("{\n");
        this.sb.indent();
        this.sb.appendFront("if(elem is " + string3 + ")\n");
        this.sb.appendFrontIndented("Insert(ref root, (" + string3 + ")elem, ((" + string3 + ")elem)." + string2 + ");\n");
        this.sb.unindent();
        this.sb.appendFront("}\n");
        this.sb.append("\n");
        this.sb.appendFront("void Removing(GRGEN_LIBGR.IGraphElement elem)\n");
        this.sb.appendFront("{\n");
        this.sb.indent();
        this.sb.appendFront("if(elem is " + string3 + ")\n");
        this.sb.appendFrontIndented("Delete(ref root, (" + string3 + ")elem);\n");
        this.sb.unindent();
        this.sb.appendFront("}\n");
        this.sb.append("\n");
        this.sb.appendFront("void ChangingAttribute(GRGEN_LIBGR.IGraphElement elem, GRGEN_LIBGR.AttributeType attrType, GRGEN_LIBGR.AttributeChangeType changeType, object newValue, object keyValue)\n");
        this.sb.appendFront("{\n");
        this.sb.indent();
        this.sb.appendFront("if(elem is " + string3 + " && attrType.Name==\"" + string2 + "\")\n");
        this.sb.appendFront("{\n");
        this.sb.indent();
        this.sb.appendFront("Delete(ref root, (" + string3 + ")elem);\n");
        this.sb.appendFront("Insert(ref root, (" + string3 + ")elem, (" + string + ")newValue);\n");
        this.sb.unindent();
        this.sb.appendFront("}\n");
        this.sb.unindent();
        this.sb.appendFront("}\n\n");
        this.sb.append("\n");
        this.sb.appendFront("void Retyping(GRGEN_LIBGR.IGraphElement oldElem, GRGEN_LIBGR.IGraphElement newElem)\n");
        this.sb.appendFront("{\n");
        this.sb.indent();
        this.sb.appendFront("if(oldElem is " + string3 + ")\n");
        this.sb.appendFrontIndented("Delete(ref root, (" + string3 + ")oldElem);\n");
        this.sb.appendFront("if(newElem is " + string3 + ")\n");
        this.sb.appendFrontIndented("Insert(ref root, (" + string3 + ")newElem, ((" + string3 + ")newElem)." + string2 + ");\n");
        this.sb.unindent();
        this.sb.appendFront("}\n");
        this.sb.append("\n");
    }

    void genIndexAATreeBalancingInsertionDeletion(AttributeIndex attributeIndex) {
        String string = this.formatAttributeType(attributeIndex.entity);
        String string2 = attributeIndex.entity.getIdent().toString();
        String string3 = this.formatElementInterfaceRef(attributeIndex.type);
        String string4 = attributeIndex.type instanceof NodeType ? " as GRGEN_LGSP.LGSPNodeWithUniqueId" : " as GRGEN_LGSP.LGSPEdgeWithUniqueId";
        this.sb.appendFront("private void Skew(ref TreeNode current)\n");
        this.sb.appendFront("{\n");
        this.sb.indent();
        this.sb.appendFront("if(current.level != current.left.level)\n");
        this.sb.appendFrontIndented("return;\n");
        this.sb.append("\n");
        this.sb.appendFront("// rotate right\n");
        this.sb.appendFront("TreeNode left = current.left;\n");
        this.sb.appendFront("current.left = left.right;\n");
        this.sb.appendFront("left.right = current;\n");
        this.sb.appendFront("current = left;\n");
        this.sb.unindent();
        this.sb.appendFront("}\n");
        this.sb.append("\n");
        this.sb.appendFront("private void Split(ref TreeNode current)\n");
        this.sb.appendFront("{\n");
        this.sb.indent();
        this.sb.appendFront("if(current.right.right.level != current.level)\n");
        this.sb.appendFrontIndented("return;\n");
        this.sb.append("\n");
        this.sb.appendFront("// rotate left\n");
        this.sb.appendFront("TreeNode right = current.right;\n");
        this.sb.appendFront("current.right = right.left;\n");
        this.sb.appendFront("right.left = current;\n");
        this.sb.appendFront("current = right;\n");
        this.sb.appendFront("++current.level;\n");
        this.sb.unindent();
        this.sb.appendFront("}\n");
        this.sb.append("\n");
        this.sb.appendFront("private void Insert(ref TreeNode current, " + string3 + " value, " + string + " attributeValue)\n");
        this.sb.appendFront("{\n");
        this.sb.indent();
        this.sb.appendFront("if(current == bottom)\n");
        this.sb.appendFront("{\n");
        this.sb.indent();
        this.sb.appendFront("current = new TreeNode(value, bottom);\n");
        this.sb.appendFront("++count;\n");
        this.sb.appendFront("++version;\n");
        this.sb.appendFront("return;\n");
        this.sb.unindent();
        this.sb.appendFront("}\n");
        this.sb.append("\n");
        if (attributeIndex.entity.getType() instanceof BooleanType) {
            this.sb.appendFront("if(attributeValue.CompareTo(current.value." + string2 + ")<0");
        } else if (attributeIndex.entity.getType() instanceof StringType) {
            this.sb.appendFront("if(String.Compare(attributeValue, current.value." + string2 + ", StringComparison.InvariantCulture)<0");
        } else {
            this.sb.appendFront("if(attributeValue < current.value." + string2);
        }
        this.sb.append(" || ( attributeValue == current.value." + string2 + " && (value" + string4 + ").uniqueId < (current.value" + string4 + ").uniqueId ) )\n");
        this.sb.appendFrontIndented("Insert(ref current.left, value, attributeValue);\n");
        if (attributeIndex.entity.getType() instanceof BooleanType) {
            this.sb.appendFront("else if(attributeValue.CompareTo(current.value." + string2 + ")>0");
        } else if (attributeIndex.entity.getType() instanceof StringType) {
            this.sb.appendFront("else if(String.Compare(attributeValue, current.value." + string2 + ", StringComparison.InvariantCulture)>0");
        } else {
            this.sb.appendFront("else if(attributeValue > current.value." + string2);
        }
        this.sb.append(" || ( attributeValue == current.value." + string2 + " && (value" + string4 + ").uniqueId > (current.value" + string4 + ").uniqueId ) )\n");
        this.sb.appendFrontIndented("Insert(ref current.right, value, attributeValue);\n");
        this.sb.appendFront("else\n");
        this.sb.appendFrontIndented("throw new Exception(\"Insertion of already available element\");\n");
        this.sb.append("\n");
        this.sb.appendFront("Skew(ref current);\n");
        this.sb.appendFront("Split(ref current);\n");
        this.sb.unindent();
        this.sb.appendFront("}\n");
        this.sb.append("\n");
        this.sb.appendFront("private void Delete(ref TreeNode current, " + string3 + " value)\n");
        this.sb.appendFront("{\n");
        this.sb.indent();
        this.sb.appendFront("if(current == bottom)\n");
        this.sb.appendFrontIndented("return;\n");
        this.sb.append("\n");
        this.sb.appendFront("// search down the tree (and set pointer last and deleted)\n");
        this.sb.appendFront("last = current;\n");
        if (attributeIndex.entity.getType() instanceof BooleanType) {
            this.sb.appendFront("if(value." + string2 + ".CompareTo(current.value." + string2 + ")<0");
        } else if (attributeIndex.entity.getType() instanceof StringType) {
            this.sb.appendFront("if(String.Compare(value." + string2 + ", current.value." + string2 + ", StringComparison.InvariantCulture)<0");
        } else {
            this.sb.appendFront("if(value." + string2 + " < current.value." + string2);
        }
        this.sb.append(" || ( value." + string2 + " == current.value." + string2 + " && (value" + string4 + ").uniqueId < (current.value" + string4 + ").uniqueId ) )\n");
        this.sb.appendFrontIndented("Delete(ref current.left, value);\n");
        this.sb.appendFront("else\n");
        this.sb.appendFront("{\n");
        this.sb.indent();
        this.sb.appendFront("deleted = current;\n");
        this.sb.appendFront("Delete(ref current.right, value);\n");
        this.sb.unindent();
        this.sb.appendFront("}\n");
        this.sb.append("\n");
        this.sb.appendFront("// at the bottom of the tree we remove the element (if present)\n");
        this.sb.appendFront("if(current == last && deleted != bottom && value." + string2 + " == deleted.value." + string2);
        this.sb.append(" && (value" + string4 + ").uniqueId == (deleted.value" + string4 + ").uniqueId )\n");
        this.sb.appendFront("{\n");
        this.sb.indent();
        this.sb.appendFront("deleted.value = current.value;\n");
        this.sb.appendFront("deleted = bottom;\n");
        this.sb.appendFront("current = current.right;\n");
        this.sb.appendFront("--count;\n");
        this.sb.appendFront("++version;\n");
        this.sb.unindent();
        this.sb.appendFront("}\n");
        this.sb.appendFront("// on the way back, we rebalance\n");
        this.sb.appendFront("else if(current.left.level < current.level - 1\n");
        this.sb.appendFrontIndented("|| current.right.level < current.level - 1)\n");
        this.sb.appendFront("{\n");
        this.sb.indent();
        this.sb.appendFront("--current.level;\n");
        this.sb.appendFront("if(current.right.level > current.level)\n");
        this.sb.appendFrontIndented("current.right.level = current.level;\n");
        this.sb.appendFront("Skew(ref current);\n");
        this.sb.appendFront("Skew(ref current.right);\n");
        this.sb.appendFront("Skew(ref current.right.right);\n");
        this.sb.appendFront("Split(ref current);\n");
        this.sb.appendFront("Split(ref current.right);\n");
        this.sb.unindent();
        this.sb.appendFront("}\n");
        this.sb.unindent();
        this.sb.appendFront("}\n");
        this.sb.append("\n");
    }

    void genIndexSetType() {
        String string;
        this.sb.appendFront("public class " + this.model.getIdent() + "IndexSet : GRGEN_LIBGR.IIndexSet\n");
        this.sb.appendFront("{\n");
        this.sb.indent();
        this.sb.appendFront("public " + this.model.getIdent() + "IndexSet(GRGEN_LGSP.LGSPGraph graph)\n");
        this.sb.appendFront("{\n");
        this.sb.indent();
        for (Index index : this.model.getIndices()) {
            string = index.getIdent().toString();
            this.sb.appendFront(string + " = new Index" + string + "Impl(graph);\n");
        }
        this.sb.unindent();
        this.sb.appendFront("}\n");
        this.sb.append("\n");
        for (Index index : this.model.getIndices()) {
            string = index.getIdent().toString();
            this.sb.appendFront("public Index" + string + "Impl " + string + ";\n");
        }
        this.sb.append("\n");
        this.sb.appendFront("public GRGEN_LIBGR.IIndex GetIndex(string indexName)\n");
        this.sb.appendFront("{\n");
        this.sb.indent();
        this.sb.appendFront("switch(indexName)\n");
        this.sb.appendFront("{\n");
        this.sb.indent();
        for (Index index : this.model.getIndices()) {
            string = index.getIdent().toString();
            this.sb.appendFront("case \"" + string + "\": return " + string + ";\n");
        }
        this.sb.appendFront("default: return null;\n");
        this.sb.unindent();
        this.sb.appendFront("}\n");
        this.sb.unindent();
        this.sb.appendFront("}\n");
        this.sb.append("\n");
        this.sb.appendFront("public void FillAsClone(GRGEN_LGSP.LGSPGraph originalGraph, IDictionary<GRGEN_LIBGR.IGraphElement, GRGEN_LIBGR.IGraphElement> oldToNewMap)\n");
        this.sb.appendFront("{\n");
        this.sb.indent();
        for (Index index : this.model.getIndices()) {
            string = index.getIdent().toString();
            this.sb.appendFront(string + ".FillAsClone((Index" + string + "Impl)originalGraph.Indices.GetIndex(\"" + string + "\"), oldToNewMap);\n");
        }
        this.sb.unindent();
        this.sb.appendFront("}\n");
        this.sb.unindent();
        this.sb.appendFront("}\n");
    }

    void genIndexImplementation(IncidenceCountIndex incidenceCountIndex, int n) {
        String string = incidenceCountIndex.getIdent().toString();
        String string2 = this.formatElementInterfaceRef(incidenceCountIndex.getStartNodeType());
        String string3 = this.model.getIdent().toString() + "GraphModel";
        this.sb.appendFront("public class Index" + string + "Impl : Index" + string + "\n");
        this.sb.appendFront("{\n");
        this.sb.indent();
        this.sb.appendFront("public GRGEN_LIBGR.IndexDescription Description { get { return " + string3 + ".GetIndexDescription(" + n + "); } }\n");
        this.sb.append("\n");
        this.sb.appendFront("public int Size { get { return count; } }\n");
        this.sb.append("\n");
        this.sb.appendFront("protected class TreeNode\n");
        this.sb.appendFront("{\n");
        this.sb.indent();
        this.sb.appendFront("// search tree structure\n");
        this.sb.appendFront("public TreeNode left;\n");
        this.sb.appendFront("public TreeNode right;\n");
        this.sb.appendFront("public int level;\n");
        this.sb.append("\n");
        this.sb.appendFront("// user data\n");
        this.sb.appendFront("public int key;\n");
        this.sb.appendFront("public " + string2 + " value;\n");
        this.sb.append("\n");
        this.sb.appendFront("// for the bottom node, operating as sentinel\n");
        this.sb.appendFront("public TreeNode()\n");
        this.sb.appendFront("{\n");
        this.sb.indent();
        this.sb.appendFront("left = this;\n");
        this.sb.appendFront("right = this;\n");
        this.sb.appendFront("level = 0;\n");
        this.sb.unindent();
        this.sb.appendFront("}\n");
        this.sb.append("\n");
        this.sb.appendFront("// for regular nodes (that are born as leaf nodes)\n");
        this.sb.appendFront("public TreeNode(int key, " + string2 + " value, TreeNode bottom)\n");
        this.sb.appendFront("{\n");
        this.sb.indent();
        this.sb.appendFront("left = bottom;\n");
        this.sb.appendFront("right = bottom;\n");
        this.sb.appendFront("level = 1;\n");
        this.sb.append("\n");
        this.sb.appendFront("this.key = key;\n");
        this.sb.appendFront("this.value = value;\n");
        this.sb.unindent();
        this.sb.appendFront("}\n");
        this.sb.append("\n");
        this.sb.appendFront("// for copy constructing from other index\n");
        this.sb.appendFront("public TreeNode(TreeNode left, TreeNode right, int level, int key, " + string2 + " value)\n");
        this.sb.appendFront("{\n");
        this.sb.indent();
        this.sb.appendFront("this.left = left;\n");
        this.sb.appendFront("this.right = right;\n");
        this.sb.appendFront("this.level = level;\n");
        this.sb.append("\n");
        this.sb.appendFront("this.key = key;\n");
        this.sb.appendFront("this.value = value;\n");
        this.sb.unindent();
        this.sb.appendFront("}\n");
        this.sb.unindent();
        this.sb.appendFront("}\n");
        this.sb.append("\n");
        this.sb.appendFront("protected TreeNode root;\n");
        this.sb.appendFront("protected TreeNode bottom;\n");
        this.sb.appendFront("protected TreeNode deleted;\n");
        this.sb.appendFront("protected TreeNode last;\n");
        this.sb.appendFront("protected int count;\n");
        this.sb.appendFront("protected int version;\n");
        this.sb.append("\n");
        this.sb.appendFront("protected IDictionary<" + string2 + ", int> nodeToIncidenceCount = new Dictionary<" + string2 + ", int>();\n");
        this.sb.append("\n");
        this.genEqualElementEntry(incidenceCountIndex);
        this.genEqualEntry(incidenceCountIndex);
        this.genAscendingElementEntry(incidenceCountIndex, false, true, false, true);
        this.genAscendingEntry(incidenceCountIndex, false, true, false, true);
        this.genAscendingElementEntry(incidenceCountIndex, true, true, false, true);
        this.genAscendingEntry(incidenceCountIndex, true, true, false, true);
        this.genAscendingElementEntry(incidenceCountIndex, true, false, false, true);
        this.genAscendingEntry(incidenceCountIndex, true, false, false, true);
        this.genAscendingElementEntry(incidenceCountIndex, false, true, true, true);
        this.genAscendingEntry(incidenceCountIndex, false, true, true, true);
        this.genAscendingElementEntry(incidenceCountIndex, false, true, true, false);
        this.genAscendingEntry(incidenceCountIndex, false, true, true, false);
        this.genAscendingElementEntry(incidenceCountIndex, true, true, true, true);
        this.genAscendingEntry(incidenceCountIndex, true, true, true, true);
        this.genAscendingElementEntry(incidenceCountIndex, true, true, true, false);
        this.genAscendingEntry(incidenceCountIndex, true, true, true, false);
        this.genAscendingElementEntry(incidenceCountIndex, true, false, true, true);
        this.genAscendingEntry(incidenceCountIndex, true, false, true, true);
        this.genAscendingElementEntry(incidenceCountIndex, true, false, true, false);
        this.genAscendingEntry(incidenceCountIndex, true, false, true, false);
        this.genDescendingElementEntry(incidenceCountIndex, false, true, false, true);
        this.genDescendingEntry(incidenceCountIndex, false, true, false, true);
        this.genDescendingElementEntry(incidenceCountIndex, true, true, false, true);
        this.genDescendingEntry(incidenceCountIndex, true, true, false, true);
        this.genDescendingElementEntry(incidenceCountIndex, true, false, false, true);
        this.genDescendingEntry(incidenceCountIndex, true, false, false, true);
        this.genDescendingElementEntry(incidenceCountIndex, false, true, true, true);
        this.genDescendingEntry(incidenceCountIndex, false, true, true, true);
        this.genDescendingElementEntry(incidenceCountIndex, false, true, true, false);
        this.genDescendingEntry(incidenceCountIndex, false, true, true, false);
        this.genDescendingElementEntry(incidenceCountIndex, true, true, true, true);
        this.genDescendingEntry(incidenceCountIndex, true, true, true, true);
        this.genDescendingElementEntry(incidenceCountIndex, true, true, true, false);
        this.genDescendingEntry(incidenceCountIndex, true, true, true, false);
        this.genDescendingElementEntry(incidenceCountIndex, true, false, true, true);
        this.genDescendingEntry(incidenceCountIndex, true, false, true, true);
        this.genDescendingElementEntry(incidenceCountIndex, true, false, true, false);
        this.genDescendingEntry(incidenceCountIndex, true, false, true, false);
        this.genEqual(incidenceCountIndex);
        this.genAscending(incidenceCountIndex, false, true, false, true);
        this.genAscending(incidenceCountIndex, true, true, false, true);
        this.genAscending(incidenceCountIndex, true, false, false, true);
        this.genAscending(incidenceCountIndex, false, true, true, true);
        this.genAscending(incidenceCountIndex, false, true, true, false);
        this.genAscending(incidenceCountIndex, true, true, true, true);
        this.genAscending(incidenceCountIndex, true, true, true, false);
        this.genAscending(incidenceCountIndex, true, false, true, true);
        this.genAscending(incidenceCountIndex, true, false, true, false);
        this.genDescending(incidenceCountIndex, false, true, false, true);
        this.genDescending(incidenceCountIndex, true, true, false, true);
        this.genDescending(incidenceCountIndex, true, false, false, true);
        this.genDescending(incidenceCountIndex, false, true, true, true);
        this.genDescending(incidenceCountIndex, false, true, true, false);
        this.genDescending(incidenceCountIndex, true, true, true, true);
        this.genDescending(incidenceCountIndex, true, true, true, false);
        this.genDescending(incidenceCountIndex, true, false, true, true);
        this.genDescending(incidenceCountIndex, true, false, true, false);
        this.genGetIncidenceCount(incidenceCountIndex);
        this.sb.appendFront("public Index" + string + "Impl(GRGEN_LGSP.LGSPGraph graph)\n");
        this.sb.appendFront("{\n");
        this.sb.indent();
        this.sb.appendFront("this.graph = graph;\n");
        this.sb.append("\n");
        this.sb.appendFront("// initialize AA tree used to implement the index\n");
        this.sb.appendFront("bottom = new TreeNode();\n");
        this.sb.appendFront("root = bottom;\n");
        this.sb.appendFront("deleted = bottom;\n");
        this.sb.appendFront("count = 0;\n");
        this.sb.appendFront("version = 0;\n");
        this.sb.append("\n");
        this.sb.appendFront("graph.OnClearingGraph += ClearingGraph;\n");
        this.sb.appendFront("graph.OnEdgeAdded += EdgeAdded;\n");
        this.sb.appendFront("graph.OnNodeAdded += NodeAdded;\n");
        this.sb.appendFront("graph.OnRemovingEdge += RemovingEdge;\n");
        this.sb.appendFront("graph.OnRemovingNode += RemovingNode;\n");
        this.sb.appendFront("graph.OnRetypingEdge += RetypingEdge;\n");
        this.sb.appendFront("graph.OnRetypingNode += RetypingNode;\n");
        this.sb.unindent();
        this.sb.appendFront("}\n");
        this.sb.append("\n");
        this.sb.appendFront("public void FillAsClone(Index" + string + "Impl that, IDictionary<GRGEN_LIBGR.IGraphElement, GRGEN_LIBGR.IGraphElement> oldToNewMap)\n");
        this.sb.appendFront("{\n");
        this.sb.indent();
        this.sb.appendFront("root = FillAsClone(that.root, that.bottom, oldToNewMap);\n");
        this.sb.appendFront("count = that.count;\n");
        this.sb.appendFront("foreach(KeyValuePair<" + string2 + ", int> ntic in that.nodeToIncidenceCount)\n");
        this.sb.appendFrontIndented("nodeToIncidenceCount.Add((" + string2 + ")oldToNewMap[ntic.Key], ntic.Value);\n");
        this.sb.unindent();
        this.sb.appendFront("}\n");
        this.sb.unindent();
        this.sb.append("\n");
        this.sb.appendFront("protected TreeNode FillAsClone(TreeNode that, TreeNode otherBottom, IDictionary<GRGEN_LIBGR.IGraphElement, GRGEN_LIBGR.IGraphElement> oldToNewMap)\n");
        this.sb.appendFront("{\n");
        this.sb.indent();
        this.sb.appendFront("if(that == otherBottom)\n");
        this.sb.appendFrontIndented("return bottom;\n");
        this.sb.appendFront("else\n");
        this.sb.indent();
        this.sb.appendFront("return new TreeNode(\n");
        this.sb.indent();
        this.sb.appendFront("FillAsClone(that.left, otherBottom, oldToNewMap),\n");
        this.sb.appendFront("FillAsClone(that.right, otherBottom, oldToNewMap),\n");
        this.sb.appendFront("that.level,\n");
        this.sb.appendFront("that.key,\n");
        this.sb.appendFront("(" + string2 + ")oldToNewMap[that.value]\n");
        this.sb.unindent();
        this.sb.unindent();
        this.sb.append(");\n");
        this.sb.unindent();
        this.sb.appendFront("}\n");
        this.sb.append("\n");
        this.genIndexMaintainingEventHandlers(incidenceCountIndex);
        this.genIndexAATreeBalancingInsertionDeletion(incidenceCountIndex);
        this.sb.appendFront("private GRGEN_LGSP.LGSPGraph graph;\n");
        this.sb.unindent();
        this.sb.appendFront("}\n");
        this.sb.append("\n");
    }

    void genEqual(IncidenceCountIndex incidenceCountIndex) {
        String string = this.formatElementInterfaceRef(incidenceCountIndex.getStartNodeType());
        this.sb.appendFront("private IEnumerable<" + string + "> Lookup(TreeNode current, int fromto)\n");
        this.sb.appendFront("{\n");
        this.sb.indent();
        this.sb.appendFront("if(current == bottom)\n");
        this.sb.appendFrontIndented("yield break;\n");
        this.sb.append("\n");
        this.sb.appendFront("int versionAtIterationBegin = version;\n");
        this.sb.append("\n");
        this.sb.appendFront("// don't go left if the value is already lower than fromto\n");
        this.sb.appendFront("if(current.key >= fromto)\n");
        this.sb.appendFront("{\n");
        this.sb.indent();
        this.sb.appendFront("foreach(" + string + " value in Lookup(current.left, fromto))\n");
        this.sb.appendFront("{\n");
        this.sb.indent();
        this.sb.appendFront("yield return value;\n");
        this.sb.appendFront("if(version != versionAtIterationBegin)\n");
        this.sb.appendFrontIndented("throw new InvalidOperationException(\"Index changed during enumeration\");\n");
        this.sb.unindent();
        this.sb.appendFront("}\n");
        this.sb.unindent();
        this.sb.appendFront("}\n");
        this.sb.append("\n");
        this.sb.appendFront("// (only) yield a value that is equal to fromto\n");
        this.sb.appendFront("if(current.key == fromto)\n");
        this.sb.appendFront("{\n");
        this.sb.indent();
        this.sb.appendFront("// the value is within range.\n");
        this.sb.appendFront("yield return current.value;\n");
        this.sb.appendFront("if(version != versionAtIterationBegin)\n");
        this.sb.appendFrontIndented("throw new InvalidOperationException(\"Index changed during enumeration\");\n");
        this.sb.unindent();
        this.sb.appendFront("}\n");
        this.sb.append("\n");
        this.sb.appendFront("// don't go right if the value is already higher than fromto\n");
        this.sb.appendFront("if(current.key <= fromto)\n");
        this.sb.appendFront("{\n");
        this.sb.indent();
        this.sb.appendFront("foreach(" + string + " value in Lookup(current.right, fromto))\n");
        this.sb.appendFront("{\n");
        this.sb.indent();
        this.sb.appendFront("yield return value;\n");
        this.sb.appendFront("if(version != versionAtIterationBegin)\n");
        this.sb.appendFrontIndented("throw new InvalidOperationException(\"Index changed during enumeration\");\n");
        this.sb.unindent();
        this.sb.appendFront("}\n");
        this.sb.unindent();
        this.sb.appendFront("}\n");
        this.sb.unindent();
        this.sb.appendFront("}\n");
        this.sb.append("\n");
    }

    void genAscending(IncidenceCountIndex incidenceCountIndex, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        String string = "int";
        String string2 = this.formatElementInterfaceRef(incidenceCountIndex.getStartNodeType());
        String string3 = "Ascending";
        if (bl) {
            string3 = string3 + "From";
            string3 = bl2 ? string3 + "Inclusive" : string3 + "Exclusive";
        }
        if (bl3) {
            string3 = string3 + "To";
            string3 = bl4 ? string3 + "Inclusive" : string3 + "Exclusive";
        }
        this.sb.appendFront("private IEnumerable<" + string2 + "> Lookup" + string3 + "(TreeNode current");
        if (bl) {
            this.sb.append(", " + string + " from");
        }
        if (bl3) {
            this.sb.append(", " + string + " to");
        }
        this.sb.append(")\n");
        this.sb.appendFront("{\n");
        this.sb.indent();
        this.sb.appendFront("if(current == bottom)\n");
        this.sb.appendFrontIndented("yield break;\n");
        this.sb.append("\n");
        this.sb.appendFront("int versionAtIterationBegin = version;\n");
        this.sb.append("\n");
        if (bl) {
            this.sb.appendFront("// don't go left if the value is already lower than from\n");
            this.sb.appendFront("if(current.key" + (bl2 ? " >= " : " > ") + "from)\n");
        }
        this.sb.appendFront("{\n");
        this.sb.indent();
        this.sb.appendFront("foreach(" + string2 + " value in Lookup" + string3 + "(current.left");
        if (bl) {
            this.sb.append(", from");
        }
        if (bl3) {
            this.sb.append(", to");
        }
        this.sb.append("))\n");
        this.sb.appendFront("{\n");
        this.sb.indent();
        this.sb.appendFront("yield return value;\n");
        this.sb.appendFront("if(version != versionAtIterationBegin)\n");
        this.sb.appendFrontIndented("throw new InvalidOperationException(\"Index changed during enumeration\");\n");
        this.sb.unindent();
        this.sb.appendFront("}\n");
        this.sb.unindent();
        this.sb.appendFront("}\n");
        this.sb.append("\n");
        if (bl || bl3) {
            this.sb.appendFront("// (only) yield a value that is within bounds\n");
            this.sb.appendFront("if(");
            if (bl) {
                this.sb.append("current.key" + (bl2 ? " >= " : " > ") + "from");
            }
            if (bl && bl3) {
                this.sb.append(" && ");
            }
            if (bl3) {
                this.sb.append("current.key" + (bl4 ? " <= " : " < ") + "to");
            }
            this.sb.append(")\n");
        }
        this.sb.appendFront("{\n");
        this.sb.indent();
        this.sb.appendFront("// the value is within range.\n");
        this.sb.appendFront("yield return current.value;\n");
        this.sb.appendFront("if(version != versionAtIterationBegin)\n");
        this.sb.appendFrontIndented("throw new InvalidOperationException(\"Index changed during enumeration\");\n");
        this.sb.unindent();
        this.sb.appendFront("}\n");
        this.sb.append("\n");
        if (bl3) {
            this.sb.appendFront("// don't go right if the value is already higher than to\n");
            this.sb.appendFront("if(current.key" + (bl4 ? " <= " : " < ") + "to)\n");
        }
        this.sb.appendFront("{\n");
        this.sb.indent();
        this.sb.appendFront("foreach(" + string2 + " value in Lookup" + string3 + "(current.right");
        if (bl) {
            this.sb.append(", from");
        }
        if (bl3) {
            this.sb.append(", to");
        }
        this.sb.append("))\n");
        this.sb.appendFront("{\n");
        this.sb.indent();
        this.sb.appendFront("yield return value;\n");
        this.sb.appendFront("if(version != versionAtIterationBegin)\n");
        this.sb.appendFrontIndented("throw new InvalidOperationException(\"Index changed during enumeration\");\n");
        this.sb.appendFront("}\n");
        this.sb.unindent();
        this.sb.appendFront("}\n");
        this.sb.unindent();
        this.sb.appendFront("}\n");
        this.sb.append("\n");
    }

    void genDescending(IncidenceCountIndex incidenceCountIndex, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        String string = "int";
        String string2 = this.formatElementInterfaceRef(incidenceCountIndex.getStartNodeType());
        String string3 = "Descending";
        if (bl) {
            string3 = string3 + "From";
            string3 = bl2 ? string3 + "Inclusive" : string3 + "Exclusive";
        }
        if (bl3) {
            string3 = string3 + "To";
            string3 = bl4 ? string3 + "Inclusive" : string3 + "Exclusive";
        }
        this.sb.appendFront("private IEnumerable<" + string2 + "> Lookup" + string3 + "(TreeNode current");
        if (bl) {
            this.sb.append(", " + string + " from");
        }
        if (bl3) {
            this.sb.append(", " + string + " to");
        }
        this.sb.append(")\n");
        this.sb.appendFront("{\n");
        this.sb.indent();
        this.sb.appendFront("if(current == bottom)\n");
        this.sb.appendFrontIndented("yield break;\n");
        this.sb.append("\n");
        this.sb.appendFront("int versionAtIterationBegin = version;\n");
        this.sb.append("\n");
        if (bl) {
            this.sb.appendFront("// don't go left if the value is already lower than from\n");
            this.sb.appendFront("if(current.key" + (bl2 ? " <= " : " < ") + "from)\n");
        }
        this.sb.appendFront("{\n");
        this.sb.indent();
        this.sb.appendFront("foreach(" + string2 + " value in Lookup" + string3 + "(current.right");
        if (bl) {
            this.sb.append(", from");
        }
        if (bl3) {
            this.sb.append(", to");
        }
        this.sb.append("))\n");
        this.sb.appendFront("{\n");
        this.sb.indent();
        this.sb.appendFront("yield return value;\n");
        this.sb.appendFront("if(version != versionAtIterationBegin)\n");
        this.sb.appendFrontIndented("throw new InvalidOperationException(\"Index changed during enumeration\");\n");
        this.sb.unindent();
        this.sb.appendFront("}\n");
        this.sb.unindent();
        this.sb.appendFront("}\n");
        this.sb.append("\n");
        if (bl || bl3) {
            this.sb.appendFront("// (only) yield a value that is within bounds\n");
            this.sb.appendFront("if(");
            if (bl) {
                this.sb.append("current.key" + (bl2 ? " <= " : " < ") + "from");
            }
            if (bl && bl3) {
                this.sb.append(" && ");
            }
            if (bl3) {
                this.sb.append("current.key" + (bl4 ? " >= " : " > ") + "to");
            }
            this.sb.append(")\n");
        }
        this.sb.appendFront("{\n");
        this.sb.indent();
        this.sb.appendFront("// the value is within range.\n");
        this.sb.appendFront("yield return current.value;\n");
        this.sb.appendFront("if(version != versionAtIterationBegin)\n");
        this.sb.appendFrontIndented("throw new InvalidOperationException(\"Index changed during enumeration\");\n");
        this.sb.unindent();
        this.sb.appendFront("}\n");
        this.sb.append("\n");
        if (bl3) {
            this.sb.appendFront("// don't go right if the value is already higher than to\n");
            this.sb.appendFront("if(current.key" + (bl4 ? " >= " : " > ") + "to)\n");
        }
        this.sb.appendFront("{\n");
        this.sb.indent();
        this.sb.appendFront("foreach(" + string2 + " value in Lookup" + string3 + "(current.left");
        if (bl) {
            this.sb.append(", from");
        }
        if (bl3) {
            this.sb.append(", to");
        }
        this.sb.append("))\n");
        this.sb.appendFront("{\n");
        this.sb.indent();
        this.sb.appendFront("yield return value;\n");
        this.sb.appendFront("if(version != versionAtIterationBegin)\n");
        this.sb.appendFrontIndented("throw new InvalidOperationException(\"Index changed during enumeration\");\n");
        this.sb.unindent();
        this.sb.appendFront("}\n");
        this.sb.unindent();
        this.sb.appendFront("}\n");
        this.sb.unindent();
        this.sb.appendFront("}\n");
        this.sb.append("\n");
    }

    void genGetIncidenceCount(IncidenceCountIndex incidenceCountIndex) {
        String string = this.formatElementInterfaceRef(incidenceCountIndex.getStartNodeType());
        this.sb.appendFront("public int GetIncidenceCount(GRGEN_LIBGR.IGraphElement element)\n");
        this.sb.appendFront("{\n");
        this.sb.appendFrontIndented("return GetIncidenceCount((" + string + ") element);\n");
        this.sb.appendFront("}\n");
        this.sb.append("\n");
        this.sb.appendFront("public int GetIncidenceCount(" + string + " element)\n");
        this.sb.appendFront("{\n");
        this.sb.appendFrontIndented("return nodeToIncidenceCount[element];\n");
        this.sb.appendFront("}\n");
    }

    void genCheckDump(IncidenceCountIndex incidenceCountIndex) {
        String string = this.formatElementInterfaceRef(incidenceCountIndex.getStartNodeType());
        this.sb.appendFront("protected void Check(TreeNode current)\n");
        this.sb.appendFront("{\n");
        this.sb.indent();
        this.sb.appendFront("if(current == bottom)\n");
        this.sb.appendFrontIndented("return;\n");
        this.sb.appendFront("Check(current.left);\n");
        this.sb.appendFront("if(!nodeToIncidenceCount.ContainsKey(current.value)) {\n");
        this.sb.indent();
        this.sb.appendFront("Dump(root);\n");
        this.sb.appendFront("Dump();\n");
        this.sb.appendFront("throw new Exception(\"Missing node\");\n");
        this.sb.unindent();
        this.sb.appendFront("}\n");
        this.sb.appendFront("if(nodeToIncidenceCount[current.value]!=current.key) {\n");
        this.sb.indent();
        this.sb.appendFront("Dump(root);\n");
        this.sb.appendFront("Dump();\n");
        this.sb.appendFront("throw new Exception(\"Incidence values differ\");\n");
        this.sb.unindent();
        this.sb.appendFront("}\n");
        this.sb.appendFront("Check(current.right);\n");
        this.sb.unindent();
        this.sb.appendFront("}\n");
        this.sb.append("\n");
        this.sb.appendFront("protected void Dump(TreeNode current)\n");
        this.sb.appendFront("{\n");
        this.sb.indent();
        this.sb.appendFront("if(current == bottom)\n");
        this.sb.appendFrontIndented("return;\n");
        this.sb.appendFront("Dump(current.left);\n");
        this.sb.appendFront("Console.Write(current.key);\n");
        this.sb.appendFront("Console.Write(\" -> \");\n");
        this.sb.appendFront("Console.WriteLine(graph.GetElementName(current.value));\n");
        this.sb.appendFront("Dump(current.right);\n");
        this.sb.unindent();
        this.sb.appendFront("}\n");
        this.sb.append("\n");
        this.sb.appendFront("protected void Dump()\n");
        this.sb.appendFront("{\n");
        this.sb.appendFront("foreach(KeyValuePair<" + string + ",int> kvp in nodeToIncidenceCount) {\n");
        this.sb.indent();
        this.sb.appendFront("Console.Write(graph.GetElementName(kvp.Key));\n");
        this.sb.appendFront("Console.Write(\" => \");\n");
        this.sb.appendFront("Console.WriteLine(kvp.Value);\n");
        this.sb.unindent();
        this.sb.appendFront("}\n");
        this.sb.unindent();
        this.sb.appendFront("}\n");
        this.sb.append("\n");
    }

    void genIndexMaintainingEventHandlers(IncidenceCountIndex incidenceCountIndex) {
        String string = this.formatElementInterfaceRef(incidenceCountIndex.getStartNodeType());
        String string2 = this.formatElementInterfaceRef(incidenceCountIndex.getIncidentEdgeType());
        String string3 = ModelIndexGen.formatTypeClassRefInstance(incidenceCountIndex.getIncidentEdgeType());
        this.sb.appendFront("void ClearingGraph(GRGEN_LIBGR.IGraph graph)\n");
        this.sb.appendFront("{\n");
        this.sb.indent();
        this.sb.appendFront("// ReInitialize AA tree to clear the index\n");
        this.sb.appendFront("bottom = new TreeNode();\n");
        this.sb.appendFront("root = bottom;\n");
        this.sb.appendFront("deleted = bottom;\n");
        this.sb.appendFront("last = null;\n");
        this.sb.appendFront("count = 0;\n");
        this.sb.appendFront("version = 0;\n");
        this.sb.unindent();
        this.sb.appendFront("}\n");
        this.sb.append("\n");
        this.sb.appendFront("void EdgeAdded(GRGEN_LIBGR.IEdge edge)\n");
        this.sb.appendFront("{\n");
        this.sb.indent();
        this.sb.appendFront("if(!(edge is " + string2 + "))\n");
        this.sb.appendFrontIndented("return;\n");
        this.sb.appendFront("GRGEN_LIBGR.INode source = edge.Source;\n");
        this.sb.appendFront("GRGEN_LIBGR.INode target = edge.Target;\n");
        this.genIndexMaintainingEdgeAdded(incidenceCountIndex);
        this.sb.unindent();
        this.sb.appendFront("}\n");
        this.sb.append("\n");
        this.sb.appendFront("void NodeAdded(GRGEN_LIBGR.INode node)\n");
        this.sb.appendFront("{\n");
        this.sb.indent();
        this.sb.appendFront("if(node is " + string + ") {\n");
        this.sb.indent();
        this.sb.appendFront("nodeToIncidenceCount.Add((" + string + ")node, 0);\n");
        this.sb.appendFront("Insert(ref root, 0, (" + string + ")node);\n");
        this.sb.unindent();
        this.sb.appendFront("}\n");
        this.sb.unindent();
        this.sb.appendFront("}\n");
        this.sb.append("\n");
        this.sb.appendFront("void RemovingEdge(GRGEN_LIBGR.IEdge edge)\n");
        this.sb.appendFront("{\n");
        this.sb.indent();
        this.sb.appendFront("if(!(edge is " + string2 + "))\n");
        this.sb.appendFrontIndented("return;\n");
        this.sb.appendFront("GRGEN_LIBGR.INode source = edge.Source;\n");
        this.sb.appendFront("GRGEN_LIBGR.INode target = edge.Target;\n");
        this.genIndexMaintainingRemovingEdge(incidenceCountIndex);
        this.sb.unindent();
        this.sb.appendFront("}\n");
        this.sb.append("\n");
        this.sb.appendFront("void RemovingNode(GRGEN_LIBGR.INode node)\n");
        this.sb.appendFront("{\n");
        this.sb.indent();
        this.sb.appendFront("if(node is " + string + ") {\n");
        this.sb.indent();
        this.sb.appendFront("nodeToIncidenceCount.Remove((" + string + ")node);\n");
        this.sb.appendFront("Delete(ref root, 0, (" + string + ")node);\n");
        this.sb.unindent();
        this.sb.appendFront("}\n");
        this.sb.unindent();
        this.sb.appendFront("}\n");
        this.sb.append("\n");
        this.sb.appendFront("void RetypingEdge(GRGEN_LIBGR.IEdge oldEdge, GRGEN_LIBGR.IEdge newEdge)\n");
        this.sb.appendFront("{\n");
        this.sb.indent();
        this.sb.appendFront("RemovingEdge(oldEdge);\n");
        this.sb.appendFront("EdgeAdded(newEdge);\n");
        this.sb.unindent();
        this.sb.appendFront("}\n");
        this.sb.append("\n");
        this.sb.appendFront("void RetypingNode(GRGEN_LIBGR.INode oldNode, GRGEN_LIBGR.INode newNode)\n");
        this.sb.appendFront("{\n");
        this.sb.indent();
        this.sb.appendFront("IDictionary<GRGEN_LIBGR.IEdge, GRGEN_LIBGR.SetValueType> incidentEdges = GRGEN_LIBGR.GraphHelper.Incident(oldNode, " + string3 + ", graph.Model.NodeModel.RootType);\n");
        this.sb.appendFront("foreach(KeyValuePair<GRGEN_LIBGR.IEdge, GRGEN_LIBGR.SetValueType> edgeKVP in incidentEdges)\n");
        this.sb.appendFront("{\n");
        this.sb.indent();
        this.sb.appendFront("GRGEN_LIBGR.IEdge edge = edgeKVP.Key;\n");
        this.sb.appendFront("GRGEN_LIBGR.INode source = edge.Source;\n");
        this.sb.appendFront("GRGEN_LIBGR.INode target = edge.Target;\n");
        this.genIndexMaintainingRemovingEdge(incidenceCountIndex);
        this.sb.unindent();
        this.sb.appendFront("}\n");
        this.sb.appendFront("if(oldNode is " + string + ") {\n");
        this.sb.indent();
        this.sb.appendFront("nodeToIncidenceCount.Remove((" + string + ")oldNode);\n");
        this.sb.appendFront("Delete(ref root, 0, (" + string + ")oldNode);\n");
        this.sb.unindent();
        this.sb.appendFront("}\n");
        this.sb.appendFront("if(newNode is " + string + ") {\n");
        this.sb.indent();
        this.sb.appendFront("nodeToIncidenceCount.Add((" + string + ")newNode, 0);\n");
        this.sb.appendFront("Insert(ref root, 0, (" + string + ")newNode);\n");
        this.sb.unindent();
        this.sb.appendFront("}\n");
        this.sb.appendFront("foreach(KeyValuePair<GRGEN_LIBGR.IEdge, GRGEN_LIBGR.SetValueType> edgeKVP in incidentEdges)\n");
        this.sb.appendFront("{\n");
        this.sb.indent();
        this.sb.appendFront("GRGEN_LIBGR.IEdge edge = edgeKVP.Key;\n");
        this.sb.appendFront("GRGEN_LIBGR.INode source = edge.Source==oldNode ? newNode : edge.Source;\n");
        this.sb.appendFront("GRGEN_LIBGR.INode target = edge.Target==oldNode ? newNode : edge.Target;\n");
        this.genIndexMaintainingEdgeAdded(incidenceCountIndex);
        this.sb.unindent();
        this.sb.appendFront("}\n");
        this.sb.unindent();
        this.sb.appendFront("}\n");
    }

    void genIndexMaintainingEdgeAdded(IncidenceCountIndex incidenceCountIndex) {
        String string = this.formatElementInterfaceRef(incidenceCountIndex.getStartNodeType());
        String string2 = this.formatElementInterfaceRef(incidenceCountIndex.getAdjacentNodeType());
        if (incidenceCountIndex.Direction() == Direction.OUTGOING) {
            this.sb.appendFront("if(source is " + string + " && target is " + string2 + ") {\n");
            this.sb.indent();
            this.sb.appendFront("Delete(ref root, nodeToIncidenceCount[(" + string + ")source], (" + string + ")source);\n");
            this.sb.appendFront("nodeToIncidenceCount[(" + string + ")source] = nodeToIncidenceCount[(" + string + ")source] + 1;\n");
            this.sb.appendFront("Insert(ref root, nodeToIncidenceCount[(" + string + ")source], (" + string + ")source);\n");
            this.sb.unindent();
            this.sb.appendFront("}\n");
        } else if (incidenceCountIndex.Direction() == Direction.INCOMING) {
            this.sb.appendFront("if(target is " + string + " && source is " + string2 + ") {\n");
            this.sb.indent();
            this.sb.appendFront("Delete(ref root, nodeToIncidenceCount[(" + string + ")target], (" + string + ")target);\n");
            this.sb.appendFront("nodeToIncidenceCount[(" + string + ")target] = nodeToIncidenceCount[(" + string + ")target] + 1;\n");
            this.sb.appendFront("Insert(ref root, nodeToIncidenceCount[(" + string + ")target], (" + string + ")target);\n");
            this.sb.unindent();
            this.sb.appendFront("}\n");
        } else {
            this.sb.appendFront("if(source is " + string + " && target is " + string2 + ") {\n");
            this.sb.indent();
            this.sb.appendFront("Delete(ref root, nodeToIncidenceCount[(" + string + ")source], (" + string + ")source);\n");
            this.sb.appendFront("nodeToIncidenceCount[(" + string + ")source] = nodeToIncidenceCount[(" + string + ")source] + 1;\n");
            this.sb.appendFront("Insert(ref root, nodeToIncidenceCount[(" + string + ")source], (" + string + ")source);\n");
            this.sb.unindent();
            this.sb.appendFront("}\n");
            this.sb.appendFront("if(target is " + string + " && source is " + string2 + " && source!=target) {\n");
            this.sb.indent();
            this.sb.appendFront("Delete(ref root, nodeToIncidenceCount[(" + string + ")target], (" + string + ")target);\n");
            this.sb.appendFront("nodeToIncidenceCount[(" + string + ")target] = nodeToIncidenceCount[(" + string + ")target] + 1;\n");
            this.sb.appendFront("Insert(ref root, nodeToIncidenceCount[(" + string + ")target], (" + string + ")target);\n");
            this.sb.unindent();
            this.sb.appendFront("}\n");
        }
    }

    void genIndexMaintainingRemovingEdge(IncidenceCountIndex incidenceCountIndex) {
        String string = this.formatElementInterfaceRef(incidenceCountIndex.getStartNodeType());
        String string2 = this.formatElementInterfaceRef(incidenceCountIndex.getAdjacentNodeType());
        if (incidenceCountIndex.Direction() == Direction.OUTGOING) {
            this.sb.appendFront("if(source is " + string + " && target is " + string2 + ") {\n");
            this.sb.indent();
            this.sb.appendFront("Delete(ref root, nodeToIncidenceCount[(" + string + ")source], (" + string + ")source);\n");
            this.sb.appendFront("nodeToIncidenceCount[(" + string + ")source] = nodeToIncidenceCount[(" + string + ")source] - 1;\n");
            this.sb.appendFront("Insert(ref root, nodeToIncidenceCount[(" + string + ")source], (" + string + ")source);\n");
            this.sb.unindent();
            this.sb.appendFront("}\n");
        } else if (incidenceCountIndex.Direction() == Direction.INCOMING) {
            this.sb.appendFront("if(target is " + string + " && source is " + string2 + ") {\n");
            this.sb.indent();
            this.sb.appendFront("Delete(ref root, nodeToIncidenceCount[(" + string + ")target], (" + string + ")target);\n");
            this.sb.appendFront("nodeToIncidenceCount[(" + string + ")target] = nodeToIncidenceCount[(" + string + ")target] - 1;\n");
            this.sb.appendFront("Insert(ref root, nodeToIncidenceCount[(" + string + ")target], (" + string + ")target);\n");
            this.sb.unindent();
            this.sb.appendFront("}\n");
        } else {
            this.sb.appendFront("if(source is " + string + " && target is " + string2 + ") {\n");
            this.sb.indent();
            this.sb.appendFront("Delete(ref root, nodeToIncidenceCount[(" + string + ")source], (" + string + ")source);\n");
            this.sb.appendFront("nodeToIncidenceCount[(" + string + ")source] = nodeToIncidenceCount[(" + string + ")source] - 1;\n");
            this.sb.appendFront("Insert(ref root, nodeToIncidenceCount[(" + string + ")source], (" + string + ")source);\n");
            this.sb.unindent();
            this.sb.appendFront("}\n");
            this.sb.appendFront("if(target is " + string + " && source is " + string2 + " && source!=target) {\n");
            this.sb.indent();
            this.sb.appendFront("Delete(ref root, nodeToIncidenceCount[(" + string + ")target], (" + string + ")target);\n");
            this.sb.appendFront("nodeToIncidenceCount[(" + string + ")target] = nodeToIncidenceCount[(" + string + ")target] - 1;\n");
            this.sb.appendFront("Insert(ref root, nodeToIncidenceCount[(" + string + ")target], (" + string + ")target);\n");
            this.sb.unindent();
            this.sb.appendFront("}\n");
        }
    }

    void genIndexAATreeBalancingInsertionDeletion(IncidenceCountIndex incidenceCountIndex) {
        String string = this.formatElementInterfaceRef(incidenceCountIndex.getStartNodeType());
        String string2 = " as GRGEN_LGSP.LGSPNodeWithUniqueId";
        this.sb.appendFront("private void Skew(ref TreeNode current)\n");
        this.sb.appendFront("{\n");
        this.sb.indent();
        this.sb.appendFront("if(current.level != current.left.level)\n");
        this.sb.appendFrontIndented("return;\n");
        this.sb.append("\n");
        this.sb.appendFront("// rotate right\n");
        this.sb.appendFront("TreeNode left = current.left;\n");
        this.sb.appendFront("current.left = left.right;\n");
        this.sb.appendFront("left.right = current;\n");
        this.sb.appendFront("current = left;\n");
        this.sb.unindent();
        this.sb.appendFront("}\n");
        this.sb.append("\n");
        this.sb.appendFront("private void Split(ref TreeNode current)\n");
        this.sb.appendFront("{\n");
        this.sb.indent();
        this.sb.appendFront("if(current.right.right.level != current.level)\n");
        this.sb.appendFrontIndented("return;\n");
        this.sb.append("\n");
        this.sb.appendFront("// rotate left\n");
        this.sb.appendFront("TreeNode right = current.right;\n");
        this.sb.appendFront("current.right = right.left;\n");
        this.sb.appendFront("right.left = current;\n");
        this.sb.appendFront("current = right;\n");
        this.sb.appendFront("++current.level;\n");
        this.sb.unindent();
        this.sb.appendFront("}\n");
        this.sb.append("\n");
        this.sb.appendFront("private void Insert(ref TreeNode current, int key, " + string + " value)\n");
        this.sb.appendFront("{\n");
        this.sb.indent();
        this.sb.appendFront("if(current == bottom)\n");
        this.sb.appendFront("{\n");
        this.sb.indent();
        this.sb.appendFront("current = new TreeNode(key, value, bottom);\n");
        this.sb.appendFront("++count;\n");
        this.sb.appendFront("++version;\n");
        this.sb.appendFront("return;\n");
        this.sb.unindent();
        this.sb.appendFront("}\n");
        this.sb.append("\n");
        this.sb.appendFront("if(key < current.key");
        this.sb.appendFront(" || ( key == current.key && (value" + string2 + ").uniqueId < (current.value" + string2 + ").uniqueId ) )\n");
        this.sb.appendFrontIndented("Insert(ref current.left, key, value);\n");
        this.sb.appendFront("else if(key > current.key");
        this.sb.appendFront(" || ( key == current.key && (value" + string2 + ").uniqueId > (current.value" + string2 + ").uniqueId ) )\n");
        this.sb.appendFrontIndented("Insert(ref current.right, key, value);\n");
        this.sb.appendFront("else\n");
        this.sb.appendFrontIndented("throw new Exception(\"Insertion of already available element\");\n");
        this.sb.append("\n");
        this.sb.appendFront("Skew(ref current);\n");
        this.sb.appendFront("Split(ref current);\n");
        this.sb.unindent();
        this.sb.appendFront("}\n");
        this.sb.append("\n");
        this.sb.appendFront("private void Delete(ref TreeNode current, int key, " + string + " value)\n");
        this.sb.appendFront("{\n");
        this.sb.indent();
        this.sb.appendFront("if(current == bottom)\n");
        this.sb.appendFrontIndented("return;\n");
        this.sb.append("\n");
        this.sb.appendFront("// search down the tree (and set pointer last and deleted)\n");
        this.sb.appendFront("last = current;\n");
        this.sb.appendFront("if(key < current.key");
        this.sb.append(" || ( key == current.key && (value" + string2 + ").uniqueId < (current.value" + string2 + ").uniqueId ) )\n");
        this.sb.appendFrontIndented("Delete(ref current.left, key, value);\n");
        this.sb.appendFront("else\n");
        this.sb.appendFront("{\n");
        this.sb.indent();
        this.sb.appendFront("deleted = current;\n");
        this.sb.appendFront("Delete(ref current.right, key, value);\n");
        this.sb.unindent();
        this.sb.appendFront("}\n");
        this.sb.append("\n");
        this.sb.appendFront("// at the bottom of the tree we remove the element (if present)\n");
        this.sb.appendFront("if(current == last && deleted != bottom && key == deleted.key");
        this.sb.appendFront(" && (value" + string2 + ").uniqueId == (deleted.value" + string2 + ").uniqueId )\n");
        this.sb.appendFront("{\n");
        this.sb.indent();
        this.sb.appendFront("deleted.value = current.value;\n");
        this.sb.appendFront("deleted.key = current.key;\n");
        this.sb.appendFront("deleted = bottom;\n");
        this.sb.appendFront("current = current.right;\n");
        this.sb.appendFront("--count;\n");
        this.sb.appendFront("++version;\n");
        this.sb.unindent();
        this.sb.appendFront("}\n");
        this.sb.appendFront("// on the way back, we rebalance\n");
        this.sb.appendFront("else if(current.left.level < current.level - 1\n");
        this.sb.appendFrontIndented("|| current.right.level < current.level - 1)\n");
        this.sb.appendFront("{\n");
        this.sb.indent();
        this.sb.appendFront("--current.level;\n");
        this.sb.appendFront("if(current.right.level > current.level)\n");
        this.sb.appendFrontIndented("current.right.level = current.level;\n");
        this.sb.appendFront("Skew(ref current);\n");
        this.sb.appendFront("Skew(ref current.right);\n");
        this.sb.appendFront("Skew(ref current.right.right);\n");
        this.sb.appendFront("Split(ref current);\n");
        this.sb.appendFront("Split(ref current.right);\n");
        this.sb.unindent();
        this.sb.appendFront("}\n");
        this.sb.unindent();
        this.sb.appendFront("}\n");
        this.sb.append("\n");
    }

    @Override
    protected void genQualAccess(SourceBuilder sourceBuilder, Qualification qualification, Object object) {
    }

    @Override
    protected void genMemberAccess(SourceBuilder sourceBuilder, Entity entity) {
    }
}

