/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.be.Csharp;

import de.unika.ipd.grgen.be.Csharp.CSharpBase;
import de.unika.ipd.grgen.ir.Emit;
import de.unika.ipd.grgen.ir.Entity;
import de.unika.ipd.grgen.ir.Exec;
import de.unika.ipd.grgen.ir.Identifiable;
import de.unika.ipd.grgen.ir.executable.Procedure;
import de.unika.ipd.grgen.ir.executable.Rule;
import de.unika.ipd.grgen.ir.expr.Qualification;
import de.unika.ipd.grgen.ir.pattern.Alternative;
import de.unika.ipd.grgen.ir.pattern.GraphEntity;
import de.unika.ipd.grgen.ir.pattern.PatternGraphLhs;
import de.unika.ipd.grgen.ir.pattern.Variable;
import de.unika.ipd.grgen.ir.stmt.CaseStatement;
import de.unika.ipd.grgen.ir.stmt.ConditionStatement;
import de.unika.ipd.grgen.ir.stmt.ContainerAccumulationYield;
import de.unika.ipd.grgen.ir.stmt.DoWhileStatement;
import de.unika.ipd.grgen.ir.stmt.EvalStatement;
import de.unika.ipd.grgen.ir.stmt.EvalStatements;
import de.unika.ipd.grgen.ir.stmt.ExecStatement;
import de.unika.ipd.grgen.ir.stmt.ImperativeStmt;
import de.unika.ipd.grgen.ir.stmt.IntegerRangeIterationYield;
import de.unika.ipd.grgen.ir.stmt.MatchesAccumulationYield;
import de.unika.ipd.grgen.ir.stmt.MultiStatement;
import de.unika.ipd.grgen.ir.stmt.SwitchStatement;
import de.unika.ipd.grgen.ir.stmt.WhileStatement;
import de.unika.ipd.grgen.ir.stmt.graph.ForFunction;
import de.unika.ipd.grgen.util.SourceBuilder;

public class ActionsExecGen
extends CSharpBase {
    public ActionsExecGen(String string, String string2, String string3, String string4) {
        super(string, string2, string3, string4);
    }

    public void genImperativeStatements(SourceBuilder sourceBuilder, Rule rule, String string, String string2, boolean bl, boolean bl2) {
        String string3;
        if (rule.getRight() == null) {
            return;
        }
        if (bl) {
            sourceBuilder.append("#if INITIAL_WARMUP\t\t// GrGen imperative statement section: " + ActionsExecGen.getPackagePrefixDoubleColon(rule) + (bl2 ? "Pattern_" : "Rule_") + ActionsExecGen.formatIdentifiable(rule) + "\n");
        }
        this.genImperativeStatements(sourceBuilder, rule, string, string2);
        PatternGraphLhs patternGraphLhs = rule.getPattern();
        for (Alternative identifiable : patternGraphLhs.getAlts()) {
            string3 = identifiable.getNameOfGraph();
            for (Rule rule2 : identifiable.getAlternativeCases()) {
                PatternGraphLhs patternGraphLhs2 = rule2.getLeft();
                this.genImperativeStatements(sourceBuilder, rule2, string + string3 + "_" + patternGraphLhs2.getNameOfGraph() + "_", string2, false, bl2);
            }
        }
        for (Rule rule3 : patternGraphLhs.getIters()) {
            string3 = rule3.getLeft().getNameOfGraph();
            this.genImperativeStatements(sourceBuilder, rule3, string + string3 + "_", string2, false, bl2);
        }
        if (bl) {
            sourceBuilder.append("#endif\n");
        }
    }

    private void genImperativeStatements(SourceBuilder sourceBuilder, Rule rule, String string, String string2) {
        int n = 0;
        for (EvalStatements object : rule.getEvals()) {
            for (EvalStatement evalStatement : object.evalStatements) {
                n = this.genImperativeStatements(sourceBuilder, rule, string, string2, evalStatement, n);
            }
        }
        for (ImperativeStmt imperativeStmt : rule.getRight().getImperativeStmts()) {
            if (imperativeStmt instanceof Exec) {
                n = this.genExec(sourceBuilder, string, string2, (Exec)imperativeStmt, n);
                continue;
            }
            if (!(imperativeStmt instanceof Emit)) assert (false) : "unknown ImperativeStmt: " + imperativeStmt + " in " + rule;
        }
    }

    private int genImperativeStatements(SourceBuilder sourceBuilder, Rule rule, String string, String string2, EvalStatement evalStatement, int n) {
        if (evalStatement instanceof ConditionStatement) {
            ConditionStatement conditionStatement = (ConditionStatement)evalStatement;
            for (EvalStatement evalStatement2 : conditionStatement.getStatements()) {
                n = this.genImperativeStatements(sourceBuilder, rule, string, string2, evalStatement2, n);
            }
            if (conditionStatement.getFalseCaseStatements() != null) {
                for (EvalStatement evalStatement4 : conditionStatement.getFalseCaseStatements()) {
                    n = this.genImperativeStatements(sourceBuilder, rule, string, string2, evalStatement4, n);
                }
            }
        } else if (evalStatement instanceof SwitchStatement) {
            SwitchStatement switchStatement = (SwitchStatement)evalStatement;
            for (EvalStatement evalStatement5 : switchStatement.getStatements()) {
                n = this.genImperativeStatements(sourceBuilder, rule, string, string2, evalStatement5, n);
            }
        } else if (evalStatement instanceof CaseStatement) {
            CaseStatement caseStatement = (CaseStatement)evalStatement;
            for (EvalStatement evalStatement6 : caseStatement.getStatements()) {
                n = this.genImperativeStatements(sourceBuilder, rule, string, string2, evalStatement6, n);
            }
        } else if (evalStatement instanceof WhileStatement) {
            WhileStatement whileStatement = (WhileStatement)evalStatement;
            for (EvalStatement evalStatement7 : whileStatement.getStatements()) {
                n = this.genImperativeStatements(sourceBuilder, rule, string, string2, evalStatement7, n);
            }
        } else if (evalStatement instanceof DoWhileStatement) {
            DoWhileStatement doWhileStatement = (DoWhileStatement)evalStatement;
            for (EvalStatement evalStatement8 : doWhileStatement.getStatements()) {
                n = this.genImperativeStatements(sourceBuilder, rule, string, string2, evalStatement8, n);
            }
        } else if (evalStatement instanceof ContainerAccumulationYield) {
            ContainerAccumulationYield containerAccumulationYield = (ContainerAccumulationYield)evalStatement;
            for (EvalStatement evalStatement9 : containerAccumulationYield.getStatements()) {
                n = this.genImperativeStatements(sourceBuilder, rule, string, string2, evalStatement9, n);
            }
        } else if (evalStatement instanceof IntegerRangeIterationYield) {
            IntegerRangeIterationYield integerRangeIterationYield = (IntegerRangeIterationYield)evalStatement;
            for (EvalStatement evalStatement10 : integerRangeIterationYield.getStatements()) {
                n = this.genImperativeStatements(sourceBuilder, rule, string, string2, evalStatement10, n);
            }
        } else if (evalStatement instanceof MatchesAccumulationYield) {
            MatchesAccumulationYield matchesAccumulationYield = (MatchesAccumulationYield)evalStatement;
            for (EvalStatement evalStatement2 : matchesAccumulationYield.getStatements()) {
                n = this.genImperativeStatements(sourceBuilder, rule, string, string2, evalStatement2, n);
            }
        } else if (evalStatement instanceof ForFunction) {
            ForFunction forFunction = (ForFunction)evalStatement;
            for (EvalStatement evalStatement3 : forFunction.getLoopedStatements()) {
                n = this.genImperativeStatements(sourceBuilder, rule, string, string2, evalStatement3, n);
            }
        } else if (evalStatement instanceof ExecStatement) {
            ExecStatement execStatement = (ExecStatement)evalStatement;
            n = this.genImperativeStatements(sourceBuilder, rule, string, string2, execStatement, n);
        }
        return n;
    }

    private int genExec(SourceBuilder sourceBuilder, String string, String string2, Exec exec, int n) {
        GraphEntity graphEntity;
        sourceBuilder.appendFront("public static GRGEN_LIBGR.EmbeddedSequenceInfo XGRSInfo_" + string + n + " = new GRGEN_LIBGR.EmbeddedSequenceInfo(\n");
        sourceBuilder.indent();
        sourceBuilder.appendFront("new string[] {");
        for (Entity entity : exec.getNeededEntities(false)) {
            if (entity.isDefToBeYieldedTo()) continue;
            sourceBuilder.append("\"" + entity.getIdent() + "\", ");
        }
        sourceBuilder.append("},\n");
        sourceBuilder.appendFront("new GRGEN_LIBGR.GrGenType[] { ");
        for (Entity entity : exec.getNeededEntities(false)) {
            if (entity.isDefToBeYieldedTo()) continue;
            if (entity instanceof Variable) {
                sourceBuilder.append("GRGEN_LIBGR.VarType.GetVarType(typeof(" + this.formatAttributeType(entity) + ")), ");
                continue;
            }
            graphEntity = (GraphEntity)entity;
            sourceBuilder.append(ActionsExecGen.formatTypeClassRef(graphEntity.getType()) + ".typeVar, ");
        }
        sourceBuilder.append("},\n");
        sourceBuilder.appendFront("new string[] {");
        for (Entity entity : exec.getNeededEntities(false)) {
            if (!entity.isDefToBeYieldedTo()) continue;
            sourceBuilder.append("\"" + entity.getIdent() + "\", ");
        }
        sourceBuilder.append("},\n");
        sourceBuilder.appendFront("new GRGEN_LIBGR.GrGenType[] { ");
        for (Entity entity : exec.getNeededEntities(false)) {
            if (!entity.isDefToBeYieldedTo()) continue;
            if (entity instanceof Variable) {
                sourceBuilder.append("GRGEN_LIBGR.VarType.GetVarType(typeof(" + this.formatAttributeType(entity) + ")), ");
                continue;
            }
            graphEntity = (GraphEntity)entity;
            sourceBuilder.append(ActionsExecGen.formatTypeClassRef(graphEntity.getType()) + ".typeVar, ");
        }
        sourceBuilder.append("},\n");
        sourceBuilder.appendFront((string2 != null ? "\"" + string2 + "\"" : "null") + ",\n");
        sourceBuilder.appendFront("\"" + ActionsExecGen.escapeBackslashAndDoubleQuotes(exec.getXGRSString()) + "\",\n");
        sourceBuilder.appendFront(exec.getLineNr() + "\n");
        sourceBuilder.unindent();
        sourceBuilder.appendFront(");\n");
        sourceBuilder.appendFront("private static bool ApplyXGRS_" + string + n + "(GRGEN_LGSP.LGSPGraphProcessingEnvironment procEnv");
        for (Entity entity : exec.getNeededEntities(false)) {
            if (entity.isDefToBeYieldedTo()) continue;
            sourceBuilder.append(", " + this.formatType(entity.getType()) + " " + ActionsExecGen.formatEntity(entity));
        }
        for (Entity entity : exec.getNeededEntities(false)) {
            if (!entity.isDefToBeYieldedTo()) continue;
            sourceBuilder.append(", ref " + this.formatType(entity.getType()) + " " + ActionsExecGen.formatEntity(entity));
        }
        sourceBuilder.append(") {\n");
        sourceBuilder.indent();
        for (Entity entity : exec.getNeededEntities(false)) {
            if (!entity.isDefToBeYieldedTo()) continue;
            sourceBuilder.appendFront(ActionsExecGen.formatEntity(entity) + " = ");
            sourceBuilder.append(ActionsExecGen.getInitializationValue(entity.getType()) + ";\n");
            sourceBuilder.append(";\n");
        }
        sourceBuilder.appendFront("return true;\n");
        sourceBuilder.unindent();
        sourceBuilder.appendFront("}\n");
        return ++n;
    }

    private int genImperativeStatements(SourceBuilder sourceBuilder, Rule rule, String string, String string2, ExecStatement execStatement, int n) {
        GraphEntity graphEntity;
        sourceBuilder.appendFront("public static GRGEN_LIBGR.EmbeddedSequenceInfo XGRSInfo_" + string + n + " = new GRGEN_LIBGR.EmbeddedSequenceInfo(\n");
        sourceBuilder.indent();
        sourceBuilder.appendFront("new string[] {");
        for (Entity entity : execStatement.getNeededEntities(true)) {
            if (entity.isDefToBeYieldedTo()) continue;
            sourceBuilder.append("\"" + entity.getIdent() + "\", ");
        }
        sourceBuilder.append("},\n");
        sourceBuilder.appendFront("new GRGEN_LIBGR.GrGenType[] { ");
        for (Entity entity : execStatement.getNeededEntities(true)) {
            if (entity.isDefToBeYieldedTo()) continue;
            if (entity instanceof Variable) {
                sourceBuilder.append("GRGEN_LIBGR.VarType.GetVarType(typeof(" + this.formatAttributeType(entity) + ")), ");
                continue;
            }
            graphEntity = (GraphEntity)entity;
            sourceBuilder.append(ActionsExecGen.formatTypeClassRef(graphEntity.getType()) + ".typeVar, ");
        }
        sourceBuilder.append("},\n");
        sourceBuilder.appendFront("new string[] {");
        for (Entity entity : execStatement.getNeededEntities(true)) {
            if (!entity.isDefToBeYieldedTo()) continue;
            sourceBuilder.append("\"" + entity.getIdent() + "\", ");
        }
        sourceBuilder.append("},\n");
        sourceBuilder.appendFront("new GRGEN_LIBGR.GrGenType[] { ");
        for (Entity entity : execStatement.getNeededEntities(true)) {
            if (!entity.isDefToBeYieldedTo()) continue;
            if (entity instanceof Variable) {
                sourceBuilder.append("GRGEN_LIBGR.VarType.GetVarType(typeof(" + this.formatAttributeType(entity) + ")), ");
                continue;
            }
            graphEntity = (GraphEntity)entity;
            sourceBuilder.append(ActionsExecGen.formatTypeClassRef(graphEntity.getType()) + ".typeVar, ");
        }
        sourceBuilder.append("},\n");
        sourceBuilder.appendFront((string2 != null ? "\"" + string2 + "\"" : "null") + ",\n");
        sourceBuilder.appendFront("\"" + ActionsExecGen.escapeBackslashAndDoubleQuotes(execStatement.getXGRSString()) + "\",\n");
        sourceBuilder.appendFront(execStatement.getLineNr() + "\n");
        sourceBuilder.unindent();
        sourceBuilder.appendFront(");\n");
        sourceBuilder.appendFront("private static bool ApplyXGRS_" + string + n + "(GRGEN_LGSP.LGSPGraphProcessingEnvironment procEnv");
        for (Entity entity : execStatement.getNeededEntities(true)) {
            if (entity.isDefToBeYieldedTo()) continue;
            sourceBuilder.append(", " + this.formatType(entity.getType()) + " " + ActionsExecGen.formatEntity(entity));
        }
        for (Entity entity : execStatement.getNeededEntities(true)) {
            if (!entity.isDefToBeYieldedTo()) continue;
            sourceBuilder.append(", ref " + this.formatType(entity.getType()) + " " + ActionsExecGen.formatEntity(entity));
        }
        sourceBuilder.append(") {\n");
        sourceBuilder.indent();
        for (Entity entity : execStatement.getNeededEntities(true)) {
            if (!entity.isDefToBeYieldedTo()) continue;
            sourceBuilder.appendFront(ActionsExecGen.formatEntity(entity) + " = ");
            sourceBuilder.append(ActionsExecGen.getInitializationValue(entity.getType()) + ";\n");
            sourceBuilder.append(";\n");
        }
        sourceBuilder.appendFront("return true;\n");
        sourceBuilder.unindent();
        sourceBuilder.appendFront("}\n");
        return ++n;
    }

    public void genImperativeStatementClosures(SourceBuilder sourceBuilder, Rule rule, String string, boolean bl) {
        String string2;
        if (rule.getRight() == null) {
            return;
        }
        if (!bl) {
            this.genImperativeStatementClosures(sourceBuilder, rule, string);
        }
        PatternGraphLhs patternGraphLhs = rule.getPattern();
        for (Alternative identifiable : patternGraphLhs.getAlts()) {
            string2 = identifiable.getNameOfGraph();
            for (Rule rule2 : identifiable.getAlternativeCases()) {
                PatternGraphLhs patternGraphLhs2 = rule2.getLeft();
                this.genImperativeStatementClosures(sourceBuilder, rule2, string + string2 + "_" + patternGraphLhs2.getNameOfGraph() + "_", false);
            }
        }
        for (Rule rule3 : patternGraphLhs.getIters()) {
            string2 = rule3.getLeft().getNameOfGraph();
            this.genImperativeStatementClosures(sourceBuilder, rule3, string + string2 + "_", false);
        }
    }

    private void genImperativeStatementClosures(SourceBuilder sourceBuilder, Rule rule, String string) {
        int n = 0;
        for (ImperativeStmt imperativeStmt : rule.getRight().getImperativeStmts()) {
            if (!(imperativeStmt instanceof Exec)) continue;
            Exec exec = (Exec)imperativeStmt;
            sourceBuilder.append("\n");
            sourceBuilder.appendFront("public class XGRSClosure_" + string + n + " : GRGEN_LGSP.LGSPEmbeddedSequenceClosure\n");
            sourceBuilder.appendFront("{\n");
            sourceBuilder.indent();
            sourceBuilder.appendFront("public XGRSClosure_" + string + n + "(");
            boolean bl = true;
            for (Entity entity : exec.getNeededEntities(false)) {
                if (bl) {
                    bl = false;
                } else {
                    sourceBuilder.append(", ");
                }
                sourceBuilder.append(this.formatType(entity.getType()) + " " + ActionsExecGen.formatEntity(entity));
            }
            sourceBuilder.append(") {\n");
            sourceBuilder.indent();
            for (Entity entity : exec.getNeededEntities(false)) {
                sourceBuilder.appendFront("this." + ActionsExecGen.formatEntity(entity) + " = " + ActionsExecGen.formatEntity(entity) + ";\n");
            }
            sourceBuilder.unindent();
            sourceBuilder.appendFront("}\n");
            sourceBuilder.appendFront("public override bool exec(GRGEN_LGSP.LGSPGraphProcessingEnvironment procEnv) {\n");
            sourceBuilder.appendFrontIndented("return ApplyXGRS_" + string + n + "(procEnv");
            for (Entity entity : exec.getNeededEntities(false)) {
                sourceBuilder.append(", " + ActionsExecGen.formatEntity(entity));
            }
            sourceBuilder.append(");\n");
            sourceBuilder.appendFront("}\n");
            for (Entity entity : exec.getNeededEntities(false)) {
                sourceBuilder.appendFront(this.formatType(entity.getType()) + " " + ActionsExecGen.formatEntity(entity) + ";\n");
            }
            sourceBuilder.unindent();
            sourceBuilder.appendFront("}\n");
            ++n;
        }
    }

    public void genImperativeStatements(SourceBuilder sourceBuilder, Procedure procedure) {
        int n = 0;
        for (EvalStatement evalStatement : procedure.getStatements()) {
            n = this.genImperativeStatements(sourceBuilder, procedure, evalStatement, n);
        }
    }

    private int genImperativeStatements(SourceBuilder sourceBuilder, Procedure procedure, EvalStatement evalStatement, int n) {
        block26: {
            block27: {
                block25: {
                    if (!(evalStatement instanceof ExecStatement)) break block25;
                    this.genImperativeStatement(sourceBuilder, procedure, procedure.getPackageContainedIn(), (ExecStatement)evalStatement, n);
                    ++n;
                    break block26;
                }
                if (!(evalStatement instanceof ConditionStatement)) break block27;
                ConditionStatement conditionStatement = (ConditionStatement)evalStatement;
                for (EvalStatement evalStatement2 : conditionStatement.getStatements()) {
                    n = this.genImperativeStatements(sourceBuilder, procedure, evalStatement2, n);
                }
                if (conditionStatement.getFalseCaseStatements() == null) break block26;
                for (EvalStatement evalStatement4 : conditionStatement.getFalseCaseStatements()) {
                    n = this.genImperativeStatements(sourceBuilder, procedure, evalStatement4, n);
                }
                break block26;
            }
            if (evalStatement instanceof SwitchStatement) {
                SwitchStatement switchStatement = (SwitchStatement)evalStatement;
                for (EvalStatement evalStatement2 : switchStatement.getStatements()) {
                    n = this.genImperativeStatements(sourceBuilder, procedure, evalStatement2, n);
                }
            } else if (evalStatement instanceof CaseStatement) {
                CaseStatement caseStatement = (CaseStatement)evalStatement;
                for (EvalStatement evalStatement3 : caseStatement.getStatements()) {
                    n = this.genImperativeStatements(sourceBuilder, procedure, evalStatement3, n);
                }
            } else if (evalStatement instanceof ContainerAccumulationYield) {
                for (EvalStatement evalStatement5 : ((ContainerAccumulationYield)evalStatement).getStatements()) {
                    n = this.genImperativeStatements(sourceBuilder, procedure, evalStatement5, n);
                }
            } else if (evalStatement instanceof IntegerRangeIterationYield) {
                for (EvalStatement evalStatement6 : ((IntegerRangeIterationYield)evalStatement).getStatements()) {
                    n = this.genImperativeStatements(sourceBuilder, procedure, evalStatement6, n);
                }
            } else if (evalStatement instanceof ForFunction) {
                for (EvalStatement evalStatement7 : ((ForFunction)evalStatement).getLoopedStatements()) {
                    n = this.genImperativeStatements(sourceBuilder, procedure, evalStatement7, n);
                }
            } else if (evalStatement instanceof DoWhileStatement) {
                for (EvalStatement evalStatement8 : ((DoWhileStatement)evalStatement).getStatements()) {
                    n = this.genImperativeStatements(sourceBuilder, procedure, evalStatement8, n);
                }
            } else if (evalStatement instanceof WhileStatement) {
                for (EvalStatement evalStatement9 : ((WhileStatement)evalStatement).getStatements()) {
                    n = this.genImperativeStatements(sourceBuilder, procedure, evalStatement9, n);
                }
            } else if (evalStatement instanceof MultiStatement) {
                for (EvalStatement evalStatement10 : ((MultiStatement)evalStatement).getStatements()) {
                    n = this.genImperativeStatements(sourceBuilder, procedure, evalStatement10, n);
                }
            }
        }
        return n;
    }

    private void genImperativeStatement(SourceBuilder sourceBuilder, Identifiable identifiable, String string, ExecStatement execStatement, int n) {
        GraphEntity graphEntity;
        Exec exec = execStatement.getExec();
        sourceBuilder.appendFront("public static GRGEN_LIBGR.EmbeddedSequenceInfo XGRSInfo_" + ActionsExecGen.formatIdentifiable(identifiable) + "_" + n + " = new GRGEN_LIBGR.EmbeddedSequenceInfo(\n");
        sourceBuilder.indent();
        sourceBuilder.appendFront("new string[] {");
        for (Entity entity : exec.getNeededEntities(true)) {
            if (entity.isDefToBeYieldedTo()) continue;
            sourceBuilder.append("\"" + entity.getIdent() + "\", ");
        }
        sourceBuilder.append("},\n");
        sourceBuilder.appendFront("new GRGEN_LIBGR.GrGenType[] { ");
        for (Entity entity : exec.getNeededEntities(true)) {
            if (entity.isDefToBeYieldedTo()) continue;
            if (entity instanceof Variable) {
                sourceBuilder.append("GRGEN_LIBGR.VarType.GetVarType(typeof(" + this.formatAttributeType(entity) + ")), ");
                continue;
            }
            graphEntity = (GraphEntity)entity;
            sourceBuilder.append(ActionsExecGen.formatTypeClassRef(graphEntity.getType()) + ".typeVar, ");
        }
        sourceBuilder.append("},\n");
        sourceBuilder.appendFront("new string[] {");
        for (Entity entity : exec.getNeededEntities(true)) {
            if (!entity.isDefToBeYieldedTo()) continue;
            sourceBuilder.append("\"" + entity.getIdent() + "\", ");
        }
        sourceBuilder.append("},\n");
        sourceBuilder.appendFront("new GRGEN_LIBGR.GrGenType[] { ");
        for (Entity entity : exec.getNeededEntities(true)) {
            if (!entity.isDefToBeYieldedTo()) continue;
            if (entity instanceof Variable) {
                sourceBuilder.append("GRGEN_LIBGR.VarType.GetVarType(typeof(" + this.formatAttributeType(entity) + ")), ");
                continue;
            }
            graphEntity = (GraphEntity)entity;
            sourceBuilder.append(ActionsExecGen.formatTypeClassRef(graphEntity.getType()) + ".typeVar, ");
        }
        sourceBuilder.append("},\n");
        sourceBuilder.appendFront((string != null ? "\"" + string + "\"" : "null") + ",\n");
        sourceBuilder.appendFront("\"" + ActionsExecGen.escapeBackslashAndDoubleQuotes(exec.getXGRSString()) + "\",\n");
        sourceBuilder.appendFront(exec.getLineNr() + "\n");
        sourceBuilder.unindent();
        sourceBuilder.appendFront(");\n");
        sourceBuilder.appendFront("private static bool ApplyXGRS_" + ActionsExecGen.formatIdentifiable(identifiable) + "_" + n + "(GRGEN_LGSP.LGSPGraphProcessingEnvironment procEnv");
        for (Entity entity : exec.getNeededEntities(true)) {
            if (entity.isDefToBeYieldedTo()) continue;
            sourceBuilder.append(", " + this.formatType(entity.getType()) + " " + ActionsExecGen.formatEntity(entity));
        }
        for (Entity entity : exec.getNeededEntities(true)) {
            if (!entity.isDefToBeYieldedTo()) continue;
            sourceBuilder.append(", ref " + this.formatType(entity.getType()) + " " + ActionsExecGen.formatEntity(entity));
        }
        sourceBuilder.append(") {\n");
        for (Entity entity : exec.getNeededEntities(true)) {
            if (!entity.isDefToBeYieldedTo()) continue;
            sourceBuilder.appendFront(ActionsExecGen.formatEntity(entity) + " = ");
            sourceBuilder.append(ActionsExecGen.getInitializationValue(entity.getType()) + ";\n");
            sourceBuilder.append(";\n");
        }
        sourceBuilder.appendFront("return true;\n");
        sourceBuilder.unindent();
        sourceBuilder.appendFront("}\n");
    }

    @Override
    protected void genQualAccess(SourceBuilder sourceBuilder, Qualification qualification, Object object) {
    }

    @Override
    protected void genMemberAccess(SourceBuilder sourceBuilder, Entity entity) {
    }
}

