/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.be.C;

import de.unika.ipd.grgen.Sys;
import de.unika.ipd.grgen.be.Backend;
import de.unika.ipd.grgen.be.BackendFactory;
import de.unika.ipd.grgen.be.C.MoreInformationCollector;
import de.unika.ipd.grgen.ir.Entity;
import de.unika.ipd.grgen.ir.Unit;
import de.unika.ipd.grgen.ir.executable.Rule;
import de.unika.ipd.grgen.ir.expr.Cast;
import de.unika.ipd.grgen.ir.expr.Constant;
import de.unika.ipd.grgen.ir.expr.Expression;
import de.unika.ipd.grgen.ir.expr.Operator;
import de.unika.ipd.grgen.ir.expr.Qualification;
import de.unika.ipd.grgen.ir.model.type.EdgeType;
import de.unika.ipd.grgen.ir.model.type.InheritanceType;
import de.unika.ipd.grgen.ir.model.type.NodeType;
import de.unika.ipd.grgen.ir.pattern.Edge;
import de.unika.ipd.grgen.ir.pattern.GraphEntity;
import de.unika.ipd.grgen.ir.pattern.Node;
import de.unika.ipd.grgen.ir.pattern.PatternGraphBase;
import de.unika.ipd.grgen.ir.pattern.PatternGraphLhs;
import de.unika.ipd.grgen.ir.stmt.Assignment;
import de.unika.ipd.grgen.ir.stmt.EvalStatement;
import de.unika.ipd.grgen.ir.stmt.EvalStatements;
import de.unika.ipd.grgen.ir.type.Type;
import java.io.File;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Set;

public class SearchPlanBackend
extends MoreInformationCollector
implements BackendFactory {
    private static final int nodesInUse = 1;
    private static final int edgesInUse = 2;
    private static final int MOD_DELETED = 4;
    private static final int MOD_ASSIGNED = 2;
    private static final int MOD_RETYPED = 1;
    private final String MODE_EDGE_NAME = "has_mode";
    private final String LS_MODE_EDGE_NAME = "has_ls_mode";
    protected final boolean emit_subgraph_info = false;
    NodeType MODE_TYPE;
    NodeType CONST_TYPE = null;
    NodeType COND_TYPE = null;
    NodeType VPROJ_TYPE = null;
    NodeType PROJ_TYPE = null;
    NodeType SYM_CONST = null;
    NodeType FRAMEADDR = null;
    NodeType MULTIPLE_ADD_TYPE = null;
    NodeType IA32_SUB = null;
    EdgeType DF = null;
    HashMap<Node, String> relatedNodes;
    private int uin = 0;

    private static String getOperatorSymbol(Operator.OperatorCode operatorCode) {
        switch (operatorCode) {
            case LOG_OR: {
                return "||";
            }
            case LOG_AND: {
                return "&&";
            }
            case BIT_OR: {
                return "|";
            }
            case BIT_XOR: {
                return "^";
            }
            case BIT_AND: {
                return "&";
            }
            case EQ: {
                return "==";
            }
            case NE: {
                return "!=";
            }
            case LT: {
                return "<";
            }
            case LE: {
                return "<=";
            }
            case GT: {
                return ">";
            }
            case GE: {
                return ">=";
            }
            case SHL: {
                return "<<";
            }
            case SHR: {
                return ">>";
            }
            case BIT_SHR: {
                return ">>";
            }
            case ADD: {
                return "+";
            }
            case SUB: {
                return "-";
            }
            case MUL: {
                return "*";
            }
            case DIV: {
                return "/";
            }
            case MOD: {
                return "%";
            }
        }
        throw new RuntimeException("internal failure");
    }

    @Override
    public Backend getBackend() {
        return this;
    }

    @Override
    public void init(Unit unit, Sys sys, File file) {
        super.init(unit, sys, file);
    }

    @Override
    public void generate() {
        PrintStream printStream = this.openFile("unit.mak");
        printStream.println("#\n# generated by grgen, don't edit\n#");
        printStream.println("UNIT_NAME = " + SearchPlanBackend.formatId(this.unit.getUnitName()));
        SearchPlanBackend.closeFile(printStream);
        System.out.println("The frame-based GrGen backend...");
        System.out.println("  generating the pattern...");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("/* generated by grgen, don't edit */\n\n");
        stringBuffer.append("#include <assert.h>\n");
        stringBuffer.append("#include \"config.h\"\n");
        stringBuffer.append("#include \"benode_t.h\"\n");
        stringBuffer.append("#include \"firm.h\"\n");
        stringBuffer.append("#include \"grs.h\"\n");
        stringBuffer.append("#include \"ia32_new_nodes.h\"\n");
        stringBuffer.append("#include \"ia32_getset.h\"\n");
        this.findModeType();
        this.findConstType();
        this.genTypes(stringBuffer);
        this.genPatterns(stringBuffer);
        this.genInterface(stringBuffer);
        this.writeFile("gen_patterns.c", stringBuffer);
        System.out.println("  generating XML overview...");
        printStream = this.openFile("overview.xml");
        this.writeOverview(printStream);
        SearchPlanBackend.closeFile(printStream);
        System.out.println("  done!");
    }

    public void findModeType() {
        for (NodeType nodeType : this.nodeTypeMap.keySet()) {
            if (!nodeType.getIdent().toString().equals("Mode")) continue;
            this.MODE_TYPE = nodeType;
            return;
        }
        System.out.println("Warning: MODE_TYPE not found!");
    }

    public void findConstType() {
        for (InheritanceType inheritanceType : this.nodeTypeMap.keySet()) {
            if (inheritanceType.getIdent().toString().equals("Const")) {
                this.CONST_TYPE = inheritanceType;
            }
            if (inheritanceType.getIdent().toString().equals("Cond")) {
                this.COND_TYPE = inheritanceType;
            }
            if (inheritanceType.getIdent().toString().equals("VProj")) {
                this.VPROJ_TYPE = inheritanceType;
            }
            if (inheritanceType.getIdent().toString().equals("Proj")) {
                this.PROJ_TYPE = inheritanceType;
            }
            if (inheritanceType.getIdent().toString().equals("MultipleAdd")) {
                this.MULTIPLE_ADD_TYPE = inheritanceType;
            }
            if (inheritanceType.getIdent().toString().equals("SymConst")) {
                this.SYM_CONST = inheritanceType;
            }
            if (inheritanceType.getIdent().toString().equals("ia32_Sub")) {
                this.IA32_SUB = inheritanceType;
            }
            if (!inheritanceType.getIdent().toString().equals("be_FrameAddr")) continue;
            this.FRAMEADDR = inheritanceType;
        }
        if (this.CONST_TYPE == null) {
            System.out.println("Warning: CONST_TYPE not found!");
        }
        if (this.VPROJ_TYPE == null) {
            System.out.println("Warning: VPROJ_TYPE not found!");
        }
        if (this.PROJ_TYPE == null) {
            System.out.println("Warning: PROJ_TYPE not found!");
        }
        if (this.IA32_SUB == null) {
            System.out.println("Warning: IA32_SUB not found!");
        }
        for (InheritanceType inheritanceType : this.edgeTypeMap.keySet()) {
            if (!inheritanceType.getIdent().toString().equals("df")) continue;
            this.DF = inheritanceType;
        }
        if (this.DF == null) {
            System.out.println("Warning: DF not found!");
        }
    }

    private void genTypes(StringBuffer stringBuffer) {
        String string = "\t";
        StringBuffer stringBuffer2 = new StringBuffer();
        stringBuffer.append("/* nodeTypeMap */ \n");
        stringBuffer2.append("/* init node ops and modes */\n");
        stringBuffer2.append("static void init(void) {\n");
        for (NodeType nodeType : this.nodeTypeMap.keySet()) {
            if (nodeType.isCastableTo(this.MODE_TYPE)) continue;
            String string2 = nodeType.getIdent().toString();
            stringBuffer.append("ir_op* grs_op_" + string2 + ";\n");
            stringBuffer2.append(string + "grs_op_" + string2 + " = ext_grs_lookup_op(\"" + string2 + "\");\n");
            stringBuffer2.append(string + "grs_op_" + string2 + " = grs_op_" + string2 + " ? grs_op_" + string2 + " : new_ir_op(get_next_ir_opcode(), \"" + string2 + "\", op_pin_state_pinned,  irop_flag_none, oparity_dynamic,  0, 0, NULL);\n");
        }
        stringBuffer.append("/* nodeTypeMap END */\n\n");
        stringBuffer2.append("} /* init node ops and modes */\n\n");
        stringBuffer.append(stringBuffer2);
    }

    private void genPatterns(StringBuffer stringBuffer) {
        String string = "\t";
        for (Rule rule : this.unit.getActionRules()) {
            if (rule.getRight() != null) {
                String string2 = rule.getIdent().toString();
                StringBuffer stringBuffer2 = new StringBuffer();
                IdGenerator<Node> idGenerator = new IdGenerator<Node>();
                IdGenerator<Edge> idGenerator2 = new IdGenerator<Edge>();
                stringBuffer2.append("/* functions for building the pattern of action " + string2 + " */\n");
                stringBuffer2.append("static INLINE ext_grs_action_t *grs_action_" + string2 + "_init(void) {\n");
                stringBuffer2.append(string + "ext_grs_action_t *act = ext_grs_new_action(ext_grs_k_rule, \"" + string2 + "\");\n");
                stringBuffer2.append(string + "int check;\n");
                this.genPattern(stringBuffer2, rule, idGenerator, idGenerator2);
                stringBuffer2.append(string + "return act;\n");
                stringBuffer2.append("} /* " + string2 + " */\n\n\n");
                this.genConditionFunctions(stringBuffer, string, string2, rule, idGenerator, idGenerator2);
                this.genEvalFunctions(stringBuffer, string, rule, idGenerator, idGenerator2);
                stringBuffer.append(stringBuffer2);
                continue;
            }
            throw new UnsupportedOperationException(rule.toString());
        }
    }

    private void genConditionFunctions(StringBuffer stringBuffer, String string, String string2, Rule rule, IdGenerator<Node> idGenerator, IdGenerator<Edge> idGenerator2) {
        stringBuffer.append("/* functions for evaluation of conditions of action " + string2 + " */\n");
        this.genConditionFunction(stringBuffer, string, rule.getLeft(), idGenerator, idGenerator2);
        for (PatternGraphLhs patternGraphLhs : rule.getLeft().getNegs()) {
            this.genConditionFunction(stringBuffer, string, patternGraphLhs, idGenerator, idGenerator2);
        }
        stringBuffer.append("\n");
    }

    private void genConditionFunction(StringBuffer stringBuffer, String string, PatternGraphLhs patternGraphLhs, IdGenerator<Node> idGenerator, IdGenerator<Edge> idGenerator2) {
        for (Expression expression : patternGraphLhs.getConditions()) {
            stringBuffer.append("static int grs_cond_func_" + expression.getId() + "(ir_node **pat_node_map, const ir_edge_t **edge_map) {\n");
            int n = this.getUnusedEvalParams(expression);
            if ((n & 1) == 0) {
                stringBuffer.append(string + "(void) pat_node_map;\n");
            }
            if ((n & 2) == 0) {
                stringBuffer.append(string + "(void) edge_map;\n");
            }
            stringBuffer.append(string + "return ");
            this.genConditionEval(stringBuffer, expression, idGenerator, idGenerator2);
            stringBuffer.append(";\n");
            stringBuffer.append("}\n");
        }
    }

    private int getUnusedEvalParams(Expression expression) {
        if (expression instanceof Operator) {
            Operator operator = (Operator)expression;
            switch (operator.arity()) {
                case 1: {
                    return this.getUnusedEvalParams(operator.getOperand(0));
                }
                case 2: {
                    return this.getUnusedEvalParams(operator.getOperand(0)) | this.getUnusedEvalParams(operator.getOperand(1));
                }
                case 3: {
                    if (operator.getOpCode() != Operator.OperatorCode.COND) break;
                    return this.getUnusedEvalParams(operator.getOperand(0)) | this.getUnusedEvalParams(operator.getOperand(1)) | this.getUnusedEvalParams(operator.getOperand(2));
                }
            }
        } else if (expression instanceof Qualification) {
            Qualification qualification = (Qualification)expression;
            Entity entity = qualification.getOwner();
            if (entity instanceof Node) {
                return 1;
            }
            if (entity instanceof Edge) {
                return 2;
            }
        }
        return 0;
    }

    private void genEvalFunctions(StringBuffer stringBuffer, String string, Rule rule, IdGenerator<Node> idGenerator, IdGenerator<Edge> idGenerator2) {
        stringBuffer.append("/* function to do eval assignments */\n");
        StringBuffer stringBuffer2 = new StringBuffer();
        StringBuffer stringBuffer3 = new StringBuffer();
        for (EvalStatements evalStatements : rule.getEvals()) {
            for (EvalStatement evalStatement : evalStatements.evalStatements) {
                GraphEntity graphEntity;
                if (!(evalStatement instanceof Assignment)) continue;
                Assignment assignment = (Assignment)evalStatement;
                Qualification qualification = assignment.getTarget();
                if (!(qualification instanceof Qualification)) {
                    throw new UnsupportedOperationException("The C backend only supports assignments to qualified expressions, yet!");
                }
                Qualification qualification2 = qualification;
                Entity entity = qualification2.getOwner();
                Entity entity2 = qualification2.getMember();
                Expression expression = assignment.getExpression();
                StringBuffer stringBuffer4 = new StringBuffer();
                stringBuffer3.append("static void grs_eval_out_func_" + assignment.getId() + "(ir_node ** const rpl_node_map, ir_edge_t ** const rpl_edge_map, ir_node **pat_node_map, ");
                if (assignment.getExpression().getType().classify() == Type.TypeClass.IS_INTEGER) {
                    stringBuffer3.append("int data) {\n");
                } else {
                    stringBuffer3.append("void *data) {\n");
                }
                stringBuffer3.append(string + "(void) pat_node_map;\n");
                stringBuffer3.append(string + "(void) rpl_edge_map;\n");
                stringBuffer3.append(string + "(void) data;\n");
                stringBuffer3.append(string + "set_grgen_" + entity2.getIdent() + "(");
                if (entity instanceof Node) {
                    graphEntity = (Node)entity;
                    stringBuffer3.append("rpl_node_map[" + ((IdGenerator)idGenerator).computeId(graphEntity) + "/* " + graphEntity.getIdent() + " */], ");
                } else if (entity instanceof Edge) {
                    graphEntity = (Edge)entity;
                    stringBuffer3.append("rpl_edge_map[" + ((IdGenerator)idGenerator2).computeId(graphEntity) + "/* " + graphEntity.getIdent() + " */], ");
                } else {
                    throw new UnsupportedOperationException("Unsupported Entity (" + entity + ")");
                }
                if (expression instanceof Constant) {
                    this.genConditionEval(stringBuffer4, expression, idGenerator, idGenerator2);
                    stringBuffer3.append(stringBuffer4);
                } else {
                    stringBuffer2.append("static void *grs_eval_in_func_" + assignment.getId() + "(ir_node ** const pat_node_map, ir_edge_t ** pat_edge_map) {\n");
                    stringBuffer2.append(string + "(void) pat_edge_map;\n");
                    stringBuffer2.append(string + "return (void*)");
                    this.genConditionEval(stringBuffer2, expression, idGenerator, idGenerator2);
                    stringBuffer2.append(";\n}\n\n");
                    stringBuffer3.append("data");
                }
                stringBuffer3.append(");\n}\n");
            }
        }
        stringBuffer.append(stringBuffer2);
        stringBuffer.append(stringBuffer3);
    }

    private static void registerEvalFunctions(StringBuffer stringBuffer, String string, Rule rule) {
        for (EvalStatements evalStatements : rule.getEvals()) {
            for (EvalStatement evalStatement : evalStatements.evalStatements) {
                if (!(evalStatement instanceof Assignment)) continue;
                Assignment assignment = (Assignment)evalStatement;
                stringBuffer.append(string + "ext_grs_act_register_eval(act, ");
                if (assignment.getExpression() instanceof Constant) {
                    stringBuffer.append("NULL");
                } else {
                    stringBuffer.append("(ext_grs_eval_in_func_t) &grs_eval_in_func_" + assignment.getId());
                }
                stringBuffer.append(", (ext_grs_eval_out_func_t) &grs_eval_out_func_" + assignment.getId() + ");\n");
            }
        }
    }

    private void genPattern(StringBuffer stringBuffer, Rule rule, IdGenerator<Node> idGenerator, IdGenerator<Edge> idGenerator2) {
        String string = "\t";
        stringBuffer.append(string + "{ /* The action */\n");
        this.genPatternGraph(stringBuffer, string + "\t", "ext_grs_act_get_pattern", rule.getLeft(), idGenerator, idGenerator2, GraphType.Pattern, rule);
        stringBuffer.append(string + "  /* The negative parts of the pattern */\n");
        int n = 0;
        for (PatternGraphLhs patternGraphLhs : rule.getLeft().getNegs()) {
            stringBuffer.append(string + "  { /* NAC " + n + "  */\n");
            this.genPatternGraph(stringBuffer, string + "    ", "ext_grs_act_impose_negative", patternGraphLhs, idGenerator, idGenerator2, GraphType.Negative, rule);
            stringBuffer.append(string + "  } /* NAC " + n + "  */\n");
            stringBuffer.append("\n");
            ++n;
        }
        stringBuffer.append("\n\n");
        stringBuffer.append(string + "  { /* The replacement */\n");
        this.genGraph(stringBuffer, string + "     ", "ext_grs_act_get_replacement", rule.getRight(), idGenerator, idGenerator2, GraphType.Replacement, rule);
        stringBuffer.append(string + "  } /* The replacement */\n\n");
        stringBuffer.append(string + "  /* Eval functions */\n");
        SearchPlanBackend.registerEvalFunctions(stringBuffer, string + "\t", rule);
        stringBuffer.append(string + "check = ext_grs_act_mature(act);\n");
        stringBuffer.append(string + "assert(check);\n");
        SearchPlanBackend.genHom(stringBuffer, rule.getLeft(), idGenerator, idGenerator2, rule);
        stringBuffer.append(string + "} /* The Action */\n\n");
    }

    private void genPatternGraph(StringBuffer stringBuffer, String string, String string2, PatternGraphLhs patternGraphLhs, IdGenerator<Node> idGenerator, IdGenerator<Edge> idGenerator2, GraphType graphType, Rule rule) {
        this.genGraph(stringBuffer, string, string2, patternGraphLhs, idGenerator, idGenerator2, graphType, rule);
        this.genConditions(stringBuffer, string, patternGraphLhs);
    }

    private static void genHom(StringBuffer stringBuffer, PatternGraphLhs patternGraphLhs, IdGenerator<Node> idGenerator, IdGenerator<Edge> idGenerator2, Rule rule) {
        for (Node node : patternGraphLhs.getNodes()) {
            for (Node node2 : patternGraphLhs.getNodes()) {
                if (node == node2 || !patternGraphLhs.isHomomorphic(node, node2)) continue;
                stringBuffer.append("ext_grs_act_allow_nodes_hom(");
                stringBuffer.append("n_" + node.getIdent() + ", n_" + node2.getIdent() + ");\n");
            }
        }
    }

    private void genGraph(StringBuffer stringBuffer, String string, String string2, PatternGraphBase patternGraphBase, IdGenerator<Node> idGenerator, IdGenerator<Edge> idGenerator2, GraphType graphType, Rule rule) {
        stringBuffer.append(string + "ext_grs_graph_t *pattern = " + string2 + "(act);\n\n");
        this.relatedNodes = new HashMap();
        this.genPatternNodes(stringBuffer, string, patternGraphBase, idGenerator, graphType, rule);
        stringBuffer.append("\n");
        this.genPatternEdges(stringBuffer, string, patternGraphBase, idGenerator2, graphType);
        this.relatedNodes.clear();
    }

    private void genPatternNodes(StringBuffer stringBuffer, String string, PatternGraphBase patternGraphBase, IdGenerator<Node> idGenerator, GraphType graphType, Rule rule) {
        stringBuffer.append(string + "/* The nodes of the pattern */\n");
        for (Node node : patternGraphBase.getNodes()) {
            String string2;
            String string3;
            int n;
            if (node.getNodeType().isCastableTo(this.MODE_TYPE)) continue;
            boolean bl = false;
            String string4 = "";
            if (((IdGenerator)idGenerator).isKnown(node)) {
                string4 = "_" + this.uin;
                ++this.uin;
                bl = true;
            }
            if (node.getRetypedNode(patternGraphBase) == null || graphType != GraphType.Replacement) {
                n = ((IdGenerator)idGenerator).computeId(node);
                string3 = node.getIdent().toString() + string4;
                string2 = node.getNodeType().getIdent().toString();
            } else {
                n = ((IdGenerator)idGenerator).computeId(node.getRetypedNode(patternGraphBase));
                string3 = node.getRetypedNode(patternGraphBase).getIdent().toString() + string4;
                string2 = node.getRetypedNode(patternGraphBase).getNodeType().getIdent().toString();
            }
            String string5 = "ANY";
            String string6 = "ANY";
            String string7 = "new_rd_" + string2;
            String[] stringArray = new String[]{"ia32_", "arm_", "mips_", "ppc32_"};
            for (String string8 : stringArray) {
                if (!string2.startsWith(string8)) continue;
                string7 = "new_bd_" + string2;
            }
            if (string2.equals("IR_node")) {
                string7 = "new_ir_node";
            }
            for (Edge edge : patternGraphBase.getOutgoing(node)) {
                Node node2;
                Node node3;
                if (edge.getEdgeType().getIdent().toString().equals("has_mode") && null != (node3 = patternGraphBase.getTarget(edge)) && (string5.equals("ANY") || !rule.getCommonEdges().contains(edge))) {
                    string5 = node3.getNodeType().getIdent().toString().substring(5);
                }
                if (!edge.getEdgeType().getIdent().toString().equals("has_ls_mode") || null == (node2 = patternGraphBase.getTarget(edge))) continue;
                string6 = node2.getNodeType().getIdent().toString().substring(5);
            }
            string3 = string3.replace('$', '_');
            if (!bl) {
                stringBuffer.append(string + "ext_grs_node_t *n_" + string3 + " = ext_grs_act_add_node(pattern, \"" + string3 + "\", grs_op_" + string2 + ", mode_" + string5 + ", mode_" + string6 + ", " + n + ", &" + string7 + ", " + SearchPlanBackend.getModifiedFlags(rule, node) + ");\n");
                continue;
            }
            String string9 = node.getIdent().toString();
            stringBuffer.append(string + "ext_grs_node_t *n_" + string3 + " = ");
            if (graphType == GraphType.Negative) {
                stringBuffer.append("ext_grs_act_add_related_node(pattern, \"" + string3 + "\", mode_" + string5 + ", mode_" + string6 + ", n_" + (String)string9 + ", " + idGenerator.getNewKey());
            } else {
                stringBuffer.append("ext_grs_act_add_node_to_keep(pattern, \"" + string3 + "\", grs_op_" + string2 + ", mode_" + string5 + ", mode_" + string6 + ", " + n + ", n_" + (String)string9 + ", &" + string7 + ", " + SearchPlanBackend.getModifiedFlags(rule, node));
            }
            stringBuffer.append(");\n");
            stringBuffer.append(string + "(void) n_" + string3 + ";\n");
            this.relatedNodes.put(node, string3);
        }
    }

    private static int getModifiedFlags(Rule rule, Node node) {
        int n = 0;
        if (node.isRetyped() || node.getRetypedEntity(rule.getRight()) != null) {
            n |= 1;
        }
        if (!rule.getCommonNodes().contains(node)) {
            n |= 4;
        }
        for (EvalStatements evalStatements : rule.getEvals()) {
            for (EvalStatement evalStatement : evalStatements.evalStatements) {
                if (!(evalStatement instanceof Assignment)) continue;
                Assignment assignment = (Assignment)evalStatement;
                Qualification qualification = assignment.getTarget();
                if (!(qualification instanceof Qualification)) {
                    throw new UnsupportedOperationException("The C backend only supports assignments to qualified expressions, yet!");
                }
                Qualification qualification2 = qualification;
                if (qualification2.getOwner().compareTo(node) != 0) continue;
                n |= 2;
            }
        }
        return n;
    }

    private void genPatternEdges(StringBuffer stringBuffer, String string, PatternGraphBase patternGraphBase, IdGenerator<Edge> idGenerator, GraphType graphType) {
        stringBuffer.append(string + "/* The edges of the pattern */\n");
        for (Edge edge : patternGraphBase.getEdges()) {
            if (edge.getEdgeType().getIdent().toString().equals("has_mode") || edge.getEdgeType().getIdent().toString().equals("has_ls_mode")) continue;
            String string2 = "";
            boolean bl = false;
            if (((IdGenerator)idGenerator).isKnown(edge)) {
                string2 = "_" + this.uin;
                ++this.uin;
                bl = true;
            } else if (graphType != GraphType.Pattern) {
                string2 = "_" + this.uin;
                ++this.uin;
            }
            int n = ((IdGenerator)idGenerator).computeId(edge);
            String string3 = "ext_grs_NO_EDGE_POS";
            String string4 = edge.getIdent().toString().replace('$', '_') + string2;
            if (string4.length() > 4 && string4.substring(0, 4).matches("pos[0123456789]")) {
                string3 = edge.getIdent().toString().substring(3, 4);
            }
            if (edge.getEdgeType().getIdent().toString().equals("dep")) {
                string3 = "ext_grs_DEPENDENCY_EDGE_POS";
            }
            Node node = patternGraphBase.getSource(edge);
            Node node2 = patternGraphBase.getTarget(edge);
            String string5 = "";
            String string6 = "";
            string5 = this.relatedNodes.containsKey(node) ? this.relatedNodes.get(node) : node.getIdent().toString();
            string6 = this.relatedNodes.containsKey(node2) ? this.relatedNodes.get(node2) : node2.getIdent().toString();
            string5 = string5.replace('$', '_');
            string6 = string6.replace('$', '_');
            if (!bl) {
                stringBuffer.append(string + "ext_grs_edge_t *e_" + string4 + " = ext_grs_act_add_edge(pattern, \"" + string4 + "\", " + string3 + ", n_" + string6 + ", n_" + string5 + ", " + n + ");\n");
                stringBuffer.append(string + "(void) e_" + string4 + ";\n");
                continue;
            }
            String string7 = graphType == GraphType.Negative ? "ext_grs_act_add_related_edge" : "ext_grs_act_add_edge_to_keep";
            String string8 = edge.getIdent().toString().replace('$', '_');
            stringBuffer.append(string + "ext_grs_edge_t *e_" + string4 + " = " + string7 + "(pattern, \"" + string4 + "\", " + string3 + ", n_" + string6 + ", n_" + string5 + ", " + n + ", e_" + string8 + ");\n");
            stringBuffer.append(string + "(void) e_" + string4 + ";\n");
        }
        stringBuffer.append("\n");
    }

    private void genConditions(StringBuffer stringBuffer, String string, PatternGraphLhs patternGraphLhs) {
        stringBuffer.append(string + "/* The conditions of the pattern */\n");
        for (Expression expression : patternGraphLhs.getConditions()) {
            String string2 = string + "\t";
            HashSet<Node> hashSet = new HashSet<Node>();
            HashSet<Edge> hashSet2 = new HashSet<Edge>();
            this.collectNodesnEdges(hashSet, hashSet2, expression);
            stringBuffer.append(string + "{ /* if */\n");
            if (hashSet.size() > 0) {
                stringBuffer.append(string2 + "ext_grs_node_t *nodes[" + hashSet.size() + "] = ");
                SearchPlanBackend.genSet(stringBuffer, hashSet);
            } else {
                stringBuffer.append(string2 + "ext_grs_node_t **nodes = NULL");
            }
            stringBuffer.append(";\n");
            if (hashSet2.size() > 0) {
                stringBuffer.append(string2 + "ext_grs_edge_t *edges[" + hashSet2.size() + "] = ");
                SearchPlanBackend.genSet(stringBuffer, hashSet2);
            } else {
                stringBuffer.append(string2 + "ext_grs_edge_t **edges = NULL");
            }
            stringBuffer.append(";\n\n");
            stringBuffer.append(string2 + "ext_grs_act_register_condition(grs_cond_func_" + expression.getId() + ", pattern, " + hashSet.size() + ", nodes, " + hashSet2.size() + ", edges);\n");
            stringBuffer.append(string + "} /* if */\n\n");
        }
    }

    private static void genSet(StringBuffer stringBuffer, Set<? extends Entity> set) {
        stringBuffer.append('{');
        String string = "";
        for (Entity entity : set) {
            stringBuffer.append(string);
            if (entity instanceof Node) {
                stringBuffer.append("n_" + entity.getIdent().toString());
            } else if (entity instanceof Edge) {
                stringBuffer.append("e_" + entity.getIdent().toString());
            } else {
                stringBuffer.append(entity.getIdent().toString());
            }
            string = ", ";
        }
        stringBuffer.append('}');
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void collectNodesnEdges(Set<Node> set, Set<Edge> set2, Expression expression) {
        if (expression instanceof Qualification) {
            Entity entity = ((Qualification)expression).getOwner();
            if (entity instanceof Node) {
                set.add((Node)entity);
                return;
            } else {
                if (!(entity instanceof Edge)) throw new UnsupportedOperationException("Unsupported Entity (" + entity + ")");
                set2.add((Edge)entity);
            }
            return;
        } else {
            if (!(expression instanceof Operator)) return;
            for (Expression expression2 : ((Operator)expression).getWalkableChildren()) {
                this.collectNodesnEdges(set, set2, expression2);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void genConditionEval(StringBuffer stringBuffer, Expression expression, IdGenerator<Node> idGenerator, IdGenerator<Edge> idGenerator2) {
        if (expression instanceof Operator) {
            Operator operator = (Operator)expression;
            switch (operator.arity()) {
                case 1: {
                    this.genConditionEval(stringBuffer, operator.getOperand(0), idGenerator, idGenerator2);
                    return;
                }
                case 2: {
                    this.genConditionEval(stringBuffer, operator.getOperand(0), idGenerator, idGenerator2);
                    stringBuffer.append(" " + SearchPlanBackend.getOperatorSymbol(operator.getOpCode()) + " ");
                    this.genConditionEval(stringBuffer, operator.getOperand(1), idGenerator, idGenerator2);
                    return;
                }
                case 3: {
                    if (operator.getOpCode() != Operator.OperatorCode.COND) throw new UnsupportedOperationException("Unsupported Operation arrity (" + operator.arity() + ")");
                    stringBuffer.append("(");
                    this.genConditionEval(stringBuffer, operator.getOperand(0), idGenerator, idGenerator2);
                    stringBuffer.append(") ? (");
                    this.genConditionEval(stringBuffer, operator.getOperand(1), idGenerator, idGenerator2);
                    stringBuffer.append(") : (");
                    this.genConditionEval(stringBuffer, operator.getOperand(2), idGenerator, idGenerator2);
                    stringBuffer.append(")");
                    return;
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported Operation arrity (" + operator.arity() + ")");
                }
            }
        } else if (expression instanceof Qualification) {
            Qualification qualification = (Qualification)expression;
            Entity entity = qualification.getOwner();
            if (entity instanceof Node) {
                Node node = (Node)entity;
                if (node.getNodeType().isCastableTo(this.VPROJ_TYPE)) {
                    stringBuffer.append("get_VProj_proj(pat_node_map[" + ((IdGenerator)idGenerator).computeId(node) + "/* " + entity.getIdent() + " */])");
                    return;
                } else if (node.getNodeType().isCastableTo(this.MULTIPLE_ADD_TYPE)) {
                    stringBuffer.append("get_irn_arity(pat_node_map[" + ((IdGenerator)idGenerator).computeId(node) + "/* " + entity.getIdent() + " */])");
                    return;
                } else if (node.getNodeType().isCastableTo(this.SYM_CONST)) {
                    stringBuffer.append("get_SymConst_entity(pat_node_map[" + ((IdGenerator)idGenerator).computeId(node) + "/* " + entity.getIdent() + " */])");
                    return;
                } else if (node.getNodeType().isCastableTo(this.COND_TYPE)) {
                    stringBuffer.append("get_Cond_default_proj(pat_node_map[" + ((IdGenerator)idGenerator).computeId(node) + "/* " + entity.getIdent() + " */])");
                    return;
                } else {
                    String string = qualification.getMember().getIdent().toString();
                    stringBuffer.append("get_grgen_" + string + "(pat_node_map[" + ((IdGenerator)idGenerator).computeId(node) + "/* " + entity.getIdent() + " */])");
                }
                return;
            } else {
                if (!(entity instanceof Edge)) throw new UnsupportedOperationException("Unsupported Entity (" + entity + ")");
                if (!qualification.getMember().getIdent().toString().equals("pos")) throw new UnsupportedOperationException("Unsupported Edge attribute (" + entity + ")");
                stringBuffer.append("get_edge_src_pos(edge_map[" + ((IdGenerator)idGenerator2).computeId((Edge)entity) + "/* " + entity.getIdent() + " */])");
            }
            return;
        } else if (expression instanceof Constant) {
            Constant constant = (Constant)expression;
            Type type = constant.getType();
            switch (type.classify()) {
                case IS_STRING: {
                    stringBuffer.append(constant.getValue().toString());
                    return;
                }
                case IS_BOOLEAN: {
                    Boolean bl = (Boolean)constant.getValue();
                    if (bl.booleanValue()) {
                        stringBuffer.append("1");
                        return;
                    }
                    stringBuffer.append("0");
                    return;
                }
                case IS_INTEGER: {
                    stringBuffer.append(constant.getValue().toString());
                    return;
                }
            }
            return;
        } else {
            if (!(expression instanceof Cast)) throw new UnsupportedOperationException("Unsupported expression type (" + expression + ")");
            Cast cast = (Cast)expression;
            this.genConditionEval(stringBuffer, cast.getExpression(), idGenerator, idGenerator2);
        }
    }

    private void genInterface(StringBuffer stringBuffer) {
        String string;
        String string2 = "\t";
        StringBuffer stringBuffer2 = new StringBuffer();
        StringBuffer stringBuffer3 = new StringBuffer();
        String string3 = this.unit.getUnitName();
        stringBuffer2.append("static int init_firm_actions_done = 0;\n");
        stringBuffer2.append("/* function for initializing the actions */\n");
        stringBuffer3.append("/* array of all actions */\n");
        int n = this.unit.getActionRules().size();
        stringBuffer3.append("unsigned int ext_grs_all_actions_count = " + n + ";\n");
        stringBuffer3.append("ext_grs_action_t **ext_grs_all_actions[" + n + "] = {\n");
        stringBuffer.append("/* global variables containing the actions */\n");
        stringBuffer2.append("void ext_grs_action_init_" + string3 + "(void) {\n");
        stringBuffer2.append("if (init_firm_actions_done) return;\n");
        stringBuffer2.append("init_firm_actions_done = 1;\n");
        stringBuffer2.append(string2 + "init();\n");
        for (Rule identifiable : this.unit.getActionRules()) {
            if (identifiable.getRight() == null) continue;
            string = identifiable.getIdent().toString();
            String string4 = "ext_grs_action_" + string3 + "_" + string;
            stringBuffer2.append(string2 + (String)string4 + " = grs_action_" + string + "_init();\n");
            stringBuffer.append("ext_grs_action_t *" + (String)string4 + ";\n");
            stringBuffer3.append(string2 + "&" + (String)string4 + ",\n");
        }
        stringBuffer2.append("\n" + string2 + "/* establish inheritance */\n");
        for (InheritanceType inheritanceType : this.nodeTypeMap.keySet()) {
            if (inheritanceType.isCastableTo(this.MODE_TYPE)) continue;
            string = inheritanceType.getIdent().toString();
            for (InheritanceType inheritanceType2 : inheritanceType.getAllSuperTypes()) {
                stringBuffer2.append(string2 + "ext_grs_appoint_heir(grs_op_" + string + ", grs_op_" + inheritanceType2.getIdent() + ");\n");
            }
            stringBuffer2.append("\n");
        }
        stringBuffer.append("\n" + stringBuffer3 + "};\n");
        stringBuffer2.append(string2 + "ext_grs_inheritance_mature();\n");
        stringBuffer2.append(string2 + "return;\n");
        stringBuffer2.append("}\n\n");
        for (Rule rule : this.unit.getActionRules()) {
            if (rule.getRight() == null) continue;
            string = rule.getIdent().toString();
            stringBuffer2.append("/* functions for building the pattern of action " + string + " */\n");
            stringBuffer2.append("static INLINE void grs_action_" + string + "_del(void) {\n");
            stringBuffer2.append(string2 + "ext_grs_del_action(ext_grs_action_" + this.unit.getUnitName() + "_" + string + ");\n");
            stringBuffer2.append(string2 + "return;\n");
            stringBuffer2.append("} /* " + string + " */\n\n\n");
        }
        stringBuffer2.append("void ext_grs_action_del_" + string3 + "(void) {\n");
        stringBuffer2.append("if(!init_firm_actions_done) return;\n");
        stringBuffer2.append("init_firm_actions_done = 0;\n");
        for (Rule rule : this.unit.getActionRules()) {
            if (rule.getRight() == null) continue;
            string = rule.getIdent().toString();
            stringBuffer2.append(string2 + "grs_action_" + string + "_del();\n");
        }
        stringBuffer2.append(string2 + "return;\n");
        stringBuffer2.append("}\n\n");
        stringBuffer.append("\n" + stringBuffer2);
    }

    private class IdGenerator<T> {
        LinkedHashMap<T, Integer> idMap = new LinkedHashMap();
        int offset = 0;

        private IdGenerator() {
        }

        public int getNewKey() {
            ++this.offset;
            return this.getMaxIndex();
        }

        private int computeId(T t) {
            if (!this.idMap.containsKey(t)) {
                this.idMap.put(t, this.getMaxIndex() + 1);
            }
            return this.idMap.get(t);
        }

        private boolean isKnown(T t) {
            return this.idMap.containsKey(t);
        }

        public int getMaxIndex() {
            return this.idMap.size() + this.offset - 1;
        }
    }

    private static enum GraphType {
        Pattern,
        Negative,
        Replacement;

    }
}

