/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.util;

import de.unika.ipd.grgen.ast.BaseNode;
import de.unika.ipd.grgen.ast.IdentNode;
import de.unika.ipd.grgen.ast.PackageIdentNode;
import de.unika.ipd.grgen.ast.ScopeOwner;
import de.unika.ipd.grgen.ast.decl.DeclNode;
import de.unika.ipd.grgen.ast.decl.executable.ActionDeclNode;
import de.unika.ipd.grgen.ast.decl.executable.TopLevelMatcherDeclNode;
import de.unika.ipd.grgen.ast.decl.pattern.IteratedDeclNode;
import de.unika.ipd.grgen.ast.model.decl.MemberDeclNode;
import de.unika.ipd.grgen.ast.model.type.InheritanceTypeNode;
import de.unika.ipd.grgen.ast.type.CompoundTypeNode;
import de.unika.ipd.grgen.ast.type.DefinedMatchTypeNode;
import de.unika.ipd.grgen.ast.type.MatchTypeActionNode;
import de.unika.ipd.grgen.ast.type.MatchTypeIteratedNode;
import de.unika.ipd.grgen.ast.type.TypeNode;
import de.unika.ipd.grgen.util.Base;

public abstract class Resolver<T>
extends Base {
    public abstract T resolve(BaseNode var1, BaseNode var2);

    public static boolean resolveOwner(PackageIdentNode packageIdentNode) {
        if (packageIdentNode.getOwnerSymbol().toString().equals("global")) {
            return true;
        }
        DeclNode declNode = packageIdentNode.getOwnerDecl();
        if (declNode == null) {
            packageIdentNode.reportError("Failure in resolving package of " + packageIdentNode + ".");
            return false;
        }
        boolean bl = declNode.resolve();
        if (!bl) {
            packageIdentNode.reportError("Failure in resolving package of " + packageIdentNode + ".");
            return false;
        }
        TypeNode typeNode = declNode.getDeclType();
        if (typeNode == null) {
            packageIdentNode.reportError("Failure in resolving package of " + packageIdentNode + ".");
            return false;
        }
        if (!(typeNode instanceof CompoundTypeNode)) {
            packageIdentNode.reportError("Failure in resolving package of " + packageIdentNode + ".");
            return false;
        }
        CompoundTypeNode compoundTypeNode = (CompoundTypeNode)typeNode;
        bl = compoundTypeNode.fixupDefinition(packageIdentNode);
        if (!bl) {
            packageIdentNode.reportError("Failure in resolving the member in the package, regarding " + packageIdentNode + ".");
            return false;
        }
        return true;
    }

    public static DeclNode resolveMember(TypeNode typeNode, IdentNode identNode) {
        DeclNode declNode = null;
        String string = identNode.toString();
        if (typeNode instanceof MatchTypeIteratedNode) {
            MatchTypeIteratedNode matchTypeIteratedNode = (MatchTypeIteratedNode)typeNode;
            if (!matchTypeIteratedNode.resolve()) {
                return null;
            }
            TopLevelMatcherDeclNode topLevelMatcherDeclNode = matchTypeIteratedNode.getTopLevelMatcher();
            IteratedDeclNode iteratedDeclNode = matchTypeIteratedNode.getIterated();
            declNode = matchTypeIteratedNode.tryGetMember(identNode.toString());
            if (declNode == null) {
                String string2 = topLevelMatcherDeclNode.getIdentNode().toString();
                String string3 = iteratedDeclNode.getIdentNode().toString();
                identNode.reportError("Unknown member " + string + " in match<" + string2 + "." + string3 + ">.");
            }
        } else if (typeNode instanceof MatchTypeActionNode) {
            MatchTypeActionNode matchTypeActionNode = (MatchTypeActionNode)typeNode;
            if (!matchTypeActionNode.resolve()) {
                return null;
            }
            ActionDeclNode actionDeclNode = matchTypeActionNode.getAction();
            declNode = matchTypeActionNode.tryGetMember(identNode.toString());
            if (declNode == null) {
                String string4 = actionDeclNode.getIdentNode().toString();
                identNode.reportError("Unknown member " + string + " in match< " + string4 + ">.");
            }
        } else if (typeNode instanceof DefinedMatchTypeNode) {
            DefinedMatchTypeNode definedMatchTypeNode = (DefinedMatchTypeNode)typeNode;
            if (!definedMatchTypeNode.resolve()) {
                return null;
            }
            declNode = definedMatchTypeNode.tryGetMember(identNode.toString());
            if (declNode == null) {
                String string5 = definedMatchTypeNode.getTypeName();
                identNode.reportError("Unknown member " + string + " in match<class " + string5 + ">.");
            }
        } else if (typeNode instanceof InheritanceTypeNode) {
            ScopeOwner scopeOwner = (ScopeOwner)((Object)typeNode);
            scopeOwner.fixupDefinition(identNode);
            InheritanceTypeNode inheritanceTypeNode = (InheritanceTypeNode)typeNode;
            declNode = (MemberDeclNode)inheritanceTypeNode.tryGetMember(identNode.getIdent().toString());
            if (declNode == null) {
                String string6 = inheritanceTypeNode.getKind();
                String string7 = inheritanceTypeNode.getTypeName();
                identNode.reportError("Unknown member " + string + " in " + string6 + " " + string7 + ".");
            }
        } else {
            identNode.reportError("The type " + typeNode + " does not support members (when accessing " + string + " of the " + typeNode.getKind() + ").");
        }
        return declNode;
    }
}

