/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.util;

import de.unika.ipd.grgen.ast.BaseNode;
import de.unika.ipd.grgen.ast.IdentNode;
import de.unika.ipd.grgen.ast.decl.DeclNode;
import de.unika.ipd.grgen.ast.decl.InvalidDeclNode;
import de.unika.ipd.grgen.ast.decl.executable.FilterFunctionDeclNode;
import de.unika.ipd.grgen.ast.decl.executable.FunctionDeclNode;
import de.unika.ipd.grgen.ast.decl.executable.MatcherDeclNode;
import de.unika.ipd.grgen.ast.decl.executable.ProcedureDeclNode;
import de.unika.ipd.grgen.ast.decl.executable.SequenceDeclNode;
import de.unika.ipd.grgen.ast.model.type.EnumTypeNode;
import de.unika.ipd.grgen.ast.model.type.InheritanceTypeNode;
import de.unika.ipd.grgen.util.Base;
import de.unika.ipd.grgen.util.Util;
import java.util.Map;
import java.util.Vector;

public class MemberResolver<T>
extends Base {
    private BaseNode orginalNode;
    private BaseNode unresolvedNode;
    private T resolvedNode;
    private Vector<Class<? extends T>> triedClasses = new Vector();
    private int validClasses;

    public boolean resolve(BaseNode baseNode) {
        this.triedClasses.clear();
        this.validClasses = 0;
        this.orginalNode = baseNode;
        if (!(this.orginalNode instanceof IdentNode)) {
            this.unresolvedNode = this.orginalNode;
            return true;
        }
        IdentNode identNode = (IdentNode)this.orginalNode;
        this.unresolvedNode = identNode.getDecl();
        if (this.unresolvedNode instanceof InvalidDeclNode) {
            DeclNode declNode = identNode.getScope().getIdentNode().getDecl();
            if (declNode instanceof MatcherDeclNode || declNode instanceof SequenceDeclNode || declNode instanceof ProcedureDeclNode || declNode instanceof FunctionDeclNode || declNode instanceof FilterFunctionDeclNode || declNode instanceof InvalidDeclNode) {
                identNode.reportError("Undefined identifier " + identNode + ".");
                return false;
            }
            if (declNode.getDeclType() instanceof EnumTypeNode) {
                identNode.reportError("Resolving failure, see error messages before; unexpected enum member " + identNode.toString() + " of " + declNode.getDeclType().toStringWithDeclarationCoords() + ".");
                return false;
            }
            InheritanceTypeNode inheritanceTypeNode = (InheritanceTypeNode)declNode.getDeclType();
            Map<String, DeclNode> map = inheritanceTypeNode.getAllMembers();
            this.unresolvedNode = map.get(identNode.toString());
            if (this.unresolvedNode == null) {
                identNode.reportError("Undefined member " + identNode + " of " + inheritanceTypeNode.toStringWithDeclarationCoords() + ".");
                return false;
            }
        }
        return true;
    }

    public T getResult() {
        return this.resolvedNode;
    }

    public <S extends T> S getResult(Class<S> clazz) {
        this.triedClasses.add(clazz);
        if (clazz.isInstance(this.unresolvedNode)) {
            ++this.validClasses;
            this.resolvedNode = clazz.cast(this.unresolvedNode);
            return clazz.cast(this.unresolvedNode);
        }
        return null;
    }

    public void failed() {
        Class[] classArray = new Class[this.triedClasses.size()];
        this.orginalNode.reportError(this.orginalNode + " is a " + this.orginalNode.getKind() + " but a " + Util.getStrListWithOr(this.triedClasses.toArray(classArray), BaseNode.class, "getKindStr") + " is expected.");
    }

    public boolean finish() {
        if (this.validClasses == 1) {
            return true;
        }
        this.failed();
        return false;
    }
}

