/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.util;

import de.unika.ipd.grgen.ast.BaseNode;
import de.unika.ipd.grgen.ast.IdentNode;
import de.unika.ipd.grgen.ast.PackageIdentNode;
import de.unika.ipd.grgen.ast.decl.DeclNode;
import de.unika.ipd.grgen.ast.util.Resolver;
import de.unika.ipd.grgen.ast.util.Triple;
import de.unika.ipd.grgen.util.Util;

public class DeclarationTripleResolver<R extends BaseNode, S extends BaseNode, T extends BaseNode>
extends Resolver<Triple<R, S, T>> {
    private Class<R> clsR;
    private Class<S> clsS;
    private Class<T> clsT;
    private Class<?>[] classes;

    public DeclarationTripleResolver(Class<R> clazz, Class<S> clazz2, Class<T> clazz3) {
        this.clsR = clazz;
        this.clsS = clazz2;
        this.clsT = clazz3;
        this.classes = new Class[]{this.clsR, this.clsS, this.clsT};
    }

    @Override
    public Triple<R, S, T> resolve(BaseNode baseNode, BaseNode baseNode2) {
        if (baseNode instanceof IdentNode) {
            Triple<R, S, T> triple = this.resolve((IdentNode)baseNode);
            if (triple != null) {
                assert ((triple.first == null ? 0 : 1) + (triple.second == null ? 0 : 1) + (triple.third == null ? 0 : 1) == 1);
                baseNode2.becomeParent(triple.first);
                baseNode2.becomeParent(triple.second);
                baseNode2.becomeParent(triple.third);
            }
            return triple;
        }
        Triple triple = new Triple();
        if (this.clsR.isInstance(baseNode)) {
            triple.first = (BaseNode)this.clsR.cast(baseNode);
        }
        if (this.clsS.isInstance(baseNode)) {
            triple.second = (BaseNode)this.clsS.cast(baseNode);
        }
        if (this.clsT.isInstance(baseNode)) {
            triple.third = (BaseNode)this.clsT.cast(baseNode);
        }
        if (triple.first != null || triple.second != null || triple.third != null) {
            assert ((triple.first == null ? 0 : 1) + (triple.second == null ? 0 : 1) + (triple.third == null ? 0 : 1) == 1);
            return triple;
        }
        baseNode.reportError(baseNode + " is a " + baseNode.getKind() + " but a " + Util.getStrListWithOr(this.classes, BaseNode.class, "getKindStr") + " is expected.");
        return null;
    }

    private Triple<R, S, T> resolve(IdentNode identNode) {
        if (identNode instanceof PackageIdentNode && !DeclarationTripleResolver.resolveOwner((PackageIdentNode)identNode)) {
            return null;
        }
        Triple triple = new Triple();
        DeclNode declNode = identNode.getDecl();
        if (this.clsR.isInstance(declNode)) {
            triple.first = (BaseNode)this.clsR.cast(declNode);
        }
        if (this.clsS.isInstance(declNode)) {
            triple.second = (BaseNode)this.clsS.cast(declNode);
        }
        if (this.clsT.isInstance(declNode)) {
            triple.third = (BaseNode)this.clsT.cast(declNode);
        }
        if (triple.first != null || triple.second != null || triple.third != null) {
            return triple;
        }
        identNode.reportError(identNode + " is a " + declNode.getKind() + " but a " + Util.getStrListWithOr(this.classes, BaseNode.class, "getKindStr") + " is expected.");
        return null;
    }
}

