/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.util;

import de.unika.ipd.grgen.ast.BaseNode;
import de.unika.ipd.grgen.ast.IdentNode;
import de.unika.ipd.grgen.ast.PackageIdentNode;
import de.unika.ipd.grgen.ast.decl.DeclNode;
import de.unika.ipd.grgen.ast.util.Quadruple;
import de.unika.ipd.grgen.ast.util.Resolver;
import de.unika.ipd.grgen.util.Util;

public class DeclarationQuadrupleResolver<R extends BaseNode, S extends BaseNode, T extends BaseNode, U extends BaseNode>
extends Resolver<Quadruple<R, S, T, U>> {
    private Class<R> clsR;
    private Class<S> clsS;
    private Class<T> clsT;
    private Class<U> clsU;
    private Class<?>[] classes;

    public DeclarationQuadrupleResolver(Class<R> clazz, Class<S> clazz2, Class<T> clazz3, Class<U> clazz4) {
        this.clsR = clazz;
        this.clsS = clazz2;
        this.clsT = clazz3;
        this.clsU = clazz4;
        this.classes = new Class[]{this.clsR, this.clsS, this.clsT};
    }

    @Override
    public Quadruple<R, S, T, U> resolve(BaseNode baseNode, BaseNode baseNode2) {
        if (baseNode instanceof IdentNode) {
            Quadruple<R, S, T, U> quadruple = this.resolve((IdentNode)baseNode);
            if (quadruple != null) {
                assert ((quadruple.first == null ? 0 : 1) + (quadruple.second == null ? 0 : 1) + (quadruple.third == null ? 0 : 1) + (quadruple.fourth == null ? 0 : 1) == 1);
                baseNode2.becomeParent(quadruple.first);
                baseNode2.becomeParent(quadruple.second);
                baseNode2.becomeParent(quadruple.third);
                baseNode2.becomeParent(quadruple.fourth);
            }
            return quadruple;
        }
        Quadruple quadruple = new Quadruple();
        if (this.clsR.isInstance(baseNode)) {
            quadruple.first = (BaseNode)this.clsR.cast(baseNode);
        }
        if (this.clsS.isInstance(baseNode)) {
            quadruple.second = (BaseNode)this.clsS.cast(baseNode);
        }
        if (this.clsT.isInstance(baseNode)) {
            quadruple.third = (BaseNode)this.clsT.cast(baseNode);
        }
        if (this.clsU.isInstance(baseNode)) {
            quadruple.fourth = (BaseNode)this.clsU.cast(baseNode);
        }
        if (quadruple.first != null || quadruple.second != null || quadruple.third != null || quadruple.fourth != null) {
            assert ((quadruple.first == null ? 0 : 1) + (quadruple.second == null ? 0 : 1) + (quadruple.third == null ? 0 : 1) + (quadruple.fourth == null ? 0 : 1) == 1);
            return quadruple;
        }
        baseNode.reportError(baseNode + " is a " + baseNode.getKind() + " but a " + Util.getStrListWithOr(this.classes, BaseNode.class, "getKindStr") + " is expected.");
        return null;
    }

    private Quadruple<R, S, T, U> resolve(IdentNode identNode) {
        if (identNode instanceof PackageIdentNode && !DeclarationQuadrupleResolver.resolveOwner((PackageIdentNode)identNode)) {
            return null;
        }
        Quadruple quadruple = new Quadruple();
        DeclNode declNode = identNode.getDecl();
        if (this.clsR.isInstance(declNode)) {
            quadruple.first = (BaseNode)this.clsR.cast(declNode);
        }
        if (this.clsS.isInstance(declNode)) {
            quadruple.second = (BaseNode)this.clsS.cast(declNode);
        }
        if (this.clsT.isInstance(declNode)) {
            quadruple.third = (BaseNode)this.clsT.cast(declNode);
        }
        if (this.clsU.isInstance(declNode)) {
            quadruple.fourth = (BaseNode)this.clsU.cast(declNode);
        }
        if (quadruple.first != null || quadruple.second != null || quadruple.third != null || quadruple.fourth != null) {
            return quadruple;
        }
        identNode.reportError(identNode + " is a " + declNode.getKind() + " but a " + Util.getStrListWithOr(this.classes, BaseNode.class, "getKindStr") + " is expected.");
        return null;
    }
}

