/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.type;

import de.unika.ipd.grgen.ast.BaseNode;
import de.unika.ipd.grgen.ast.CollectNode;
import de.unika.ipd.grgen.ast.IdentNode;
import de.unika.ipd.grgen.ast.model.type.InheritanceTypeNode;
import de.unika.ipd.grgen.ast.type.TypeExprNode;
import de.unika.ipd.grgen.ast.util.CollectResolver;
import de.unika.ipd.grgen.ast.util.DeclarationTypeResolver;
import de.unika.ipd.grgen.ir.IR;
import de.unika.ipd.grgen.ir.model.type.InheritanceType;
import de.unika.ipd.grgen.ir.type.TypeExprConst;
import de.unika.ipd.grgen.parser.Coords;
import java.util.Collection;
import java.util.Vector;

public class TypeConstraintNode
extends TypeExprNode {
    private CollectNode<InheritanceTypeNode> operands;
    private CollectNode<IdentNode> operandsUnresolved;
    private static final CollectResolver<InheritanceTypeNode> operandsResolver;

    public TypeConstraintNode(Coords coords, CollectNode<IdentNode> collectNode) {
        super(coords, TypeExprNode.TypeOperator.SET);
        this.operandsUnresolved = collectNode;
        this.becomeParent(this.operandsUnresolved);
    }

    public TypeConstraintNode(IdentNode identNode) {
        super(identNode.getCoords(), TypeExprNode.TypeOperator.SET);
        this.operandsUnresolved = new CollectNode();
        this.becomeParent(this.operandsUnresolved);
        this.operandsUnresolved.addChild(identNode);
    }

    public Collection<BaseNode> getChildren() {
        Vector<BaseNode> vector = new Vector<BaseNode>();
        vector.add(this.getValidVersion(this.operandsUnresolved, this.operands));
        return vector;
    }

    @Override
    public Collection<String> getChildrenNames() {
        Vector<String> vector = new Vector<String>();
        vector.add("operands");
        return vector;
    }

    @Override
    protected boolean resolveLocal() {
        this.operands = operandsResolver.resolve(this.operandsUnresolved, this);
        return this.operands != null;
    }

    @Override
    protected boolean checkLocal() {
        return true;
    }

    @Override
    protected IR constructIR() {
        TypeExprConst typeExprConst = new TypeExprConst();
        for (InheritanceTypeNode inheritanceTypeNode : this.operands.getChildren()) {
            InheritanceType inheritanceType = inheritanceTypeNode.checkIR(InheritanceType.class);
            typeExprConst.addOperand(inheritanceType);
        }
        return typeExprConst;
    }

    static {
        TypeConstraintNode.setName(TypeConstraintNode.class, "type expr constraint");
        operandsResolver = new CollectResolver<InheritanceTypeNode>(new DeclarationTypeResolver<InheritanceTypeNode>(InheritanceTypeNode.class));
    }
}

